/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.classloader;

import org.apache.openejb.util.classloader.ClassLoaderComparator;

public class MultipleClassLoader
extends ClassLoader
implements ClassLoaderComparator {
    private final ClassLoader second;

    public MultipleClassLoader(ClassLoader first, ClassLoader second) {
        super(first);
        this.second = second;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.second != this.getParent()) {
                return this.loadClassSecond(name);
            }
            throw cnfe;
        }
        catch (NoClassDefFoundError ncdfe) {
            if (this.second != this.getParent()) {
                return this.loadClassSecond(name);
            }
            throw ncdfe;
        }
        catch (LinkageError le) {
            if (this.second != this.getParent()) {
                return this.loadClassSecond(name);
            }
            throw le;
        }
    }

    public Class<?> loadClassSecond(String name) throws ClassNotFoundException {
        return this.second.loadClass(name);
    }

    public boolean equals(Object other) {
        return this == other || this.getParent().equals(other);
    }

    public int hashCode() {
        return this.getParent().hashCode();
    }

    @Override
    public boolean isSame(ClassLoader cl) {
        return this.equals(cl);
    }
}

