/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.util.JTFTools;
import acm.util.MediaTools;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class GLabel
extends GObject {
    public static final Font DEFAULT_FONT = new Font("Default", 0, 12);
    private String label;
    private Font labelFont;
    private static final Component DUMMY_COMPONENT = MediaTools.getImageObserver();

    public GLabel(String str) {
        this(str, 0.0, 0.0);
    }

    public GLabel(String str, double x, double y) {
        this.label = str;
        this.setFont(DEFAULT_FONT);
        this.setLocation(x, y);
    }

    public void setFont(Font font) {
        this.labelFont = font;
        this.repaint();
    }

    public void setFont(String str) {
        this.setFont(JTFTools.decodeFont(str, this.getFont()));
    }

    public Font getFont() {
        return this.labelFont;
    }

    public void setLabel(String str) {
        this.label = str;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void paint(Graphics g) {
        g.setFont(this.labelFont);
        g.drawString(this.label, GMath.round(this.getX()), GMath.round(this.getY()));
    }

    public double getWidth() {
        return this.getFontMetrics().stringWidth(this.label);
    }

    public double getHeight() {
        return this.getFontMetrics().getHeight();
    }

    public double getAscent() {
        return this.getFontMetrics().getAscent();
    }

    public double getDescent() {
        return this.getFontMetrics().getDescent();
    }

    public FontMetrics getFontMetrics() {
        Component comp = this.getComponent();
        if (comp == null) {
            comp = DUMMY_COMPONENT;
        }
        return comp.getFontMetrics(this.labelFont);
    }

    public GRectangle getBounds() {
        return new GRectangle(this.getX(), this.getY() - this.getAscent(), this.getWidth(), this.getHeight());
    }

    public String paramString() {
        return String.valueOf(super.paramString()) + ", string=\"" + this.label + "\"";
    }
}

