/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvas;
import acm.graphics.GCompound;
import acm.graphics.GContainer;
import acm.graphics.GDimension;
import acm.graphics.GFillable;
import acm.graphics.GMath;
import acm.graphics.GPoint;
import acm.graphics.GRectangle;
import acm.graphics.GResizable;
import acm.util.ErrorException;
import acm.util.JTFTools;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;

public abstract class GObject
implements Cloneable {
    private GContainer myParent;
    private Color color;
    private double xc;
    private double yc;
    private boolean isVisible = true;
    private boolean mouseListenersEnabled = false;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private ActionListener actionListener;

    protected GObject() {
    }

    public abstract void paint(Graphics var1);

    public abstract GRectangle getBounds();

    public void setLocation(double x, double y) {
        this.xc = x;
        this.yc = y;
        this.repaint();
    }

    public final void setLocation(GPoint pt) {
        this.setLocation(pt.getX(), pt.getY());
    }

    public GPoint getLocation() {
        return new GPoint(this.xc, this.yc);
    }

    public double getX() {
        return this.xc;
    }

    public double getY() {
        return this.yc;
    }

    public void move(double dx, double dy) {
        this.setLocation(this.xc + dx, this.yc + dy);
    }

    public final void movePolar(double r, double theta) {
        double radians = theta * Math.PI / 180.0;
        this.move(r * Math.cos(radians), -r * Math.sin(radians));
    }

    public GDimension getSize() {
        GRectangle bounds = this.getBounds();
        return new GDimension(bounds.getWidth(), bounds.getHeight());
    }

    public double getWidth() {
        return this.getBounds().getWidth();
    }

    public double getHeight() {
        return this.getBounds().getHeight();
    }

    public boolean contains(double x, double y) {
        return this.getBounds().contains(GMath.round(x), GMath.round(y));
    }

    public final boolean contains(GPoint pt) {
        return this.contains(pt.getX(), pt.getY());
    }

    public void sendToFront() {
        if (this.myParent == null) {
            return;
        }
        if (this.myParent instanceof GCanvas) {
            ((GCanvas)this.myParent).sendToFront(this);
        } else if (this.myParent instanceof GCompound) {
            ((GCompound)this.myParent).sendToFront(this);
        } else {
            try {
                Class<?> parentClass = this.myParent.getClass();
                Class[] types = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] args = new Object[]{this};
                Method fn = parentClass.getMethod("sendToFront", types);
                if (fn != null) {
                    fn.invoke((Object)this.myParent, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendToBack() {
        if (this.myParent == null) {
            return;
        }
        if (this.myParent instanceof GCanvas) {
            ((GCanvas)this.myParent).sendToBack(this);
        } else if (this.myParent instanceof GCompound) {
            ((GCompound)this.myParent).sendToBack(this);
        } else {
            try {
                Class<?> parentClass = this.myParent.getClass();
                Class[] types = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] args = new Object[]{this};
                Method fn = parentClass.getMethod("sendToBack", types);
                if (fn != null) {
                    fn.invoke((Object)this.myParent, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendForward() {
        if (this.myParent == null) {
            return;
        }
        if (this.myParent instanceof GCanvas) {
            ((GCanvas)this.myParent).sendForward(this);
        } else if (this.myParent instanceof GCompound) {
            ((GCompound)this.myParent).sendForward(this);
        } else {
            try {
                Class<?> parentClass = this.myParent.getClass();
                Class[] types = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] args = new Object[]{this};
                Method fn = parentClass.getMethod("sendForward", types);
                if (fn != null) {
                    fn.invoke((Object)this.myParent, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendBackward() {
        if (this.myParent == null) {
            return;
        }
        if (this.myParent instanceof GCanvas) {
            ((GCanvas)this.myParent).sendBackward(this);
        } else if (this.myParent instanceof GCompound) {
            ((GCompound)this.myParent).sendBackward(this);
        } else {
            try {
                Class<?> parentClass = this.myParent.getClass();
                Class[] types = new Class[]{Class.forName("acm.graphics.GObject")};
                Object[] args = new Object[]{this};
                Method fn = parentClass.getMethod("sendBackward", types);
                if (fn != null) {
                    fn.invoke((Object)this.myParent, args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setColor(Color c) {
        this.color = c;
        this.repaint();
    }

    public Color getColor() {
        GObject obj = this;
        while (obj.color == null) {
            GContainer parent = obj.getParent();
            if (parent instanceof GObject) {
                obj = (GObject)((Object)parent);
                continue;
            }
            if (parent instanceof Component) {
                return ((Component)((Object)parent)).getForeground();
            }
            return Color.black;
        }
        return obj.color;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
        this.repaint();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public String toString() {
        String name = this.getClass().getName();
        if (name.startsWith("acm.graphics.")) {
            name = name.substring("acm.graphics.".length());
        }
        return String.valueOf(name) + "[" + this.paramString() + "]";
    }

    public GContainer getParent() {
        return this.myParent;
    }

    public void pause(double milliseconds) {
        JTFTools.pause(milliseconds);
    }

    public void addMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.add(this.mouseListener, listener);
        this.mouseListenersEnabled = true;
    }

    public void removeMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, listener);
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, listener);
        this.mouseListenersEnabled = true;
    }

    public void removeMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, listener);
    }

    public void addActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, listener);
    }

    public void fireActionEvent(String actionCommand) {
        this.fireActionEvent(new ActionEvent(this, 1001, actionCommand));
    }

    public void fireActionEvent(ActionEvent e) {
        this.actionListener.actionPerformed(e);
    }

    protected void fireMouseListeners(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                if (this.mouseListener == null) break;
                this.mouseListener.mousePressed(e);
                break;
            }
            case 502: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseReleased(e);
                break;
            }
            case 500: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseClicked(e);
                break;
            }
            case 505: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseExited(e);
                break;
            }
            case 504: {
                if (this.mouseListener == null) break;
                this.mouseListener.mouseEntered(e);
                break;
            }
            case 503: {
                if (this.mouseMotionListener == null) break;
                this.mouseMotionListener.mouseMoved(e);
                break;
            }
            case 506: {
                if (this.mouseMotionListener == null) break;
                this.mouseMotionListener.mouseDragged(e);
            }
        }
    }

    protected boolean areMouseListenersEnabled() {
        return this.mouseListenersEnabled;
    }

    protected void start() {
        this.start(null);
    }

    protected void start(String[] args) {
        try {
            Class<?> programClass = Class.forName("acm.program.GraphicsProgram");
            Class<?> gObjectClass = Class.forName("acm.graphics.GObject");
            Class[] types = new Class[]{gObjectClass, args.getClass()};
            Object[] params = new Object[]{this, args};
            Method startGraphicsProgram = programClass.getMethod("startGraphicsProgram", types);
            startGraphicsProgram.invoke(null, params);
        }
        catch (Exception ex) {
            throw new ErrorException(ex);
        }
    }

    protected Color getObjectColor() {
        return this.color;
    }

    protected String paramString() {
        String param = "";
        if (this instanceof GResizable) {
            GRectangle r = this.getBounds();
            param = String.valueOf(param) + "bounds=(" + r.getX() + ", " + r.getY() + ", " + r.getWidth() + ", " + r.getHeight() + ")";
        } else {
            GPoint pt = this.getLocation();
            param = String.valueOf(param) + "location=(" + pt.getX() + ", " + pt.getY() + ")";
        }
        if (this.color != null) {
            param = String.valueOf(param) + ", color=" + GObject.colorName(this.color);
        }
        if (this instanceof GFillable) {
            param = String.valueOf(param) + ", filled=" + ((GFillable)((Object)this)).isFilled();
            Color fillColor = ((GFillable)((Object)this)).getFillColor();
            if (fillColor != null && fillColor != this.color) {
                param = String.valueOf(param) + ", fillColor=" + GObject.colorName(fillColor);
            }
        }
        return param;
    }

    protected static String colorName(Color color) {
        if (color.equals(Color.black)) {
            return "BLACK";
        }
        if (color.equals(Color.blue)) {
            return "BLUE";
        }
        if (color.equals(Color.cyan)) {
            return "CYAN";
        }
        if (color.equals(Color.darkGray)) {
            return "DARK_GRAY";
        }
        if (color.equals(Color.gray)) {
            return "GRAY";
        }
        if (color.equals(Color.green)) {
            return "GREEN";
        }
        if (color.equals(Color.lightGray)) {
            return "LIGHT_GRAY";
        }
        if (color.equals(Color.magenta)) {
            return "MAGENTA";
        }
        if (color.equals(Color.orange)) {
            return "ORANGE";
        }
        if (color.equals(Color.pink)) {
            return "PINK";
        }
        if (color.equals(Color.red)) {
            return "RED";
        }
        if (color.equals(Color.white)) {
            return "WHITE";
        }
        if (color.equals(Color.yellow)) {
            return "YELLOW";
        }
        return "0x" + Integer.toString(color.getRGB() & 0xFFFFFF, 16).toUpperCase();
    }

    protected void paintObject(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        Color oldColor = g.getColor();
        if (this.color != null) {
            g.setColor(this.color);
        }
        this.paint(g);
        if (this.color != null) {
            g.setColor(oldColor);
        }
    }

    protected void setParent(GContainer parent) {
        this.myParent = parent;
    }

    protected Component getComponent() {
        GContainer parent = this.getParent();
        while (parent instanceof GObject) {
            parent = ((GObject)((Object)parent)).getParent();
        }
        return (Component)((Object)parent);
    }

    protected void updateEnabledList() {
        Component comp = this.getComponent();
        if (comp instanceof GCanvas) {
            ((GCanvas)comp).updateEnabledList();
        }
    }

    protected void repaint() {
        GContainer parent = this.getParent();
        while (parent instanceof GObject) {
            parent = ((GObject)((Object)parent)).getParent();
        }
        if (parent instanceof GCanvas) {
            ((GCanvas)parent).conditionalRepaint();
        }
    }
}

