/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GDimension;
import acm.graphics.GPoint;
import java.awt.Rectangle;

public class GRectangle {
    private double xc;
    private double yc;
    private double myWidth;
    private double myHeight;

    public GRectangle() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public GRectangle(double x, double y, double width, double height) {
        this.xc = x;
        this.yc = y;
        this.myWidth = width;
        this.myHeight = height;
    }

    public GRectangle(double width, double height) {
        this(0.0, 0.0, width, height);
    }

    public GRectangle(GPoint pt, GDimension size) {
        this(pt.getX(), pt.getY(), size.getWidth(), size.getHeight());
    }

    public GRectangle(GPoint pt) {
        this(pt.getX(), pt.getY(), 0.0, 0.0);
    }

    public GRectangle(GDimension size) {
        this(0.0, 0.0, size.getWidth(), size.getHeight());
    }

    public GRectangle(GRectangle r) {
        this(r.xc, r.yc, r.myWidth, r.myHeight);
    }

    public double getX() {
        return this.xc;
    }

    public double getY() {
        return this.yc;
    }

    public double getWidth() {
        return this.myWidth;
    }

    public double getHeight() {
        return this.myHeight;
    }

    public void setBounds(double x, double y, double width, double height) {
        this.xc = x;
        this.yc = y;
        this.myWidth = width;
        this.myHeight = height;
    }

    public void setBounds(GPoint pt, GDimension size) {
        this.setBounds(pt.getX(), pt.getY(), size.getWidth(), size.getHeight());
    }

    public void setBounds(GRectangle bounds) {
        this.setBounds(bounds.xc, bounds.yc, bounds.myWidth, bounds.myHeight);
    }

    public GRectangle getBounds() {
        return new GRectangle(this);
    }

    public void setLocation(double x, double y) {
        this.xc = x;
        this.yc = y;
    }

    public void setLocation(GPoint pt) {
        this.setLocation(pt.getX(), pt.getY());
    }

    public GPoint getLocation() {
        return new GPoint(this.xc, this.yc);
    }

    public void translate(double dx, double dy) {
        this.xc += dx;
        this.yc += dy;
    }

    public void setSize(double width, double height) {
        this.myWidth = width;
        this.myHeight = height;
    }

    public void setSize(GDimension size) {
        this.setSize(size.getWidth(), size.getHeight());
    }

    public GDimension getSize() {
        return new GDimension(this.myWidth, this.myHeight);
    }

    public void grow(double dx, double dy) {
        this.xc -= dx;
        this.yc -= dy;
        this.myWidth += 2.0 * dx;
        this.myHeight += 2.0 * dy;
    }

    public boolean isEmpty() {
        return this.myWidth <= 0.0 || this.myHeight <= 0.0;
    }

    public boolean contains(double x, double y) {
        return x >= this.xc && y >= this.yc && x < this.xc + this.myWidth && y < this.yc + this.myHeight;
    }

    public boolean contains(GPoint pt) {
        return this.contains(pt.getX(), pt.getY());
    }

    public boolean intersects(GRectangle r) {
        if (this.xc > r.xc + r.myWidth) {
            return false;
        }
        if (this.yc > r.yc + r.myHeight) {
            return false;
        }
        if (r.xc > this.xc + this.myWidth) {
            return false;
        }
        return !(r.yc > this.yc + this.myHeight);
    }

    public GRectangle intersection(GRectangle r) {
        double x1 = Math.max(this.xc, r.xc);
        double y1 = Math.max(this.yc, r.yc);
        double x2 = Math.min(this.xc + this.myWidth, r.xc + r.myWidth);
        double y2 = Math.min(this.yc + this.myHeight, r.yc + r.myHeight);
        return new GRectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public GRectangle union(GRectangle r) {
        if (this.isEmpty()) {
            return new GRectangle(r);
        }
        if (r.isEmpty()) {
            return new GRectangle(this);
        }
        double x1 = Math.min(this.xc, r.xc);
        double y1 = Math.min(this.yc, r.yc);
        double x2 = Math.max(this.xc + this.myWidth, r.xc + r.myWidth);
        double y2 = Math.max(this.yc + this.myHeight, r.yc + r.myHeight);
        return new GRectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(GRectangle r) {
        if (r.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.setBounds(r);
            return;
        }
        double x2 = Math.max(this.xc + this.myWidth, r.xc + r.myWidth);
        double y2 = Math.max(this.yc + this.myHeight, r.yc + r.myHeight);
        this.xc = Math.min(r.xc, this.xc);
        this.yc = Math.min(r.yc, this.yc);
        this.myWidth = x2 - this.xc;
        this.myHeight = y2 - this.yc;
    }

    public void add(double x, double y) {
        if (this.isEmpty()) {
            this.setBounds(x, y, 0.0, 0.0);
            return;
        }
        double x2 = Math.max(x + this.myWidth, x);
        double y2 = Math.max(y + this.myHeight, y);
        this.xc = Math.min(x, this.xc);
        this.yc = Math.min(y, this.yc);
        this.myWidth = x2 - this.xc;
        this.myHeight = y2 - this.yc;
    }

    public Rectangle toRectangle() {
        return new Rectangle((int)Math.round(this.xc), (int)Math.round(this.yc), (int)Math.round(this.myWidth), (int)Math.round(this.myHeight));
    }

    public int hashCode() {
        return new Float((float)this.xc).hashCode() ^ new Float((float)this.yc).hashCode() ^ new Float((float)this.myWidth).hashCode() ^ new Float((float)this.myHeight).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GRectangle)) {
            return false;
        }
        GRectangle r = (GRectangle)obj;
        if ((float)this.xc != (float)r.xc) {
            return false;
        }
        if ((float)this.yc != (float)r.yc) {
            return false;
        }
        if ((float)this.myWidth != (float)r.myWidth) {
            return false;
        }
        return (float)this.myHeight == (float)r.myHeight;
    }

    public String toString() {
        return "[" + (float)this.xc + ", " + (float)this.yc + ", " + (float)this.myWidth + "x" + (float)this.myHeight + "]";
    }
}

