/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.gui.TableLayout;
import acm.io.IOConsole;
import acm.io.IODialog;
import acm.io.IOModel;
import acm.program.DOSCommandLine;
import acm.program.ProgramAppletStub;
import acm.program.ProgramFrame;
import acm.program.ProgramMenuBar;
import acm.program.ProgramStartupListener;
import acm.program.ProgramWindowListener;
import acm.util.ErrorException;
import acm.util.JTFTools;
import acm.util.Platform;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;

public abstract class Program
extends JApplet
implements IOModel,
Runnable,
MouseListener,
MouseMotionListener,
ActionListener {
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String WEST = "West";
    public static final String CENTER = "Center";
    private static final int STARTUP_DELAY = 1000;
    private static final int STARTUP_CYCLE = 300;
    private static final int THREAD_BUFFER = 10;
    private static final int DEFAULT_X = 16;
    private static final int DEFAULT_Y = 40;
    private static final int DEFAULT_WIDTH = 754;
    private static final int DEFAULT_HEIGHT = 492;
    private Frame programFrame;
    private HashMap optionTable;
    private AppletStub appletStub;
    private String myTitle;
    private ProgramMenuBar myMenuBar;
    private HashMap parameterTable;
    private Component northBorder;
    private Component southBorder;
    private Component eastBorder;
    private Component westBorder;
    private JPanel northPanel;
    private JPanel southPanel;
    private JPanel eastPanel;
    private JPanel westPanel;
    private JPanel centerPanel;
    private IOConsole myConsole;
    private IODialog myDialog;
    private Object startupObject;
    private Thread mainThread;
    private Rectangle programBounds;
    private boolean started;
    private boolean shown;
    private boolean isAppletMode;
    private boolean macMenuBarFlag;

    protected Program() {
        JTFTools.registerApplet(this);
        this.shown = false;
        this.parameterTable = null;
        this.isAppletMode = false;
        this.macMenuBarFlag = true;
        this.myTitle = this.getClass().getName();
        this.myTitle = this.myTitle.substring(this.myTitle.lastIndexOf(".") + 1);
        this.appletStub = new ProgramAppletStub(this);
        this.setAppletStub(this.appletStub);
        Container contentPane = this.getContentPane();
        this.initContentPane(contentPane);
        this.setVisible(false);
        this.setConsole(this.createConsole());
        this.myDialog = this.createDialogIO();
        this.myDialog.setAssociatedConsole(this.myConsole);
        this.myMenuBar = this.createMenuBar();
    }

    public void run() {
    }

    public void init() {
    }

    public void print(String value) {
        this.getOutputModel().print(value);
    }

    public final void print(boolean x) {
        this.print("" + x);
    }

    public final void print(char x) {
        this.print("" + x);
    }

    public final void print(double x) {
        this.print("" + x);
    }

    public final void print(float x) {
        this.print("" + x);
    }

    public final void print(int x) {
        this.print("" + x);
    }

    public final void print(long x) {
        this.print("" + x);
    }

    public final void print(Object x) {
        this.print("" + x);
    }

    public void println() {
        this.getOutputModel().println();
    }

    public void println(String value) {
        this.getOutputModel().println(value);
    }

    public final void println(boolean x) {
        this.println("" + x);
    }

    public final void println(char x) {
        this.println("" + x);
    }

    public final void println(double x) {
        this.println("" + x);
    }

    public final void println(float x) {
        this.println("" + x);
    }

    public final void println(int x) {
        this.println("" + x);
    }

    public final void println(long x) {
        this.println("" + x);
    }

    public final void println(Object x) {
        this.println("" + x);
    }

    public void showErrorMessage(String msg) {
        this.getOutputModel().showErrorMessage(msg);
    }

    public final String readLine() {
        return this.readLine(null);
    }

    public String readLine(String prompt) {
        return this.getInputModel().readLine(prompt);
    }

    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public final int readInt(int low, int high) {
        return this.readInt(null, low, high);
    }

    public final int readInt(String prompt) {
        return this.readInt(prompt, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int readInt(String prompt, int low, int high) {
        return this.getInputModel().readInt(prompt, low, high);
    }

    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public final double readDouble(double low, double high) {
        return this.readDouble(null, low, high);
    }

    public final double readDouble(String prompt) {
        return this.readDouble(prompt, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public double readDouble(String prompt, double low, double high) {
        return this.getInputModel().readDouble(prompt, low, high);
    }

    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    public final boolean readBoolean(String prompt) {
        return this.readBoolean(prompt, "true", "false");
    }

    public boolean readBoolean(String prompt, String trueLabel, String falseLabel) {
        return this.getInputModel().readBoolean(prompt, trueLabel, falseLabel);
    }

    public boolean isAppletMode() {
        if (!this.started) {
            throw new ErrorException("You can't call isAppletMode from the constructor");
        }
        return this.isAppletMode;
    }

    public void setConsole(IOConsole console) {
        this.myConsole = console;
    }

    public IOConsole getConsole() {
        return this.myConsole;
    }

    public IODialog getDialog() {
        return this.myDialog;
    }

    public IOModel getInputModel() {
        return this.getConsole();
    }

    public IOModel getOutputModel() {
        return this.getConsole();
    }

    public BufferedReader getReader() {
        return this.getConsole().getReader();
    }

    public PrintWriter getWriter() {
        return this.getConsole().getWriter();
    }

    public JPanel getRegionPanel(String region) {
        if (region.equals(NORTH)) {
            return this.northPanel;
        }
        if (region.equals(SOUTH)) {
            return this.southPanel;
        }
        if (region.equals(WEST)) {
            return this.westPanel;
        }
        if (region.equals(EAST)) {
            return this.eastPanel;
        }
        if (region.equals(CENTER)) {
            return this.centerPanel;
        }
        throw new ErrorException("getRegionPanel: Illegal region " + region);
    }

    public void add(Component comp, String region, Object constraints) {
        if (region.equals(NORTH)) {
            this.northPanel.add(comp, constraints);
        } else if (region.equals(SOUTH)) {
            this.southPanel.add(comp, constraints);
        } else if (region.equals(WEST)) {
            this.westPanel.add(comp, constraints);
        } else if (region.equals(EAST)) {
            this.eastPanel.add(comp, constraints);
        } else if (region.equals(CENTER)) {
            this.centerPanel.add(comp, constraints);
        } else {
            throw new ErrorException("add: Illegal region " + region);
        }
    }

    public void addActionListeners() {
        this.addActionListeners(this.getContentPane());
    }

    public void setTitle(String title) {
        this.myTitle = title;
        if (this.programFrame != null) {
            this.programFrame.setTitle(title);
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public ProgramMenuBar getMenuBar() {
        return this.myMenuBar;
    }

    public void start(String[] args) {
        if (this.parameterTable == null) {
            this.parameterTable = Program.createParameterTable(args);
        }
        if (this.getParent() == null) {
            this.initApplicationFrame();
        }
        this.validate();
        this.setVisible(true);
        Container contentPane = this.getContentPane();
        if (this.programFrame != null) {
            this.programFrame.validate();
            if (contentPane.getComponentCount() != 0) {
                this.programFrame.setVisible(true);
                this.shown = true;
            }
            if (Platform.isWindows()) {
                this.circumventFrameSizeBug(this.programFrame, this.programBounds.getSize());
            }
        }
        this.started = true;
        this.init();
        if (this.programFrame != null && this.myMenuBar != null) {
            this.installMenuBar(this.myMenuBar, this.programFrame);
            this.myMenuBar.update();
        }
        this.validate();
        this.startRun();
    }

    public void exit() {
        if (!this.isAppletMode) {
            System.exit(0);
        }
    }

    public void pause(double milliseconds) {
        JTFTools.pause(milliseconds);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected Frame createProgramFrame() {
        ProgramFrame frame = new ProgramFrame(this.getTitle());
        frame.setLayout(new BorderLayout());
        return frame;
    }

    protected IOConsole createConsole() {
        return IOConsole.SYSTEM_CONSOLE;
    }

    protected IODialog createDialogIO() {
        return new IODialog(this.getContentPane());
    }

    public ProgramMenuBar createMenuBar() {
        return new ProgramMenuBar(this);
    }

    public Dimension getPreferredSize() {
        return this.computeProgramBounds().getSize();
    }

    public Dimension getSize() {
        Container contentPane = this.getContentPane();
        if (contentPane == null) {
            return super.getSize();
        }
        return contentPane.getSize();
    }

    public Rectangle getBounds() {
        Container contentPane = this.getContentPane();
        if (contentPane == null) {
            return super.getBounds();
        }
        return contentPane.getBounds();
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public String getParameter(String name) {
        String value = null;
        if (this.parameterTable != null) {
            value = (String)this.parameterTable.get(name.toLowerCase());
        }
        if (value != null) {
            return value;
        }
        return super.getParameter(name);
    }

    public void setLayout(LayoutManager layout) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.setLayout(layout);
        } else {
            super.setLayout(layout);
        }
    }

    public LayoutManager getLayout() {
        if (this.isRootPaneCheckingEnabled()) {
            return this.centerPanel.getLayout();
        }
        return super.getLayout();
    }

    public void setBackground(Color color) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.setBackground(color);
        }
        super.setBackground(color);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.isRootPaneCheckingEnabled()) {
            if (constraints == null) {
                this.centerPanel.add(comp, index);
            } else if (constraints.equals(NORTH)) {
                this.northPanel.add(comp, index);
            } else if (constraints.equals(SOUTH)) {
                this.southPanel.add(comp, index);
            } else if (constraints.equals(WEST)) {
                this.westPanel.add(comp, index);
            } else if (constraints.equals(EAST)) {
                this.eastPanel.add(comp, index);
            } else if (constraints.equals(CENTER)) {
                this.centerPanel.add(comp, index);
            } else {
                this.centerPanel.add(comp, constraints, index);
            }
            if (!this.shown && this.programFrame != null) {
                this.programFrame.setVisible(true);
                this.shown = true;
            }
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public void remove(int index) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.remove(index);
        } else {
            super.remove(index);
        }
    }

    public void remove(Component comp) {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.remove(comp);
        } else {
            super.remove(comp);
        }
    }

    public void removeAll() {
        if (this.isRootPaneCheckingEnabled()) {
            this.centerPanel.removeAll();
        } else {
            super.removeAll();
        }
    }

    public void validate() {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().validate();
        }
        super.validate();
    }

    public void repaint() {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().repaint();
        }
        super.repaint();
    }

    public final void start() {
        boolean bl = this.isAppletMode = this.getParent() != null;
        if (this.isAppletMode) {
            if (!this.started) {
                this.started = true;
                this.validate();
                this.setVisible(true);
                this.myMenuBar.update();
                this.mainThread = Thread.currentThread();
                this.startRun();
            }
        } else {
            this.start(null);
        }
    }

    public void destroy() {
        if (this.mainThread != null) {
            try {
                Class<?> threadClass = Class.forName("java.lang.Thread");
                Method stop = threadClass.getMethod("stop", new Class[0]);
                stop.invoke((Object)this.mainThread, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        HashMap ht = Program.createParameterTable(args);
        String className = (String)ht.get("code");
        Class<?> mainClass = null;
        Program program = null;
        if (className == null) {
            try {
                className = System.getProperty("java.main");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (className == null) {
            String commandLine = Program.getCommandLine();
            className = Program.readMainClassFromCommandLine(commandLine);
        }
        if (className != null) {
            if (className.endsWith(".class")) {
                className = className.substring(0, className.length() - 6);
            }
            className = className.replace('/', '.');
            try {
                mainClass = Class.forName(className);
            }
            catch (ClassNotFoundException commandLine) {
                // empty catch block
            }
        }
        if (mainClass != null) {
            try {
                Object obj = mainClass.newInstance();
                if (obj instanceof Program) {
                    program = (Program)obj;
                    program.setStartupObject(null);
                } else {
                    className = (String)ht.get("program");
                    if (className == null) {
                        throw new ErrorException("Main class does not specify a program");
                    }
                    program = (Program)Class.forName(className).newInstance();
                    program.setStartupObject(obj);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (program == null) {
            throw new ErrorException("Cannot determine the main class.");
        }
        program.setParameterTable(ht);
        program.start();
    }

    public void menuAction(String cmd) {
        IOConsole console = this.myConsole;
        if (this.myMenuBar != null && (console = this.myMenuBar.getConsole()) == null) {
            console = this.myConsole;
        }
        if (console == null) {
            return;
        }
        if (cmd.equals("Quit")) {
            this.exit();
        } else if (cmd.equals("Print")) {
            Frame frame = JTFTools.getEnclosingFrame(this);
            if (frame == null) {
                return;
            }
            PrintJob pj = frame.getToolkit().getPrintJob(frame, this.myTitle, null);
            if (pj == null) {
                return;
            }
            frame.printAll(pj.getGraphics());
            pj.end();
        } else if (cmd.equals("Cut")) {
            console.cut();
        } else if (cmd.equals("Copy")) {
            console.copy();
        } else if (cmd.equals("Paste")) {
            console.paste();
        } else if (cmd.equals("Select All")) {
            console.selectAll();
        } else if (cmd.equals("Save")) {
            console.save();
        } else if (cmd.equals("Save As")) {
            console.saveAs();
        } else if (cmd.equals("Script")) {
            console.script();
        } else if (cmd.equals("Print Console")) {
            console.printConsole();
        }
    }

    public boolean updateMenuItem(JMenuItem item) {
        IOConsole console = this.myConsole;
        if (this.myMenuBar != null && (console = this.myMenuBar.getConsole()) == null) {
            console = this.myConsole;
        }
        if (console != null && console.updateMenuItem(item)) {
            return true;
        }
        String cmd = item.getActionCommand();
        if (cmd == null) {
            return false;
        }
        if (cmd.equals("Quit")) {
            item.setEnabled(true);
            return true;
        }
        if (cmd.equals("Print")) {
            item.setEnabled(this.getContentPane().getComponentCount() > 0);
            return true;
        }
        return false;
    }

    protected void setMacMenuBarFlag(boolean flag) {
        this.macMenuBarFlag = flag;
    }

    protected boolean getMacMenuBarFlag() {
        return this.macMenuBarFlag;
    }

    protected Component getBorder(String side) {
        if (side.equals(NORTH)) {
            return this.northBorder;
        }
        if (side.equals(SOUTH)) {
            return this.southBorder;
        }
        if (side.equals(EAST)) {
            return this.eastBorder;
        }
        if (side.equals(WEST)) {
            return this.westBorder;
        }
        throw new ErrorException("Illegal border specification - " + side);
    }

    protected String[] getArgumentArray() {
        return this.parameterTable == null ? null : (String[])this.parameterTable.get("ARGS");
    }

    protected boolean isStarted() {
        IOConsole console = this.getConsole();
        if (console == null) {
            return false;
        }
        if (console.getParent() == null) {
            return true;
        }
        Dimension size = console.getSize();
        return console.isShowing() && size.width != 0 && size.height != 0;
    }

    protected void startHook() {
    }

    protected void endHook() {
    }

    protected void setAppletStub(AppletStub stub) {
        this.appletStub = stub;
        this.setStub(stub);
    }

    protected AppletStub getAppletStub() {
        return this.appletStub;
    }

    protected void setParameterTable(HashMap ht) {
        this.parameterTable = ht;
    }

    protected HashMap getParameterTable() {
        return this.parameterTable;
    }

    protected void setStartupObject(Object obj) {
        this.startupObject = obj;
    }

    protected Object getStartupObject() {
        return this.startupObject;
    }

    protected static String getCommandLine() {
        switch (Platform.getPlatform()) {
            case 1: 
            case 2: {
                return Program.getShellCommandLine();
            }
            case 3: {
                return DOSCommandLine.getCommandLine();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void startRun() {
        ProgramStartupListener listener = new ProgramStartupListener();
        JRootPane root = this.getRootPane();
        if (root.isShowing()) {
            root.addComponentListener(listener);
            ((Component)root).validate();
            JTFTools.pause(1000.0);
            ProgramStartupListener programStartupListener = listener;
            synchronized (programStartupListener) {
                while (!this.isStarted()) {
                    try {
                        listener.wait(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            ((Component)root).update(((Component)root).getGraphics());
        }
        root.setCursor(Cursor.getDefaultCursor());
        this.startHook();
        this.runHook();
        this.endHook();
        Container contentPane = this.getContentPane();
        if (root.isShowing() && contentPane.getComponentCount() == 0) {
            this.exit();
        }
    }

    protected void runHook() {
        this.run();
    }

    protected static HashMap createParameterTable(String[] args) {
        if (args == null) {
            return null;
        }
        HashMap<String, Object> ht = new HashMap<String, Object>();
        ArrayList<String> v = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            int equals = arg.indexOf(61);
            if (equals > 0) {
                String name = arg.substring(0, equals).toLowerCase();
                String value = arg.substring(equals + 1);
                ht.put(name, value);
            } else {
                v.add(arg);
            }
            ++i;
        }
        String[] newArgs = new String[v.size()];
        int i2 = 0;
        while (i2 < v.size()) {
            newArgs[i2] = (String)v.get(i2);
            ++i2;
        }
        ht.put("ARGS", newArgs);
        return ht;
    }

    protected static String readMainClassFromCommandLine(String line) {
        if (line == null) {
            return null;
        }
        boolean jarFlag = false;
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(line));
            tokenizer.resetSyntax();
            tokenizer.wordChars(33, 255);
            tokenizer.quoteChar(34);
            tokenizer.quoteChar(39);
            tokenizer.whitespaceChars(32, 32);
            tokenizer.whitespaceChars(9, 9);
            boolean cmdRead = false;
            while (true) {
                int tt = tokenizer.nextToken();
                String token = tokenizer.sval;
                switch (tt) {
                    case -1: {
                        return null;
                    }
                    case -3: 
                    case 34: 
                    case 39: {
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (cmdRead) {
                    if (token.startsWith("-")) {
                        if (token.equals("-jar")) {
                            jarFlag = true;
                            continue;
                        }
                        if (!token.equals("-cp") && !token.equals("-classpath")) continue;
                        tokenizer.nextToken();
                        continue;
                    }
                    if (jarFlag) {
                        return Program.readMainClassFromManifest(token);
                    }
                    return token;
                }
                cmdRead = true;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void initContentPane(Container contentPane) {
        contentPane.setLayout(new BorderLayout());
        this.northPanel = new JPanel();
        this.southPanel = new JPanel();
        this.eastPanel = new JPanel();
        this.westPanel = new JPanel();
        this.centerPanel = new JPanel();
        this.northPanel.setLayout(new TableLayout(1, 0, 5, 5));
        this.southPanel.setLayout(new TableLayout(1, 0, 5, 5));
        this.westPanel.setLayout(new TableLayout(0, 1, 5, 5));
        this.eastPanel.setLayout(new TableLayout(0, 1, 5, 5));
        this.centerPanel.setLayout(new GridLayout(1, 0));
        contentPane.add((Component)this.northPanel, NORTH);
        contentPane.add((Component)this.southPanel, SOUTH);
        contentPane.add((Component)this.eastPanel, EAST);
        contentPane.add((Component)this.westPanel, WEST);
        contentPane.add((Component)this.centerPanel, CENTER);
    }

    private void addActionListeners(Component comp) {
        if (this.isButton(comp)) {
            if (!this.hasActionListener(comp)) {
                try {
                    Class[] types = new Class[]{Class.forName("java.awt.event.ActionListener")};
                    Object[] args = new Object[]{this};
                    Method addActionListener = comp.getClass().getMethod("addActionListener", types);
                    addActionListener.invoke((Object)comp, args);
                }
                catch (Exception ex) {
                    throw new ErrorException(ex);
                }
            }
        } else if (comp instanceof Container) {
            Container container = (Container)comp;
            int nComponents = container.getComponentCount();
            int i = 0;
            while (i < nComponents) {
                this.addActionListeners(container.getComponent(i));
                ++i;
            }
        }
    }

    private boolean isButton(Component comp) {
        if (comp instanceof Button || comp instanceof JButton) {
            return true;
        }
        try {
            return Class.forName("ButtonLike").isInstance(comp);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean hasActionListener(Component comp) {
        try {
            Class[] types = new Class[]{Class.forName("java.lang.Class")};
            Object[] args = new Object[]{Class.forName("java.awt.event.ActionListener")};
            Method getListeners = comp.getClass().getMethod("getListeners", types);
            EventListener[] listeners = (EventListener[])getListeners.invoke((Object)comp, args);
            return listeners.length > 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void initApplicationFrame() {
        this.programFrame = this.createProgramFrame();
        ((ProgramAppletStub)this.appletStub).setFrame(this.programFrame);
        this.programFrame.add((Component)this, CENTER);
        this.programFrame.addWindowListener(new ProgramWindowListener());
        this.programBounds = this.computeProgramBounds();
        Insets insets = this.programFrame.getInsets();
        int frameWidth = this.programBounds.width + insets.left + insets.right;
        int frameHeight = this.programBounds.height + insets.top + insets.bottom;
        this.programFrame.setBounds(this.programBounds.x, this.programBounds.y, frameWidth, frameHeight);
    }

    private void installMenuBar(ProgramMenuBar menuBar, Frame frame) {
        if (Platform.isMac() && this.macMenuBarFlag) {
            frame.setMenuBar(menuBar.createMacMenuBar());
        } else {
            try {
                Class<?> frameClass = frame.getClass();
                Class[] types = new Class[]{menuBar.getClass()};
                Object[] args = new Object[]{menuBar};
                Method setJMenuBar = frameClass.getMethod("setJMenuBar", types);
                setJMenuBar.invoke((Object)frame, args);
            }
            catch (Exception ex) {
                frame.setMenuBar(menuBar.createMacMenuBar());
                frame.pack();
            }
        }
    }

    private int decodeSizeParameter(String name, int value, int max) {
        String str = this.getParameter(name);
        if (str == null) {
            try {
                Class<?> mainClass = this.getClass();
                Field field = mainClass.getField("APPLICATION_" + name);
                Object obj = field.get(null);
                if (obj instanceof Integer) {
                    return (Integer)obj;
                }
                if (!(obj instanceof String)) {
                    return value;
                }
                str = (String)obj;
            }
            catch (Exception ex) {
                return value;
            }
        }
        if (str.equals("*")) {
            str = "100%";
        }
        if (str.endsWith("%")) {
            int percent = Integer.parseInt(str.substring(0, str.length() - 1));
            return (int)Math.round((double)percent / 100.0 * (double)max);
        }
        return Integer.parseInt(str);
    }

    private Rectangle computeProgramBounds() {
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        int width = this.decodeSizeParameter("WIDTH", 754, size.width);
        int height = this.decodeSizeParameter("HEIGHT", 492, size.height);
        int x = this.decodeSizeParameter("X", width >= size.width ? 0 : 16, size.width);
        int y = this.decodeSizeParameter("Y", height >= size.height ? 0 : 40, size.height);
        return new Rectangle(x, y, width, height);
    }

    private void circumventFrameSizeBug(Frame frame, Dimension size) {
        Container contentPane = this.getContentPane();
        Dimension actualSize = contentPane.getSize();
        if (size.equals(actualSize)) {
            return;
        }
        Dimension frameSize = frame.getSize();
        frameSize.width += size.width - actualSize.width;
        frameSize.height += size.height - actualSize.height;
        frame.setSize(frameSize.width, frameSize.height);
        frame.validate();
    }

    private static String readMainClassFromManifest(String jarName) {
        try {
            ZipFile jarFile = new ZipFile(jarName);
            ZipEntry entry = jarFile.getEntry("META-INF/MANIFEST.MF");
            if (entry == null) {
                return null;
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(jarFile.getInputStream(entry)));
            String line = rd.readLine();
            while (line != null) {
                if (line.startsWith("Main-Class:")) {
                    return line.substring("Main-Class:".length()).trim();
                }
                line = rd.readLine();
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private static String getShellCommandLine() {
        try {
            String option = Platform.isMac() ? "command" : "args";
            String[] argv = new String[]{"bash", "-c", "ps -p $PPID -o " + option};
            Process p = Runtime.getRuntime().exec(argv);
            p.waitFor();
            if (p.getErrorStream().read() != -1) {
                return null;
            }
            BufferedReader rd = new BufferedReader(new InputStreamReader(p.getInputStream()));
            rd.readLine();
            return rd.readLine();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

