// ---------------------------------------------------------------------------
// The Play, by Deirdra Kiai
// ---------------------------------------------------------------------------

undum.game.id = "http://www.deirdrakiai.com/theplay/";

undum.game.version = "1.0";

undum.game.situations = {

	"001": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			All right, Ainsley. This is it. Just one more run through the entire play, and we'll be all good to go. Never mind that your leading lady had a serious allergic reaction to the face paint and needed to be replaced at the very last minute. And for that matter, never mind that the rest of the cast has only had a grand total of two weeks to rehearse. The show must go on, yada yada yada, and because you are the brilliant and talented Ainsley Morgan Warrington, you will make it so.[br]\
			Well, you'd better, anyway, or your fading career'll finally extinguish into nonexistence and you'll find yourself having to take up substitute teaching or something equally horrible.[br]\
			\"_Right, then. From the top!_[002]\"\
			");
		}
	}),

	"002": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			-SETTING: An artist’s studio in Ancient Rome. A beautiful statue stands still on a pedestal in the middle of the room. She is surrounded by a dining couch, a cypress tree, a large urn, and several paintings on easels.-[br]\
			-The statue begins to fidget with her dress. A gladiator climbs through the window and does a double take at the sight of her.-[br]\
			[/play][br]\
			\"Hey, uh, Ainsley?\" _Karl_(002-a) stares straight at you with that typically slack-jawed look on his face. \"_Is she supposed to be moving around like that?_[003]\"\
			");
		},
		actions: {
			"002-a": function(character, system, action) {
				system.say("Karl Papadakis fancies himself a stand-up comedian -- not a particularly good one, or so you've heard, but what do you know? You don't even like stand-up comedy. Either way, he's here because he wishes to broaden his theatrical horizons, so to speak. Whether he's actually broadening anything besides your capacity for patience is anyone's guess.");
			}
		}
	}),
	
	"003": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			Of course she isn't supposed to be moving. She's supposed to be standing completely still, just like one of those creepy street performers you keep seeing on the pier... you know, the ones who startle tourists with sudden movements.[br]\
			You clear your throat. \"What seems to be the problem, Emily?\"[br]\
			\"_Erica_(003-a),\" she replies through gritted teeth.[br]\
			\"My apologies. Erica. Now, I understand you only just got here, so let me take the time to remind you that there are only two things you're required to do in this production -- that is to say, stand as still as possible, and recite the correct lines. _It appears as though you're having a bit of trouble with the former?_[004]\"\
			");
		},
		actions: {
			"003-a": function(character, system, action) {
				system.say("The producers had no budget for a proper understudy, so when Vivian had to be rushed to the hospital, it was up to you to scramble around and find a replacement. The only local actress available on such short notice was one Erica Harding, whose previous credentials involved a bit part in -The Fallopian Fugues-. Nothing near ideal -- really, for a production of this low calibre, what could you possibly expect? -- but she will have to do.");
			}
		}
	}),
	
	"004": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"I'd be fine if this damn _dress_(004-a) didn't keep riding up everywhere. Seriously, you should try breathing in this thing. It's like I've been shrink wrapped or something.\"[br]\
			%Hmm. Now that she mentions it, Vivian -was- quite a bit less... er, endowed... than the new girl. This does pose a problem. Perhaps you should _call on Henrietta for help_[005]? Then again, the less time you spend on disruptions, the sooner you'll be able to get home for some much-needed rest. Might be best to _move along and deal with it tomorrow_[012].%\
			");
		},
		actions: {
			"004-a": function(character, system, action) {
				system.say("It's a nice dress, coloured the same marble white as its wearer's makeup, but she's right, it does look rather uncomfortably tight. Come to think of it, it vaguely reminds you of that number you wore at a particularly memorable costume party, back in your university days. Oh, to have legs like -that- again...");
			}
		}
	}),
	
	"005": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"_HENRIETTA!_(005-a)\" you bellow at the top of your lungs. If anyone can fix this mess, it's her. Right on cue, she drowsily stumbles in from backstage, her mousy brown hair looking even more bedraggled than usual.[br]\
			\"Yeah, yeah, I'm here, _what happened this time?_[006]\"\
			");
			character.sandbox.henriettaEntered = true;
		},
		actions: {
			"005-a": function(character, system, action) {
				system.say("Henrietta's your long-suffering stage manager. Most of your friends in the business wanted nothing to do with you after your fall from grace, but not her. She's stuck with you all this time, bless her soul -- still as hard-working and eager to please as she was back when you first collaborated on -The Ballad of Benji Benjamino- over a decade ago.");
			}
		}
	}),
	
	"006": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Seems like that dress is a touch too small for Erin&#x2014\"[br]\
			\"Erica!\"[br]\
			\"Yes, that's what I meant. Anyway, I'm going to need it altered as soon as possible. Preferably immediately.\"[br]\
			Henrietta pushes her glasses up her nose. \"Richard's already on his way to New York to do costumes for -For All Intensive Porpoises-.\"[br]\
			\"Well, can't you do it?\"[br]\
			\"Me? Sew? You're kidding, right?\"[br]\
			%You desperately wish you were, but truth be told, you're rather out of options. You could just _ask her to do something, anything to make it fit_[007]. Or maybe there's _something lying around from a previous production_[009]. Or you could, of course, ignore the dress and _get on with the rehearsal already_[011].%\
			");
		}
	}),
	
	"007": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Honestly, Henrietta, you're about the only real hope I've got at this time of night. Isn't there -something- you can do to fix the dress?\"[br]\
			\"All right, all right. I can't promise this'll work, but I'll do my best.\" With that, she gestures for Em -- er, Erica to follow her backstage.[br]\
			A few minutes and ripping noises later, she emerges in the same dress held together with staples and duct tape. _She climbs back up on the pedestal..._[008]\
			");
		}
	}),
	
	"008": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			...and as she does, the dress falls right off, leaving her in nothing but her underwear. Great. Just... great.[br]\
			Politely averting your eyes, you notice Karl having considerably less success at doing the same, instead standing absolutely shell-shocked. Don't young men have the internet for this sort of thing?[br]\
			\"The hell are you staring at?!\" Erica snipes as she darts backstage to cover herself up.[br]\
			Henrietta shrugs sheepishly. \"I told you I couldn't promise it'd work.\"[br]\
			\"Fine. I'm sorry I asked. Of course, now she's going to need a new costume.\" You're not quite yet at the point in your career where you feel the need to use nudity to garner more ticket sales, and you pray you never get there.[br]\
			\"I guess I could see if there's something left behind from another show. _Gimme a sec._[010]\"\
			");
			system.setQuality("erica", dec(character.qualities.erica));
			system.setQuality("henrietta", dec(character.qualities.henrietta));
		}
	}),
	
	"009": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Sorry I asked.\" Henrietta was always much better with power tools than sewing equipment. \"Could you just find something else she could wear? I'm sure I saw some leftover costumes backstage.\"[br]\
			\"Sure, I'll see what I can dig up. _Gimme a sec._[010]\"\
			");
		}
	}),
	
	"010": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			Several minutes later, Henrietta returns, followed by Erica wearing a rather frumpy floral print sundress. You think you recognise it from last month's run of -Much Alarm About Agnes-.[br]\
			\"This was all I could find. Well, either this or a furry bear suit.\"[br]\
			\"It'll have to do, I suppose. We can always paint it white later. Now, come on, _let's get back to rehearsing, already_[013].\"\
			");
			character.sandbox.changedDress = true;
		}
	}),
	
	"011": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			You decide not to bother Henrietta after all. Poor dear's been working sixteen-hour days and depleting the theatre's coffee supply at an astronomical rate. Least you could do is _give her somewhat of a break_[012].\
			");
		}
	}),
	
	"012": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"I'll try and find someone to take care of the dress problem tomorrow. In the meantime, we have to focus on getting through this rehearsal, which is eating away at valuable time I could be spending sleeping or watching low-budget monster movies. Now, Emma&#x2014\"[br]\
			\"Erica!\"[br]\
			\"Whatever. I need you to try your best to act more statue-like, regardless of tight clothing. Do you think you could do that for me? Please?\"[br]\
			\"Fine,\" she mumbles noncommittally.[br]\
			\"And Karl? If she does start moving around, at least -try- to pretend she's completely stationary.\"[br]\
			\"You're the boss.\"[br]\
			\"Excellent! _Let's get on with it, then!_[015]\"\
			");
			system.setQuality("erica", dec(character.qualities.erica));
		}
	}),
	
	"013": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
		   	-SETTING: An artist’s studio in Ancient Rome. A beautiful statue wearing a frumpy floral print dress stands still on a pedestal in the middle of the room. She is surrounded by a dining couch, a cypress tree, a large urn, and several paintings on easels.-[br]\
			-A gladiator climbs through the window, then paces frantically around the studio, mumbling to himself and looking for a place to hide.-[br]\
			STATUE: -(frozen in place, moving nothing but her lips)- He never told me he was having a guest over.[br]\
			GLADIATOR: -(freezes in his tracks)- What? Who said that? Who's in here?[br]\
			STATUE: Never met a talking statue before, have you?[br]\
			GLADIATOR: You're a... you're... Mrs. Robertson!\
			[/play][br]\
			\"_Er, Karl?_[014]\"\
			");
		}
	}),
	
	"014": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Crap! Did I say that out loud? It's just... that's the exact same dress my fifth grade teacher always used to wear, I'm not kidding.\"[br]\
			\"Oh, so now I look like a schoolmarm. Wonderful.\" Erica crosses her arms in irritation.[br]\
			\"Well, if it makes you feel any better, she was kinda hot...\"[br]\
			\"Ugh!\"[>017]\
			");
		}
	}),
	
	"015": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
		   	-A gladiator climbs through the window, then paces frantically around the studio, mumbling to himself and looking for a place to hide.-[br]\
			STATUE: -(frozen in place, moving nothing but her lips)- He never told me he was having a guest over.[br]\
			GLADIATOR: -(freezes in his tracks)- What? Who said that? Who's in here?[br]\
			STATUE: Never met a talking statue before, have you?[br]\
			GLADIATOR: You're a... you're... Marilyn Monroe!\
			[/play][br]\
			\"_Er, Karl?_[016]\"\
			");
		}
	}),
	
	"016": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Oh, crap, I just said that out loud, didn't I? It's just... she looks exactly like that picture, y'know, the one with her standing on the air vent where her underwear's showing? Except she also looks like she has to pee real bad.\"[br]\
			\"Okay, seriously? Eeugh.\" Erica crosses her arms in irritation.[>017]\
			");
		}
	}),
	
	"017": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			%Wonderful. Just what you need right now. Another potential _sexual harassment_(017-a) situation on your hands. Question is, Ainsley, what do you do about it this time? Your first instinct is to _chew Karl out_[018], but then you think maybe it'd be a better idea to try and _smooth things over with Erica_[019] instead.%\
			");
		},
		actions: {
			"017-a": function(character, system, action) {
				system.say("Memories of -Feelings!- and the whole debacle with Langdon Godfrey begin to flood back into your mind, but there's no time to dwell on that right now. You clear your throat and continue.");
			}
		}
	}),
	
	"018": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Very suave and debonair of you, Karl. I'm sure Erica's absolutely flattered by your lacklustre attempt at flirtation.\"[br]\
			\"Really?\" Sarcasm doesn't appear to get through to the poor boy. You'll have to try a more direct approach.[br]\
			\"Let me spell it out for you: while we may not have a human resources department, this is nevertheless a professional environment. As such, I expect you to conduct yourself with a certain amount of decorum and respect, which most certainly does -not- include ogling your fellow performers. Am I making myself clear?\"[br]\
			\"Y-yeah... sure... okay...\" Karl stammers as you watch him visibly deflate. Erica, meanwhile, looks relieved -- or at least, a touch less tense.[br]\
			\"Good. Now, _try that line again_[020].\"\
			");
			system.setQuality("karl", dec(character.qualities.karl));
			system.setQuality("erica", inc(character.qualities.erica));
		}
	}),
	
	"019": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Erica, darling, don't pay him too much mind. He's just trying to flatter you, awkward and misguided though his attempts may be. And believe you me, it could be much worse, and I say this from experience.\"\
			");
			if (character.qualities.erica < 0) {
				system.say("[br]\
				\"So you're siding with Creepface McCreeperson over here. Typical. And what's with calling me -darling-? What century are you from, anyway?\"[br]\
				You sigh in exasperation. Perhaps this wasn't the best tactic after all. Damned if you do, damned if you don't: that's how it always goes with these things. \"Very well then. Forget I said anything. Karl, _try that line again with the -correct- words_[020], if at all possible.\"\
				");
				system.setQuality("erica", dec(character.qualities.erica));
			} else {
				system.say("[br]\
				\"Huh. Whatever.\" She shrugs and lets out a sigh. Well, that wasn't too bad. Sometimes, all people need is a little talking to.[br]\
				\"Right. Now, Karl, try that line again, and while you're at it, _try saying the -correct- words for once_[020].\"\
				");
			}
		}
	}),
	
	"020": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			GLADIATOR: You're a... you're... but... how?[br]\
			STATUE: I don't know. Why don't you ask -him-? He made me.[br]\
			GLADIATOR: Who?[br]\
			STATUE: ...oh. So you're not one of his...[br]\
			GLADIATOR: -(paces around the room)- Look. I don't really have any time to stay and chitchat. I need a place to hide. It's important.[br]\
			STATUE: I don't understand...\
			[/play][br]\
			Erica throws her hands up in frustration. \"Okay, _you wanna know what I don't understand?_[021]\"\
			");
		}
	}),
	
	"021": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			No, of course you don't, because as previously mentioned, you wanted to get this rehearsal over and done with as soon as possible. However, that doesn't stop her from continuing.[br]\
			\"Why isn't my character putting up more of a fight, here? I mean, the guy's basically breaking and entering, and she's just letting him. There's no way -I'm- playing yet another woman who stands there passively while the men get to do all the -important- stuff.\"[br]\
			%She does have a point, mind you -- _James Dough_(021-a) was never particularly known for his progressive portrayals of women -- but with only one rehearsal left until opening night, _you can't afford to waste time on revisions_[029]. However, you also can't afford to lose yet another leading lady, so perhaps it would be wise to _oblige her somewhat_[022].%\
			");
		},
		actions: {
			"021-a": function(character, system, action) {
				system.say("Your mind flashes back to the one and only time you met the late James Dough in the flesh. It was at some party or other, ages ago. You were still rather young and at the very beginning stages of your career, and he was already getting on in years. Still, your impressions of the elderly playwright were never particularly positive; he stank of rotten cheese and you could have sworn he tried to take a peek beneath your friend Angela's skirt. Most other colleagues of yours seem to hold him in high esteem, however.");
			}
		}
	}),
	
	"022": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			Well, it certainly couldn't hurt to give Dough's tired old script a fresh new interpretation. A sly smile forms across your lips. \"All right, Erica. What do you suggest she do instead?\"[br]\
			\"I dunno. Something. Anything, I guess.\"[br]\
			\"Come on, now, give me an example. Show me.\" As far as you're concerned, if there's rewriting to be done, you're not going to be the one to do it.[br]\
			\"What do you mean?\"[br]\
			\"You're an actress, aren't you? Improvise.\"[br]\
			\"_Well, okay..._[023]\"\
			");
		}
	}),
	
	"023": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			STATUE: I'm sorry, sir, but I'm going to have to ask you to leave.[br]\
			GLADIATOR: What? But they&#x2014[br]\
			STATUE: -(raises voice)- You're trespassing on private property. The local authorities will be here any minute now. Leave immediately and no one will get hurt.[br]\
			GLADIATOR: They're making&#x2014[br]\
			STATUE: You heard me. Leave. -Now.-\
			[/play][br]\
			\"Aw man, now what am I supposed to do?\"[br]\
			%For a stand-up comedian, Karl's improvisational skills sadly appear somewhat lacking. You could just tell him to _put himself in the character's shoes_[024], or perhaps you could attempt to _play the situation to his strengths_[026]. Then again, you're also starting to think to yourself that _sticking to the script was the better idea, after all_[030].%\
			");
			system.setQuality("erica", inc(character.qualities.erica));
			character.sandbox.improvised++;
		}
	}),
	
	"024": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Well, Karl, what would -you- do in this predicament?\"[br]\
			\"Huh, good question. I, uh, think I'd just leave. Maybe check if the next house is empty? Don't want to make any trouble, you know.\"[br]\
			Sadly, that won't quite do, since there'll be no play to speak of. \"All right, suppose for the sake of this exercise that there is no next house. Your goal is to remain in this room as long as possible.\"[br]\
			\"So you're saying I should, like, stall her?\"[br]\
			Sure, why not? \"_Yes. Stall her. That's a great idea._[025]\"\
			");
		}
	}),
	
	"025": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			GLADIATOR: I'm not leaving![br]\
			STATUE: Didn't you hear me? The authorities will be arriving soon.[br]\
			GLADIATOR: Well, you know what? I don't think there -are- any authorities. I think you just made them up.[br]\
			STATUE: I most certainly did not![br]\
			GLADIATOR: All right, then, prove it! Let them come out and arrest me! I'm just going to stand here until they do![br]\
			-Silence ensues for the next two minutes.-\
			[/play][br]\
			\"Ainsley! This is taking forever! _What are you trying to do, put the audience to sleep?_[027]\"\
			");
			system.setQuality("karl", inc(character.qualities.karl));
			character.sandbox.improvised++;
		}
	}),
	
	"026": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Karl, put those supposed comedy skills of yours to good use. Why don't you tell a joke or something?\"[br]\
			\"A joke! I can tell a joke. Let's see, uh...\"\
			[play][br]\
			GLADIATOR: You know, this reminds me of the last time I got the cops called on me. It was the night I snuck into that bachelorette party. 'Course, later on, I found out they were just the entertainment...\
			[/play][br]\
			\"Ainsley, _what in the name of George Bernard Shaw do you think you're doing?_[027]\"\
			");
			system.setQuality("karl", inc(character.qualities.karl));
			character.sandbox.improvised++;
		}
	}),
	
	"027": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			You whirl around and notice _Brock_(027-a), who seems to have just returned from his extended smoke break. \"I don't know what shoddy script -you're- reading, but I was under the impression that we were supposed to be rehearsing -Nothing's Fair...-\"[br]\
			%He smugly smiles as you feel your face turning a bright shade of red. On one level, _you do agree with him, sort of_[031]. On many other levels, however, _you don't particularly -want- to_[028].%\
			");
			character.sandbox.brockEntered = true;
		},
		actions: {
			"027-a": function(character, system, action) {
				system.say("What can you say about Brock Morgenstern, really? He's certainly the most -experienced- of this particular cast. Knows exactly what he's doing and gets right down to business, that sort of thing. That said, while the two of you were never on particularly chummy terms, he seems almost hostile to you these days. He's a close, personal friend of Langdon's. Go figure.");
			}
		}
	}),
	
	"028": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Brock, did I ask you to share your brilliant insights? Did I even ask you to say anything at all? No? Then I think you'd do well to let -me- do the directing, here.\"[br]\
			\"Suit yourself. If you're really so desperate for yet -another- box office flop, I won't get in your way.\" With that, he storms back outside in a huff.[br]\
			\"Right,\" you mumble. \"_Now, where were we, again?_[034]\"\
			");
			system.setQuality("brock", dec(character.qualities.brock));
		}
	}),
	
	"029": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.sandbox.changedDress) {
				system.say("[br]\
				\"She's a statue, Erica. She's -supposed- to stand there passively. Plus, thanks to all that time we just spent looking for a new dress for you to wear, there's really nothing that can be done about it.\"\
				");
			} else {
				system.say("[br]\
				\"She's a statue, Erica. She's -supposed- to stand there passively. Also, as I'm relatively certain I mentioned earlier, we're extremely short on time.\"\
				");
			}
			system.say("[br]\
			\"But...\"[br]\
			\"Just keep on going, say your lines as written, and before you know it, this production will be over and you'll be able to play whatever strong female character you desire. _Karl, your line, please._[032]\"\
			");
			system.setQuality("erica", dec(character.qualities.erica));
		}
	}),
	
	"030": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			You let out a sigh of resignation. \"Well, Erica, it looks like rewriting the script isn't such a trivial task after all, now is it?\"[br]\
			\"I guess not,\" she murmurs monotonously as she glares at Karl, who simply shrugs.[br]\
			\"I'm sorry, but at least this way, he isn't freezing up on stage and ruining the show for everyone. _Moving along, now!_[032]\"\
			");
			system.setQuality("erica", dec(character.qualities.erica));
			system.setQuality("karl", dec(character.qualities.karl));
			character.sandbox.improvised--;
		}
	}),
	
	"031": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			As much as it pains you to admit it, Brock's right: while James Dough's stilted dialogue and tired subject matter is bad enough, what you see happening on stage right in front of you is even worse.[br]\
			\"Karl, Erica, I'm sorry, but this clearly isn't working. Let's go back to what's in the script, shall we?\" In response, Erica and Karl make the kinds of noises you'd hear from a pair of petulant three-year-olds who've just had their Duplo blocks taken away.[br]\
			Brock rolls his eyes and sneers. \"If you'll excuse me, I'll be stepping back outside. Wake me up when you people actually start -acting-, for once.\"[br]\
			\"Right,\" you mutter, trying not to let yourself be bothered. \"_Where were we, again?_[032]\"\
			");
			system.setQuality("brock", inc(character.qualities.brock));
			system.setQuality("erica", dec(character.qualities.erica));
			system.setQuality("karl", dec(character.qualities.karl));
			character.sandbox.improvised--;
		}
	}),
	
	"032": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			GLADIATOR: They’re making me fight an ostrich tomorrow! An ostrich! I’m gonna lose, I just know it, and I’m not ready to go, damn it! Not yet! -(slumps on couch, burying face in hands)-[br]\
			STATUE: But it’s just a harmless bird, isn’t it?[br]\
			GLADIATOR: Harmless! Ha! You should see how badly it maimed the last guy. Those things sure can kick.[br]\
			STATUE: I see. Can’t you just forfeit?[br]\
			GLADIATOR: -(stands up)- You just don’t get it, do you? If I forfeit, they’ll just kill me anyway. I’m nothing but entertainment to these people. Just another sack of blood and guts they want to rip apart and smother all over their faces for lunch&#x2014[br]\
			[/play][br]\
			Hmm... _that definitely doesn't sound right_[033].\
			");
		}
	}),
	
	"033": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Karl, darling, this is supposed to be a somewhat family friendly show. Cannibalism isn't called for anywhere in the script.\"[br]\
			\"Ack, did I just say... oh crap. Let me try again.\"\
			");
			if (character.qualities.erica < -1) {
				system.say("[br]\
				\"_You do that._[036]\" Out of the corner of your eye, you spy Erica gritting her teeth and glaring at him in irritation.\
				");
				system.setQuality("karl", dec(character.qualities.karl));
			} else if (character.qualities.erica > 0) {
				system.say("[br]\
				\"_You do that._[036]\" Out of the corner of your eye, you spy Erica trying not to burst out laughing, and Karl winking and grinning at her in response.\
				");
				system.setQuality("karl", inc(character.qualities.karl));
			} else {
				system.say("[br]\
				\"_You do that._[036]\"\
				");
			}
		}
	}),
	
	"034": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			GLADIATOR: They’re making me fight an ostrich tomorrow! An ostrich! I’m gonna lose, I just know it, and I’m not ready to go, damn it! Not yet! -(slumps on couch, burying face in hands)-[br]\
			STATUE: Pfft. You're seriously getting all worked up about an -ostrich-? What kind of coward -are- you?[br]\
			GLADIATOR: Well, uh, lady... I'll have you know that ostriches are some of the most horrible, ferocious beasts in all of Rome! And they sure can kick. I should know; I used to be married to one.[br]\
			STATUE: And you're sure it wasn't just because you were hogging the covers?[br]\
			GLADIATOR: Okay, so it gets cold in these shoddy excuses for houses. Sue me.\
			[/play][br]\
			%Hrmph. All this improvisation is nice and all, but it seems to be veering a bit off track; you still have to get to the part where the statue's artist shows up, after all. Should you _speak up and say something_[035], or just _trust that they'll get there on their own_[038]?%\
			");
			character.sandbox.improvised++;
		}
	}),
	
	"035": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"All right, kids, let's not go too far off the rails. Remember: the artist does still need to barge in at some point.\"\
			");
			if (character.qualities.erica < 0) {
				system.say("[br]\
				Erica rolls her eyes. \"Hey, don't look at me; I'm not the one making stupid jokes about my ex-wife.\"[br]\
				\"Yeah, well... you shouldn't have called me a coward!\"[br]\
				Oh, brother. \"That's quite enough, you two. I'm not about to waste precious rehearsal time watching you bicker. Let's get back to where we left off.\"\
				");
				system.setQuality("erica", dec(character.qualities.erica));
				system.setQuality("karl", dec(character.qualities.karl));
			}
			system.say("[br]\
			Karl nods. \"Gotcha.\"[br]\
			Erica shrugs. \"_Whatever you say, Ainsley._[037]\"\
			");
		}
	}),
	
	"036": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			GLADIATOR: -(stands up)- You just don’t get it, do you? If I forfeit, they’ll just kill me anyway. I’m nothing but entertainment to these people. Just another sack of blood and guts they want to rip apart and smother all over the room while they sit into their high-priced seats and cheer and eat their lunch.[br]\
			STATUE: That’s the most barbaric thing I’ve ever heard. I’m so sorry.[br]\
			GLADIATOR: So, you see, that’s why I need to hide. And whatever you do, you can’t tell anyone I was in here, or else...[br]\
			-Complete silence ensues in response.-\
			[/play][br]\
			\"Oh, silly me. _Is this my entrance?_[040] I'm sorry, I'd nearly fallen asleep.\"\
			");
		}
	}),
	
	"037": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			GLADIATOR: -(stands up)- The thing is, they're gonna kill me no matter what I do. I’m nothing but entertainment to these people. Just another sack of blood and guts they want to rip apart and smother all over the room while they sit into their high-priced seats and cheer and eat their lunch.[br]\
			STATUE: That’s the most barbaric thing I’ve ever heard. I’m so sorry.[br]\
			GLADIATOR: So, you see, that’s why I need to hide. And whatever you do, you can’t tell anyone I was in here, or else...[br]\
			-Complete silence ensues in response.-\
			[/play][br]\
			\"Oh, I'm sorry. I was so bored by this subpar performance, I nearly _forgot my entrance_[040]. Silly me.\"\
			");
		}
	}),
	
	"038": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"You're doing great, kids! _Keep up the good work_[039].\" Hey, friendly encouragement sometimes -does- result in good work. Can't hurt to try, at any rate.\
			");
			system.setQuality("erica", inc(character.qualities.erica));
			system.setQuality("karl", inc(character.qualities.karl));
		}
	}),

	"039": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			STATUE: Well, if you hate these houses so much, why don't you just leave?[br]\
			GLADIATOR: -(stands up)- I told you, they're going to have me killed! For entertainment![br]\
			STATUE: And what makes you think I won't have you killed for breaking and entering?[br]\
			GLADIATOR: I'm... kinda good looking, I guess? Yeah, that's right. You really don't want to see my awesome body get ripped to shreds by fearsome beasts, trust me. -(poses and flexes muscles)-[br]\
			STATUE: Enh. You're no statue, that's for sure.\
			[/play][br]\
			\"Oh, for Shakespeare's sake! _Is this mind-numbing nonsense quite finished yet?_[040]\"\
			");
			character.sandbox.improvised++;
		}
	}),
	
	"040": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (!character.sandbox.brockEntered)
			{
				system.say("[br]\
				You whirl around and notice _Brock_(040-a), who appears to have returned from his extended smoke break. \"Before tonight's dress rehearsal, I'd have said this'd be one of the top three dullest performances of -Nothing's Fair...- I've ever been part of, but now, I know it's easily the absolute worst.\"\
				");
				character.sandbox.brockEntered = true;
			}
			system.say("[br]\
			\"Brock, darling. How nice of you to join us. If you could just go over there and play your part with the rest of the cast, that'd be absolutely wonderful.\" You fold your hands on your lap, trying your level best to resist the urge to smack him over the head.[br]\
			\"Gladly,\" he spits back at you as he turns and _saunters over to the stage_[041].\
			");
		},
		actions: {
			"040-a": function(character, system, action) {
				system.say("What can you say about Brock Morgenstern, really? He's certainly the most -experienced- of this particular cast. Knows exactly what he's doing and gets right down to business, that sort of thing. That said, while the two of you were never on particularly chummy terms, he seems almost hostile to you these days. He's a close, personal friend of Langdon's. Go figure.");
			}
		}
	}),

	"041": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: -(off stage)- Who are you talking to in there?[br]\
			STATUE: No one! -(whispers)- It’s him! Quick! Hide![br]\
			GLADIATOR: Where?[br]\
			STATUE: -(still whispering)- I don’t know! Anywhere![br]\
			-The gladiator jumps and hides under the dining couch just as the artist walks into the room. The couch appears to wobble slightly.-\
			[/play][br]\
			%Hrm, that _dining couch_(041-a) definitely looks a touch unstable, but then, what can you really expect for the almost nonexistent budget the stage crew's been given? Still, the script does call for at least one person to sit on it. Do you think it's _worth worrying about_[042], or do you just _carry on and hope for the best_[044]?%\
			");
		},
		actions: {
			"041-a": function(character, system, action) {
				system.say("You eye the couch: a near-perfect replica of a Roman dining couch, or lectus, as seen in myriad reference pictures, made using only scrap particle board, styrofoam, and paint. Yes, Henrietta and her crew do know what they're doing, despite the lack of any proper building materials.");
			}
		}
	}),
	
	"042": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.sandbox.henriettaEntered) {
				system.say("[br]\
				\"Henrietta, sweetheart,\" you yell in the general direction of the stage, \"could you come back over here for a second?\"\
				");
			} else {
				system.say("[br]\
				\"_HENRIETTA!_(042-a)\" you bellow at the top of your lungs. Right on cue, she drowsily stumbles in from backstage, her mousy brown hair looking even more bedraggled than usual.\
				");
				character.sandbox.henriettaEntered = true;
			}
			system.say("[br]\
			\"What's up, Ainsley?\"[br]\
			\"The dining couch over there looks like it's barely struggling to stay up. Anything you can do to help it?\"[br]\
			\"Hmm...\" She scrunches her brow. \"The crew's all gone home, but I can try and give it some reinforcement, if you really need me to.\"[br]\
			%Do you think _it's a good idea to let her_[043], or should you _save her the trouble_[045]?%\
			");
		},
		actions: {
			"042-a": function(character, system, action) {
				system.say("Henrietta's your long-suffering stage manager. Most of your friends in the business wanted nothing to do with you after your fall from grace, but not her. She's stuck with you all this time, bless her soul -- still as hard-working and eager to please as she was back when you first collaborated on -The Ballad of Benji Benjamino- over a decade ago.");
			}
		}
	}),
	
	"043": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Yes, that'd be wonderful. Thank you.\"\
			");
			if (character.qualities.henrietta < 0) {
				system.say("[br]\
				You watch her dash backstage and return with some tools and an armload of scrap prop material. Once Karl crawls out from underneath the couch, she immediately gets to work, drilling and hammering things in place, though not with quite the same adeptness you've come to expect of her over the years.[br]\
				\"AGH!\" she yells suddenly, and you notice her shaking her hand in pain. \"It's okay, it's okay, I'm fine,\" she mutters to herself, though she clearly isn't. Maybe this wasn't the greatest of ideas after all.\
				");
				system.setQuality("henrietta", dec(character.qualities.henrietta));
			} else {
				system.say("[br]\
				You watch her dash backstage and return with some tools and an armload of scrap prop material. Once Karl crawls out from underneath the couch, she immediately gets to work, drilling and hammering things in place. The girl's always been a natural at this sort of thing.\
				");
				system.setQuality("henrietta", inc(character.qualities.henrietta));
			}
			system.say("[br]\
			\"There,\" she announces a few minutes later. \"That should hold it.\" Karl rolls back under the couch and gives you a thumbs up. Definitely a messy, haphazard repair job, but at least it seems to be sturdy.[br]\
			\"Fantastic. _Back to where we were, then!_[046]\"\
			");
			character.sandbox.repairedCouch = true;
		}
	}),
	
	"044": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			Well, it's only wobbling a little bit. Definitely not worth fussing over. You nod firmly to yourself as _the actors continue_[046].\
			");
		}
	}),
	
	"045": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"In that case, don't worry about it, dear. We can live with it.\" She looks more bleary-eyed than ever, even despite all that coffee she's been drinking. Probably a good idea not to let her go near any power tools in this state.[br]\
			\"Okay, Ainsley,\" she shrugs, returning backstage.[br]\
			\"Now, then. _Back to where we were._[046]\"\
			");
		}
	}),

	"046": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: -(glances back and forth)- Hmm. Empty. I could have sworn I heard someone yelling.[br]\
			STATUE: Oh, I was just talking to myself.[br]\
			ARTIST: You never talk to yourself.[br]\
			STATUE: How do you know? It’s not like you’ve come to visit me all that much, lately.[br]\
			ARTIST: -(walks towards couch)- Like I’ve told you countless times, I’ve been busy. -(sits down, facing away)-\
			[/play]\
			");
			if (character.sandbox.repairedCouch) {
				system.say("[br]\
				You hold your breath as _the dining couch creaks under Brock's weight_[064]...\
				");
			} else {
				system.say("[br]\
				You hold your breath as _the dining couch creaks under Brock's weight_[047]...\
				");
			}
		}
	}),
	
	"047": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			...and watch in horror as the legs snap and fall right off and the whole couch collapses with a crash. A nanosecond later, Brock appears to be sitting on Karl's back, who in turn is wincing in slight discomfort. Poor thing.[br]\
			\"Can't even get proper furniture, I see.\" Brock stands up and gives you an even-more-sour-than-usual look. \"No wonder there isn't a single self-respecting actor in town who'd _work with -you-_(047-b).\"\
			");
			if (character.sandbox.henriettaEntered) {
				system.say("[br]\
				\"Aw, great,\" murmurs Henrietta as she surveys the scene with a frown. \"I shoulda known it wouldn't hold up. Guess I'd better _get this mess fixed_[048], huh?\"\
				");
			} else {
				system.say("[br]\
				Just then, a very bedraggled-looking, bleary-eyed _Henrietta_(047-a) appears, surveying the scene with a frown. \"Aw, great. I shoulda known it wouldn't hold up. Guess I'd better _get this mess fixed_[048], huh?\"\
				");
				character.sandbox.henriettaEntered = true;
			}
		},
		actions: {
			"047-a": function(character, system, action) {
				system.say("Henrietta's your long-suffering stage manager. She's stuck with you all this time -- even after your fall from grace, bless her soul -- and she's still just as hard-working and eager to please as she was back when you first collaborated on -The Ballad of Benji Benjamino- over a decade ago.[br]\
				Of course, after this debacle of a play, who knows whether that'll continue to be the case?");
			},
			"047-b": function(character, system, action) {
				system.say("Brock's right, of course. No one wants to work with you these days, not after what happened with Langdon Godfrey. Gossip travels fast around these parts, and everyone thought you were out of your mind, firing such a high-profile, talented, and admittedly ridiculously good-looking man. He would've brought your career to a whole new level of acclaim, and instead, you threw it all down the toilet. Be that as it may, you can't quite bring yourself to regret it...");
			}
		}
	}),
	
	"048": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			You bury your face in your hands. \"Well, we don't have much of a choice, now do we?\"\
			");
			if (character.qualities.karl > 0) {
				system.say("[br]\
				\"Hey, wait,\" Karl interjects, \"I got an idea!\"[br]\
				Oh dear. \"What is it, Karl?\"[br]\
				\"Well, wouldn't it be kinda funny if, y'know, we just left it in? The couch breaking, I mean? He could be all like -hey, what are you doing in here?- and stuff. I dunno. Just a suggestion.\"\
				");
				if (character.qualities.erica > 0) {
					system.say("[br]\
					Erica cracks a slight smirk. \"That -would- be pretty funny. All I do is whine about being neglected in this scene, anyway.\"\
					");
				} else {
					system.say("[br]\
					Erica sighs in irritation. \"God, no. I want to get out of here, damn it.\"\
					");
				}
				system.say("[br]\
				%What do you say, then, Ainsley? _Make the best out of a frustrating situation_[049], or _just keep going as you were_[062]?%\
				");
			} else {
				system.say("[>063]");
			}
		}
	}),
	
	"049": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			The more you think about it, the more you like the idea. \"All right, then. Henrietta, fix the dining couch, but only just enough so it'll collapse in the exact same way tomorrow. Brock, Karl, assume the same positions you were in before, and try and preserve those looks of wide-eyed surprise, if at all possible.\"[br]\
			\"Ugh, this is completely and utterly ridiculous,\" Brock mutters as he _re-seats himself over top of Karl_[050].\
			");
		}
	}),

	"050": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			-The artist suddenly discovers that the couch has collapsed under him, and is now sitting on the gladiator.-[br]\
			ARTIST: Hmm. That's strange. This dining couch feels somewhat... bonier than usual.[br]\
			STATUE: And you're sure it isn't from forgetting to feed yourself?[br]\
			ARTIST: No, I absolutely insist, something's... -(glances down at the gladiator)- ...well, what do we have here? -(grabs the gladiator by the collar)- An intruder, I see? Looks like I ought to turn you over to the authorities![br]\
			GLADIATOR: -(picks up a piece of couch debris and holds it threateningly)- Oh yeah? Not if I can help it!\
			[/play][br]\
			%Oh, dear. This could potentially turn out violent. Should you _raise an objection_[051], or let them _go on as they are_[053]?%\
			");
			character.sandbox.improvised++;
		}
	}),
	
	"051": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Hold it. I don't want you turning this into a bloodbath, all right? Otherwise, I'd have to get you all to sign waiver forms, which we really don't have time for right now.\"[br]\
			\"_Okay._[052]\" Karl sighs and puts down the piece of debris he's holding.\
			");
		}
	}),

	"052": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: All right, intruder. You have exactly five minutes to leave this house safely, otherwise the authorities will be here and... let's just say you'll wish you did as I told you. And don't even think about taking anything with you, or mark my words, you -will- be found. -(walks offstage)-\
			[/play][br]\
			\"There, Ainsley. I've done my part in this charade. Now it's up to you and your motley crew of hacks to resolve it.\"[br]\
			\"Hey, who're you calling a hack, you pompous jerkwad?\" Erica retorts.[br]\
			\"Yeah,\" echoes Karl.[br]\
			\"Now, now. _Less name-calling, more rehearsing, please!_[101]\"\
			");
			system.setQuality("brock", inc(character.qualities.brock));
			character.sandbox.improvised++;
		}
	}),

	"053": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"All right, if you're going to do a fight scene, go right ahead, but please try not to severely maim one another.\"\
			[play][br]\
			-The artist, in turn, picks up a similar-sized piece of couch debris and deflects a blow from the gladiator. They spar for a good amount of time, ducking and jumping to avoid the other's makeshift weapon... until the gladiator knocks the artist's board out of his hands and stands over him with a triumphant look on his face.-\
			[/play][br]\
			\"Hey!\" yells Brock. \"_That wasn't fair!_[054] You can't just -- agh!\"\
			");
			character.sandbox.improvised++;
		}
	}),
	
	"054": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.sandbox.changedDress && character.qualities.erica >= 0)
			{
				system.say("[br]\
				\"Speaking of things that aren't fair, tell me: why do the boys get to have all the fun?\" Erica leaps off the pedestal and hitches up the skirt of her dress. \"Karl, hold up that piece of board for me, will you?\"\
				[play][br]\
				-The statue leaps up in the air and does a perfect roundhouse kick in the direction of the board the gladiator is holding up, thwacking it into pieces. Before the gladiator can react, she crouches down and trips him over, making him fall right on top of the artist.-\
				[/play][br]\
				\"Didn't know I had a black belt in taekwondo, huh?\" She smiles and surveys her handiwork as Karl and Brock gape at her in awe. Even Henrietta looks to be poking her head out and nodding in approval.[br]\
				You smile in spite of yourself. The critics will definitely be having a field day with this, and once word gets out that there's a fight scene, you'll draw in ticket sales like there's no tomorrow. \"Well done, Erica. _What happens next?_[055]\"\
				");
				system.setQuality("erica", inc(character.qualities.erica));
				character.sandbox.improvised++;
			} else {
				system.say("[br]\
				\"On the contrary, I think it was perfectly fair,\" you reply. But if you're honest with yourself, it has more to do with you not particularly wanting to rehearse several hours of choreographed fighting than any actual sense of fairness. \"Just keep playing the scene from where you are. It'll make things much simpler for all of us.\"[br]\
				Brock groans in irritation. \"_Fine._[061]\"\
				");
				system.setQuality("brock", dec(character.qualities.brock));
			}
		}
	}),

	"055": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			GLADIATOR: -(gets up)- That was some seriously impressive fighting there, m'lady. Say... you, uh, don't happen to do gladiator battles with ostriches, do you?[br]\
			ARTIST: -(also gets up)- What? No, no, you have it all wrong. She's staying right here with me. Imagine all the money I could make demonstrating this talent to the public![br]\
			STATUE: Seriously? I just kicked your butts and you expect me to stand around and do your bidding? Forget it. I'm off to see the world. Ta! -(walks off the stage)-\
			[/play][br]\
			Brock throws up his hands. \"Oh, Chekhov. What do we do now?\"[br]\
			\"Yeah, Ainsley,\" echoes Karl. What -do- we do?\"[br]\
			%Maybe there's an opportunity for _teamwork and cooperation_[056] to be had in this situation. Of course, it may just be easier to let them _part ways_[059].%\
			");
			character.sandbox.improvised++;
			character.sandbox.ericaFightScene = true;
		}
	}),
	
	"056": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Why don't you work together as a team to figure it out?\"[br]\
			\"What do you mean, exactly?\" Brock furrows his brow.[br]\
			\"Well, the artist is now without his talking statue, and the gladiator's still trying to hide from the authorities. Maybe they can help one another somehow.\"[br]\
			\"Right...\" Karl answers, then pauses for a few seconds. \"_I got an idea._[058]\"\
			");
		}
	}),

	"058": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			GLADIATOR: So, uh, you're an artist, right?[br]\
			ARTIST: Yes... what are you getting at, exactly?[br]\
			GLADIATOR: Well, I was just wondering, since I've got no place to go and this lovely rippling physique... do you, by any chance, need a model?[br]\
			ARTIST: Hrm. I'll probably live to regret this, but... -(pauses, then shrugs)- ...sure. Why not?[br]\
			GLADIATOR: Okay, then![br]\
			-The gladiator climbs up on the statue's vacant pedestal and strikes a dashing pose, while the artist grabs a sheet of paper and starts sketching.-\
			[/play][br]\
			_Not a bad ending at all._[113] Definitely veering quite a bit from the source material, but it's certainly more fun to watch, if you do say so yourself. Hopefully, the producers won't object terribly.\
			");
			system.setQuality("brock", inc(character.qualities.brock));
			system.setQuality("karl", inc(character.qualities.karl));
			character.sandbox.improvised++;
			character.sandbox.twistEnding = true;
		}
	}),
	
	"059": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Well, what do you think the characters would do in this situation? They'd probably just part ways and never talk to one another again, right?\"[br]\
			\"I guess...\" Karl rubs his chin, while Brock looks on, scrunching his brow.[br]\
			\"Then let's get to it. _Finish the play here and now!_[060]\"\
			");
		}
	}),

	"060": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			GLADIATOR: I should get going. Now that there's a violent talking statue on the loose, surely the authorities will be too preoccupied to notice -me-.[br]\
			ARTIST: Good. Now, get out of my house. I've got another statue to carve, hopefully one that won't get on my last nerve.[br]\
			-They stand around awkwardly for a moment.-[br]\
			GLADIATOR: Well, I guess this is goodbye, huh?[br]\
			ARTIST: I suppose so. Goodbye.[br]\
			-The pair shake hands quickly, then walk off in opposite directions of the stage.-\
			[/play][br]\
			There. Quite a divergent ending from the source material, but on the whole, _not bad, and rather entertaining_[113], if you do say so yourself. Hopefully, the producers won't object terribly.\
			");
			character.sandbox.improvised++;
			character.sandbox.twistEnding = true;
		}
	}),

	"061": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: All right, then. You win. Take whatever you want and get out of here. I don't want any trouble. Have a nice day. -(walks offstage)-\
			[/play][br]\
			\"Happy now, Ainsley? Good, because I'm done with this madness.\"[br]\
			Hrm. It's a bit defeatist and rushed, but it's better than nothing, you figure. \"Erica? Karl? _Finish off the scene, why don't you._[101]\"\
			");
			character.sandbox.improvised++;
		}
	}),
	
	"062": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Karl, that's a very nice suggestion, but I'd rather not entertain it right now. Not with less than eighteen hours before opening night. Henrietta?\"[>063]\
			");
		}
	}),
	
	"063": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"And I was actually hoping I'd get to go home tonight.\" You and her both. \"This is definitely gonna take a while. Here, I'll get you some folding chairs you can use instead.\"[br]\
			Henrietta quickly returns with the chairs and lines them up where the couch used to be, forming some... -thing- that looks nothing like anything that existed in Ancient Rome, but at least isn't going to collapse anytime soon. \"Now if you'll excuse me, I'm gonna make some calls and see if any of the set crew's actually awake this time of night.\"[br]\
			\"Thank you, Henrietta. The rest of you, _back to your places_[065]!\"\
			");
			system.setQuality("henrietta", dec(character.qualities.henrietta));
		}
	}),
	
	"064": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			...and sure enough, Henrietta's repairs keep it good and steady. Crisis averted. _Onwards and upwards!_[065]\
			");
		}
	}),

	"065": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			STATUE: That's right, I almost forgot. You'd rather spend hours talking to what's-his-face instead.[br]\
			ARTIST: You mean Tiberius? But he's not even finished yet![br]\
			STATUE: He \"hasn't been finished yet\" for months now.[br]\
			ARTIST: -(raises foot and points to it)- It's his toes. You know it always takes me forever to get the toes just right. -(stomps foot down, nothing happens)-\
			[/play][br]\
			\"You imbecile!\" barks Brock. \"_You're supposed to yell -Ow!-_[066]\"\
			");
		}
	}),
	
	"066": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.sandbox.repairedCouch) {
				system.say("[br]\
				\"Uh, okay,\" says Karl from under the couch. \"Ow.\"\
				");
			} else {
				system.say("[br]\
				\"Uh, okay,\" says Karl from under the chairs... er, couch. \"Ow.\"\
				");
			}
			system.say("[br]\
			\"No, no, no, say it like you mean it! Or perhaps you'd rather I stomp on your foot for real; what do you think?\" The vicious smile on Brock's face is starting to scare you a bit.[br]\
			\"It's okay, I'm sorry, it's all right, you don't have to&#x2014\"\
			%This looks like it could get out of hand rather quickly. Do you think you should _interject_[067], or would you rather leave them to _settle their differences on their own_[068]?%\
			");
		}
	}),
	
	"067": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Brock, -I'll- be doing the directing, here.\" You give him the sternest look you can muster.[br]\
			\"Siding with _whiny amateur hacks_(067-a) over those with -real- talent, huh? Typical.\"[br]\
			\"I'm not siding with anyone. Karl, try and listen more carefully for your cue next time around. _Let's keep going._[078]\"\
			");
			system.setQuality("brock", dec(character.qualities.brock));
		},
		actions: {
			"067-a": function(character, system, action) {
				system.say("Brock is, of course, referring to Jenna Garrity, the young woman who lodged the complaint against Langdon that got him into so much trouble in fhe first place. You feel bile rising up your throat just thinking about what happened. Best to put it from your mind right now.");
			}
		}
	}),
	
	"068": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"No, trust me, it's for your own good. You're going to have to learn to act sooner or later.\" You cringe as Brock reaches below, grabs Karl's foot, and steps on it as hard as he can.[br]\
			\"AGH! OW! URGH! IT HURTS, IT HURTS!\"\
			");
			if (character.qualities.erica > 0) {
				system.say("[br]\
				You spot Erica glaring at you reproachfully and feel a bit of a knot in your stomach, in spite of yourself.\
				");
				system.setQuality("erica", dec(character.qualities.erica));
			}
			system.say("[br]\
			\"See? There we go. Much better. Don't you think so, Ainsley?\"[br]\
			Swallowing and wincing inwardly, you gesture at the cast to continue. \"We really don't have much time. _Let's keep going._[069]\"\
			");
			system.setQuality("karl", dec(character.qualities.karl));
			system.setQuality("brock", inc(character.qualities.brock));
			character.sandbox.karlInjured = true;
		}
	}),

	"069": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: -(stands up)- Who was that?![br]\
			STATUE: I don’t know. Probably came from outside.[br]\
			ARTIST: Really? Because I could have sworn it came from under the... -(peeks under the couch and comes face to face with the gladiator, who is clutching his foot and whimpering in pain)-\
			[/play][br]\
			\"...oh, you have GOT to be kidding me.\"[br]\
			Uh-oh. This definitely can't be good. \"Karl? _Are you all right down there?_[070]\"\
			");
		}
	}),
	
	"070": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.qualities.karl > 0) {
				system.say("[br]\
				Karl clumsily tries to crawl up to a standing position. \"I'm okay! I'll be fine! I just... ack...\"\
				");
			} else {
				system.say("[br]\
				\"...can't move... so much pain... argh...\"\
				");
			}
			system.say("[br]\
			%Oh, fantastic, Ainsley. Your leading man's injured, and right before the _physically demanding_(070-a) part of the scene, to boot. What'll you do now? I suppose you could do your best to _soldier on_[071], but that might make things even worse. Maybe there's a way to _act around it_[072]...%\
			");
			if (character.sandbox.repairedCouch) {
				system.say("[br]\
				%Or you could always _call on Henrietta again_[076]. She'd know what to do, wouldn't she?%\
				");
			} else {
				system.say("[br]\
				%You figure Henrietta would know what to do, but she's already too preoccupied with the matter of the dining couch. There goes -that- idea.%\
				");
			}
		},
		actions: {
			"070-a": function(character, system, action) {
				system.say("The whole next bit of scene -- the part where the gladiator's comedically trying not to be seen by the artist -- well, it's supposed to be the most iconic aspect of the whole play. It's what everyone's expecting. And you've already been working with Karl an obscene amount and then some, trying to get the timing perfect. This... completely ruins everything, to say the least.");
			}
		}
	}),
	
	"071": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Just walk it off, Karl. You'll have plenty of time to rest after the rehearsal.\" Provided this cursed rehearsal actually does finish, that is.\
			");
			if (character.qualities.karl > 0) {
				system.say("[br]\
				\"No problem! I can do this!\" He stands up and limps around a bit. Definitely doesn't look too serious. He'll be fine. Just keep telling yourself that.[br]\
				\"Okay, then! _Let's try that once more!_[078]\"\
				");
			} else {
				system.say("[br]\
				\"...okay... if you say so...\" You watch as Karl makes a half-hearted attempt to raise himself to a standing position, which only results in him collapsing to the floor again.[br]\
				Brock smirks and shakes his head. \"Goodness, Ainsley. What kind of _spineless wimps_(071-a) are you getting for your productions, these days? Seriously!\"[br]\
				%Well, with Karl unable to move and all, I guess you have only _one real option_[072] left, here...%\
				");
				system.setQuality("karl", dec(character.qualities.karl));
				system.setQuality("brock", inc(character.qualities.brock));
			}
		},
		actions: {
			"071-a": function(character, system, action) {
				system.say("Spineless wimps, he says? Brock's one to talk, blindly agreeing with all of Langdon's blatant lies. Just like all the rest of them. Even -- especially -- the ones who said they privately agreed with you, but \"didn't want to get involved.\" You understand that all they wanted was to keep their jobs and positions of influence -- you understand them all too well. And these days, more than ever, you resent them for it.");
			}
		}
	}),
	
	"072": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Looks like we have no choice,\" you announce. \"We're going to have to improvise a scene with an injured gladiator.\"[br]\
			\"But that... that completely misses the point of the entire play!\" Brock stammers. \"You can't just&#x2014\"[br]\
			\"I'm the director and I can do whatever I please. Now, let's _start again from the part where you discover him under the couch_[073].\"[br]\
			\"Ugh. This is a ludicrous waste of time, I tell you.\"\
			");
		}
	}),

	"073": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: -(reaches under the couch and grabs the gladiator by the collar)- And just what do you think you're doing, intruder?[br]\
			GLADIATOR: Uh... making sure your couch is in working order, sir?[br]\
			ARTIST: That's funny. I don't recall asking for a repairman.[br]\
			GLADIATOR: Well, see, I... ack...[br]\
			ARTIST: -(hoists the gladiator up on his feet)- You know what I think? I think you're lying. I think you're trying to steal my life's work![br]\
			GLADIATOR: Yeah, well, it's not like you'd even miss her, apparently!\
			[/play]\
			");
			if (character.qualities.erica >= 0) {
				system.say("[br]\
				\"_Hey, Ainsley!_[074]\" Erica interrupts.\
				");
			} else {
				system.say("[br]\
				Well. This seems to be going... interestingly. Nothing else to do but _watch and see where else it goes_[052], is there?\
				");
			}
			character.sandbox.improvised++;
		}
	}),
	
	"074": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Yes, Erica?\"[br]\
			\"I think the statue has a few words of her own she'd like to share. I'm pretty sure that if she were a -real- woman and not some fantasy object created by an old white dude, she wouldn't take too kindly to being treated like property.\"[br]\
			Brock looks up at the ceiling lights and sighs. \"Oh boy, here we go again.\"[br]\
			\"All right, then,\" you answer. \"_What are these words she wishes to say?_[075]\"\
			");
		}
	}),

	"075": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			STATUE: Come on, now. Like anyone could actually -steal- me. Let alone a gladiator who's afraid of ostriches.[br]\
			GLADIATOR: Hey![br]\
			STATUE: It's true! That's why you're here, isn't it? See, he's completely harmless.[br]\
			GLADIATOR: I'm not harmless! In fact, I'll have you know I&#x2014 -(tries to step forward and winces)- ...agh, okay, maybe I -am- harmless...\
			[/play][br]\
			You grin to yourself. Karl may be in a bit of pain, but he seems to be carrying it well. _Now, to see where else this might go..._[052]\
			");
			system.setQuality("erica", inc(character.qualities.erica));
			system.setQuality("karl", inc(character.qualities.karl));
			character.sandbox.improvised++;
		}
	}),
	
	"076": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			You summon Henrietta out from backstage. \"Sorry to bother you again, darling, but our young gladiator here appears to be hurt.\"[br]\
			She wanders on over to the still-struggling Karl. \"Ooh, that doesn't look too good,\" she says, prodding at his foot with her fingers as he winces slightly. \"I'll be right back. _Lemme go get some ice and something to wrap that in._[077]\"\
			");
		}
	}),
	
	"077": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			Henrietta does exactly that, and after several minutes tending to the injury -- not to mention several minutes of Brock pacing erratically and Erica standing around looking bored -- gets him standing again. \"Take it easy, okay? Don't put too much weight on it.\"[br]\
			\"I... I think I'm good, Ainsley.\" Karl limps a few steps. \"Yeah, I can do this.\"[br]\
			\"Splendid. _Back under the couch, then!_[078]\"\
			");
			system.setQuality("karl", inc(character.qualities.karl));
		}
	}),

	"078": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: -(stands up)- Who was that?![br]\
			STATUE: I don’t know. Probably came from outside.[br]\
			ARTIST: Really? Because I could have sworn it came from under the... -(peeks under the couch just as the gladiator rolls out and darts behing the urn)- ...all right, so maybe it did come from outside. I must be hearing things again.[br]\
			STATUE: You just like him better because he can’t talk back.\
			[/play][br]\
			\"Oh God, I hate this part,\" grumbles Erica. \"I mean, I have to be like -oh, why don't you love me anymore?- and that's just so disgustingly whiny. Can't I say something else?\"[br]\
			%Joy. She wants to improvise again. With the way things are going so far tonight, you've half a mind to completely give up and _let her do whatever she wants_[079]. You do worry, however, about the other actors screwing up and missing their cues; this is, after all, the big physical comedy scene. You really think you should just _lay down the law_[081] and make everyone stick to the script or else. Then again, a _more diplomatic approach_[082] might help instead.%\
			");
		}
	}),
	
	"079": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Go right ahead, Erica sweetie. Say whatever pleases you.\"[br]\
			\"Methinks the _girl doth protest too much_(079-a),\" mumbles Brock under his breath.[br]\
			\"Don't call me -girl-, buster.\" Erica stretches her arms and cracks her knuckles. \"Anyway, _like I was saying_[080]...\"\
			");
			system.setQuality("erica", inc(character.qualities.erica));
		},
		actions: {
			"079-a": function(character, system, action) {
				system.say("You wonder to yourself whether Erica knows you've got somewhat of a reputation. All for taking Jenna Garrity's complaints seriously, rather than letting them go just like anyone else would. She probably does have some kind of an inkling, if her persistence in changing the play into something more woman-friendly is any indication. At this point, you really don't mind all that much.");
			}
		}
	}),

	"080": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			STATUE: I don't know why I even bother. You're hardly even around anymore, and when you are, you're making excuses not to talk to me.[br]\
			ARTIST: That's completely ridiculous.[br]\
			STATUE: You're the one who's being ridiculous. Why are you so afraid of me?[br]\
			ARTIST: -(glares at statue)- Why can you even talk, anyway?[br]\
			STATUE: How am I supposed to know? You made me.[br]\
			ARTIST: -(paces over to the urn and circles around it)- Yes, but I didn't mean to... well, you're a statue. Statues can't&#x2014 -(trips over the gladiator and falls flat on his face)-\
			[/play]\
			");
			character.sandbox.improvised++;
			if (character.qualities.karl > 0) {
				system.say("[br]\
				\"You know, Brock,\" Karl remarks with a wry grin, \"_you should really watch where you're going_[084].\"\
				");
			} else {
				system.say("[br]\
				\"Sorry! Sorry!\" Karl panics. \"_It was an accident, I swear!_[084]\"\
				");
			}
		}
	}),
	
	"081": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.sandbox.improvised) {
				system.say("[br]\
				\"No! No more improvisation. Horsing around at the beginning was fun, I'll grant you that much, but now it's time to get to serious business. _Come on, now._[083]\"\
				");
			} else {
				system.say("[br]\
				\"No! No improvisation, period. My patience is being tried enough as it is. _Come on, now._[083]\"\
				");
			}
			system.setQuality("erica", dec(character.qualities.erica));
			character.sandbox.noMoreImprov = true;
		}
	}),
	
	"082": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Who says the statue even -means- what she says? She's just saying things so she can distract the artist, isn't she?\"\
			");
			if (character.qualities.erica > 0) {
				system.say("[br]\
				\"Huh. I guess you're right. I still hate that she's doing it, but I guess it kinda makes sense, too.\"[br]\
				\"Atta girl. _One more time with the line_[083], then!\"\
				");
			} else {
				system.say("[br]\
				\"That's a complete crock of monkey snot and you know it, Ainsley. She's distracting him so she can save the gladiator. Either way, it's all just for some dude.\"[br]\
				Not quite the effect that you were hoping for, but what's done is done. \"Just say the lines, Erica. For the sake of my sanity and that of everyone else in this theatre. -Please.-\"[br]\
				\"Ugh. _-Whatever.-_[083]\"\
				");
				system.setQuality("erica", dec(character.qualities.erica));
			}
		}
	}),

	"083": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			STATUE: You just like him better because he can’t talk back.[br]\
			ARTIST: Don't be ridiculous.[br]\
			STATUE: You're the one who's being ridiculous, locking yourself up in the other room with him all day.[br]\
			ARTIST: -(glares at statue)- Why can you even talk, anyway?[br]\
			STATUE: I don't know. Why can you?[br]\
			ARTIST: -(paces over to the urn and circles around it)- That's a completely different question. You're a statue. Statues can't&#x2014 -(trips over the gladiator and falls flat on his face)-\
			[/play]\
			");
			if (character.qualities.karl > 0) {
				system.say("[br]\
				\"You know, Brock,\" Karl remarks with a wry grin, \"_you should really watch where you're going_[084].\"\
				");
			} else {
				system.say("[br]\
				\"Sorry! Sorry!\" Karl panics. \"_It was an accident, I swear!_[084]\"\
				");
			}
		}
	}),
	
	"084": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"You... you moronic little...\"\
			");
			if (character.sandbox.karlInjured) {
				system.say("[br]\
				You almost feel sorry for Brock. Well, not quite \"almost\". Barely even \"a little\". That said, you can't help but wonder if this really was an accident, or retaliation for Brock's previous physical attack.\
				");
			} else {
				system.say("[br]\
				You almost feel sorry for Brock. Well, not quite \"almost\". Barely even \"a bit\". The guy's been at odds with the rest of the cast this whole time -- not to mention -you- -- to the point that a petard-hoisting was bound to happen sooner or later.\
				");
			}
			if (!character.sandbox.noMoreImprov && character.qualities.karl > 0) {
				if (character.qualities.erica > 0) {
					system.say("[br]\
					\"Hey, Ainsley!\" Karl chuckles to himself. \"We gotta leave that in the play. It's total comedy gold, man.\" You glance over at Erica, who grins approvingly.\
					");
				} else {
					system.say("[br]\
					\"Hey, Ainsley!\" Karl chuckles to himself. \"We gotta leave that in the play. It's total comedy gold, man.\" You glance over at Erica, who simply yawns.\
					");
				}
				system.say("[br]\
				%What do you say, then? Do you _agree_[085]? Do you _snipe at Karl_[088] for missing his cue to move, thus derailing the rehearsal yet again? Do you _blame Brock for his own misfortune_[089]? Or do you _simply get them both back on track as quickly as possible_[090]?%\
				");
			} else {
				system.say("[br]\
				%What do you say, then? Do you _blame Brock for his own misfortune_[089]? Do you _snipe at Karl_[088] for missing his cue to move, thus derailing the rehearsal yet again? Or do you _simply get them both back on track as quickly as possible_[090]?%\
				");
			}
			system.setQuality("brock", dec(character.qualities.brock));
		}
	}),
	
	"085": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"That's a fantastic idea, Karl. A touch of schadenfreude is just what this scene needs to keep it fresh and exciting for a modern audience.\"[br]\
			\"I don't even know what that means, but _okay!_[086]\"\
			");
			system.setQuality("karl", inc(character.qualities.karl));
		}
	}),

	"086": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: What was that?! -(looks around, but the gladiator dashes behind the cypress tree before he can be seen)-[br]\
			STATUE: I don't see anything. Maybe you've been drinking too much wine again.[br]\
			ARTIST: -(paces around and surveys the room)- No, I swear to you, there was something here! -(glances over at the cypress tree)- Something... -(walks towards it, but just misses the gladiator ducking out towards the statue's pedestal, pulling down the artist's toga as he does so, leaving him in his underwear)- ...AGH![br]\
			STATUE: Oh dear. You haven't been eating properly either, have you?\
			[/play][br]\
			\"All right, all right, enough!\" yells Brock. \"_ENOUGH!_[087]\"\
			");
			character.sandbox.improvised++;
		}
	}),
	
	"087": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.qualities.brock == -3) {
				system.say("[br]\
				\"I have absolutely had it with you people and your pathetic excuses for acting. Enjoy participating in this mess without me.\" And with that, he storms off the stage and out of the theatre.[br]\
				\"Brock!\" you call after him. Like it'll do any good at this point. Sure, he was being a real jerk all night, and maybe he deserved it. But is it really worth losing him over, especially with just a few hours to opening night?[br]\
				Burying your face in your hands, you begin to consider the feasibility of selling all your possessions and moving to Antarctica.\
				[heading]THE END\
				");
			} else {
				system.say("[>097]");
			}
		}
	}),
	
	"088": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.sandbox.karlInjured) {
				system.say("[br]\
				\"Karl, you're supposed to move -around- Brock as he circles around the urn. We've been over this already. Now, if your foot's still in pain, maybe you should...\"[br]\
				\"No, I'm fine, honest!\"[br]\
				\"Very well. If you could do that part again, like we've rehearsed countless times, that'd be much appreciated. Thank you.\"\
				");
			} else {
				system.say("[br]\
				\"Karl, you're supposed to move -around- Brock as he circles around the urn. We've been over this already. Now if you wouldn't mind doing it again, like we've rehearsed countless times, that'd be much appreciated. Thank you.\"\
				");
			}
			system.say("[br]\
			Karl sighs as Brock self-righteously smiles at him. \"_Okay, Ainsley._[091] You don't have to get mad at me.\"\
			");
			system.setQuality("karl", dec(character.qualities.karl));
			system.setQuality("brock", inc(character.qualities.brock));
		}
	}),
	
	"089": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.sandbox.karlInjured) {
				system.say("[br]\
				\"Now Brock, if you wanted Karl to get out of the way quickly enough, you should've thought about that -before- you mangled his foot.\"[br]\
				\"I didn't step on it -that- hard! It's not -my- fault that oaf can't take a little pain!\"[br]\
				\"Either way, try and watch for obstacles before careening to the floor next time, all right?\"\
				");
			} else {
				system.say("[br]\
				\"Brock, try and watch for obstacles before careening to the floor next time, all right?\"\
				");
			}
			system.say("[br]\
			\"Goddammit. Don't tell me what to do, Ainsley. _I -know- what I'm doing._[091] Just... ugh.\"\
			");
			system.setQuality("karl", inc(character.qualities.karl));
			system.setQuality("brock", dec(character.qualities.brock));
		}
	}),
	
	"090": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Let's _do that again_[091], please -- and this time, properly. Karl, move away from Brock when he walks towards you. Brock, try not to trip over him. We've rehearsed this enough times, and I'd rather not have to go over it again, all right?\"\
			");
		}
	}),

	"091": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: -(paces over to the urn and circles around it as the gladiator, still crouched, shuffles to the opposite side)- That's a completely different question. You're a statue. Statues can’t talk. At least, they shouldn’t be able to. Everyone knows that.[br]\
			STATUE: -(diverts artist’s attention towards her, gladiator takes the opportunity to crawl behind the cypress tree)- Well, if it’d make you feel any better, I could stop talking.[br]\
			ARTIST: Good. Maybe I’ll finally be able to hear myself think again.[br]\
			STATUE: Fine![br]\
			ARTIST: Good![br]\
			-The artist turns around and folds his arms. Awkward silence ensues.-\
			[/play][br]\
			\"Psst! Ainsley! _Is this the part where I sneeze?_[092]\"\
			");
		}
	}),

	"092": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Yes, Karl.\"[br]\
			\"Okay. Just checking.\"\
			[play][br]\
			-Suddenly, the gladiator sneezes.-[br]\
			ARTIST: -(glares at the statue)- I thought you were going to stop talking![br]\
			STATUE: It wasn’t... er, I mean, I wasn’t talking, I was sneezing.[br]\
			ARTIST: But you’re talking now.[br]\
			STATUE: That doesn’t count. I was&#x2014[br]\
			-Just then, the gladiator somersaults away from the tree and careens straight into the pedestal, which then proceeds to fall over, taking the statue down with it.-\
			[/play][br]\
			_Oh, drat._[093] And just when things were starting to go relatively smoothly for an instant, too.\
			");
		}
	}),
	
	"093": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Aw, crap,\" mumbles Karl, still dazed from the impact. \"I was aiming for -behind- the pedestal, I swear!\" Yes, just like you'd practiced all this time. Or would have, if you'd even had any of the props on stage available to you before tonight.\
			");
			if (character.sandbox.changedDress) {
				if (character.qualities.erica > 0) {
					system.say("[br]\
					Erica raises herself to a sitting position and wryly arches her eyebrow at Karl. \"You were distracted by -my- behind, weren't you? Come on, don't lie. I saw you checking me out.\"[br]\
					\"I, uh...\" His ears are as bright red as a freshly-cooked lobster. Oh, dear.[br]\
					Brock, meanwhile, stares at them in irritation, then fixes his gaze on you. \"So? What are you going to do, Ainsley? Kick him out when she inevitably accuses him of sexual harassment? That's _what they all do_(093-a), isn't it: ruin the lives of perfectly good men when they can't get their way?\"[br]\
					");
					system.setQuality("erica", inc(character.qualities.erica));
					system.setQuality("karl", inc(character.qualities.karl));
				} else {
					system.say("[br]\
					\"Karl, you idiot!\" Erica stares at him lividly. \"You were trying to peep under my dress! I saw you! Ugh...\"[br]\
					\"No! I swear, I...\"[br]\
					\"That's _what they all do_(093-a), isn't it?\" Brock sneers. \"Accuse men of sexual harassment when they can't get their way.\" He fixes his gaze on you. \"What are you going to do, Ainsley, fire -him- too? Good riddance, as far as I'm concerned.\"\
					");
					system.setQuality("erica", dec(character.qualities.erica));
					system.setQuality("karl", dec(character.qualities.karl));
				}
			} else {
				system.say("[br]\
				Erica attempts to pull herself up to a standing position, but as she does so, a clearly audible ripping noise lets out -- it would appear that the too-tight dress you were in too much of a hurry to deal with at the start of rehearsal has now completely split down the middle of her back. Terrific.[br]\
				\"See, I told you it was too tight! You'd think someone around here would actually listen to me for a change, but noooo...\"[br]\
				\"Ooh, the plot thickens!\" Brock chortles mockingly and fixes his gaze on you. \"What do you think she'll do now, Ainsley? Accuse us all of sexual harassment? That's _what all girls do_(093-a) when they can't get their way, isn't it?\"\
				");
				system.setQuality("erica", dec(character.qualities.erica));
			}
			system.say("[br]\
			%Do you _dignify him with a response_[094], or do you _ignore his outburst_[095]?%\
			");
		},
		actions: {
			"093-a": function(character, system, action) {
				system.say("There was a time when you, too, once thought women reported harassment just for attention, as some cheap attempt to become more well-known and further their careers. Then, you saw for yourself how wrong you were, how such women were routinely humiliated and ostracised for speaking out. And then there was Jenna Garrity, with the terrified look she had in her eyes when she shyly cornered you after everyone had left and told you everything Langdon had said and done. You believed her. How could anyone -not- believe her?");
			}
		}
	}),
	
	"094": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"What exactly is it you're insinuating, Brock?\"[br]\
			\"Why'd you have to screw him over, Ainsley? Langdon's a talented actor with a great future ahead of him. Any director would be honoured to work with him, but you... you just couldn't see past your own washed-out irrelevance, so you had to take it out on&#x2014\"[br]\
			\"She was afraid to show up to rehearsals!\"[br]\
			\"She was just some -chick-. Get over it. There's a million of them lined up to take her place... there always is.\"[br]\
			You _just stand there_[095], shaken and speechless, desperately wanting to tell him what an ignorant fool he's being, yet knowing any attempt at explanation would be completely futile.\
			");
			system.setQuality("brock", inc(character.qualities.brock));
		}
	}),
	
	"095": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (!character.sandbox.changedDress) {
				if (character.qualities.erica == -3) {
					system.say("[br]\
					\"Okay, that's it,\" yells Erica before anyone else can say anything. \"I'm -done- with this pathetic excuse for a play. Go find someone else to be your stupid statue.\" With that, she pulls the remains of her dress back over herself and storms off the stage.[br]\
					\"Erica, wait!\" you protest, but it doesn't seem to do much in the way of good. Nice job, Ainsley. Where are you going to find yet -another- actress to take on this role with opening night happening in just a few hours? Even you aren't capable of pulling such magic out of thin air. I hope you're happy.[br]\
					[heading]THE END\
					");
				} else {
					system.say("[br]\
					\"Um, hello? I'm kinda naked here?\"[br]\
					You look over at Erica, hiding herself behind some scenery, and feel somewhat grateful for not having to listen to Brock's tirades any longer. \"Go backstage and get Henrietta to put something on you.\"[br]\
					A few minutes later, she emerges out with some floral print sundress that you think you recognise from last month's run of -Much Alarm About Agnes-. \"All right, then,\" you announce. \"Now that our wardrobe mishap has been taken care of, let's get on with the _last bit of the play_[097], shall we?\"\
					");
				}
			} else {
				system.say("[>096]");
			}
		}
	}),
	
	"096": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.qualities.brock == -3) {
				system.say("[br]\
				\"Now if you'll excuse me,\" Brock continues, \"I'm out of this dump. This whole charade was amusing at first, but now it's become completely ridiculous. Enjoy performing this farce without me.\" And with that, he storms back out of the building.[br]\
				Well, Ainsley, if it's any consolation, Brock was doing nothing but causing trouble, anyway. Maybe it's for the best that he's gone. Question is, how are you going to find another actor to play the artist on such short notice? Finding a replacement statue was hard enough, remember?[br]\
				Sinking deeper into your chair, you think to yourself that maybe a career in basket weaving is in your future.[br]\
				[heading]THE END\
				");
			} else if (character.qualities.karl == -3) {
				system.say("[br]\
				\"AGH! Damn it, I WASN'T peeping under her dress!\" Karl bursts out before anyone else can say anything. \"Why do you keep blaming -me- for everything that's gone to the crapper tonight? Just 'cause I'm not a frou-frou actor like all of you doesn't mean you can treat me like your butt monkey. I'm outta here.\" And with that, he storms off the stage, almost in tears.[br]\
				\"Karl!\" you yell back at him, but it doesn't do you a whiff of good. You've pushed the kid way past his breaking point, and he was already high-strung enough as it is. I hope you're happy, Ainsley. Oh, and good luck finding another gladiator with only a few hours left to go before opening night.[br]\
				[heading]THE END\
				");
			} else {
				system.say("[br]\
				\"Are you quite finished yet?\" you ask calmly, once you regain your composure. \"Can we get on with the _last bit of the play_[097], already?\" You're a professional, and your priority right now is to see this trainwreck of a rehearsal to its end. Silently, all three actors shuffle back to their places on stage.\
				");
			}
		}
	}),

	"097": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: Forget it. Just forget it, all right. I need to go somewhere quiet right now. -(walks away from the statue, while the gladiator peeks slightly to the side from behind her to see what's going on)-[br]\
			STATUE: -(diverts the artist’s attention back to her, causing the gladiator to quickly duck)- You do that. And say hi to what’s-his-face, while you’re at it.[br]\
			GLADIATOR: -(comes out from behind the pedestal as the artist walks offstage)- What’s his problem?[br]\
			STATUE: Damned if I know. Sad thing is, he was always so charming and sweet while he was carving me. He’d tell me just about everything. Of course, once I started talking... well, you know the rest.[br]\
			GLADIATOR: I think you should leave him. You deserve better.\
			[/play][br]\
			\"_Hey, Ainsley?_[098]\" Karl interjects.\
			");
		}
	}),
	
	"098": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"What's the problem, Karl?\"\
			");
			if (character.qualities.brock > 0) {
				system.say("[br]\
				\"Yeah, Karl, what's the problem?\" Brock echoes in a mocking tone of voice. \"Forgot your lines again?\"\
				");
			} else if (character.qualities.erica < -1) {
				system.say("[br]\
				Erica lets out a groan. \"Come -on-, Karl, I want to go home already.\"\
				");
			}
			if (character.qualities.karl < 0 || character.sandbox.noMoreImprov) {
				system.say("[br]\
				\"Actually, it's nothing. Never mind.\" Karl takes a deep breath and sighs.[br]\
				\"Well, all right, then. _Suit yourself._[104]\"\
				");
			} else {
				system.say("[br]\
				\"Well, y'know, I was thinking, she -should- leave. I mean, why would she stay, right? The artist isn't treating her well, and she seems to like the gladiator better, anyway. Just an idea.\"[br]\
				%Hmph. You're _loathe to make any more changes_[099] to the script, with it being almost the end and all. Plus, everyone who's ever seen this play knows the statue has to stay put as she is. But maybe that's just it. Maybe an alternate ending is _exactly what you need_[100] to make this show memorable and save your career. After all, it won't be saved by the stellar acting or set decoration, that's for sure.%\
				");
			}
		}
	}),
	
	"099": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Karl, that's a very nice idea, but in my mind, an even nicer idea would be finishing off this damned play and getting home in time for the tail end of the Boris Karloff marathon on TV tonight.\"[br]\
			\"Fine, _if you say so_[104].\"\
			");
		}
	}),
	
	"100": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"You make a very persuasive argument, Karl. Very well, then. Let's rewrite the ending and have the statue run off with the gladiator.\"[br]\
			\"Are you out of your mind?\" Brock steps out from backstage, incredulous. \"She's a -statue-. She can't just walk off the pedestal. The audience definitely won't go for it.\"[br]\
			\"Well, so far as I'm concerned, if they can believe her talking, then walking isn't very far-fetched at all. What do you say, Erica?\"\
			");
			if (character.qualities.erica > 0) {
				system.say("[br]\
				\"I'm gonna have to agree with you, Ainsley. Come on, _let's do this thing_[105].\"\
				");
			} else {
				system.say("[br]\
				\"Oh, I definitely think the statue needs to leave that douchecanoe of an artist. But I _don't think she ought to be hanging around that gladiator_[109], either.\"\
				");
			}
			system.setQuality("karl", inc(character.qualities.karl));
			system.setQuality("brock", dec(character.qualities.brock));
		}
	}),

	"101": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			GLADIATOR: Huh. I guess I'd better leave.[br]\
			STATUE: Probably a good idea.[br]\
			GLADIATOR: So, you, uh, wanna come with me? I mean, you deserve better than that buttclown who thinks he can treat you like a clod of dirt just 'cause he carved you. Not that I'm -that- much better, but still. What d'you think?\
			[/play][br]\
			%Now that you think about it, this may be a good part to segue _back on track with the script_[102]. But it also may be a better idea to _let them keep improvising_[103]. What do you tell them, Ainsley?%\
			");
			character.sandbox.improvised++;
		}
	}),
	
	"102": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"All right, folks, let's get this thing finished once and for all. Erica, go from the part where the _statue explains that she needs to stay_[104].\"\
			");
		}
	}),
	
	"103": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.qualities.erica > 0) {
				system.say("[br]\
				You wait as Erica pauses briefly and thinks about _what to say next_[105].\
				");
			} else {
				system.say("[br]\
				You wait as Erica pauses briefly and thinks about _what to say next_[109].\
				");
			}
		}
	}),

	"104": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			STATUE: Leave? I can’t even move off this pedestal. Besides, he needs me. He may refuse to admit it, but it’s true. No one understands him like I do. This is where I must stay.[br]\
			GLADIATOR: You’re right. And for that matter... -(turns to face window)- I should go. Face the music. Do what I was born to do and fight that ostrich. -(turns to statue)- That crowd sure isn’t going to entertain itself, that’s for sure.[br]\
			STATUE: So you’re not scared anymore?[br]\
			GLADIATOR: Oh, I’m terrified. But really, there’s nothing else I can do, either. Somehow, realising that suddenly makes everything seem so much easier.[br]\
			STATUE: Yes, that makes sense. I... guess this is goodbye, then.[br]\
			GLADIATOR: I guess so. -(begins to walk back towards the window, then hesitates)-\
			[/play][br]\
			\"And, uh, I'm _supposed to kiss her_[110] here, right?\"\
			");
		}
	}),

	"105": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			STATUE: It's true. I should leave this place. I've been thinking about it for a long time, actually. I just have no idea where it is I'd actually go...[br]\
			GLADIATOR: I don't know where I'm going to go, either. It's not looking like I can hide here any longer, after all. But maybe if you come with me -- wherever it is -- it won't be so bad, don't you think?[br]\
			-The gladiator takes the statue's hand as she steps down from the pedestal. They begin to walk away...-\"\
			[/play][br]\
			\"Wait. No!\" Brock runs frantically back on stage. \"This isn't how the story ends, Ainsley. The statue has to stay, because if she goes, the whole thing becomes completely meaningless, and... well, she just can't leave! It's not right, I tell you!\"[br]\
			%Goodness. Brock really does seem to be adamant that the original ending to the script be preserved. Then again, he's been criticising you all evening, and quite frankly, you're sick and tired of it. Do you try and _placate him with hopes that he'll finally stop bothering you for once_[106], or _end the play right here and be done with it_[108]?%\
			");
			system.setQuality("erica", inc(character.qualities.erica));
			character.sandbox.improvised++;
		}
	}),
	
	"106": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Well, Brock, the statue has spoken. If you want the artist to have her, the artist has to come out and convince her to stay.\"[br]\
			\"Oh, come on, you're not serious, are you?\"[br]\
			\"Completely serious. This play needs to be believable. Now, are you going to try to win her back, or should we just end here and now?\"[br]\
			\"_All right, all right_[107],\" sighs Brock.\
			");
		}
	}),

	"107": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			ARTIST: No! Stop right there! Where do you think you're going?[br]\
			STATUE: I'm leaving. I'm tired of living this life, stuck on a pedestal and begging you for attention. I'd rather be spending my time with someone who actually enjoys my company.[br]\
			ARTIST: Wait! You can't go! I do enjoy your company! You're the most important thing -- no, person -- in my life, and I'd be completely lost without you! Please, don't go![br]\
			STATUE: You know, I've been waiting for you to say that for ages. -(pauses)- But my decision still stands. I'm sorry. I have to go now.[br]\
			-The statue walks over to the artist, gives him a kiss on the cheek, then takes the gladiator's hand as they both walk offstage together. The artist glances over at the empty pedestal, a crestfallen look on his face.-\
			[/play][br]\
			Hrm. Kind of a bittersweet ending, and not really what the audience is expecting, but it's growing on you. It'll have to do, you suppose. For now, you're just relieved that you _made it to the end without anything catastrophic happening_[113].\
			");
			system.setQuality("brock", inc(character.qualities.brock));
			character.sandbox.improvised++;
			character.sandbox.twistEnding = true;
		}
	}),
	
	"108": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"On the contrary, the more I think about it, the more I think modern audiences would prefer that the statue left with the gladiator. It just feels like the far more realistic option.\"[br]\
			\"Exactly!\" Erica nods in approval. \"Finally, -someone- gets it.\"[br]\
			Brock sighs. \"Well, I'm a purist. Sue me. But if it means we can get this over with and go home, I'm not complaining.\"\
			[play][br]\
			-The gladiator and the statue walk off the stage together as the lights slowly dim.-\
			[/play][br]\
			Not bad. Not bad at all. And the best part is, now you can _finally get home and sleep!_[113]\
			");
			character.sandbox.twistEnding = true;
		}
	}),

	"109": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			STATUE: It's true. I should leave this place. I've been thinking about it for a long time, but I haven't been able to do it up until now, because...[br]\
			GLADIATOR: Oh? Why not?[br]\
			STATUE: Because I can't let him notice I'm gone. He may be barely aware of my existence these days, but if he comes in here and sees an empty pedestal... well, I don't even want to know what he'll do. Which is why I need you to stand here in my place.[br]\
			GLADIATOR: Wait a minute, wait a minute... you want -me- to pretend like I'm a statue?[br]\
			STATUE: Why not? You're wanted by the law, anyway. At least this way, you won't be killed by any ostriches.[br]\
			GLADIATOR: Hmm. Good point. Okay, here.[br]\
			-The gladiator takes the statue's hand, who steps down from the pedestal as he steps up on top of it. As he takes on the same position in which the statue was previously standing, the statue walks off the stage, free at last.-\
			[/play][br]\
			Well. That was an... -interesting- interpretation of the ending. It'll get the critics talking, that's for sure. And speaking of endings, looks like you've _made it through the rehearsal without an aneurysm_[113]!\
			");
			system.setQuality("erica", inc(character.qualities.erica));
			character.sandbox.improvised++;
			character.sandbox.twistEnding = true;
		}
	}),
	
	"110": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"That's correct, Karl.\"\
			");
			if (character.qualities.karl > 1) {
				if (character.qualities.erica > 1) {
					system.say("[play][br]\
					-The gladiator moves back towards the statue, stands on his tiptoes, passionately kisses the statue right on her lips, then exits the way he came.-\
					[/play][br]\
					Erm. Well. Technically, he was only supposed to kiss her on the cheek, but this works too, you suppose. And would you look at that: you made it through to the _end of the play_[113]!\
					");
					system.setQuality("erica", inc(character.qualities.erica));
					system.setQuality("karl", inc(character.qualities.karl));
				} else {
					system.say("[play][br]\
					-The gladiator moves back towards the statue, stands on his tiptoes, and passionately kisses the statue right on her lips. She then proceeds to slap him hard on the face.-\
					[/play][br]\
					\"Ugh! What the HELL, Karl? You're _supposed to be kissing me on the cheek_[111]!\"\
					");
					system.setQuality("erica", dec(character.qualities.erica));
					system.setQuality("karl", dec(character.qualities.karl));
					character.sandbox.failedKiss = true;
				}
			} else {
				system.say("[play][br]\
				-The gladiator moves back towards the statue, stands on his tiptoes, quickly kisses her on the cheek, then exits the way he came.-\
				[/play][br]\
				Hmm. Well, that was certainly one of the most awkward kissing scenes you've ever witnessed, but it could have turned out much worse, you suppose. And would you look at that: you made it through to the _end of the play_[113]!\
				");
			}
		}
	}),
	
	"111": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
				\"Well, uh, I thought it could use a bit more, er, passion... you know? I mean, who ends a play with kissing on the -cheek-... right?\"\
			");
			if (character.qualities.erica == -3) {
				system.say("[br]\
				\"Okay, you know what, I can't do this anymore,\" she snaps. \"Go find someone else to be your stupid statue.\" And with that, she storms off the stage and out the door.[br]\
				\"Ha!\" Brock shakes his head, grinning. \"Having a hissy fit over a pathetic little kiss, is she?\" He looks over at Karl with a sneer of disdain. \"Not that I blame her.\"[br]\
				Nice job, Ainsley. No matter what kinds of good intentions you may have, you always wind up screwing it up somehow; it's -Feelings!- and Langdon Godfrey all over again, only this time with a potential lawsuit. Time to pack it in for an early retirement and start dusting off your cross-stitching skills, you think?\
				[heading]THE END\
				");
			} else {
				system.say("[br]\
				\"Just don't ever do that again, or I swear, you won't be able to so much as feel your lips anymore, let alone anything else.\"[br]\
				\"Ooh, this is going to be fun. I'm getting the popcorn out.\"[br]\
				\"Shut up, Brock!\"[br]\
				\"All right, then. Enough, all of you,\" you interrupt, \"Karl, try that _one more time_[112], with a bit less slobbering.\"\
				");
			}
		}
	}),
	
	"112": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[play][br]\
			-The gladiator moves back towards the statue, stands on his tiptoes, abruptly kisses her on the cheek, then exits the way he came.-\
			[/play][br]\
			Ah, there we go. Much better. Definitely one of the most awkward kisses you've ever witnessed in theatre, but at least no one's getting slapped for it. And would you look at that: you made it through to the _end of the play_[113]!\
			");
		}
	}),
	
	"113": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Great job, everyone,\" you announce as you get up from your chair. \"I'll see you all at 4 PM this afternoon, right here in this very theatre. And for the sake of my sanity and that of your fellow cast members, -please- don't be late.\"[br]\
			With that, the actors, looking just as happy to go home as you are, start to _shuffle off and pack up their things_[114].\
			");
		}
	}),
	
	"114": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.qualities.karl > 0 && !character.sandbox.failedKiss && !character.sandbox.ericaFightScene) {
				system.say("[br]\
				On their way out, you spot Karl cornering Erica at the door. \"Hey, uh, Erica? I was just wondering... you wanna go out for coffee before the show tomorrow? You know, to go over our lines and stuff?\"\
				");
				if (character.qualities.erica == 3) {
					system.say("[br]\
					Erica grins back at him. \"Sure, why not?\"[br]\
					\"Great! Cuthbert's Coffee across the street at 2?\"[br]\
					\"Sounds good to me. See you then.\" And with that, they _both walk off_[115] in nervous elation. How adorable. Oh, to be young and attractive again.\
					");
					character.sandbox.actorChemistry = true;
				} else if (character.qualities.erica > 0) {
					system.say("[br]\
					Erica has a bit of a pained, awkward look on her face. \"Look, Karl, you're a nice guy and all, but I'd rather not. Sorry. I'll see you later.\"[br]\
					\"Okay.\" And with that, they _both leave_[115]..\
					");
				} else {
					system.say("[br]\
					Erica looks at him quizzically. \"You're asking me out? Seriously? Yeah, right. Drop dead, creep.\" And with that, she walks off, nearly slamming the door in his face.[br]\
					Karl then shrugs to no one in particular. \"Can't blame a guy for trying.\" Then he, too, heads _out the door_[115].\
					");
				}
			} else {
				if (character.qualities.karl > 0) {
					system.say("[br]\
					Karl heads out the door first, with a bounce in his step. \"Bye, Ainsley. Seeya tomorrow.\"\
					");
				} else if (character.qualities.karl > -2) {
					system.say("[br]\
					Karl heads out the door first, tired but relatively calm. \"Bye, Ainsley. Seeya tomorrow.\"\
					");
				} else {
					system.say("[br]\
					Karl heads out the door first, bleary-eyed and completely worn out. He doesn't say so much as a word as he leaves.\
					");
				}
				if (character.qualities.erica > 0) {
					system.say("[br]\
					Erica walks out in turn, smiling. \"You know what? This wasn't as bad as I thought it'd be. See you in a few hours, Ainsley.\"[br]\
					\"_See you, Erica,_[115]\" you reply, finding yourself smiling back. All things considered, as an understudy, she wasn't a bad find in the least.\
					");
				} else if (character.qualities.erica > -2) {
					system.say("[br]\
					Erica walks out in turn, also rather tired. All things considered, she wasn't the greatest understudy you've ever worked with, but she at least didn't cause any horrible problems. And the _play hasn't had to be cancelled yet_[115], so there's that.\
					");
				} else {
					system.say("[br]\
					Erica walks out in turn, crankier than ever. She wasn't great, but really, you expected as much. For now, you're just relieved that she _hasn't up and quit_[115] the production, already.\
					");
				}
			}
		}
	}),
	
	"115": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			Brock leaves next, pausing to glance at you before walking out the door, as if he wants to say something, but ultimately stays quiet.[br]\
			%Do you _speak to him_[116], perhaps in a last-ditch effort to make amends? Or maybe that's _not such a wise idea_[117].%\
			");
		}
	}),
	
	"116": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			\"Something I can help you with, Brock?\"\
			");
			if (character.qualities.brock > 0) {
				system.say("[br]\
				He pauses for a second, caught a little off guard. \"I think I may have misjudged you. You're less inept as a director than I took you for.\"[br]\
				\"Thank you, Brock.\" That's probably the closest thing you'll ever get to a compliment from him, so you may as well take it as such.[br]\
				\"Well, good night,\" he says, and after hesitating a bit longer, _walks out the door_[117].\
				");
				system.setQuality("brock", inc(character.qualities.brock));
			} else {
				system.say("[br]\
				He pauses for a second, and walks out the door, not saying so much as a word. _So much for that._[117]\
				");
			}
		}
	}),
	
	"117": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			system.say("[br]\
			As you yourself prepare to head out on your way, you turn towards the stage. \"Henrietta? Go home. Get some sleep. It's late.\" From experience, you know she'll probably wind up falling asleep in the theatre if no one tells her to leave.\
			");
			if (character.sandbox.repairedCouch) {
				system.say("[br]\
				Henrietta steps into view. \"All right, Ainsley. Lemme go lock up first.\"\
				");
			} else {
				system.say("[br]\
				Henrietta steps into view. \"Okay, the couch should be all fixed up and delivered here by early afternoon. My work here is done. Now all I gotta do is lock up.\"\
				");
			}
			system.say("[br]\
			\"You do that. I'll _wait for you_[118].\"\
			");
		}
	}),
	
	"118": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			if (character.qualities.henrietta > 0) {
				system.say("[br]\
				As the two of you head outside, she grins at you. \"Remember that time we did -Smell Ya Later, Freddie Slater- and that Arthur Whatsisface guy projectile vomited all over the stage? I gotta say, this wasn't anywhere near as bad as that, and we've still had plenty of work since. You gotta stop worrying so much.\"[br]\
				You chuckle. She knows you well, and really, she's right. It could be so much worse. Setbacks happen, but somehow you manage to bounce back from them.[br]\
				");
			} else {
				system.say("[br]\
				As the two of you head outside, she lets out a hearty yawn. \"I think I'm getting too old for this. I'm so tired I can barely think straight.\" She's been saying that a lot lately, and you don't blame her, but she's still here, and that's really all that matters.\
				");
			}
			system.say("[br]\
			\"Good night, Henrietta. And thank you again.\" With that, you amble off in your own separate directions, looking forward to a good night's sleep and hoping and praying that _nothing blows up tomorrow_[119].\
			");
		}
	}),
	
	"119": new undum.SimpleSituation("",{
		enter: function(character, system, from) {
			var blurb = "NOTHING’S FAIR IN ART, LOVE, OR WAR, Kludge Theatre &#x2014 ";
			if (character.sandbox.improvised > 5) {
				blurb += "If you’re a James Dough purist, you’d be best off staying away from this one, as it’s almost nothing like the classic play we’ve all come to expect. The rest of you are definitely in for quite the show. ";
				character.sandbox.interestingPlot = 3;
			} else if (character.sandbox.twistEnding) {
				blurb += "At first glance, it seems like just another rehash of the old James Dough play we’ve all come to know backwards and forwards, but a surprise twist ending puts a completely different spin on its overall theme. Whether it works or not is debatable, but it’s certainly interesting. ";
				character.sandbox.interestingPlot = 2;
			} else if (character.sandbox.improvised > 0) {
				blurb += "James Dough’s well-known play about a reluctant gladiator meeting a talking statue gets a bit of a more modern flavour thrown in. Your mileage will likely vary as to how well it works. ";
				character.sandbox.interestingPlot = 1;
			} else {
				blurb += "Really, what do you expect? A bare-bones rehash of the tried-and-true James Dough classic. ";
			}
			if (character.qualities.karl > 1 && character.qualities.erica > 1 && character.qualities.brock > 1) {
				blurb += "The cast is surprisingly fun and believable to watch in this production, particularly given dialogue that tends to sound stilted and boring in less capable hands. ";
				character.sandbox.interestingCharacters = 3;
			} else if (character.sandbox.actorChemistry) {
				blurb += "Pleasantly enough, the two newcomer leads have surprising chemistry, making the otherwise hackneyed prose actually sound believable at times. ";
				character.sandbox.interestingCharacters = 2;
			} else if (character.qualities.brock > character.qualities.karl && character.qualities.brock > character.qualities.erica) {
				blurb += "While the two newcomer leads are nothing to write home about, veteran Brock Morgenstern chews up the scenery, edging towards hammy at times but always entertaining. ";
				character.sandbox.interestingCharacters = 1;
			} else if (character.qualities.erica >= character.qualities.karl && character.qualities.erica > 0) {
				blurb += "Newcomer Erica Harding particularly shines in this piece, performing her character with a biting, empowered edge, uncharacteristic of what we usually see in Dough’s talking statue. ";
				character.sandbox.interestingCharacters = 1;
			} else if (character.qualities.karl > 0) {
				blurb += "Local stand-up comedian Karl Papadakis plays his first theater role surprisingly well, his boundless enthusiasm and charm making up for occasional clumsiness. ";
				character.sandbox.interestingCharacters = 1;
			} else {
				blurb += "There’s not much to recommend in terms of the acting, with stilted, chemistry-less performances all around; you’ll probably find more believable characters in a bad romance novel. ";
			}
			if (character.sandbox.interestingPlot + character.sandbox.interestingCharacters > 4) {
				blurb += "Highly recommended. ";
			} else if (character.sandbox.interestingPlot + character.sandbox.interestingCharacters > 3) {
				blurb += "Recommended. ";
			} else if (character.sandbox.interestingPlot + character.sandbox.interestingCharacters > 2) {
				blurb += "Worth checking out, if only for the sheer spectacle of it all. ";
			} else if (character.sandbox.interestingPlot + character.sandbox.interestingCharacters > 0) {
				blurb += "Worth seeing if you haven’t got anything better planned for the weekend. ";
			} else {
				blurb += "Not particularly worth seeing unless you’re a die-hard Dough aficionado, and even then, you’d be better off renting the made-for-TV version instead. ";
			}
			blurb += "&#x2014 -J. Astrid Fleck, The Transient Weekly-";
			system.say("[br]\
			[heading]THE END[br]\
			[play][br]"+blurb+"[/play]");
		}
	})
	
};

undum.game.start = "001";

var MoodQuality = function(title, opts) {
	undum.WordScaleQuality.call(this, title, [
		"exasperated".l(), "irritable".l(), "flustered".l(),
		"tired".l(), "relaxed".l(), "eager".l(), "enthusiastic".l()
	], opts);
	if (!('offset' in opts)) this.offset = -3;
	if (!('useBonuses' in opts)) this.useBonuses = false;
};
MoodQuality.inherits(undum.WordScaleQuality);

undum.game.qualities = {
	karl: new MoodQuality(
		"Karl", {priority:"0001", group:'cast'}
	),
	erica: new MoodQuality(
		"Erica", {priority:"0002", group:'cast'}
	),
	brock: new MoodQuality(
		"Brock", {priority:"0003", group:'cast'}
	),
	henrietta: new MoodQuality(
		"Henrietta", {priority:"0004", group:'cast'}
	)
};

undum.game.sandbox = {
	henriettaEntered: new Boolean(),
	changedDress: new Boolean(),
	improvised: new Number(),
	brockEntered: new Boolean(),
	repairedCouch: new Boolean(),
	karlInjured: new Boolean(),
	noMoreImprov: new Boolean(),
	failedKiss: new Boolean(),
	twistEnding: new Boolean(),
	actorChemistry: new Boolean(),
	ericaFightScene: new Boolean(),
	interestingPlot: new Number(),
	interestingCharacters: new Number()
};

undum.game.qualityGroups = {
	cast: new undum.QualityGroup(null, {priority:"0001"})
};

undum.game.init = function(character, system) {
	character.qualities.karl = 0;
	character.qualities.erica = 0;
	character.qualities.brock = 0;
	character.qualities.henrietta = 0;
	
	character.sandbox.henriettaEntered = false;
	character.sandbox.changedDress = false;
	character.sandbox.improvised = 0;
	character.sandbox.brockEntered = false;
	character.sandbox.repairedCouch = false;
	character.sandbox.karlInjured = false;
	character.sandbox.noMoreImprov = false;
	character.sandbox.failedKiss = false;
	character.sandbox.twistEnding = false;
	character.sandbox.actorChemistry = false;
	character.sandbox.ericaFightScene = false;
	character.sandbox.interestingPlot = 0;
	character.sandbox.interestingCharacters = 0;
};

function inc(value)
{
	value++;
	if (value > 3) value = 3;
	return value;
}

function dec(value)
{
	value--;
	if (value < -3) value = -3;
	return value;
}
