/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Scanner;
import javax.swing.JOptionPane;

public class Data {
    public static int moves = 0;
    public static int deaths = 0;
    public static short score = 0;
    public static short maxScore = (short)200;
    public static int year = -21374;
    public static int kimisNumber = 19670064;
    public static int hint = 1;
    public static boolean gameOver;
    public static boolean yesOrNo;
    public static boolean confirmingNewGame;
    public static boolean confirmingRestoreGame;
    public static boolean confirmingQuitGame;
    private static String[] saveData;

    public static void setUpGame() {
        Thesaurus.addExtraWords();
        Meditate.setShrines();
        Room.setRooms();
        Room.setExits();
        Room.setRoomsWithPanels();
        Data.newGame();
    }

    public static void yesOrNo(String string) {
        switch (string) {
            case "YES": {
                if (confirmingNewGame) {
                    Data.newGame();
                    confirmingNewGame = false;
                } else if (confirmingRestoreGame) {
                    Data.attemptToRestoreGame();
                    confirmingRestoreGame = false;
                } else if (confirmingQuitGame) {
                    System.exit(0);
                } else {
                    System.out.println("Data.yesOrNo() error");
                }
                yesOrNo = false;
                break;
            }
            case "NO": {
                if (confirmingNewGame) {
                    Story.print("Restart canceled.");
                    confirmingNewGame = false;
                } else if (confirmingRestoreGame) {
                    Story.print("Restore canceled.");
                    confirmingRestoreGame = false;
                } else if (confirmingQuitGame) {
                    Story.print("Phew!");
                } else {
                    System.out.println("Data.yesOrNo() error");
                }
                yesOrNo = false;
                break;
            }
            default: {
                Story.print("Please type yes or no.");
            }
        }
    }

    public static void confirmNewGame() {
        Story.print("You are about to start a new game. Any unsaved progress will be lost. Continue?");
        yesOrNo = true;
        confirmingNewGame = true;
    }

    public static void newGame() {
        Wabewalker.deleteHeader();
        Story.wipeStory();
        Data.resetGameData();
        Room.setGardenObjects();
        Room.setHouseObjects();
        Room.setTempleObjects();
        Story.print(Story.intro1);
        Story.newParagraph();
        Story.pressKey("start");
    }

    public static void startGame() {
        Story.wipeStory();
        Wabewalker.setHeader();
        Story.print(Story.intro2);
        Story.newParagraph();
        Room.location.add(Room.gardenPatio);
        Room.visited.add(Room.gardenPatio);
        Wabewalker.locationHolder.setText(Player.getLocation().title);
        Story.printLocation();
        Story.newLine();
        Story.printDesc();
        Data.updateScore(0);
    }

    private static boolean fileValid(String string) {
        return string != null && !string.equals("");
    }

    public static void attemptToSaveGame() {
        String string = JOptionPane.showInputDialog("Enter a name for the save file");
        if (Data.fileValid(string)) {
            File file = new File(string + ".txt");
            if (file.exists()) {
                Data.confirmOverwrite(string);
            } else {
                Data.saveGame(string);
            }
        } else {
            Story.print("Save canceled.");
        }
    }

    public static void confirmOverwrite(String string) {
        int n = JOptionPane.showConfirmDialog(null, "Overwrite existing save data?", "Confirmation Request", 0);
        if (n == 0) {
            Data.saveGame(string);
        } else {
            Story.print("Save canceled.");
        }
    }

    public static void saveGame(String string) {
        try {
            File file = new File(string + ".txt");
            file.delete();
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.println("This is the save data for Wabewalker.");
            printWriter.println("Do not edit this file, because it will corrupt the save.");
            printWriter.println(Player.getLocation().title);
            printWriter.println(Story.brief);
            printWriter.println(Player.meditating);
            printWriter.println(Player.dreaming);
            printWriter.println(Player.sawReaper1);
            printWriter.println(Player.sawReaper2);
            printWriter.println(Player.facingReaper);
            printWriter.println(Player.orangeAlive);
            printWriter.println(Player.greenAlive);
            printWriter.println(Player.purpleAlive);
            printWriter.println(Player.orangeAtTV);
            printWriter.println(Player.greenAtTV);
            printWriter.println(Player.purpleAtTV);
            printWriter.println(Player.caughtFish);
            printWriter.println(Player.hadCorn);
            printWriter.println(Player.raDropped);
            printWriter.println(Player.onPhone);
            printWriter.println(Player.fishing);
            printWriter.println(Player.sipped);
            printWriter.println(Player.spokeToClan);
            printWriter.println(Player.metIsachi);
            printWriter.println(Player.playedTheaterTV);
            printWriter.println(Player.baitedRod);
            printWriter.println(Player.openedHokura);
            printWriter.println(Player.examinedCard);
            printWriter.println(Player.gotKimiPoints);
            printWriter.println(Player.openedSandExhibitDoor);
            printWriter.println(Player.gotTodPoints);
            printWriter.println(Player.readBook);
            printWriter.println(Player.readCryptogram);
            printWriter.println(Player.pulledHallwayLever);
            printWriter.println(Player.openedCloset);
            printWriter.println(Player.openedShrineRoom2Door);
            printWriter.println(Player.tookParchment);
            printWriter.println(Player.examinedMannequin);
            printWriter.println(Player.startedFishing);
            printWriter.println(Player.previousLocation);
            printWriter.println(Meditate.visualizingLotus);
            printWriter.println(Meditate.visualizingFish);
            printWriter.println(Meditate.visualizingKnot);
            printWriter.println(Meditate.trancedGarden);
            printWriter.println(Meditate.trancedHouse);
            printWriter.println(Meditate.trancedTemple);
            printWriter.println(Meditate.trancesTranced);
            printWriter.println(Meditate.gardenTrance);
            printWriter.println(Meditate.houseTrance);
            printWriter.println(Meditate.templeTrance);
            printWriter.println(NPC.scheduled);
            printWriter.println(NPC.reaperMoved);
            printWriter.println(NPC.kimiState);
            printWriter.println(NPC.todState);
            printWriter.println(moves);
            printWriter.println(score);
            printWriter.println(year);
            printWriter.println(World.tripwire);
            printWriter.println(World.dark);
            printWriter.println(World.raDropped);
            printWriter.println(World.islandOpen);
            printWriter.println(World.omInSafe);
            printWriter.println(World.jiInSafe);
            printWriter.println(World.niInSafe);
            printWriter.println(World.yuInCase);
            printWriter.println(World.goInBox);
            printWriter.println(World.sandExhibitDoorOpen);
            printWriter.println(World.loungeSafeOpen);
            printWriter.println(World.shrineRoom1SafeOpen);
            printWriter.println(World.shrineRoom2DoorOpen);
            printWriter.println(World.courtyardDoorOpen);
            printWriter.println(World.studySafeOpen);
            printWriter.println(World.creakyDeckOpen);
            printWriter.println(World.caseOpen);
            printWriter.println(World.cornOnRod);
            printWriter.println(World.bite);
            printWriter.println(World.theaterTVAtBeginning);
            printWriter.println(World.reaperDisabled);
            printWriter.println(Player.memory.contains("fish"));
            printWriter.println(Player.memory.contains("lotus"));
            printWriter.println(Player.memory.contains("knot"));
            printWriter.println(Player.memory.contains("om"));
            printWriter.println(Player.memory.contains("ni"));
            printWriter.println(Player.memory.contains("go"));
            printWriter.println(Player.memory.contains("yu"));
            printWriter.println(Player.memory.contains("ji"));
            printWriter.println(Player.memory.contains("ra"));
            printWriter.println(Player.memory.contains("shi"));
            printWriter.println(Player.inventory.contains(Item.om.getTitle()));
            printWriter.println(Player.inventory.contains(Item.ni.getTitle()));
            printWriter.println(Player.inventory.contains(Item.go.getTitle()));
            printWriter.println(Player.inventory.contains(Item.yu.getTitle()));
            printWriter.println(Player.inventory.contains(Item.ji.getTitle()));
            printWriter.println(Player.inventory.contains(Item.ra.getTitle()));
            printWriter.println(Player.inventory.contains(Item.shi.getTitle()));
            printWriter.println(Player.inventory.contains(Item.book.getTitle()));
            printWriter.println(Player.inventory.contains(Item.cryptogram.getTitle()));
            printWriter.println(Player.inventory.contains(Item.rod.getTitle()));
            printWriter.println(Player.inventory.contains(Item.corn.getTitle()));
            printWriter.println(Player.inventory.contains(Item.parchment.getTitle()));
            printWriter.println(Player.inventory.contains(Item.card.getTitle()));
            printWriter.println(Player.inventory.contains(Item.phone.getTitle()));
            printWriter.println(Player.inventory.contains(Item.jewelledCase.getTitle()));
            printWriter.println(Player.inventory.contains(Item.sword.getTitle()));
            printWriter.println(Player.orangeSavedInventory.contains(Item.om.getTitle()));
            printWriter.println(Player.orangeSavedInventory.contains(Item.ji.getTitle()));
            printWriter.println(Player.orangeSavedInventory.contains(Item.book.getTitle()));
            printWriter.println(Player.orangeSavedInventory.contains(Item.sword.getTitle()));
            printWriter.println(Player.greenSavedInventory.contains(Item.ra.getTitle()));
            printWriter.println(Player.greenSavedInventory.contains(Item.ni.getTitle()));
            printWriter.println(Player.greenSavedInventory.contains(Item.rod.getTitle()));
            printWriter.println(Player.greenSavedInventory.contains(Item.corn.getTitle()));
            printWriter.println(Player.greenSavedInventory.contains(Item.cryptogram.getTitle()));
            printWriter.println(Player.greenSavedInventory.contains(Item.phone.getTitle()));
            printWriter.println(Player.greenSavedInventory.contains(Item.parchment.getTitle()));
            printWriter.println(Player.purpleSavedInventory.contains(Item.go.getTitle()));
            printWriter.println(Player.purpleSavedInventory.contains(Item.yu.getTitle()));
            printWriter.println(Player.purpleSavedInventory.contains(Item.shi.getTitle()));
            printWriter.println(Player.purpleSavedInventory.contains(Item.card.getTitle()));
            printWriter.println(Player.purpleSavedInventory.contains(Item.jewelledCase.getTitle()));
            printWriter.println(Item.getLocation(Item.om.getTitle()));
            printWriter.println(Item.getLocation(Item.ni.getTitle()));
            printWriter.println(Item.getLocation(Item.go.getTitle()));
            printWriter.println(Item.getLocation(Item.yu.getTitle()));
            printWriter.println(Item.getLocation(Item.ji.getTitle()));
            printWriter.println(Item.getLocation(Item.ra.getTitle()));
            printWriter.println(Item.getLocation(Item.shi.getTitle()));
            printWriter.println(Item.getLocation(Item.book.getTitle()));
            printWriter.println(Item.getLocation(Item.cryptogram.getTitle()));
            printWriter.println(Item.getLocation(Item.rod.getTitle()));
            printWriter.println(Item.getLocation(Item.corn.getTitle()));
            printWriter.println(Item.getLocation(Item.parchment.getTitle()));
            printWriter.println(Item.getLocation(Item.card.getTitle()));
            printWriter.println(Item.getLocation(Item.phone.getTitle()));
            printWriter.println(Item.getLocation(Item.jewelledCase.getTitle()));
            printWriter.println(Item.getLocation(Item.sword.getTitle()));
            printWriter.println(deaths);
            for (int i = 0; i < Player.guesses.size(); ++i) {
                printWriter.println(Player.guesses.get(i));
            }
            printWriter.close();
            Story.print("Save successful.");
        }
        catch (Exception exception) {
            Story.print("Save unsuccessful.");
        }
    }

    public static void confirmRestore() {
        Story.print("You are about to restore the game to a previous state. Any unsaved progress will be lost. Continue?");
        yesOrNo = true;
        confirmingRestoreGame = true;
    }

    public static void attemptToRestoreGame() {
        String string = JOptionPane.showInputDialog("Enter the name of the save file you would like to restore.");
        if (Data.fileValid(string)) {
            File file = new File(string + ".txt");
            if (file.exists()) {
                Story.restartRestoreOrQuit = false;
                Data.loadGame(string);
            } else {
                Story.print("Restore unsuccessful. File not found.\n(Be sure that the save file is in the same folder as the Wabewalker Executable Jar File)");
            }
        } else {
            Story.print("Restore canceled.");
        }
    }

    private static int getFileSize(String string) {
        try {
            int n = 0;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string + ".txt"));
            while (bufferedReader.readLine() != null) {
                ++n;
            }
            bufferedReader.close();
            return n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static void loadGame(String string) {
        boolean bl = false;
        int n = Data.getFileSize(string);
        try {
            File file = new File(string + ".txt");
            Scanner scanner = new Scanner(file);
            for (int i = 0; i < n; ++i) {
                Data.saveData[i] = scanner.nextLine();
            }
            scanner.close();
            Story.print("Restore successful.");
            bl = true;
        }
        catch (Exception exception) {
            Story.print("Restore unsuccessful.");
        }
        if (bl) {
            Story.newParagraph();
            Data.resetGameData();
            Player.restoreSavedLocation(Room.getRoomFromTitle(saveData[2]));
            Story.brief = saveData[3].equals("true");
            Player.meditating = saveData[4].equals("true");
            Player.dreaming = saveData[5].equals("true");
            Player.sawReaper1 = saveData[6].equals("true");
            Player.sawReaper2 = saveData[7].equals("true");
            Player.facingReaper = saveData[8].equals("true");
            Player.orangeAlive = saveData[9].equals("true");
            Player.greenAlive = saveData[10].equals("true");
            Player.purpleAlive = saveData[11].equals("true");
            Player.orangeAtTV = saveData[12].equals("true");
            Player.greenAtTV = saveData[13].equals("true");
            Player.purpleAtTV = saveData[14].equals("true");
            Player.caughtFish = saveData[15].equals("true");
            Player.hadCorn = saveData[16].equals("true");
            Player.raDropped = saveData[17].equals("true");
            Player.onPhone = saveData[18].equals("true");
            Player.fishing = saveData[19].equals("true");
            Player.sipped = saveData[20].equals("true");
            Player.spokeToClan = saveData[21].equals("true");
            Player.metIsachi = saveData[22].equals("true");
            Player.playedTheaterTV = saveData[23].equals("true");
            Player.baitedRod = saveData[24].equals("true");
            Player.openedHokura = saveData[25].equals("true");
            Player.examinedCard = saveData[26].equals("true");
            Player.gotKimiPoints = saveData[27].equals("true");
            Player.openedSandExhibitDoor = saveData[28].equals("true");
            Player.gotTodPoints = saveData[29].equals("true");
            Player.readBook = saveData[30].equals("true");
            Player.readCryptogram = saveData[31].equals("true");
            Player.pulledHallwayLever = saveData[32].equals("true");
            Player.openedCloset = saveData[33].equals("true");
            Player.openedShrineRoom2Door = saveData[34].equals("true");
            Player.tookParchment = saveData[35].equals("true");
            Player.examinedMannequin = saveData[36].equals("true");
            Player.startedFishing = Integer.parseInt(saveData[37]);
            Player.previousLocation = saveData[38];
            Meditate.visualizingLotus = saveData[39].equals("true");
            Meditate.visualizingFish = saveData[40].equals("true");
            Meditate.visualizingKnot = saveData[41].equals("true");
            Meditate.trancedGarden = saveData[42].equals("true");
            Meditate.trancedHouse = saveData[43].equals("true");
            Meditate.trancedTemple = saveData[44].equals("true");
            Meditate.trancesTranced = Integer.parseInt(saveData[45]);
            Meditate.gardenTrance = Integer.parseInt(saveData[46]);
            Meditate.houseTrance = Integer.parseInt(saveData[47]);
            Meditate.templeTrance = Integer.parseInt(saveData[48]);
            NPC.scheduled = saveData[49].equals("true");
            NPC.reaperMoved = saveData[50].equals("true");
            NPC.kimiState = saveData[51];
            NPC.todState = saveData[52];
            moves = Integer.parseInt(saveData[53]);
            score = Short.parseShort(saveData[54]);
            year = Integer.parseInt(saveData[55]);
            World.tripwire = saveData[56].equals("true");
            World.dark = saveData[57].equals("true");
            World.raDropped = saveData[58].equals("true");
            World.islandOpen = saveData[59].equals("true");
            World.omInSafe = saveData[60].equals("true");
            World.jiInSafe = saveData[61].equals("true");
            World.niInSafe = saveData[62].equals("true");
            World.yuInCase = saveData[63].equals("true");
            World.goInBox = saveData[64].equals("true");
            World.sandExhibitDoorOpen = saveData[65].equals("true");
            World.loungeSafeOpen = saveData[66].equals("true");
            World.shrineRoom1SafeOpen = saveData[67].equals("true");
            World.shrineRoom2DoorOpen = saveData[68].equals("true");
            World.courtyardDoorOpen = saveData[69].equals("true");
            World.studySafeOpen = saveData[70].equals("true");
            World.creakyDeckOpen = saveData[71].equals("true");
            World.caseOpen = saveData[72].equals("true");
            World.cornOnRod = saveData[73].equals("true");
            World.bite = saveData[74].equals("true");
            World.theaterTVAtBeginning = saveData[75].equals("true");
            World.reaperDisabled = saveData[76].equals("true");
            if (saveData[77].equals("true")) {
                Player.memory.add("fish");
            }
            if (saveData[78].equals("true")) {
                Player.memory.add("lotus");
            }
            if (saveData[79].equals("true")) {
                Player.memory.add("knot");
            }
            if (saveData[80].equals("true")) {
                Player.memory.add("om");
            }
            if (saveData[81].equals("true")) {
                Player.memory.add("ni");
            }
            if (saveData[82].equals("true")) {
                Player.memory.add("go");
            }
            if (saveData[83].equals("true")) {
                Player.memory.add("yu");
            }
            if (saveData[84].equals("true")) {
                Player.memory.add("ji");
            }
            if (saveData[85].equals("true")) {
                Player.memory.add("ra");
            }
            if (saveData[86].equals("true")) {
                Player.memory.add("shi");
            }
            if (saveData[87].equals("true")) {
                Player.inventory.add(Item.om.getTitle());
            }
            if (saveData[88].equals("true")) {
                Player.inventory.add(Item.ni.getTitle());
            }
            if (saveData[89].equals("true")) {
                Player.inventory.add(Item.go.getTitle());
            }
            if (saveData[90].equals("true")) {
                Player.inventory.add(Item.yu.getTitle());
            }
            if (saveData[91].equals("true")) {
                Player.inventory.add(Item.ji.getTitle());
            }
            if (saveData[92].equals("true")) {
                Player.inventory.add(Item.ra.getTitle());
            }
            if (saveData[93].equals("true")) {
                Player.inventory.add(Item.shi.getTitle());
            }
            if (saveData[94].equals("true")) {
                Player.inventory.add(Item.book.getTitle());
            }
            if (saveData[95].equals("true")) {
                Player.inventory.add(Item.cryptogram.getTitle());
            }
            if (saveData[96].equals("true")) {
                Player.inventory.add(Item.rod.getTitle());
            }
            if (saveData[97].equals("true")) {
                Player.inventory.add(Item.corn.getTitle());
            }
            if (saveData[98].equals("true")) {
                Player.inventory.add(Item.parchment.getTitle());
            }
            if (saveData[99].equals("true")) {
                Player.inventory.add(Item.card.getTitle());
            }
            if (saveData[100].equals("true")) {
                Player.inventory.add(Item.phone.getTitle());
            }
            if (saveData[101].equals("true")) {
                Player.inventory.add(Item.jewelledCase.getTitle());
            }
            if (saveData[102].equals("true")) {
                Player.inventory.add(Item.sword.getTitle());
            }
            if (saveData[103].equals("true")) {
                Player.orangeSavedInventory.add(Item.om.getTitle());
            }
            if (saveData[104].equals("true")) {
                Player.orangeSavedInventory.add(Item.ji.getTitle());
            }
            if (saveData[105].equals("true")) {
                Player.orangeSavedInventory.add(Item.book.getTitle());
            }
            if (saveData[106].equals("true")) {
                Player.orangeSavedInventory.add(Item.sword.getTitle());
            }
            if (saveData[107].equals("true")) {
                Player.greenSavedInventory.add(Item.ra.getTitle());
            }
            if (saveData[108].equals("true")) {
                Player.greenSavedInventory.add(Item.ni.getTitle());
            }
            if (saveData[109].equals("true")) {
                Player.greenSavedInventory.add(Item.rod.getTitle());
            }
            if (saveData[110].equals("true")) {
                Player.greenSavedInventory.add(Item.corn.getTitle());
            }
            if (saveData[111].equals("true")) {
                Player.greenSavedInventory.add(Item.cryptogram.getTitle());
            }
            if (saveData[112].equals("true")) {
                Player.greenSavedInventory.add(Item.phone.getTitle());
            }
            if (saveData[113].equals("true")) {
                Player.greenSavedInventory.add(Item.parchment.getTitle());
            }
            if (saveData[114].equals("true")) {
                Player.purpleSavedInventory.add(Item.go.getTitle());
            }
            if (saveData[115].equals("true")) {
                Player.purpleSavedInventory.add(Item.yu.getTitle());
            }
            if (saveData[116].equals("true")) {
                Player.purpleSavedInventory.add(Item.shi.getTitle());
            }
            if (saveData[117].equals("true")) {
                Player.purpleSavedInventory.add(Item.card.getTitle());
            }
            if (saveData[118].equals("true")) {
                Player.purpleSavedInventory.add(Item.jewelledCase.getTitle());
            }
            Room.placeItem(Item.om.getTitle(), saveData[119]);
            Room.placeItem(Item.ni.getTitle(), saveData[120]);
            Room.placeItem(Item.go.getTitle(), saveData[121]);
            Room.placeItem(Item.yu.getTitle(), saveData[122]);
            Room.placeItem(Item.ji.getTitle(), saveData[123]);
            Room.placeItem(Item.ra.getTitle(), saveData[124]);
            Room.placeItem(Item.shi.getTitle(), saveData[125]);
            Room.placeItem(Item.book.getTitle(), saveData[126]);
            Room.placeItem(Item.cryptogram.getTitle(), saveData[127]);
            Room.placeItem(Item.rod.getTitle(), saveData[128]);
            Room.placeItem(Item.corn.getTitle(), saveData[129]);
            Room.placeItem(Item.parchment.getTitle(), saveData[130]);
            Room.placeItem(Item.card.getTitle(), saveData[131]);
            Room.placeItem(Item.phone.getTitle(), saveData[132]);
            Room.placeItem(Item.jewelledCase.getTitle(), saveData[133]);
            Room.placeItem(Item.sword.getTitle(), saveData[134]);
            deaths = Integer.parseInt(saveData[135]);
            for (int i = 0; i < Player.guesses.size(); ++i) {
                Player.guesses.add(saveData[136] + i);
            }
            World.resetBulbs();
            Story.newLine();
            Story.printDesc();
            Story.printDesc2();
            Story.printObjects();
        }
    }

    public static void confirmQuit() {
        int n = JOptionPane.showConfirmDialog(null, "You are about to exit the game.\nAny unsaved progress will be lost.\nContinue?", "Confirmation Request", 0);
        if (n == 0) {
            System.exit(0);
        }
    }

    public static void setYear() {
        year = Data.getRandom(1999);
        while (year < 101 || Player.guesses.contains(year)) {
            year = Data.getRandom(1999);
        }
    }

    public static int getRandom(int n) {
        int n2 = (int)(Math.random() * (double)n + 1.0);
        return n2;
    }

    public static void checkGuesses() {
        if (Player.guesses.size() > 1500) {
            Player.guesses.clear();
        }
    }

    public static void updateScore(int n) {
        score = (short)(score + n);
        Wabewalker.scoreHolder.setText("Score: " + score + " ");
        if (score > 0 && score < maxScore) {
            Story.newParagraph();
            Story.print("[Your score just increased by " + n + " points! Your total is now " + score + " out of " + maxScore + ".]");
        }
    }

    public static void handleGameOver(String string) {
        switch (string) {
            case "YES": {
                Data.newGame();
                break;
            }
            case "NO": {
                System.exit(0);
                break;
            }
            default: {
                Story.printYesOrNo();
            }
        }
    }

    private static void resetGameData() {
        moves = 0;
        score = 0;
        year = -21374;
        Story.brief = false;
        Room.location.clear();
        Room.visited.clear();
        Player.meditating = false;
        Player.dreaming = false;
        Player.sawReaper1 = false;
        Player.sawReaper2 = false;
        Player.facingReaper = false;
        Player.orangeAlive = true;
        Player.greenAlive = true;
        Player.purpleAlive = true;
        Player.orangeAtTV = false;
        Player.greenAtTV = false;
        Player.purpleAtTV = false;
        Player.caughtFish = false;
        Player.hadCorn = false;
        Player.raDropped = false;
        Player.onPhone = false;
        Player.fishing = false;
        Player.sipped = false;
        Player.spokeToClan = false;
        Player.metIsachi = false;
        Player.playedTheaterTV = false;
        Player.baitedRod = false;
        Player.openedHokura = false;
        Player.examinedCard = false;
        Player.gotKimiPoints = false;
        Player.openedSandExhibitDoor = false;
        Player.gotTodPoints = false;
        Player.readBook = false;
        Player.readCryptogram = false;
        Player.pulledHallwayLever = false;
        Player.openedCloset = false;
        Player.openedShrineRoom2Door = false;
        Player.tookParchment = false;
        Player.examinedMannequin = false;
        Player.startedFishing = 0;
        Player.previousLocation = "";
        Player.memory.clear();
        Player.guesses.clear();
        Player.inventory.clear();
        Player.orangeSavedInventory.clear();
        Player.greenSavedInventory.clear();
        Player.purpleSavedInventory.clear();
        Meditate.visualizingLotus = false;
        Meditate.visualizingFish = false;
        Meditate.visualizingKnot = false;
        Meditate.trancedGarden = false;
        Meditate.trancedHouse = false;
        Meditate.trancedTemple = false;
        Meditate.trancesTranced = 0;
        Meditate.gardenTrance = 0;
        Meditate.houseTrance = 0;
        Meditate.templeTrance = 0;
        Meditate.chantInputs.clear();
        NPC.scheduled = false;
        NPC.reaperMoved = false;
        NPC.kimiState = "";
        NPC.todState = "content";
        World.tripwire = false;
        World.dark = false;
        World.raDropped = false;
        World.islandOpen = false;
        World.omInSafe = true;
        World.jiInSafe = true;
        World.niInSafe = true;
        World.yuInCase = true;
        World.goInBox = true;
        World.sandExhibitDoorOpen = false;
        World.loungeSafeOpen = false;
        World.shrineRoom1SafeOpen = false;
        World.shrineRoom2DoorOpen = false;
        World.courtyardDoorOpen = false;
        World.studySafeOpen = false;
        World.creakyDeckOpen = false;
        World.caseOpen = false;
        World.cornOnRod = false;
        World.bite = false;
        World.theaterTVAtBeginning = true;
        World.reaperDisabled = false;
        World.resetBulbs();
        Room.wipeRooms();
    }

    private static void addMemory() {
        Player.memory.add("lotus");
        Player.memory.add("fish");
        Player.memory.add("knot");
        Player.memory.add("om");
        Player.memory.add("ni");
        Player.memory.add("go");
        Player.memory.add("yu");
        Player.memory.add("ji");
        Player.memory.add("ra");
        Player.memory.add("shi");
    }

    private static void addItems() {
        Player.inventory.add(Item.Om.getTitle());
        Player.inventory.add(Item.Ni.getTitle());
        Player.inventory.add(Item.Go.getTitle());
        Player.inventory.add(Item.Yu.getTitle());
        Player.inventory.add(Item.Ji.getTitle());
        Player.inventory.add(Item.Ra.getTitle());
        Player.inventory.add(Item.Shi.getTitle());
    }

    public static void cheat() {
        Story.print("What a mischievous thing to try!");
    }

    static {
        saveData = new String[2222];
    }
}

