/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHIfStatement;
import bsh.BlockNameSpace;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;

class BSHForStatement
extends SimpleNode
implements ParserConstants {
    public boolean hasForInit;
    public boolean hasExpression;
    public boolean hasForUpdate;
    private SimpleNode forInit;
    private SimpleNode expression;
    private SimpleNode forUpdate;
    private SimpleNode statement;
    private boolean parsed;

    BSHForStatement(int n2) {
        super(n2);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        boolean bl;
        int n2 = 0;
        if (this.hasForInit) {
            this.forInit = (SimpleNode)this.jjtGetChild(n2++);
        }
        if (this.hasExpression) {
            this.expression = (SimpleNode)this.jjtGetChild(n2++);
        }
        if (this.hasForUpdate) {
            this.forUpdate = (SimpleNode)this.jjtGetChild(n2++);
        }
        if (n2 < this.jjtGetNumChildren()) {
            this.statement = (SimpleNode)this.jjtGetChild(n2);
        }
        NameSpace nameSpace = callStack.top();
        BlockNameSpace blockNameSpace = new BlockNameSpace(nameSpace);
        callStack.swap(blockNameSpace);
        if (this.hasForInit) {
            this.forInit.eval(callStack, interpreter);
        }
        Object object = Primitive.VOID;
        while (!this.hasExpression || (bl = BSHIfStatement.evaluateCondition(this.expression, callStack, interpreter))) {
            Object object2;
            bl = false;
            if (this.statement != null && (object2 = this.statement.eval(callStack, interpreter)) instanceof ReturnControl) {
                switch (((ReturnControl)object2).kind) {
                    case 40: {
                        object = object2;
                        bl = true;
                        break;
                    }
                    case 18: {
                        break;
                    }
                    case 11: {
                        bl = true;
                    }
                }
            }
            if (bl) break;
            if (!this.hasForUpdate) continue;
            this.forUpdate.eval(callStack, interpreter);
        }
        callStack.swap(nameSpace);
        return object;
    }
}

