/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHPrimitiveType;
import bsh.BshClassManager;
import bsh.EvalError;
import bsh.NameSpace;
import bsh.SimpleNode;
import java.lang.reflect.Array;

class BSHType
extends SimpleNode
implements BshClassManager.Listener {
    private Class baseType;
    private int arrayDims;
    private Class type;

    BSHType(int n2) {
        super(n2);
        BshClassManager.addCMListener(this);
    }

    public void addArrayDimension() {
        ++this.arrayDims;
    }

    public Class getType(NameSpace nameSpace) throws EvalError {
        if (this.type != null) {
            return this.type;
        }
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        this.baseType = simpleNode instanceof BSHPrimitiveType ? ((BSHPrimitiveType)simpleNode).getType() : ((BSHAmbiguousName)simpleNode).toClass(nameSpace);
        if (this.arrayDims > 0) {
            try {
                int[] nArray = new int[this.arrayDims];
                Object object = Array.newInstance(this.baseType, nArray);
                this.type = object.getClass();
            }
            catch (Exception exception) {
                throw new EvalError("Couldn't construct array type", this);
            }
        } else {
            this.type = this.baseType;
        }
        return this.type;
    }

    public Class getBaseType() {
        return this.baseType;
    }

    public int getArrayDims() {
        return this.arrayDims;
    }

    public void classLoaderChanged() {
        this.type = null;
        this.baseType = null;
    }
}

