/*
 * Decompiled with CFR 0.152.
 */
package bsh;

class TokenMgrError
extends Error {
    static final int LEXICAL_ERROR = 0;
    static final int STATIC_LEXER_ERROR = 1;
    static final int INVALID_LEXICAL_STATE = 2;
    static final int LOOP_DETECTED = 3;
    int errorCode;

    protected static final String addEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            switch (string.charAt(n2)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                default: {
                    char c2 = string.charAt(n2);
                    if (c2 < ' ' || c2 > '~') {
                        String string2 = "0000" + Integer.toString(c2, 16);
                        stringBuffer.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        break;
                    }
                    stringBuffer.append(c2);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static final String LexicalError(boolean bl, int n2, int n3, int n4, String string, char c2) {
        return "Lexical error at line " + n3 + ", column " + n4 + ".  Encountered: " + (bl ? "<EOF> " : "\"" + TokenMgrError.addEscapes(String.valueOf(c2)) + "\"" + " (" + c2 + "), ") + "after : \"" + TokenMgrError.addEscapes(string) + "\"";
    }

    public String getMessage() {
        return super.getMessage();
    }

    public TokenMgrError() {
    }

    public TokenMgrError(String string, int n2) {
        super(string);
        this.errorCode = n2;
    }

    public TokenMgrError(boolean bl, int n2, int n3, int n4, String string, char c2, int n5) {
        this(TokenMgrError.LexicalError(bl, n2, n3, n4, string, c2), n5);
    }
}

