/*
 * Decompiled with CFR 0.152.
 */
public class IrcDccChatSynchronousHandler
implements IrcDccListener {
    IrcDccChatSocket s;
    String curNick;
    String curText;
    protected boolean clientHasDisconnected = false;

    public IrcDccChatSynchronousHandler() {
        this.s = null;
    }

    public IrcDccChatSynchronousHandler(IrcDccChatSocket s) {
        this.s = s;
        s.setDccListener(this);
    }

    public synchronized void setSocket(IrcDccChatSocket s) {
        this.s = s;
        s.setDccListener(this);
    }

    public synchronized IrcDccChatSocket getSocket() {
        return this.s;
    }

    public synchronized String getInput() {
        try {
            this.wait();
        }
        catch (InterruptedException intex) {
            System.out.println(intex);
            intex.printStackTrace();
            return null;
        }
        String temp = this.curText;
        this.curText = null;
        return temp;
    }

    public void escribir(String str) {
        if (this.s != null) {
            this.s.sendMessage(str);
        }
    }

    public synchronized void dccMsg(String nick, String message) {
        this.curNick = nick;
        this.curText = message;
        System.out.println("Input gotten: " + message);
        this.notify();
    }

    public synchronized void dccConnection(String nick) {
        System.out.println("Connected to " + nick);
    }

    public synchronized void dccDisconnection(String nick) {
        System.out.println("Disconnected from " + nick);
        this.clientHasDisconnected = true;
        this.curText = null;
        this.notify();
    }
}

