/*
 * Decompiled with CFR 0.152.
 */
import bsh.TargetError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class World
implements Informador,
SupportingCode {
    private String worldname;
    private String modulename;
    private String worlddir;
    private int maxroom;
    private int maxitem;
    private int maxmob;
    private int maxabsent;
    private int maxspell;
    private Room[] room;
    private Item[] item;
    private Mobile[] mob;
    private AbstractEntity[] absent;
    private Spell[] spell;
    private InputOutputClient io;
    private List playerList = new Vector();
    private ObjectCode itsCode;
    private String author = null;
    private String version = null;
    private String parserVersion = null;
    private String date = null;
    private String type = null;
    private Random aleat;
    private long semilla;
    private NaturalLanguage lenguaje;
    private Map nameTable;
    public boolean serverIntroExeccedFlag;
    public Object serverIntroSyncObject = new Object();
    private Element[] itemNode;
    private Element[] mobNode;
    private Element[] roomNode;
    private Element[] absentNode;
    private Element[] spellNode;
    private VisualConfiguration vc;
    private List fileList = new ArrayList();
    private List playerTemplateNodes = new ArrayList();
    private List playersToAdd = new Vector();
    private BufferedReader logReader;
    boolean from_log;

    public void endOfLog() {
        this.from_log = false;
        List jugadores = this.getPlayerList();
        int i = 0;
        while (i < jugadores.size()) {
            Player jugador = (Player)jugadores.get(i);
            jugador.endOfLog();
            ++i;
        }
    }

    public void prepareLog(String s) throws FileNotFoundException {
        this.from_log = true;
        FileInputStream logInput = new FileInputStream(s);
        this.logReader = new BufferedReader(Utility.getBestInputStreamReader(logInput));
        try {
            this.logReader.readLine();
            this.logReader.readLine();
        }
        catch (IOException exc) {
            this.escribir(String.valueOf(this.io.getColorCode("error")) + "Excepci\u00f3n I/O al leer el log" + this.io.getColorCode("reset"));
        }
        List jugadores = this.getPlayerList();
        int i = 0;
        while (i < jugadores.size()) {
            Player jugador = (Player)jugadores.get(i);
            jugador.prepareLog(this.logReader);
            ++i;
        }
    }

    public void loadWorldFromXML(Node n, final InputOutputClient io, boolean noSerCliente) throws XMLtoWorldException {
        Element elt;
        int i;
        NodeList spellNodes;
        NodeList codeNodes;
        NodeList fileListNodes;
        NodeList confNodes;
        this.io = io;
        boolean jugadorAsignadoACliente = false;
        this.escribir(String.valueOf(io.getColorCode("information")) + "Obteniendo informaci\u00f3n de mundo...\n" + io.getColorCode("reset"));
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("World node not Element");
        }
        Element e = (Element)n;
        this.worldname = "Mundo Sin Nombre";
        this.version = "Desconocida";
        this.parserVersion = "Sabe Dios";
        this.modulename = "Sin Nombre";
        this.maxroom = 0;
        this.maxitem = 0;
        this.maxmob = 0;
        this.author = "Don Nadie";
        this.date = "El a\u00f1o de Maricasta\u00f1a";
        this.type = "Qui\u00e9n sabe";
        if (!e.hasAttribute("worldName")) {
            throw new XMLtoWorldException("World node lacks attribute worldName");
        }
        if (!e.hasAttribute("moduleName")) {
            throw new XMLtoWorldException("Item node lacks attribute moduleName");
        }
        if (!e.hasAttribute("maxroom")) {
            this.maxroom = e.getElementsByTagName("Room").getLength();
        }
        if (!e.hasAttribute("maxitem")) {
            this.maxitem = e.getElementsByTagName("Item").getLength();
        }
        if (!e.hasAttribute("maxmob")) {
            this.maxmob = e.getElementsByTagName("Mobile").getLength();
            System.out.println("Max Mob set to " + this.maxmob);
        }
        if (!e.hasAttribute("maxabsent")) {
            this.maxabsent = e.getElementsByTagName("AbstractEntity").getLength();
            System.out.println("Max Abstract set to " + this.maxmob);
        }
        if (!e.hasAttribute("maxspell")) {
            this.maxspell = e.getElementsByTagName("Spell").getLength();
            System.out.println("Max Spell set to " + this.maxmob);
        }
        this.worldname = e.getAttribute("worldName");
        this.modulename = e.getAttribute("moduleName");
        try {
            if (e.hasAttribute("maxroom")) {
                this.maxroom = Integer.valueOf(e.getAttribute("maxroom"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (e.hasAttribute("maxitem")) {
                this.maxitem = Integer.valueOf(e.getAttribute("maxitem"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (e.hasAttribute("maxmob")) {
                this.maxmob = Integer.valueOf(e.getAttribute("maxmob"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (e.hasAttribute("maxabsent")) {
                this.maxabsent = Integer.valueOf(e.getAttribute("maxabsent"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (e.hasAttribute("maxspell")) {
                this.maxmob = Integer.valueOf(e.getAttribute("maxspell"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (e.hasAttribute("author")) {
            this.author = e.getAttribute("author");
        }
        if (e.hasAttribute("version")) {
            this.version = e.getAttribute("version");
        }
        if (e.hasAttribute("parserVersion")) {
            this.parserVersion = e.getAttribute("parserVersion");
        }
        if (e.hasAttribute("date")) {
            this.date = e.getAttribute("date");
        }
        if ((confNodes = e.getElementsByTagName("VisualConfiguration")).getLength() > 0) {
            Element confNode = (Element)confNodes.item(0);
            this.vc = new VisualConfiguration(confNode, this.getWorldDir());
            if (io instanceof ColoredSwingClient) {
                System.out.println("VISUAL CONFIGURATION SET TO " + this.vc);
                ((ColoredSwingClient)io).setVisualConfiguration(this.vc);
            }
        }
        if ((fileListNodes = e.getElementsByTagName("FileList")).getLength() > 0) {
            Element fileListNode = (Element)fileListNodes.item(0);
            NodeList fileNodes = fileListNode.getElementsByTagName("File");
            this.fileList = new ArrayList();
            int i2 = 0;
            while (i2 < fileNodes.getLength()) {
                if (((Element)fileNodes.item(i2)).hasAttribute("path")) {
                    this.fileList.add(String.valueOf(this.getWorldDir()) + ((Element)fileNodes.item(i2)).getAttribute("path"));
                }
                ++i2;
            }
        }
        ArrayList<Integer> playerIDs = new ArrayList<Integer>();
        NodeList plNodes = e.getElementsByTagName("PlayerList");
        if (plNodes.getLength() > 0) {
            Element plNode = (Element)plNodes.item(0);
            NodeList plidnodes = plNode.getElementsByTagName("Player");
            int i3 = 0;
            while (i3 < plidnodes.getLength()) {
                int idnumber;
                Element playerIDNode = (Element)plidnodes.item(i3);
                if (playerIDNode.hasAttribute("id") && (idnumber = Integer.valueOf(playerIDNode.getAttribute("id")).intValue()) > 0) {
                    playerIDs.add(new Integer(idnumber));
                }
                ++i3;
            }
        }
        if ((codeNodes = e.getElementsByTagName("Code")).getLength() > 0) {
            try {
                this.itsCode = new ObjectCode(this, codeNodes.item(0));
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("Exception at Code node: " + ex.getMessage());
            }
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "Cargando datos ling\u00fc\u00edsticos...\n" + io.getColorCode("reset"));
        this.lenguaje = new NaturalLanguage();
        Thread.currentThread();
        Thread.yield();
        NodeList playerGenerationNodes = e.getElementsByTagName("PlayerGeneration");
        if (playerGenerationNodes.getLength() > 0) {
            Element playerGenerationNode = (Element)playerGenerationNodes.item(0);
            NodeList templateNodes = playerGenerationNode.getElementsByTagName("Template");
            int i4 = 0;
            while (i4 < templateNodes.getLength()) {
                Element templateElement = (Element)templateNodes.item(i4);
                this.playerTemplateNodes.add(templateElement);
                ++i4;
            }
        }
        NodeList roomLists = e.getElementsByTagName("Rooms");
        NodeList itemLists = e.getElementsByTagName("Items");
        NodeList mobileLists = e.getElementsByTagName("Mobiles");
        NodeList absentLists = e.getElementsByTagName("AbstractEntities");
        NodeList spellLists = e.getElementsByTagName("Spells");
        Element roomListElement = roomLists.getLength() > 0 ? (Element)roomLists.item(0) : null;
        Element itemListElement = itemLists.getLength() > 0 ? (Element)itemLists.item(0) : null;
        Element mobileListElement = mobileLists.getLength() > 0 ? (Element)mobileLists.item(0) : null;
        Element absentListElement = absentLists.getLength() > 0 ? (Element)absentLists.item(0) : null;
        Element spellListElement = spellLists.getLength() > 0 ? (Element)spellLists.item(0) : null;
        NodeList roomNodes = roomListElement != null ? roomListElement.getElementsByTagName("Room") : null;
        NodeList itemNodes = itemListElement != null ? itemListElement.getElementsByTagName("Item") : null;
        NodeList mobileNodes = mobileListElement != null ? mobileListElement.getElementsByTagName("Mobile") : null;
        NodeList absentNodes = absentListElement != null ? absentListElement.getElementsByTagName("AbstractEntity") : null;
        NodeList nodeList = spellNodes = spellListElement != null ? spellListElement.getElementsByTagName("Spell") : null;
        if (roomNodes != null && roomNodes.getLength() != this.maxroom) {
            this.escribir("Warning: " + roomNodes.getLength() + " room nodes while maxroom is " + this.maxroom);
        }
        if (itemNodes != null && itemNodes.getLength() != this.maxitem) {
            this.escribir("Warning: " + itemNodes.getLength() + " item nodes while maxitem is " + this.maxitem);
        }
        if (mobileNodes != null && mobileNodes.getLength() != this.maxmob) {
            this.escribir("Warning: " + mobileNodes.getLength() + " mobile nodes while maxmob is " + this.maxmob);
        }
        if (absentNodes != null && absentNodes.getLength() != this.maxabsent) {
            this.escribir("Warning: " + absentNodes.getLength() + " abstract entity nodes while maxabsent is " + this.maxabsent);
        }
        if (spellNodes != null && spellNodes.getLength() != this.maxspell) {
            this.escribir("Warning: " + spellNodes.getLength() + "  spell nodes while maxspell is " + this.maxspell);
        }
        if (roomNodes != null) {
            this.roomNode = new Element[roomNodes.getLength()];
            i = 0;
            while (i < roomNodes.getLength()) {
                this.roomNode[i] = (Element)roomNodes.item(i);
                ++i;
            }
        } else {
            this.roomNode = new Element[0];
        }
        if (itemNodes != null) {
            this.itemNode = new Element[itemNodes.getLength()];
            i = 0;
            while (i < itemNodes.getLength()) {
                this.itemNode[i] = (Element)itemNodes.item(i);
                ++i;
            }
        } else {
            this.itemNode = new Element[0];
        }
        if (mobileNodes != null) {
            this.mobNode = new Element[mobileNodes.getLength()];
            i = 0;
            while (i < mobileNodes.getLength()) {
                this.mobNode[i] = (Element)mobileNodes.item(i);
                ++i;
            }
        } else {
            this.mobNode = new Element[0];
        }
        if (absentNodes != null) {
            this.absentNode = new Element[absentNodes.getLength()];
            i = 0;
            while (i < absentNodes.getLength()) {
                this.absentNode[i] = (Element)absentNodes.item(i);
                ++i;
            }
        } else {
            this.absentNode = new Element[0];
        }
        if (spellNodes != null) {
            this.spellNode = new Element[spellNodes.getLength()];
            i = 0;
            while (i < spellNodes.getLength()) {
                this.spellNode[i] = (Element)spellNodes.item(i);
                ++i;
            }
        } else {
            this.spellNode = new Element[0];
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "Creando tabla de nombres...\n" + io.getColorCode("reset"));
        int nameTableSize = this.maxroom + this.maxitem + this.maxmob + this.maxabsent + this.maxspell;
        this.nameTable = new Hashtable(nameTableSize > 100 ? nameTableSize : 100);
        int nentries = 0;
        int i5 = 0;
        while (i5 < this.roomNode.length) {
            elt = this.roomNode[i5];
            if (!elt.hasAttribute("name")) {
                throw new XMLtoWorldException("Room " + i5 + " without id or name attr");
            }
            try {
                if (elt.hasAttribute("id")) {
                    this.nameTable.put(elt.getAttribute("name"), Integer.valueOf(elt.getAttribute("id")));
                } else {
                    this.nameTable.put(elt.getAttribute("name"), new Integer(i5 + 10000000));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("id attribute not number");
            }
            ++nentries;
            ++i5;
        }
        i5 = 0;
        while (i5 < this.itemNode.length) {
            elt = this.itemNode[i5];
            if (!elt.hasAttribute("name")) {
                throw new XMLtoWorldException("Item " + i5 + " without name attr");
            }
            try {
                if (elt.hasAttribute("id")) {
                    this.nameTable.put(elt.getAttribute("name"), Integer.valueOf(elt.getAttribute("id")));
                } else {
                    this.nameTable.put(elt.getAttribute("name"), new Integer(i5 + 30000000));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("id attribute not number");
            }
            ++nentries;
            ++i5;
        }
        i5 = 0;
        while (i5 < this.mobNode.length) {
            elt = this.mobNode[i5];
            if (!elt.hasAttribute("name")) {
                throw new XMLtoWorldException("Mobile " + i5 + " without name attr");
            }
            try {
                if (elt.hasAttribute("id")) {
                    this.nameTable.put(elt.getAttribute("name"), Integer.valueOf(elt.getAttribute("id")));
                } else {
                    this.nameTable.put(elt.getAttribute("name"), new Integer(i5 + 20000000));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("id attribute not number");
            }
            ++nentries;
            ++i5;
        }
        i5 = 0;
        while (i5 < this.absentNode.length) {
            elt = this.absentNode[i5];
            if (!elt.hasAttribute("name")) {
                throw new XMLtoWorldException("AbstractEntity " + i5 + " without name attr");
            }
            try {
                if (elt.hasAttribute("id")) {
                    this.nameTable.put(elt.getAttribute("name"), Integer.valueOf(elt.getAttribute("id")));
                } else {
                    this.nameTable.put(elt.getAttribute("name"), new Integer(i5 + 40000000));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("id attribute not number");
            }
            ++nentries;
            ++i5;
        }
        i5 = 0;
        while (i5 < this.spellNode.length) {
            elt = this.spellNode[i5];
            if (!elt.hasAttribute("name")) {
                throw new XMLtoWorldException("Spell " + i5 + " without name attr");
            }
            try {
                if (elt.hasAttribute("id")) {
                    this.nameTable.put(elt.getAttribute("name"), Integer.valueOf(elt.getAttribute("id")));
                } else {
                    this.nameTable.put(elt.getAttribute("name"), new Integer(i5 + 50000000));
                }
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("id attribute not number");
            }
            ++nentries;
            ++i5;
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "Inicializando entidades abstractas...\n" + io.getColorCode("reset"));
        this.absent = new AbstractEntity[this.absentNode.length];
        i5 = 0;
        while (i5 < this.absentNode.length) {
            this.absent[i5] = AbstractEntity.getInstance(this, this.absentNode[i5]);
            if (this.absent[i5].getID() % 10000000 == 0) {
                this.absent[i5].setID(i5 + 40000000);
            }
            ++i5;
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "Inicializando hechizos...\n" + io.getColorCode("reset"));
        this.spell = new Spell[this.spellNode.length];
        i5 = 0;
        while (i5 < this.spellNode.length) {
            this.spell[i5] = Spell.getInstance(this, this.spellNode[i5]);
            if (this.spell[i5].getID() % 10000000 == 0) {
                this.spell[i5].setID(i5 + 50000000);
            }
            ++i5;
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "Inicializando items...\n" + io.getColorCode("reset"));
        this.item = new Item[this.itemNode.length];
        i5 = 0;
        while (i5 < this.itemNode.length) {
            this.item[i5] = Item.getInstance(this, this.itemNode[i5]);
            if (this.item[i5].getID() % 10000000 == 0) {
                this.item[i5].setID(i5 + 30000000);
                System.out.println("&ID SET" + this.item[i5].getID());
            }
            ++i5;
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "Inicializando bichos...\n" + io.getColorCode("reset"));
        this.mob = new Mobile[this.mobNode.length];
        i5 = 0;
        while (i5 < this.mobNode.length) {
            if (this.mobNode[i5].hasAttribute("id") && playerIDs.contains(Integer.valueOf(this.mobNode[i5].getAttribute("id")))) {
                this.mob[i5] = new Player(this, io, this.mobNode[i5]);
                jugadorAsignadoACliente = true;
                this.addPlayer((Player)this.mob[i5]);
                if (this.playerTemplateNodes.size() == 0) {
                    this.playerTemplateNodes.add(this.mobNode[i5]);
                }
            } else {
                this.mob[i5] = Mobile.getInstance(this, this.mobNode[i5]);
                if (this.mob[i5].getID() % 10000000 == 0) {
                    this.mob[i5].setID(i5 + 20000000);
                }
            }
            ++i5;
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "Inicializando habitaciones...\n" + io.getColorCode("reset"));
        this.room = new Room[this.roomNode.length];
        i5 = 0;
        while (i5 < this.roomNode.length) {
            this.room[i5] = new Room(this, this.roomNode[i5]);
            if (this.room[i5].getID() % 10000000 == 0) {
                this.room[i5].setID(i5 + 10000000);
            }
            ++i5;
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + (this.maxroom + this.maxitem + this.maxmob + this.maxspell + this.maxabsent) + " entidades cargadas.\n" + io.getColorCode("reset"));
        this.escribir(String.valueOf(io.getColorCode("information")) + "Completando cargas diferidas..." + io.getColorCode("reset") + "\n");
        i5 = 0;
        while (i5 < this.maxitem) {
            this.item[i5].loadInventoryFromXML(this);
            this.item[i5].readRelationshipListFromXML(this, this.itemNode[i5]);
            ++i5;
        }
        i5 = 0;
        while (i5 < this.maxmob) {
            this.mob[i5].readRelationshipListFromXML(this, this.mobNode[i5]);
            ++i5;
        }
        i5 = 0;
        while (i5 < this.maxroom) {
            this.room[i5].readRelationshipListFromXML(this, this.roomNode[i5]);
            ++i5;
        }
        i5 = 0;
        while (i5 < this.maxabsent) {
            this.absent[i5].readRelationshipListFromXML(this, this.absentNode[i5]);
            ++i5;
        }
        i5 = 0;
        while (i5 < this.maxspell) {
            this.spell[i5].readRelationshipListFromXML(this, this.spellNode[i5]);
            ++i5;
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "\nMundo inicializado." + io.getColorCode("reset") + "\n");
        this.escribir("\n=============================================================");
        this.escribir("\n" + io.getColorCode("information") + "Informaci\u00f3n de Juego:");
        if (this.modulename != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Nombre]           " + this.modulename + io.getColorCode("reset"));
        }
        if (this.type != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Tipo]             " + this.type + io.getColorCode("reset"));
        }
        if (this.author != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Autor]            " + this.author + io.getColorCode("reset"));
        }
        if (this.version != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Versi\u00f3n]          " + this.version + io.getColorCode("reset"));
        }
        if (this.date != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Fecha]            " + this.date + io.getColorCode("reset"));
        }
        if (this.parserVersion != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Versi\u00f3n engine]   " + this.parserVersion + io.getColorCode("reset"));
        }
        this.escribir("\n=============================================================\n");
        if (!jugadorAsignadoACliente && !noSerCliente) {
            Thread th = new Thread(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        Object object = World.this.serverIntroSyncObject;
                        synchronized (object) {
                            while (!World.this.serverIntroExeccedFlag) {
                                try {
                                    World.this.serverIntroSyncObject.wait();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        World.this.addNewPlayerASAP(io);
                        return;
                    }
                    catch (XMLtoWorldException xml2we) {
                        io.escribir("XML to World Exception when assigning player.\n");
                        xml2we.printStackTrace();
                    }
                }
            };
            th.start();
        }
    }

    public World(String modulefile, InputOutputClient io, boolean noSerCliente) throws FileNotFoundException, IOException {
        int nlinea;
        String id_linea;
        int line;
        int idnumber;
        BufferedReader br;
        if (modulefile.toLowerCase().endsWith(".xml")) {
            this.worlddir = String.valueOf(new File(new File(modulefile).getParent()).getPath()) + File.separatorChar;
            io.escribir(String.valueOf(io.getColorCode("information")) + "Leyendo datos XML...\n" + io.getColorCode("reset"));
            Document d = null;
            try {
                BufferedReader br2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(modulefile)), "ISO-8859-1"));
                InputSource is = new InputSource(br2);
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                io.escribir(String.valueOf(io.getColorCode("information")) + "Obteniendo \u00e1rbol DOM de los datos XML...\n" + io.getColorCode("reset"));
                d = db.parse(new File(modulefile));
            }
            catch (FileNotFoundException fnfe) {
                throw fnfe;
            }
            catch (ParserConfigurationException pce) {
                System.out.println(pce);
            }
            catch (SAXException se) {
                System.out.println(se);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            Element n = d.getDocumentElement();
            try {
                this.loadWorldFromXML(n, io, noSerCliente);
            }
            catch (XMLtoWorldException x2we) {
                this.escribir("Excepci\u00f3n al leer el mundo de XML: " + x2we.getMessage());
            }
            return;
        }
        this.io = io;
        FileInputStream fp = new FileInputStream(modulefile);
        BufferedReader filein = new BufferedReader(Utility.getBestInputStreamReader(fp));
        String linea = "";
        String token = "";
        String zipFile = "";
        this.escribir(String.valueOf(io.getColorCode("information")) + "\nCARGA DEL MUNDO EN LA M\u00c1QUINA DE ESTADOS DE AETHERIA\n" + io.getColorCode("reset"));
        this.escribir(String.valueOf(io.getColorCode("information")) + "\nObteniendo informaci\u00f3n de mundo...\n" + io.getColorCode("reset"));
        Thread.currentThread();
        Thread.yield();
        while ((linea = filein.readLine()) != null) {
            String id_linea2;
            boolean terminamos;
            token = StringMethods.getTok(linea, 1, ' ');
            if (token.equalsIgnoreCase("module")) {
                this.worldname = StringMethods.getTok(linea, 2, ' ');
                continue;
            }
            if (token.equalsIgnoreCase("maxroom")) {
                this.maxroom = Integer.valueOf(StringMethods.getTok(linea, 2, ' '));
                continue;
            }
            if (token.equalsIgnoreCase("maxitem")) {
                this.maxitem = Integer.valueOf(StringMethods.getTok(linea, 2, ' '));
                continue;
            }
            if (token.equalsIgnoreCase("maxmob")) {
                this.maxmob = Integer.valueOf(StringMethods.getTok(linea, 2, ' '));
                continue;
            }
            if (token.equalsIgnoreCase("printthis")) {
                this.escribir(String.valueOf(StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ')) + "\n");
                continue;
            }
            if (token.equalsIgnoreCase("modulename")) {
                this.modulename = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("author")) {
                this.author = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("version")) {
                this.version = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("date")) {
                this.date = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("parserversion")) {
                this.parserVersion = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("zipfile")) {
                zipFile = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                continue;
            }
            if (token.equalsIgnoreCase("begin_eva_code")) {
                String EVACodeString = "";
                terminamos = false;
                while (!terminamos) {
                    linea = filein.readLine();
                    id_linea2 = StringMethods.getTok(linea, 1, ' ');
                    if (id_linea2.equalsIgnoreCase("end_eva_code")) {
                        terminamos = true;
                        continue;
                    }
                    EVACodeString = String.valueOf(EVACodeString) + "\n";
                    EVACodeString = String.valueOf(EVACodeString) + linea;
                }
                this.itsCode = new ObjectCode(EVACodeString, "EVA", this);
                continue;
            }
            if (!token.equalsIgnoreCase("begin_bsh_code")) continue;
            String BSHCodeString = "";
            terminamos = false;
            while (!terminamos) {
                linea = filein.readLine();
                id_linea2 = StringMethods.getTok(linea, 1, ' ');
                if (id_linea2.equalsIgnoreCase("end_bsh_code")) {
                    terminamos = true;
                    continue;
                }
                BSHCodeString = String.valueOf(BSHCodeString) + "\n";
                BSHCodeString = String.valueOf(BSHCodeString) + linea;
            }
            this.itsCode = new ObjectCode(BSHCodeString, "BeanShell", this);
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "\nCargando datos ling\u00fc\u00edsticos..." + io.getColorCode("reset"));
        this.lenguaje = new NaturalLanguage();
        Thread.currentThread();
        Thread.yield();
        this.worlddir = String.valueOf(new File(new File(modulefile).getParent()).getPath()) + File.separatorChar;
        this.escribir(String.valueOf(io.getColorCode("information")) + "\nCreando tabla de nombres...\n" + io.getColorCode("reset"));
        int nameTableSize = this.maxroom + this.maxitem + this.maxmob;
        this.nameTable = new Hashtable(nameTableSize > 100 ? nameTableSize : 100);
        int nentries = 0;
        try {
            int i = 0;
            while (i < this.maxitem) {
                br = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream(Utility.itemFile(this, i))));
                linea = "";
                idnumber = i;
                line = 1;
                while (line < 100) {
                    linea = br.readLine();
                    id_linea = StringMethods.getTok(linea, 1, ' ');
                    linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                    if (id_linea != null) {
                        nlinea = 0;
                        try {
                            nlinea = Integer.valueOf(id_linea);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (nlinea == 1) {
                            idnumber = Integer.valueOf(linea);
                        }
                        if (nlinea == 4) {
                            this.nameTable.put(linea, new Integer(Utility.completeItemID(idnumber)));
                            ++nentries;
                        }
                    }
                    ++line;
                }
                ++i;
            }
        }
        catch (FileNotFoundException i) {
            // empty catch block
        }
        try {
            int i = 0;
            while (i < this.maxroom) {
                br = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream(Utility.roomFile(this, i))));
                linea = "";
                idnumber = i;
                line = 1;
                while (line < 100) {
                    linea = br.readLine();
                    id_linea = StringMethods.getTok(linea, 1, ' ');
                    linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                    if (id_linea != null) {
                        nlinea = 0;
                        try {
                            nlinea = Integer.valueOf(id_linea);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (nlinea == 1) {
                            idnumber = Integer.valueOf(linea);
                        }
                        if (nlinea == 4) {
                            this.nameTable.put(linea, new Integer(Utility.completeRoomID(idnumber)));
                            ++nentries;
                        }
                    }
                    ++line;
                }
                ++i;
            }
        }
        catch (FileNotFoundException i) {
            // empty catch block
        }
        try {
            int i = 0;
            while (i < this.maxmob) {
                br = new BufferedReader(Utility.getBestInputStreamReader(new FileInputStream(Utility.mobFile(this, i))));
                linea = "";
                idnumber = i;
                line = 1;
                while (line < 100) {
                    linea = br.readLine();
                    id_linea = StringMethods.getTok(linea, 1, ' ');
                    linea = StringMethods.getToks(linea, 2, StringMethods.numToks(linea, ' '), ' ');
                    if (id_linea != null) {
                        nlinea = 0;
                        try {
                            nlinea = Integer.valueOf(id_linea);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (nlinea == 1) {
                            idnumber = Integer.valueOf(linea);
                        }
                        if (nlinea == 4) {
                            this.nameTable.put(linea, new Integer(Utility.completeMobileID(idnumber)));
                            ++nentries;
                        }
                    }
                    ++line;
                }
                ++i;
            }
        }
        catch (FileNotFoundException fnfe) {
            this.escribir(String.valueOf(io.getColorCode("information")) + "Entradas: " + nentries + "\n" + io.getColorCode("reset"));
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "Inicializando items...\n" + io.getColorCode("reset"));
        this.item = new Item[this.maxitem];
        int i = 0;
        try {
            while (i < this.maxitem) {
                this.item[i] = Item.getInstance(this, Utility.itemFile(this, i));
                ++i;
            }
        }
        catch (FileNotFoundException nomasitems) {
            this.maxitem = i;
        }
        catch (IOException npi) {
            System.out.println("No puedo abrir el objeto " + i);
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "Inicializando bichos...\n" + io.getColorCode("reset"));
        this.mob = new Mobile[this.maxmob];
        i = 1;
        try {
            while (i < this.maxmob) {
                this.mob[i] = Mobile.getInstance(this, Utility.mobFile(this, i));
                ++i;
            }
        }
        catch (FileNotFoundException nomasmobs) {
            this.maxmob = i;
        }
        catch (IOException npi) {
            System.out.println("No puedo abrir el bicho " + i);
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "Inicializando habitaciones...\n" + io.getColorCode("reset"));
        this.room = new Room[this.maxroom];
        i = 0;
        try {
            while (i < this.maxroom) {
                this.room[i] = new Room(this, Utility.roomFile(this, i));
                ++i;
            }
        }
        catch (FileNotFoundException nomashabitaciones) {
            this.maxroom = i;
        }
        catch (IOException npi) {
            System.out.println("No puedo abrir la habitaci\u00f3n " + i);
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + (this.maxroom + this.maxitem + this.maxmob) + " entidades cargadas.\n");
        this.escribir(String.valueOf(io.getColorCode("information")) + "Completando cargas diferidas..." + io.getColorCode("reset"));
        i = 1;
        while (i < this.maxitem) {
            this.item[i].loadInventory(this);
            ++i;
        }
        this.escribir(String.valueOf(io.getColorCode("information")) + "\nMundo inicializado." + io.getColorCode("reset") + "\n");
        this.escribir("\n=============================================================");
        this.escribir("\n" + io.getColorCode("information") + "Informaci\u00f3n de Juego:");
        if (this.modulename != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Nombre]           " + this.modulename + io.getColorCode("reset"));
        }
        if (this.type != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Tipo]             " + this.type + io.getColorCode("reset"));
        }
        if (this.author != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Autor]            " + this.author + io.getColorCode("reset"));
        }
        if (this.version != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Versi\u00f3n]          " + this.version + io.getColorCode("reset"));
        }
        if (this.date != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Fecha]            " + this.date + io.getColorCode("reset"));
        }
        if (this.parserVersion != null) {
            this.escribir("\n" + io.getColorCode("information") + "[Versi\u00f3n engine]   " + this.parserVersion + io.getColorCode("reset"));
        }
        this.escribir("\n=============================================================\n");
    }

    public String getWorldPath() {
        return this.worlddir;
    }

    public String getWorldDir() {
        return String.valueOf(new File(this.worlddir).getName()) + File.separatorChar;
    }

    public int getMaxRoom() {
        return this.maxroom;
    }

    public int getMaxItem() {
        return this.maxitem;
    }

    public int getMaxMob() {
        return this.maxmob;
    }

    public int getMaxAbstractEntity() {
        return this.maxabsent;
    }

    public int getMaxSpell() {
        return this.maxspell;
    }

    public Room getRoom(int roomid) {
        return this.room[roomid % 10000000];
    }

    public List getRooms() {
        ArrayList<Room> rooms = new ArrayList<Room>();
        int i = 0;
        while (i < this.maxroom) {
            rooms.add(this.getRoom(i));
            ++i;
        }
        return rooms;
    }

    public Room getRoom(String ident) {
        try {
            return this.getRoom(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getRoom(i);
            }
            return null;
        }
    }

    public int roomNameToID(String roomName) {
        Integer i = (Integer)this.nameTable.get(roomName);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public Item getItem(int itemid) {
        return this.item[itemid % 10000000];
    }

    public Item getItem(String ident) {
        try {
            return this.getItem(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getItem(i);
            }
            return null;
        }
    }

    public Mobile getMob(int mobid) {
        return this.mob[mobid % 10000000];
    }

    public Mobile getMobile(String ident) {
        return this.getMob(ident);
    }

    public Mobile getMobile(int id) {
        return this.getMob(id);
    }

    public Mobile getMob(String ident) {
        try {
            return this.getMob(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getMob(i);
            }
            return null;
        }
    }

    public AbstractEntity getAbstractEntity(int absentid) {
        return this.absent[absentid % 40000000];
    }

    public AbstractEntity getAbstractEntity(String ident) {
        try {
            return this.getAbstractEntity(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getAbstractEntity(i);
            }
            return null;
        }
    }

    public Spell getSpell(int spellid) {
        return this.spell[spellid % 50000000];
    }

    public Spell getSpell(String ident) {
        try {
            return this.getSpell(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getSpell(i);
            }
            return null;
        }
    }

    public Entity getObject(int objectid) {
        if (objectid == 20000000) {
            return this.getMob(objectid);
        }
        if (objectid < 20000000) {
            return this.getRoom(objectid);
        }
        if (objectid < 30000000) {
            return this.getMob(objectid);
        }
        if (objectid < 40000000) {
            return this.getItem(objectid);
        }
        if (objectid < 50000000) {
            return this.getAbstractEntity(objectid);
        }
        if (objectid < 60000000) {
            return this.getSpell(objectid);
        }
        return null;
    }

    public Entity getObject(String ident) {
        try {
            return this.getObject(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getObject(i);
            }
            return null;
        }
    }

    public InputOutputClient getIO() {
        return this.io;
    }

    public Element getItemNode(int itemid) {
        return this.itemNode[itemid % 10000000];
    }

    public Element getMobileNode(int mobid) {
        return this.mobNode[mobid % 10000000];
    }

    public Element getRoomNode(int roomid) {
        return this.roomNode[roomid % 10000000];
    }

    public Element getAbstractEntityNode(int absentid) {
        return this.absentNode[absentid % 10000000];
    }

    public Element getSpellNode(int spellid) {
        return this.spellNode[spellid % 10000000];
    }

    public Element getItemNode(String ident) {
        try {
            return this.getItemNode(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getItemNode(i);
            }
            return null;
        }
    }

    public Element getMobileNode(String ident) {
        try {
            return this.getMobileNode(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getMobileNode(i);
            }
            return null;
        }
    }

    public Element getRoomNode(String ident) {
        try {
            return this.getRoomNode(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getRoomNode(i);
            }
            return null;
        }
    }

    public Element getAbstractEntityNode(String ident) {
        try {
            return this.getAbstractEntityNode(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getAbstractEntityNode(i);
            }
            return null;
        }
    }

    public Element getSpellNode(String ident) {
        try {
            return this.getSpellNode(Integer.parseInt(ident));
        }
        catch (NumberFormatException nfe) {
            Integer i = (Integer)this.nameTable.get(ident);
            if (i != null) {
                return this.getSpellNode(i);
            }
            return null;
        }
    }

    public void escribir(String s) {
        this.io.escribir(s);
    }

    public void setIO(InputOutputClient es) {
        this.io = es;
    }

    public String getModuleName() {
        return this.modulename;
    }

    public boolean execCode(String routine, String dataSegment) throws EVASemanticException {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, dataSegment);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args, ReturnValue retval) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args, retval);
        }
        return false;
    }

    public NaturalLanguage getLang() {
        return this.lenguaje;
    }

    public void setRandomNumberSeed() {
        System.out.println("Setting world's random generator.");
        this.semilla = new Date().getTime();
        this.aleat = new Random(this.semilla);
        System.out.println("Seed set to " + this.semilla);
        int i = 0;
        while (i < this.maxroom) {
            this.room[i].loadNumberGenerator(this);
            ++i;
        }
        i = 0;
        while (i < this.maxmob) {
            this.mob[i].loadNumberGenerator(this);
            ++i;
        }
        i = 0;
        while (i < this.maxitem) {
            this.item[i].loadNumberGenerator(this);
            ++i;
        }
    }

    public void setRandomNumberSeed(String logfile) throws FileNotFoundException {
        FileInputStream logInput = new FileInputStream(logfile);
        BufferedReader logReader = new BufferedReader(Utility.getBestInputStreamReader(logInput));
        try {
            logReader.readLine();
            this.semilla = Long.valueOf(logReader.readLine());
            this.aleat = new Random(this.semilla);
        }
        catch (IOException exc) {
            this.escribir("Excepci\u00f3n I/O al leer el log");
        }
        int i = 0;
        while (i < this.maxroom) {
            this.room[i].loadNumberGenerator(this);
            ++i;
        }
        i = 0;
        while (i < this.maxmob) {
            this.mob[i].loadNumberGenerator(this);
            ++i;
        }
        i = 0;
        while (i < this.maxitem) {
            this.item[i].loadNumberGenerator(this);
            ++i;
        }
        i = 0;
        while (i < this.maxabsent) {
            this.absent[i].loadNumberGenerator(this);
            ++i;
        }
        i = 0;
        while (i < this.maxspell) {
            this.spell[i].loadNumberGenerator(this);
            ++i;
        }
    }

    public long getRandomNumberSeed() {
        return this.semilla;
    }

    public Random getRandom() {
        return this.aleat;
    }

    public List getPlayerList() {
        return this.playerList;
    }

    public Player getPlayer() {
        return (Player)this.playerList.get(0);
    }

    public Document getXMLRepresentation() throws ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element suElemento = doc.createElement("World");
        suElemento.setAttribute("worldName", String.valueOf(this.worldname));
        suElemento.setAttribute("moduleName", String.valueOf(this.modulename));
        suElemento.setAttribute("worldDir", String.valueOf(this.worlddir));
        suElemento.setAttribute("maxroom", String.valueOf(this.maxroom));
        suElemento.setAttribute("maxitem", String.valueOf(this.maxitem));
        suElemento.setAttribute("maxmob", String.valueOf(this.maxmob));
        suElemento.setAttribute("author", String.valueOf(this.author));
        suElemento.setAttribute("version", String.valueOf(this.version));
        suElemento.setAttribute("parserVersion", String.valueOf(this.parserVersion));
        suElemento.setAttribute("date", String.valueOf(this.date));
        suElemento.setAttribute("type", String.valueOf(this.type));
        if (this.vc != null) {
            suElemento.appendChild(this.vc.getXMLRepresentation(doc));
        }
        Element playerListElement = doc.createElement("PlayerList");
        int i = 0;
        while (i < this.playerList.size()) {
            Element playerElement = doc.createElement("Player");
            playerElement.setAttribute("id", String.valueOf(((Player)this.playerList.get(i)).getID()));
            playerListElement.appendChild(playerElement);
            ++i;
        }
        suElemento.appendChild(playerListElement);
        Element fileListElement = doc.createElement("FileList");
        int i2 = 0;
        while (i2 < this.fileList.size()) {
            Element fileElement = doc.createElement("File");
            fileElement.setAttribute("path", (String)this.fileList.get(i2));
            fileListElement.appendChild(fileElement);
            ++i2;
        }
        suElemento.appendChild(fileListElement);
        if (this.itsCode != null) {
            suElemento.appendChild(this.itsCode.getXMLRepresentation(doc));
        }
        Element pgElement = doc.createElement("PlayerGeneration");
        int i3 = 0;
        while (i3 < this.playerTemplateNodes.size()) {
            pgElement.appendChild(doc.importNode((Element)this.playerTemplateNodes.get(i3), true));
            ++i3;
        }
        suElemento.appendChild(pgElement);
        Element roomsElement = doc.createElement("Rooms");
        Element itemsElement = doc.createElement("Items");
        Element mobilesElement = doc.createElement("Mobiles");
        Element absentsElement = doc.createElement("AbstractEntities");
        Element spellsElement = doc.createElement("Spells");
        int i4 = 0;
        while (i4 < this.maxroom) {
            roomsElement.appendChild(this.room[i4].getXMLRepresentation(doc));
            ++i4;
        }
        i4 = 0;
        while (i4 < this.maxitem) {
            itemsElement.appendChild(this.item[i4].getXMLRepresentation(doc));
            ++i4;
        }
        i4 = 0;
        while (i4 < this.maxmob) {
            System.out.println("Mob " + i4);
            if (this.mob[i4] != null) {
                mobilesElement.appendChild(this.mob[i4].getXMLRepresentation(doc));
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < this.maxabsent) {
            absentsElement.appendChild(this.absent[i4].getXMLRepresentation(doc));
            ++i4;
        }
        i4 = 0;
        while (i4 < this.maxspell) {
            spellsElement.appendChild(this.spell[i4].getXMLRepresentation(doc));
            ++i4;
        }
        suElemento.appendChild(roomsElement);
        suElemento.appendChild(itemsElement);
        suElemento.appendChild(mobilesElement);
        suElemento.appendChild(absentsElement);
        suElemento.appendChild(spellsElement);
        doc.appendChild(suElemento);
        return doc;
    }

    public void addItemAssigningID(Item newItem) {
        if (this.item.length <= this.maxitem) {
            Item[] newArray = this.item.length > 2 ? new Item[(int)((double)this.item.length * 1.5)] : new Item[4];
            int i = 0;
            while (i < this.maxitem) {
                newArray[i] = this.item[i];
                ++i;
            }
            this.item = newArray;
        }
        this.item[this.maxitem] = newItem;
        newItem.setID(this.maxitem);
        ++this.maxitem;
        newItem.loadNumberGenerator(this);
    }

    public Item addCloneOfItem(Item ourItem) {
        return ourItem.createNewInstance(this, true, true);
    }

    public void addMobileAssigningID(Mobile newMob) {
        if (this.mob.length <= this.maxmob) {
            Mobile[] newArray = this.mob.length > 2 ? new Mobile[(int)((double)this.mob.length * 1.5)] : new Mobile[4];
            int i = 0;
            while (i < this.maxmob) {
                newArray[i] = this.mob[i];
                ++i;
            }
            this.mob = newArray;
        }
        this.mob[this.maxmob] = newMob;
        newMob.setID(this.maxmob);
        ++this.maxmob;
        newMob.loadNumberGenerator(this);
    }

    public void addRoomAssigningID(Room newRoom) {
        if (this.room.length <= this.maxroom) {
            Room[] newArray = this.room.length > 2 ? new Room[(int)((double)this.room.length * 1.5)] : new Room[4];
            int i = 0;
            while (i < this.maxroom) {
                newArray[i] = this.room[i];
                ++i;
            }
            this.room = newArray;
        }
        this.room[this.maxroom] = newRoom;
        newRoom.setID(this.maxroom);
        ++this.maxroom;
        newRoom.loadNumberGenerator(this);
    }

    public void addAbstractEntityAssigningID(AbstractEntity newAbsEnt) {
        if (this.absent.length <= this.maxabsent) {
            AbstractEntity[] newArray = this.absent.length > 2 ? new AbstractEntity[(int)((double)this.absent.length * 1.5)] : new AbstractEntity[4];
            int i = 0;
            while (i < this.maxabsent) {
                newArray[i] = this.absent[i];
                ++i;
            }
            this.absent = newArray;
        }
        this.absent[this.maxabsent] = newAbsEnt;
        newAbsEnt.setID(this.maxabsent);
        ++this.maxabsent;
        newAbsEnt.loadNumberGenerator(this);
    }

    public Player createPlayerFromTemplate(InputOutputClient io) throws XMLtoWorldException {
        if (this.playerTemplateNodes == null || this.playerTemplateNodes.size() < 1) {
            return null;
        }
        return new Player(this, io, (Element)this.playerTemplateNodes.get(0));
    }

    public void addNewPlayerASAP(InputOutputClient io) throws XMLtoWorldException {
        ReturnValue retval = new ReturnValue(null);
        boolean ejecutado = false;
        try {
            System.out.println("Before exec code");
            ejecutado = this.execCode("assignPlayer", new Object[]{io}, retval);
            System.out.println("After exec code");
        }
        catch (TargetError bshte) {
            this.escribir("bsh.TargetError found at assignPlayer routine");
            System.out.println(bshte.printTargetError(bshte));
            this.escribir(bshte.printTargetError(bshte));
            bshte.printStackTrace();
        }
        if (retval.getRetVal() != null) {
            Player p = (Player)retval.getRetVal();
            if (this.playerList.contains(p)) {
                p.reconnect(io);
                return;
            }
            World world = this;
            synchronized (world) {
                this.playersToAdd.add(p);
            }
            return;
        }
        if (ejecutado) {
            return;
        }
        World world = this;
        synchronized (world) {
            this.playersToAdd.add(this.createPlayerFromTemplate(io));
        }
        io.escribir("Player enqueued to be added...\n");
    }

    public Room getLimbo() {
        return this.getRoom(0);
    }

    public void update() {
        int i = 0;
        while (i < this.getMaxRoom()) {
            if (this.getRoom(i) != null) {
                this.getRoom(i).update(this);
            }
            ++i;
        }
        i = 0;
        while (i < this.getMaxMob()) {
            if (this.getMob(i) != null) {
                this.getMob(i).update(this);
            }
            ++i;
        }
        i = 0;
        while (i < this.getMaxItem()) {
            if (this.getItem(i) != null) {
                this.getItem(i).update(this);
            }
            ++i;
        }
        i = 0;
        while (i < this.getMaxAbstractEntity()) {
            if (this.getAbstractEntity(i) != null) {
                this.getAbstractEntity(i).update(this);
            }
            ++i;
        }
        i = 0;
        while (i < this.getMaxSpell()) {
            if (this.getSpell(i) != null) {
                this.getSpell(i).update(this);
            }
            ++i;
        }
        if (!this.playersToAdd.isEmpty()) {
            i = 0;
            while (i < this.playersToAdd.size()) {
                Player p = (Player)this.playersToAdd.get(i);
                System.out.println("The " + i + "th Player is " + p);
                this.addMobileAssigningID(p);
                Room startingRoom = this.getRoom(1);
                startingRoom.addMob(p);
                this.addPlayer(p);
                p.getIO().escribir("Has sido a\u00f1adido al mundo.\n");
                p.getRoom().informActionAuto(p, null, "De repente, $1 aparece de la nada.\n", false);
                this.escribir("New player joined the game.\n");
                try {
                    this.execCode("intro", "");
                    this.execCode("intro", new Object[]{p});
                }
                catch (EVASemanticException esm) {
                    this.escribir("EVASemanticException found at intro routine");
                }
                catch (TargetError bshte) {
                    this.escribir("bsh.TargetError found at intro routine");
                }
                ++i;
            }
            this.playersToAdd = new Vector();
        }
    }

    public void loadState(String statefname) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException, XMLtoWorldException {
        File f = new File(statefname);
        Document d = null;
        this.room = null;
        this.item = null;
        this.mob = null;
        this.absent = null;
        this.spell = null;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "ISO-8859-1"));
        InputSource is = new InputSource(br);
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.io.escribir(String.valueOf(this.io.getColorCode("information")) + "Obteniendo \u00e1rbol DOM de los datos XML [estado]...\n" + this.io.getColorCode("reset"));
        d = db.parse(is);
        Element n = d.getDocumentElement();
        this.loadWorldFromXML(n, this.io, false);
    }

    public int getNumberOfConnectedPlayers() {
        int addedPlayers = 0;
        int i = 0;
        while (i < this.playerList.size()) {
            Player cur = (Player)this.playerList.get(i);
            if (cur.getState() != 15) {
                ++addedPlayers;
            }
            ++i;
        }
        return addedPlayers + this.playersToAdd.size();
    }

    public VisualConfiguration getVisualConfiguration() {
        return this.vc;
    }

    public List getFileList() {
        return this.fileList;
    }

    public void addPlayer(Player p) {
        this.playerList.add(p);
        if (this.from_log) {
            p.prepareLog(this.logReader);
        }
    }
}

