{ OTOS 1.5 }
{ IF Competition }

PROGRAM AOL_15;

USES crt, ES, COMANDOS, IA, ENTORNO;

CONST
     MARCO = LightGray;
     FONDO = Blue;
     COLOR_JUGADOR = LightGray;
     COLOR_ORDENADOR = White;

VAR
   aoljugador :Comandos_Jugador;
   ordenador :Comandos_Ordenador;
   estado :Estados;
   num_areas :WORD;
   ult_desc, descripcion, comando, cosas, salidas :Cadena;
   memo, ult :Doskey;
   mem_objetos, mem_salidas :Objetos;
   movido :BOOLEAN;
   turnos :WORD;
   tecla :CHAR;
{*}
   nombre_fichero, nombre_comportamiento :STRING[12];
   fichero :BOOLEAN;
   fich, comportamiento :TEXT;
   param :WORD;
{*}

BEGIN

{ ----- LECTURA DE PARMETROS ---- }
     fichero := FALSE;
     nombre_comportamiento := 'IA.TXT';
     param := 1;
     WHILE (param <= ParamCount) DO BEGIN
      IF ((ParamStr(param) = '-script') OR
         (ParamStr(param) = '-tr')) THEN BEGIN
             IF (ParamCount < param + 1) THEN nombre_fichero := 'SCRIPT.TXT'
             ELSE BEGIN
                  param := param + 1;
                  nombre_fichero := ParamStr(param);
             END;
             Assign(fich, nombre_fichero);
             Rewrite(fich);
             fichero := TRUE;
      END;
      IF (ParamStr(param) = '-ia') THEN BEGIN
         IF (ParamCount < param + 1) THEN nombre_comportamiento := 'IA.TXT'
         ELSE BEGIN
              param := param + 1;
              nombre_comportamiento := ParamStr(param);
         END;
      END;
      param := param + 1;
     END;

{ -------------------------------- }

{ ----- INICIALIZAMOS LAS VARIABLES DE AOL ----- }
  { Comandos, comandos especiales, objetos y salidas }
     Inicializar_Jugador(aoljugador, nombre_comportamiento, num_areas);
     Inicializar_Ordenador(ordenador);
     Inicializar_Objetos(mem_objetos);
     Inicializar_Objetos(mem_salidas);
  { Cadenas }
     Inicializar_Cadena(ult_desc);
     Inicializar_Cadena(descripcion);
     Inicializar_Cadena(cosas);
     Inicializar_Cadena(salidas);
     Inicializar_Doskey(memo);
  { Estado Inicial }
     estado := mirar;
     movido := FALSE;
  { Turnos }
     turnos := 0;
{ ----------------------------------------------- }
     TextMode(C80);
     Pantalla_Presentacion(Black, LightGray);
     tecla := ReadKey;
     Intro(Black, LightGray);
     tecla := ReadKey;
     Crear_Pantalla(MARCO, FONDO);
     TextColor(COLOR_ORDENADOR);
     Leer_Cadena(descripcion, memo, ult);
     WHILE (Estado <> fin) DO BEGIN
         {*}
           IF (fichero) THEN BEGIN
              A_Fichero(fich, descripcion);
              WriteLn(fich);
           END;
         {*}
           turnos := turnos + 1;
           IF (estado = mirar)THEN BEGIN
              IF ((Longitud(descripcion) = 0) AND
                 (ult_desc <> NIL)) THEN BEGIN
                     Escribir_Cadena(ult_desc);
                     WriteLn;
                     Write('You can see: ');
                     Escribir_Cadena(cosas);
                     WriteLn;
                     Write('Exits lead to: ');
                     Escribir_Cadena(salidas);
                 {*}
                     IF (fichero) THEN BEGIN
                        A_Fichero(fich, ult_desc);
                        WriteLn(fich);
                        Write(fich, 'You can see: ');
                        A_Fichero(fich, cosas);
                        WriteLn(fich);
                        Write(fich, 'Exits lead to: ');
                        A_Fichero(fich, salidas);
                     END;
                 {*}
              END
              ELSE BEGIN
                   Copiar(ult_desc, descripcion);
                   WriteLn;
                   Write('You can see: ');
                   Leer_Cadena(cosas, memo, ult);
                   Memorizar_Objetos(cosas, mem_objetos);
                   WriteLn;
               {*}
                   IF (fichero) THEN BEGIN
                      Write(fich, 'You can see: ');
                      A_Fichero(fich, cosas);
                      WriteLn(fich);
                   END;
               {*}
                   Write('Exits lead to: ');
                   Leer_Cadena(salidas, memo, ult);
                   Memorizar_Objetos(salidas, mem_salidas);
               {*}
                   IF (fichero) THEN BEGIN
                      Write(fich, 'Exits lead to: ');
                      A_Fichero(fich, salidas);
                      WriteLn(fich);
                   END;
               {*}
              END;
           END;
           IF (estado = inventario) THEN
              Memorizar_Objetos(descripcion, mem_objetos);
           WriteLn; WriteLn;
           Write('> ');
           IF (NOT(movido)) THEN
              comando := Orden_Jugador(aoljugador, mem_objetos, mem_salidas,
                                       num_areas, turnos, movido)
           ELSE BEGIN
               comando := Asignar('l');
               movido := FALSE;
           END;
           estado := Cambiar_Estado(comando, ordenador);
           TextColor(COLOR_JUGADOR);
           Escribir_Cadena(comando);
           WriteLn;
       {*}
           IF (fichero) THEN BEGIN
              Writeln(fich);
              Write(fich, '> ');
              A_Fichero(fich, comando);
              WriteLn(fich);
           END;
       {*}
           TextColor(COLOR_ORDENADOR);
           Leer_Cadena(descripcion, memo, ult);
           IF (Iguales(descripcion, ordenador[6])) THEN
              estado := fin;
     END;
     Pantalla_Final(Black, LightGray);
     tecla := ReadKey;
     TextMode(C80);
 {*}
     IF (fichero) THEN
        Close(fich);
 {*}

END. { AOL_15 }