/*
 * Decompiled with CFR 0.152.
 */
package jurt;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import jurt.Command;
import jurt.Concept;
import jurt.Expression;
import jurt.Rebuff;
import jurt.Refusal;
import jurt.ScopeMethod;
import jurt.Vicinity;

public class Action
implements Serializable {
    public static final int REGULAR = 0;
    public static final int REDO = 1;
    public static final int UNDO = 2;
    public static final int RESTART = 3;
    public static final int META = 4;
    public static final int SAVESLOT1 = 5;
    public static final int LOADSLOT1 = 6;
    String type;
    int meta = 0;
    public Vicinity vic;
    public Expression expr1;
    public Expression expr2;
    public Concept noun;
    public Concept second;
    public Vector vector;
    public String string;

    public Action(String string, Vicinity vicinity) {
        this.type = string;
        this.vic = vicinity;
    }

    public Action(String string, Vicinity vicinity, Expression expression) {
        this.type = string;
        this.vic = vicinity;
        this.expr1 = expression;
    }

    public Action(String string, Vicinity vicinity, Expression expression, Expression expression2) {
        this.type = string;
        this.vic = vicinity;
        this.expr1 = expression;
        this.expr2 = expression2;
    }

    public Action(String string, Vicinity vicinity, Concept concept) {
        this.type = string;
        this.vic = vicinity;
        this.noun = concept;
    }

    public Action(String string, Vicinity vicinity, Concept concept, Concept concept2) {
        this.type = string;
        this.vic = vicinity;
        this.noun = concept;
        this.second = concept2;
    }

    public void performAll() throws Refusal {
    }

    public void runTurn() throws Refusal {
        this.perform();
        this.vic.checkCeiling();
        try {
            this.vic.scopeLoop(new ScopeMethod(){

                public void scopeMethod(Concept concept) throws Refusal {
                    concept.eachTurn(Action.this.vic);
                }
            });
        }
        catch (Rebuff rebuff) {
            rebuff.printMessage(this.vic.io);
        }
        this.vic.checkCeiling();
        if (this.vic.isNeedLook()) {
            this.vic.ceiling.printLook(this.vic, 4);
        }
        this.vic.actor.runDaemonList(this.vic);
        this.vic.checkCeiling();
        if (this.vic.isNeedLook()) {
            this.vic.ceiling.printLook(this.vic, 4);
        }
    }

    public void perform() throws Refusal {
        try {
            this.vic.scopeLoop(new ScopeMethod(){

                public void scopeMethod(Concept concept) throws Refusal {
                    concept.reactBefore(Action.this);
                }
            });
            if (this.noun != null) {
                this.noun.before(this);
            }
            this.performSingle();
        }
        catch (Rebuff rebuff) {
            rebuff.printMessage(this.vic.io);
        }
    }

    public void perform(boolean bl) throws Refusal {
        this.perform();
        if (bl) {
            throw new Rebuff();
        }
    }

    public void runAfters() throws Refusal {
        this.vic.scopeLoop(new ScopeMethod(){

            public void scopeMethod(Concept concept) throws Refusal {
                concept.reactAfter(Action.this);
            }
        });
        if (this.noun != null) {
            this.noun.after(this);
        }
    }

    public void performSingle() throws Refusal {
    }

    public void qualifyVector(Vector vector, boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            Concept concept = (Concept)vector.elementAt(n2);
            int n3 = this.getRank(concept, bl);
            if (n3 == n) {
                ++n2;
                continue;
            }
            if (n3 < n) {
                vector.removeElementAt(n2);
                continue;
            }
            n = n3;
            while (n2-- > 0) {
                vector.removeElementAt(0);
            }
            n2 = 1;
        }
    }

    public int getRank(Concept concept, boolean bl) {
        return 0;
    }

    public boolean isType(String string) {
        return string.equals(this.type);
    }

    public void setPronoun(Concept concept) {
        Hashtable hashtable = this.vic.getPronouns();
        if (hashtable != null) {
            String string = "it";
            if (concept.has("plural")) {
                string = "them";
            } else if (concept.has("male")) {
                string = "him";
            } else if (concept.has("female")) {
                string = "her";
            }
            hashtable.put(string, concept);
        }
    }

    public void setMeta(int n) {
        this.meta = n;
    }

    public int getMeta() {
        return this.meta;
    }

    public static class CheckRestart
    extends Action {
        public CheckRestart(Vicinity vicinity) {
            super("meta-check-restart", vicinity);
            this.setMeta(3);
        }

        public void performSingle() throws Refusal {
            this.vic.io.println("Do you want to restart the game from the beginning?");
            this.vic.io.print("(yes/no)?");
            this.vic.io.flush();
            String string = this.vic.io.readLine();
            if (string == null) {
                throw new Refusal("[ no input read ]");
            }
            Command command = new Command(string);
            if (!command.parseYesNo()) {
                throw new Refusal();
            }
        }
    }

    public static class Restart
    extends Action {
        public Restart(Vicinity vicinity) {
            super("meta-restart", vicinity);
            this.setMeta(3);
        }

        public void performSingle() throws Refusal {
        }
    }

    public static class Undo
    extends Action {
        public Undo(Vicinity vicinity) {
            super("meta-undo", vicinity);
            this.setMeta(2);
        }

        public void performSingle() throws Refusal {
        }
    }

    public static class Redo
    extends Action {
        public Redo(Vicinity vicinity) {
            super("meta-redo", vicinity);
            this.setMeta(1);
        }

        public void performSingle() throws Refusal {
        }
    }
}

