/*
 * Decompiled with CFR 0.152.
 */
import acm.program.ConsoleProgram;
import acm.util.ErrorException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Adventure
extends ConsoleProgram {
    String currentroom;
    int emotionsexpressed = 0;
    boolean described;
    boolean objectslisted;
    boolean platformUp = false;
    boolean laughed = false;
    boolean cried = false;
    boolean screamed = false;
    boolean danced = false;
    boolean gameover = false;
    boolean actionoccurred;
    boolean successfullyMoved = false;
    boolean bluedooropen = false;
    boolean keyfound = false;
    boolean gameWon = false;
    boolean fishsaved = false;
    boolean fishmurdered = false;
    boolean unlockedbox = false;
    BufferedReader rd;
    AdvObject obj = new AdvObject();
    ArrayList help = new ArrayList();
    AdvMotionTableEntry[] currentMotionTable;
    AdvMotionTableEntry currentMotionEntry = null;
    AdvRoom room = new AdvRoom();
    HashMap verbs = new HashMap();
    HashMap rooms = new HashMap();
    HashMap objects = new HashMap();
    HashMap inventory = new HashMap();
    HashMap synonyms = new HashMap();
    AdvCommand Quit = new QuitCommand();
    AdvCommand Help = new HelpCommand();
    AdvCommand Look = new LookCommand();
    AdvCommand Inventory = new InventoryCommand();
    AdvCommand Take = new TakeCommand();
    AdvCommand Drop = new DropCommand();
    AdvCommand Examine = new ExamineCommand();
    AdvCommand Laugh = new LaughCommand();
    AdvCommand Cry = new CryCommand();
    AdvCommand Jump = new JumpCommand();
    AdvCommand Yell = new YellCommand();
    AdvCommand Dance = new DanceCommand();
    AdvCommand Sleep = new SleepCommand();
    AdvCommand Break = new BreakCommand();
    AdvCommand Unlock = new UnlockCommand();
    AdvCommand Wear = new WearCommand();
    AdvCommand Grin = new GrinCommand();
    AdvCommand Frown = new FrownCommand();
    AdvCommand Smell = new SmellCommand();
    AdvCommand Read = new ReadCommand();
    AdvCommand Sing = new SingCommand();
    AdvCommand Use = new UseCommand();
    AdvCommand Groan = new GroanCommand();
    AdvCommand Clap = new ClapCommand();
    AdvCommand Nod = new NodCommand();
    AdvCommand Shrug = new ShrugCommand();
    AdvCommand Sigh = new SighCommand();
    AdvCommand Cheer = new CheerCommand();
    AdvCommand Blush = new BlushCommand();
    AdvCommand Sit = new SitCommand();
    AdvCommand Open = new OpenCommand();
    AdvCommand Shudder = new ShudderCommand();
    AdvCommand Ponder = new PonderCommand();
    AdvCommand Talk = new TalkCommand();
    AdvCommand Listen = new ListenCommand();
    AdvCommand Hold = new HoldCommand();
    AdvCommand Swim = new SwimCommand();
    AdvCommand Liberate = new LiberateCommand();
    AdvCommand Kill = new KillCommand();
    AdvCommand Cut = new CutCommand();
    String verb;
    String directObject;

    public static void main(String[] args) {
        new Adventure().start(args);
    }

    public void run() {
        this.println("Welcome to Tentellian Island!");
        this.println("-----------------------------------------------");
        this.println("");
        String name = "wood";
        this.prepareGame(name);
        this.playGame();
    }

    private void prepareGame(String name) {
        this.readHelp(name);
        this.readRooms(name);
        this.readObjects(name);
        this.readSynonyms(name);
        this.initializeVerbs();
        this.currentroom = "1";
        this.room = (AdvRoom)this.rooms.get(this.currentroom);
        AdvObject note = this.room.getObject(1);
        this.inventory.put(note.getName(), note);
        this.room.removeObject(note);
        this.currentMotionTable = this.room.getMotionTable();
        this.println(this.room.getName());
    }

    private void readHelp(String name) {
        String filename = "wood-help.txt";
        try {
            String helpstring;
            this.rd = new BufferedReader(new FileReader(filename));
            while ((helpstring = this.rd.readLine()) != null) {
                if (helpstring.length() <= 0) continue;
                this.help.add(helpstring);
            }
            this.rd.close();
        }
        catch (IOException ex) {
            throw new ErrorException((Exception)ex);
        }
    }

    private void readRooms(String name) {
        String filename = "wood-rooms.txt";
        try {
            this.rd = new BufferedReader(new FileReader(filename));
            while (true) {
                this.room = new AdvRoom();
                if (!this.room.readFromFile(this.rd)) break;
                String roomstring = "" + this.room.getRoomNumber();
                this.rooms.put(roomstring, this.room);
            }
            this.rd.close();
        }
        catch (IOException ex) {
            throw new ErrorException((Exception)ex);
        }
    }

    private void readObjects(String name) {
        String filename = "wood-objects.txt";
        try {
            this.rd = new BufferedReader(new FileReader(filename));
            while (true) {
                this.obj = new AdvObject();
                if (!this.obj.readFromFile(this.rd)) break;
                this.objects.put(this.obj.getName(), this.obj);
                this.currentroom = "" + this.obj.getInitialLocation();
                this.room = (AdvRoom)this.rooms.get(this.currentroom);
                this.room.addObject(this.obj);
            }
            this.rd.close();
        }
        catch (IOException ex) {
            throw new ErrorException((Exception)ex);
        }
    }

    private void readSynonyms(String name) {
        String filename = "wood-synonyms.txt";
        try {
            String line;
            this.rd = new BufferedReader(new FileReader(filename));
            while ((line = this.rd.readLine()) != null) {
                int equals = line.indexOf("=");
                String synword = line.substring(0, equals);
                String synverb = line.substring(equals + 1);
                this.synonyms.put(synword, synverb);
            }
            this.rd.close();
        }
        catch (IOException ex) {
            throw new ErrorException((Exception)ex);
        }
    }

    private void initializeVerbs() {
        String quit = "QUIT";
        this.verbs.put(quit, this.Quit);
        String kill = "KILL";
        this.verbs.put(kill, this.Kill);
        String liberate = "LIBERATE";
        this.verbs.put(liberate, this.Liberate);
        String helps = "HELP";
        this.verbs.put(helps, this.Help);
        String look = "LOOK";
        this.verbs.put(look, this.Look);
        String invent = "INVENTORY";
        this.verbs.put(invent, this.Inventory);
        String take = "TAKE";
        this.verbs.put(take, this.Take);
        String drop = "DROP";
        this.verbs.put(drop, this.Drop);
        String BREAK = "BREAK";
        this.verbs.put(BREAK, this.Break);
        String use = "USE";
        this.verbs.put(use, this.Use);
        String cut = "CUT";
        this.verbs.put(cut, this.Cut);
        String examine = "EXAMINE";
        this.verbs.put(examine, this.Examine);
        String laugh = "LAUGH";
        this.verbs.put(laugh, this.Laugh);
        String unlock = "UNLOCK";
        this.verbs.put(unlock, this.Unlock);
        String open = "OPEN";
        this.verbs.put(open, this.Open);
        String cry = "CRY";
        this.verbs.put(cry, this.Cry);
        String jump = "JUMP";
        this.verbs.put(jump, this.Jump);
        String yell = "YELL";
        this.verbs.put(yell, this.Yell);
        String dance = "DANCE";
        this.verbs.put(dance, this.Dance);
        String sleep = "SLEEP";
        this.verbs.put(sleep, this.Sleep);
        String wear = "WEAR";
        this.verbs.put(wear, this.Wear);
        String smell = "SMELL";
        this.verbs.put(smell, this.Smell);
        String read = "READ";
        this.verbs.put(read, this.Read);
        String sing = "SING";
        this.verbs.put(sing, this.Sing);
        String groan = "GROAN";
        this.verbs.put(groan, this.Groan);
        String sigh = "SIGH";
        this.verbs.put(sigh, this.Sigh);
        String cheer = "CHEER";
        this.verbs.put(cheer, this.Cheer);
        String sit = "SIT";
        this.verbs.put(sit, this.Sit);
        String nod = "NOD";
        this.verbs.put(nod, this.Nod);
        String blush = "BLUSH";
        this.verbs.put(blush, this.Blush);
        String clap = "CLAP";
        this.verbs.put(clap, this.Clap);
        String shrug = "SHRUG";
        this.verbs.put(shrug, this.Shrug);
        String shudder = "SHUDDER";
        this.verbs.put(shudder, this.Shudder);
        String ponder = "PONDER";
        this.verbs.put(ponder, this.Ponder);
        String talk = "TALK";
        this.verbs.put(talk, this.Talk);
        String listen = "LISTEN";
        this.verbs.put(listen, this.Listen);
        String hold = "HOLD";
        this.verbs.put(hold, this.Hold);
        String swim = "SWIM";
        this.verbs.put(swim, this.Swim);
    }

    private void playGame() {
        block6: {
            do {
                this.updateRoom();
                this.parseInput();
                this.actionoccurred = false;
                if (this.gameover) break block6;
                this.checkForMotionVerb(this.verb);
                this.checkForActionVerb(this.verb, this.directObject);
                this.checkForFORCED();
                if (this.successfullyMoved) {
                    this.println(this.room.getName());
                    this.successfullyMoved = false;
                    this.checkforLightInCorridor();
                    this.checkForEmotionalContent();
                }
                if (this.actionoccurred) continue;
                this.println("That doesn't make sense.");
            } while (!this.gameWon);
            if (this.fishmurdered) {
                this.badWinnersText();
            } else if (this.fishsaved) {
                this.winnersText();
            } else {
                this.secondaryWinnersText();
            }
        }
    }

    private void updateRoom() {
        if (!this.room.hasBeenVisited()) {
            this.room.setVisited(true);
            if (this.room.getRoomNumber() == 9) {
                this.checkForPendantPower();
            }
            String[] roomdescrip = this.room.getDescription();
            int i = 0;
            while (i < roomdescrip.length) {
                this.println(roomdescrip[i]);
                ++i;
            }
            this.listObjects();
        }
    }

    private void parseInput() {
        String userline = this.readLine();
        int space = userline.indexOf(" ");
        this.verb = this.parseVerb(space, userline).toUpperCase();
        this.directObject = null;
        if (space != -1) {
            this.directObject = this.parseDirectObject(space, userline).trim().toUpperCase();
        }
    }

    private void checkForActionVerb(String verb, String DO) {
        if (!this.actionoccurred && (this.verbs.containsKey(verb) || this.synonyms.containsKey(verb) && this.verbs.containsKey(this.synonyms.get(verb)))) {
            if (this.synonyms.containsKey(verb)) {
                verb = (String)this.synonyms.get(verb);
            }
            this.actionoccurred = true;
            AdvCommand command = (AdvCommand)this.verbs.get(verb);
            AdvObject object = null;
            if (this.objects.containsKey(DO)) {
                object = (AdvObject)this.objects.get(DO);
            }
            command.execute(this, object);
        }
    }

    private void checkForMotionVerb(String verb) {
        if (!this.actionoccurred) {
            if (this.synonyms.containsKey(verb)) {
                verb = (String)this.synonyms.get(verb);
            }
            AdvMotionCommand direction = new AdvMotionCommand(verb);
            boolean found = false;
            int i = 0;
            while (i < this.currentMotionTable.length) {
                if (this.currentMotionTable[i].getDirection().equals(verb)) {
                    found = true;
                }
                ++i;
            }
            if (found) {
                direction.execute(this, null);
                this.actionoccurred = true;
            }
        }
    }

    private void checkForFORCED() {
        while (this.currentMotionTable[0].getDirection().equals("FORCED")) {
            boolean found = false;
            int i = 0;
            while (i < this.currentMotionTable.length) {
                String keyname = this.currentMotionTable[i].getKeyName();
                if (this.unlocked(keyname) && !found) {
                    this.currentroom = "" + this.currentMotionTable[i].getDestinationRoom();
                    found = true;
                }
                if (!this.unlocked(keyname) && !found) {
                    this.currentroom = "" + this.currentMotionTable[i + 1].getDestinationRoom();
                    found = true;
                }
                ++i;
            }
            i = 0;
            while (i < this.room.getDescription().length) {
                this.println(this.room.getDescription()[i]);
                ++i;
            }
            this.successfullyMoved = false;
            this.room = (AdvRoom)this.rooms.get(this.currentroom);
            this.currentMotionTable = this.room.getMotionTable();
            if (!this.currentroom.equals("0")) continue;
            this.gameover = true;
        }
    }

    private String parseVerb(int space, String line) {
        if (space == -1) {
            return line;
        }
        String averb = line.substring(0, space);
        return averb;
    }

    private String parseDirectObject(int space, String line) {
        String DO = line.substring(space).trim();
        return DO;
    }

    private boolean checkForLight() {
        return this.inventory.containsKey("BULB");
    }

    public void checkforLightInCorridor() {
        if (this.room.getRoomNumber() == 10 && this.checkForLight()) {
            int i = 0;
            while (i < this.room.getObjectCount()) {
                AdvObject object = this.room.getObject(i);
                object.setVisible(true);
                this.println("The corridor is slightly illuminated by the glowing bulb, allowing you to take a closer look at things in the nasty corridor.");
                this.println("You can hear the Humming Room to the North.");
                ++i;
            }
        }
    }

    public void checkForEmotionalContent() {
        if (this.inventory.containsKey("EMOTOR")) {
            if (this.room.getRoomNumber() == 6) {
                this.println("A feeling of empty boredom emanates from the pool of water.");
            }
            if (this.room.getRoomNumber() == 14) {
                this.println("You feel very giggly for some reason.");
            }
            if (this.room.getRoomNumber() == 16) {
                this.println("You suddenly feel a surge of anger and rage.");
            }
            if (this.room.getRoomNumber() == 20) {
                this.println("You begin to feel lonely and sad.");
            }
            if (this.room.getRoomNumber() == 21) {
                this.println("You feel jaunty and light on your feet all of a sudden.");
            }
        }
    }

    private void checkForPendantPower() {
        if (this.inventory.containsKey("PENDANT")) {
            this.println("The pendant emits a shrill noise as the humming growns louder, canceling out its overbearing effects and making it possible to pass freely into the Humming Room.");
        }
    }

    public void advanceEmotor(String emotion) {
        int endemo;
        int beginningemo = this.emotionsexpressed++;
        if (emotion.equals("laugh") && !this.laughed) {
            this.laughed = true;
        }
        if (emotion.equals("sad") && !this.cried) {
            this.cried = true;
            ++this.emotionsexpressed;
        }
        if (emotion.equals("anger") && !this.screamed) {
            this.screamed = true;
            ++this.emotionsexpressed;
        }
        if (emotion.equals("dance") && !this.danced) {
            this.danced = true;
            ++this.emotionsexpressed;
        }
        if ((endemo = this.emotionsexpressed) > beginningemo) {
            this.emotorLevelUp(this.emotionsexpressed);
        }
    }

    private void emotorLevelUp(int emo) {
        switch (emo) {
            case 1: {
                this.println("The emotor grows warmer in your hands, and a surface of transparent orange light flickers underneath the box in the middle of the room.");
                break;
            }
            case 2: {
                this.println("The emotor becomes downright hot to the touch, and the orange light over the hole becomes more opaque.");
                break;
            }
            case 3: {
                this.println("It becomes painful to hold the emotor due to its scalding temperature. The orange light looks almost solid and is barely translucent at all.");
                break;
            }
            case 4: {
                this.println("The emotor is burning your hands. What appears to be a smooth orange floor has formed over the hole in the middle of the room.");
                this.println("The emotor's temperature finally cools down, much to your relief.");
                this.platformUp = true;
            }
        }
    }

    public void executeMotionCommand(String direction) {
        direction = direction.toUpperCase();
        boolean found = false;
        int i = 0;
        while (i < this.currentMotionTable.length) {
            if (this.currentMotionTable[i].getDirection().equals(direction)) {
                String keyname = this.currentMotionTable[i].getKeyName();
                if (this.unlocked(keyname) && !found) {
                    this.currentroom = "" + this.currentMotionTable[i].getDestinationRoom();
                    found = true;
                }
                if (!this.unlocked(keyname) && !found) {
                    this.currentroom = "" + this.currentMotionTable[i + 1].getDestinationRoom();
                    found = true;
                }
                this.successfullyMoved = true;
            }
            ++i;
        }
        this.room = (AdvRoom)this.rooms.get(this.currentroom);
        this.currentMotionTable = this.room.getMotionTable();
        this.actionoccurred = true;
    }

    public boolean unlocked(String keyname) {
        if (keyname == null) {
            return true;
        }
        if (this.room.getRoomNumber() == 13 && this.bluedooropen) {
            return true;
        }
        if ((this.room.getRoomNumber() == 15 || this.room.getRoomNumber() == 17 || this.room.getRoomNumber() == 19) && this.platformUp) {
            return true;
        }
        return this.inventory.containsKey(keyname);
    }

    public void executeQuitCommand() {
        block1: {
            String line;
            do {
                if (!(line = this.readLine("Do you REALLY want to quit? ").toUpperCase()).equals("YES") && !line.equals("Y")) continue;
                this.gameover = true;
                this.println("Thanks for playing!");
                break block1;
            } while (!line.equals("NO") && !line.equals("N"));
            this.println("Yay!");
        }
    }

    public void executeHelpCommand() {
        int i = 0;
        while (i < this.help.size()) {
            this.println(this.help.get(i));
            ++i;
        }
    }

    public void executeLookCommand() {
        this.println(this.room.getName());
        String[] roomdescript = this.room.getDescription();
        this.described = false;
        this.objectslisted = false;
        this.checkForBulbLightingCorridor();
        this.checkForDeadBulbsInBlue();
        if (!this.described) {
            int i = 0;
            while (i < roomdescript.length) {
                this.println(roomdescript[i]);
                ++i;
            }
            if ((this.room.getRoomNumber() == 15 || this.room.getRoomNumber() == 17 || this.room.getRoomNumber() == 19) && this.platformUp) {
                this.println("The center of the room, formerly a hole, is covered by a smooth orange surface. It looks like it would be safe to walk on.");
            }
        }
        if (!this.objectslisted) {
            this.listObjects();
        }
    }

    private void listObjects() {
        int i = 0;
        while (i < this.room.getObjectCount()) {
            if (this.room.getObject(i).isVisible()) {
                String objectsname = this.room.getObject(i).getName().toLowerCase();
                if (objectsname.charAt(objectsname.length() - 1) == 's') {
                    this.println("Some " + objectsname + " are here.");
                } else {
                    this.println("A " + objectsname + " is here.");
                }
            }
            ++i;
        }
    }

    private void checkForDeadBulbsInBlue() {
        if (this.room.getRoomNumber() == 13 && this.bluedooropen) {
            this.described = true;
            this.println("Bulbous blue growths still cover most surfaces around the edges of the room, but they have shriveled away in the area around the door.");
            this.println("You can now pass through the doorway to the South with ease.");
        }
    }

    private void checkForBulbLightingCorridor() {
        if (this.room.getRoomNumber() == 10) {
            this.objectslisted = true;
            if (this.checkForLight()) {
                int i = 0;
                while (i < this.room.getObjectCount()) {
                    AdvObject object = this.room.getObject(i);
                    object.setVisible(true);
                    ++i;
                }
                this.described = true;
                this.println("In the dim blue light of the bulb, you can make out the moss-covered walls, with yellow-green fluid seeping down in places.");
                this.println("You can now see things lying on the rocky floor along with the general rubble.");
                this.listObjects();
            }
        }
    }

    public void executeInventoryCommand() {
        if (this.inventory.size() == 0) {
            this.println("You aren't carrying one single thing.");
        }
        if (this.inventory.size() == 1) {
            this.println("You are carrying 1 item: ");
        }
        if (this.inventory.size() > 1) {
            this.println("You are carrying " + this.inventory.size() + " items: ");
        }
        Iterator i = this.inventory.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.println(key.toLowerCase());
        }
    }

    public void executeTakeCommand(AdvObject obj) {
        if (obj != null) {
            if (this.room.getRoomNumber() == 18 && obj.getName().equals("BOX")) {
                this.println("The box itself won't move from its mid-air position. You came here for the contents of the box.");
            } else if (this.room.getRoomNumber() == 6 && obj.getName().equals("FISH")) {
                if (!obj.canMove()) {
                    this.println("The fish dart away from your hands with surprising agility when you try to grab them.");
                } else {
                    this.println("The fish allow to pick them up out of the water.");
                    this.inventory.put(obj.getName(), obj);
                    this.room.removeObject(obj);
                    this.println("Taken.");
                }
            } else if (obj.canMove()) {
                if (this.room.containsObject(obj)) {
                    this.inventory.put(obj.getName(), obj);
                    this.room.removeObject(obj);
                    this.println("Taken.");
                    if (obj.getName().equals("KEY")) {
                        this.keyfound = true;
                    }
                } else {
                    this.println("There's no " + obj.getName().toLowerCase() + " in the room.");
                }
            } else {
                this.println("You can't take the " + obj.getName().toLowerCase() + ".");
            }
        } else {
            this.println("You can't take that!");
        }
    }

    public void executeDropCommand(AdvObject obj) {
        if (obj != null) {
            if (obj.getName().equals("FISH") && this.inventory.containsKey("FISH")) {
                if (this.room.getRoomNumber() == 1) {
                    this.fishReleaseOcean();
                    this.inventory.remove(obj.getName());
                } else if (this.room.getRoomNumber() >= 115 && this.room.getRoomNumber() <= 117) {
                    this.println("You release the fish into the yellow lake. They squirm spastically for a few seconds and then float still in the water.");
                    this.murderFish();
                    this.inventory.remove(obj.getName());
                } else {
                    this.println("You should probably drop them in a body of water somewhere if you want them to survive.");
                }
            } else if (this.hasObject(obj)) {
                this.inventory.remove(obj.getName());
                this.room.addObject(obj);
                this.println("Dropped.");
            } else if (obj != null) {
                this.println("You don't have any " + obj.getName().toLowerCase() + " to drop!");
            }
        } else {
            this.println("You can't drop that.");
        }
    }

    public void executeLiberateCommand(AdvObject obj) {
        if (obj != null) {
            if (obj.getName().equals("FISH") && this.inventory.containsKey("FISH")) {
                if (this.room.getRoomNumber() == 1) {
                    this.fishReleaseOcean();
                    this.inventory.remove(obj.getName());
                } else if (this.room.getRoomNumber() >= 115 && this.room.getRoomNumber() <= 117) {
                    this.println("You release the fish into the yellow lake. They squirm spastically for a few seconds and then float still in the water.");
                    this.murderFish();
                    this.inventory.remove(obj.getName());
                } else {
                    this.println("You should probably drop them in a body of water somewhere if you want them to survive.");
                }
            } else {
                this.println("It makes no sense to try to liberate the " + obj.getName().toLowerCase() + ".");
            }
        } else {
            this.println("That doesn't even make sense.");
        }
    }

    public void fishReleaseOcean() {
        this.println("You crouch down and release the fish into the ocean. They float still at first, and you wonder if it was too late. To your delight, they soon begin to show some signs of life and after a moment go swimming off into the ocean.");
        if (this.inventory.containsKey("EMOTOR")) {
            this.println("The emotor surges with warmth and you are filled with a feeling of gratefulness.");
            this.println("");
            this.fishVision();
        }
        this.fishsaved = true;
    }

    public void fishVision() {
        this.println("There is a flash of orange light and you are struck with a vision. You are looking at yourself from the perspective of the Professor, whose thoughts you can read. You quickly recognize the scene as the last time you met before leaving. Although you feel the Professor smiling and wishing you a safe journey, in your mind you feel a cold satisfaction.");
        this.println("");
        this.println("You feel the Professor's conviction that you cannot spread stories about your adventures on this island.");
        this.println("You now know with frightening certainty that the Professor plans to murder you upon your return.");
        this.println("But what can be done...");
    }

    public void murderFish() {
        this.println("You have murdered the fish.");
        if (this.inventory.containsKey("EMOTOR")) {
            this.println("The emotor grows warm and surges with a mix of agony and hatred.");
            this.println("");
            this.fishVision();
        }
        this.fishmurdered = true;
    }

    public void executeExamineCommand(AdvObject obj) {
        if (obj != null) {
            if ((obj.getName().equals("POOL") || obj.getName().equals("FISH")) && this.room.getRoomNumber() == 6 && this.inventory.containsKey("EMOTOR") && !this.inventory.containsKey("FISH")) {
                this.println("You gaze into the pool and see some small fish swimming slowly in circles.");
                this.println("The emotor grows warm and you develop an emotional bond with the fish. You begin to feel hot, exhausted, and bored, just as they do.");
                this.println("More than anything, though, the fish long to return to the ocean.");
                int i = 0;
                while (i < this.room.getObjectCount()) {
                    obj = this.room.getObject(i);
                    if (obj.getName().equals("FISH")) {
                        obj.setMoveable(true);
                    }
                    ++i;
                }
            } else if (this.room.getRoomNumber() > 0 && this.room.getRoomNumber() < 5 && obj.getName().equals("DOCK")) {
                this.println("The dock is rickety and covered in a wet, gray moss.");
            } else if (this.inventory.containsKey(obj.getName()) || this.room.containsObject(obj)) {
                this.println(obj.getDescription());
            } else {
                this.println("I don't see any " + obj.getName().toLowerCase() + " here.");
            }
        } else if (this.room.getRoomNumber() == 10) {
            this.executeLookCommand();
        } else {
            this.println("You can't examine any such thing.");
        }
        this.searchForKey(obj);
    }

    public void searchForKey(AdvObject obj) {
        if (obj != null && this.room.getRoomNumber() == 7 && obj.getName().equals("PLANTS") && !this.keyfound) {
            int i = 0;
            while (i < this.room.getObjectCount()) {
                AdvObject objecto = this.room.getObject(i);
                objecto.setVisible(true);
                objecto.setMoveable(true);
                ++i;
            }
            this.keyfound = true;
            obj.setMoveable(false);
            obj.setVisible(false);
            this.println("You spot something shiny among the plants. It appears to be a key.");
        }
    }

    public void executeBreakCommand(AdvObject obj) {
        if (obj != null) {
            if (this.hasObject(obj)) {
                if (obj.getName().equals("CRYSTAL")) {
                    this.println("You hurl the crystal to the ground with all your might.");
                    this.println("It shatters into countless pieces and the swirling gas escapes.");
                    this.inventory.remove("CRYSTAL");
                    if (this.room.getRoomNumber() == 13) {
                        this.println("The blue bulbs around the smashed crystal begin to shrivel away.");
                        this.println("The gas spreads, killing off a number of the bulbs that had been growing over the doorway.");
                        this.bluedooropen = true;
                    } else {
                        this.println("The gas quickly dissipates and is gone.");
                    }
                } else {
                    this.println("You can't break the " + obj.getName().toLowerCase() + ".");
                }
            } else if (obj.getName().equals("BOX") && this.room.getRoomNumber() == 18) {
                this.println("Sheer force won't work on the box. Despite its weathered appearance, it is quite sturdy.");
            } else {
                this.println("You don't have any " + obj.getName().toLowerCase() + " to break!");
            }
        } else {
            this.println("You can't break that.");
        }
    }

    public void executeLaughCommand() {
        if (this.inventory.containsKey("EMOTOR") && this.room.getRoomNumber() == 14) {
            this.println("You giggle a little to yourself before bursting out in laughter so intense that you begin to cry.");
            this.advanceEmotor("laugh");
        } else {
            this.println("You laugh heartily, slapping your thigh a few times.");
        }
    }

    public void executeCryCommand() {
        if (this.inventory.containsKey("EMOTOR") && this.room.getRoomNumber() == 20) {
            this.println("You sniff a few times as the tears begin to well up. Soon they are streaming down your face uncontrollably.");
            this.advanceEmotor("sad");
        } else {
            this.println("You hold your head in your hands and let a few tears roll down your cheeks.");
        }
    }

    public void executeYellCommand() {
        if (this.inventory.containsKey("EMOTOR") && this.room.getRoomNumber() == 16) {
            this.println("You surpise yourself with the level of rage and anger that accompanies your loud scream.");
            this.advanceEmotor("anger");
        } else {
            this.println("You let out your frustration with a primal yell.");
        }
    }

    public void executeDanceCommand() {
        if (this.inventory.containsKey("EMOTOR") && this.room.getRoomNumber() == 21) {
            this.println("You begin to bob to an imaginary beat and in no time find yourself pulling all kinds of moves that you didn't even know you were capable of.");
            this.advanceEmotor("dance");
        } else {
            this.println("You snap your fingers and bend your knees to the tune of your favorite song.");
        }
    }

    public void executeOpenCommand(AdvObject obj) {
        if (obj != null) {
            if (this.room.getRoomNumber() == 18 && obj.getName().equals("BOX")) {
                if (!this.unlockedbox) {
                    this.println("The box is locked. You'll need to unlock it with a key of some sort.");
                } else {
                    this.println("The box popped open by itself after you unlocked it.");
                }
            } else {
                this.println("It's no use trying to unlock the " + obj.getName().toLowerCase() + ".");
            }
        } else {
            this.println("You can't very well unlock that.");
        }
    }

    public void executeListenCommand() {
        int rnum = this.room.getRoomNumber();
        if (rnum == 1) {
            this.println("You hear only the water lapping against the dock.");
        } else if (rnum == 8) {
            this.println("You hear humming coming from within the structure. The more you listen to it, the more unbearable it becomes.");
        } else if (rnum == 9) {
            this.println("You hear a gentle hum. It is a little disconcerting, and you soon become uncomfortable standing here and listening to it.");
        } else if (rnum == 10) {
            this.println("Besides the perpetual noise of the nearby Humming Room, you hear a periodic dripping noise in the corridor.");
        } else if (rnum == 11) {
            this.println("You hear a drip of water somewhere in the corridor every now and then, along with the distant humming.");
        } else if (rnum > 13 && rnum < 22) {
            this.println("The silence in this open room is a notable change from the constant humming audible throughout the rest of the structure.");
        } else {
            this.println("You don't hear anything unusual.");
        }
    }

    public void executeUseCommand(AdvObject obj) {
        if (this.hasObject(obj)) {
            if (obj.getName().equals("EMOTOR")) {
                this.println("You don't need to \"use\" the emotor. It is a complex device and will work automatically when the time comes.");
            } else if (obj.getName().equals("GEM-HAT")) {
                this.println("You can use the gem-hat by wearing it.");
            } else if (obj.getName().equals("KEY")) {
                this.println("Be more specific. Are you trying to unlock something?");
            } else if (obj.getName().equals("CRYSTAL")) {
                this.println("But what exactly do you want to DO with the crystal?");
            } else {
                this.println("There's no obvious way to use the " + obj.getName().toLowerCase() + ".");
            }
        } else {
            this.println("Can't use that.");
        }
    }

    public void executeReadCommand(AdvObject obj) {
        if (this.hasObject(obj)) {
            if (obj.getName().equals("NOTE")) {
                this.println(obj.getDescription());
            } else {
                this.println("You can't read the " + obj.getName().toUpperCase() + ".");
            }
        } else {
            this.println("There's no way you're reading that.");
        }
    }

    public void executeSingCommand() {
        if (this.inventory.containsKey("EMOTOR") && this.room.getRoomNumber() == 21) {
            this.println("You belt out your favorite tune with surprising skill. You even hit the high notes!");
            this.advanceEmotor("dance");
        } else {
            this.println("You sing a little tune under your breath to pass the time.");
        }
    }

    public void executeSmellCommand(AdvObject obj) {
        if (obj != null) {
            if (this.room.containsObject(obj)) {
                if (obj.getName().equals("PLANTS")) {
                    this.println("Predictably, the plants reek of fish and other decomposing biomaterial.");
                } else if (obj.getName().equals("WATER")) {
                    this.println("It smells salty and fresh, but a bit fishy.");
                } else if (obj.getName().equals("BOX")) {
                    this.println("The box smells like aged wood.");
                } else {
                    this.println("There is no particularly strong scent to the " + obj.getName().toLowerCase() + ".");
                }
            } else if (this.inventory.containsKey(obj.getName())) {
                if (obj.getName().equals("PENDANT")) {
                    this.println("The pendant smells metallic with a hint of musk from the rotting fabric.");
                } else if (obj.getName().equals("NOTE")) {
                    this.println("It smells like the Professor.");
                } else if (obj.getName().equals("KEY")) {
                    this.println("It smells metallic, with a fishy hint of the plants it was hidden in.");
                } else if (obj.getName().equals("BULB")) {
                    this.println("The bulb smells most like body odor.");
                } else {
                    this.println("There is no particularly strong scent to the " + obj.getName().toLowerCase() + ".");
                }
            } else {
                this.println("It's unclear what you're trying to smell.");
            }
        } else {
            this.println("It's unclear what you're trying to smell.");
        }
    }

    public void executeWearCommand(AdvObject obj) {
        if (this.hasObject(obj)) {
            if (obj.getName().equals("PENDANT") && this.inventory.containsKey("PENDANT")) {
                this.println("The tattered cloth holding the pendant together would probably fall apart if you were to try it on.");
            } else if (obj.getName().equals("GEM-HAT") && this.inventory.containsKey("GEM-HAT")) {
                this.println("Taking a deep breath, you bow your head and put on the gem-hat...");
                this.gameWon = true;
            } else {
                this.println("There's no way you can wear the " + obj.getName().toLowerCase() + ".");
            }
        } else {
            this.println("You can't wear that.");
        }
    }

    public void executeHoldCommand(AdvObject obj) {
        if (this.hasObject(obj)) {
            this.println("You hold the " + obj.getName().toLowerCase() + " in your hand.");
        } else if (obj != null) {
            this.println("You can't hold the " + obj.getName().toUpperCase() + ".");
        } else {
            this.println("It's impossible to hold that.");
        }
    }

    public void executeKillCommand(AdvObject obj) {
        if (this.inventory.containsKey("KNIFE")) {
            if (obj.getName().equals("FISH") && this.inventory.containsKey("FISH")) {
                this.println("You cut up the fish with your knife, covering yourself and the knife with blood in the process.");
                this.murderFish();
                this.inventory.remove("FISH");
            } else if (obj != null) {
                this.println("It's no use trying to use the knife against the " + obj.getName() + ".");
            } else {
                this.println("You can't use the knife against that.");
            }
        } else {
            this.println("You have no means of doing that.");
        }
    }

    public void executeSleepCommand() {
        this.println("You take a short nap and wake up completely refreshed.");
    }

    public void executeGrinCommand() {
        this.println("You beam proudly at your accomplishments.");
    }

    public void executeFrownCommand() {
        this.println("You furrown your brow and frown, full of frustration.");
    }

    public void executeGroanCommand() {
        this.println("You groan loudly and roll your eyes.");
    }

    public void executeCheerCommand() {
        this.println("You throw a fist in the air and yell with all the enthusiasm you can muster.");
    }

    public void executeShrugCommand() {
        this.println("You shrug nonchalantly. No big deal.");
    }

    public void executeSitCommand() {
        this.println("You take a seat. It feels good to give your legs some rest for a moment.");
    }

    public void executeClapCommand() {
        this.println("You clap your hands excitedly.");
    }

    public void executeNodCommand() {
        this.println("You nod emphatically.");
    }

    public void executeSighCommand() {
        this.println("You take a deep breath and let out a long sigh.");
    }

    public void executeBlushCommand() {
        this.println("You blush bright red. How embarassing!");
    }

    public void executeJumpCommand() {
        this.println("You bend your knees, then leap skywards with all your might.");
    }

    public void executeShudderCommand() {
        this.println("You experience a full-body shudder of fear.");
    }

    public void executePonderCommand() {
        this.println("You ponder your current situation but don't come to any sure conclusions.");
    }

    public void executeTalkCommand() {
        this.println("You start talking to yourself under your breath.");
    }

    public void executeUnlockCommand(AdvObject obj) {
        if (obj != null) {
            if (this.room.getRoomNumber() == 18 && obj.getName().equals("BOX")) {
                if (this.inventory.containsKey("KEY")) {
                    int i = 0;
                    while (i < this.room.getObjectCount()) {
                        AdvObject objecto = this.room.getObject(i);
                        objecto.setVisible(true);
                        objecto.setMoveable(true);
                        ++i;
                    }
                    this.println("You heave the key into the keyhole and rotate it ninety degress. With a satisfying snap, the box unlocks and pops open.");
                    this.println("Inside is what you came here for, what you were hoping to proudly bring back to the Professor... a gem-hat.");
                    obj.setMoveable(false);
                    this.unlockedbox = true;
                } else {
                    this.println("You don't have a key for the box.");
                }
            } else {
                this.println("It doesn't make any sense to try to unlock the " + obj.getName().toLowerCase() + ".");
            }
        } else {
            this.println("Don't even think about trying to unlock that.");
        }
    }

    private boolean hasObject(AdvObject obj) {
        return obj != null && this.inventory.containsKey(obj.getName());
    }

    private void winnersText() {
        this.println("");
        this.println("...");
        this.println("");
        this.println("When you open your eyes, you find yourself on a crowded sidewalk, bustling with pedestrians.");
        this.println("You leap to the side just in time to avoid a speeding biker who nearly runs you down.");
        this.println("");
        this.println("If the Professor wants to keep this hat a secret, you can keep it a secret alright. Neither the Professor nor anyone else need ever find out about your sucessful mission, you think to yourself smugly.");
        this.println("With a grin, you fit the gem-hat snugly atop your head and disappear again...");
        this.println("");
        this.println("Congratulations! You have completed this quest.");
        this.println("Look for more text adventures by Zack Wood, coming soon thanks to CS106A, Eric Roberts, and Kimber Lockhart.");
    }

    private void secondaryWinnersText() {
        this.println("");
        this.println("...");
        this.println("");
        this.println("When you open your eyes, you find yourself in the Professor's office.");
        this.println("As you gather your senses and open your mouth to announce your arrival, the door opens.");
        this.println("The Professor enters and greets you warmly, eyes flicking to the illustrious gem-hat seated atop your head.");
        this.println("\"Ah, I see you were successful! Let me have a look at that while you tell me all about what happened.\" The Professor's hand beckons eagerly for the gem-hat.");
        this.println("");
        if (this.inventory.containsKey("EMOTOR")) {
            this.println("The emotor feels warm against your body and, strangely enough, you sense malicious intent seething beneath the Professor's grinning face.");
            this.println("You take a step back, clutching the gem-hat to your chest with white knuckles.");
            this.println("\"Come on now, I want to hear all about your trip. Just hand over the gem-hat...\" The Professor notices your hesitancy and a strange look creeps over her face.");
            this.println("");
            this.println("Suddenly, the Professor's hand darts behind her back, reaching for something. Not wanting to find out what it is, you throw on the gem-hat.");
            this.println("A loud bang echoes throughout the office, but the Professor was too late; the the only thing remaining where you were standing just moments earlier is a gun-shot blast in her Mahogany paneling.");
        } else {
            this.println("After handing over the gem-hat with a great sense of accomplishment, you accept a cup of tea and breathlessly recount your travels and the discovery of the gem-hat.");
            this.println("Your eyes grow tired as you near the end of your tale, and you realize how long it's been since you last slept.");
            this.println("");
            this.println("The last thing you remember before nodding off is the Professor's voice, saying \"I'm sorry, but I can't let anyone else find out about this.\"");
            this.println("You never wake up.");
        }
        this.println("");
        this.println("Congratulations! You have completed the Quest for the Gem-Hat! Sadly, you did not survive this time.");
        this.println("Look for more text adventures by Zack Wood, coming soon thanks to CS106A, Eric Roberts, and Kimber Lockhart.");
    }

    private void badWinnersText() {
        this.println("");
        this.println("...");
        this.println("");
        this.println("When you open your eyes, you find yourself in the Professor's office.");
        this.println("As you gather your senses and open your mouth to announce your arrival, the door opens.");
        this.println("The Professor walks in with a grin at first, but it turns to a look of shock and terror upon noticing the bloody knife you clutch.");
        this.println("");
        this.println("Before the Professor can speak, you disseaper with the aid of the gem-hat and reapper on the other side of the room, grabbing the Professor from behind.");
        this.println("You reach around with the knife and strike swiftly three times. The limp body falls to the ground in front of you and a grin involuntarily creeps across your face.");
        this.println("");
        this.println("The Professor hoped to use you, to take advantage of you... But you proved that you are no pawn.");
        this.println("You press the gem-hat atop your head and disseaper from the office as blood continues to seep from beneath the Professor's corpse onto the lush carpet.");
        this.println("");
        this.println("Congratulations! You have completed this quest.");
        this.println("Look for more text adventures by Zack Wood, coming soon thanks to CS106A, Eric Roberts, and Kimber Lockhart.");
    }
}

