/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.io.IOConsole;
import acm.program.MacCheckboxMenuItem;
import acm.program.MacMenuItem;
import acm.program.Program;
import acm.program.ProgramMenuListener;
import acm.util.Platform;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ProgramMenuBar
extends JMenuBar {
    private Program myProgram;
    private ProgramMenuListener listener;
    private IOConsole activeConsole;

    public ProgramMenuBar(Program program) {
        this.myProgram = program;
        this.listener = new ProgramMenuListener(program);
        this.init();
    }

    public void setConsole(IOConsole console) {
        this.activeConsole = console;
    }

    public IOConsole getConsole() {
        return this.activeConsole;
    }

    public void update() {
        int nMenus = this.getMenuCount();
        int i = 0;
        while (i < nMenus) {
            this.updateMenuItem(this.getMenu(i));
            ++i;
        }
    }

    protected void init() {
        this.add(this.createFileMenu());
        this.add(this.createEditMenu());
    }

    protected JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        this.addSaveItems(menu);
        menu.addSeparator();
        this.addPrintItems(menu);
        menu.addSeparator();
        this.addQuitItem(menu);
        return menu;
    }

    protected JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic(69);
        this.addEditItems(menu);
        return menu;
    }

    protected void addQuitItem(JMenu menu) {
        if (Platform.isMac()) {
            JMenuItem item = this.createMenuItem("Quit", 81, 0);
            item.setEnabled(true);
            menu.add(item);
        } else {
            JMenuItem item = this.createMenuItem("Exit", 0, 88);
            item.setActionCommand("Quit");
            item.setEnabled(true);
            menu.add(item);
        }
    }

    protected void addEditItems(JMenu menu) {
        if (Platform.isMac()) {
            menu.add(this.createMenuItem("Cut", 88, 0));
            menu.add(this.createMenuItem("Copy", 67, 0));
            menu.add(this.createMenuItem("Paste", 86, 0));
            menu.add(this.createMenuItem("Select All", 65, 0));
        } else {
            JMenuItem item = this.createMenuItem("Cut (x)", 88, 0);
            item.setActionCommand("Cut");
            menu.add(item);
            item = this.createMenuItem("Copy (c)", 67, 0);
            item.setActionCommand("Copy");
            menu.add(item);
            item = this.createMenuItem("Paste (v)", 86, 0);
            item.setActionCommand("Paste");
            menu.add(item);
            menu.add(this.createMenuItem("Select All", 65, 0));
        }
    }

    protected void addSaveItems(JMenu menu) {
        menu.add(this.createMenuItem("Save", 83, 0));
        menu.add(this.createMenuItem("Save As...", 0, 0));
    }

    protected void addPrintItems(JMenu menu) {
        menu.add(this.createMenuItem("Print", 80, 0));
        menu.add(this.createMenuItem("Print Console", 0, 0));
        menu.add(this.createMenuItem("Script...", 0, 0));
    }

    protected MenuBar createMacMenuBar() {
        MenuBar mbar = new MenuBar();
        int nMenus = this.getMenuCount();
        int i = 0;
        while (i < nMenus) {
            mbar.add(this.createMacMenu(this.getMenu(i)));
            ++i;
        }
        return mbar;
    }

    protected JMenuItem createMenuItem(String text, int accelerator, int mnemonic) {
        JMenuItem item = mnemonic == 0 ? new JMenuItem(text) : new JMenuItem(text, mnemonic);
        item.addActionListener(this.listener);
        if (accelerator != 0) {
            item.setAccelerator(KeyStroke.getKeyStroke((int)((char)accelerator), 2));
        }
        item.setEnabled(false);
        if (text.endsWith("...")) {
            item.setActionCommand(text.substring(0, text.length() - 3));
        }
        return item;
    }

    private Menu createMacMenu(JMenu jmenu) {
        Menu menu = new Menu(jmenu.getText());
        int nItems = jmenu.getItemCount();
        int i = 0;
        while (i < nItems) {
            menu.add(this.createMacMenuItem(jmenu.getItem(i)));
            ++i;
        }
        return menu;
    }

    private MenuItem createMacMenuItem(JMenuItem jitem) {
        if (jitem == null) {
            return new MenuItem("-");
        }
        if (jitem instanceof JMenu) {
            return this.createMacMenu((JMenu)jitem);
        }
        if (jitem instanceof JCheckBoxMenuItem) {
            return new MacCheckboxMenuItem((JCheckBoxMenuItem)jitem);
        }
        return new MacMenuItem(jitem);
    }

    private void addProgramMenuItems(Menu programMenu, JMenuItem jitem) {
        if (jitem == null) {
            programMenu.addSeparator();
        } else if (jitem instanceof JMenu) {
            JMenu jmenu = (JMenu)jitem;
            int nItems = jmenu.getItemCount();
            int i = 0;
            while (i < nItems) {
                this.addProgramMenuItems(programMenu, jmenu.getItem(i));
                ++i;
            }
        } else if (jitem instanceof JCheckBoxMenuItem) {
            programMenu.add(new MacCheckboxMenuItem((JCheckBoxMenuItem)jitem));
        } else if (!jitem.getActionCommand().equals("Quit")) {
            programMenu.add(new MacMenuItem(jitem));
        }
    }

    protected void updateMenuItem(JMenuItem item) {
        if (item instanceof JMenu) {
            JMenu menu = (JMenu)item;
            int nItems = menu.getItemCount();
            int i = 0;
            while (i < nItems) {
                JMenuItem subItem = menu.getItem(i);
                if (subItem != null) {
                    this.updateMenuItem(subItem);
                }
                ++i;
            }
        } else {
            this.myProgram.updateMenuItem(item);
        }
    }
}

