/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.EmptyContainer;
import acm.util.ErrorException;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.util.HashMap;

public class JTFTools {
    private static HashMap appletTable = new HashMap();
    private static Applet mostRecentApplet = null;

    public static Container createEmptyContainer() {
        return new EmptyContainer();
    }

    public static Frame getEnclosingFrame(Component comp) {
        while (comp != null && !(comp instanceof Frame)) {
            comp = comp.getParent();
        }
        return (Frame)comp;
    }

    public static Font decodeFont(String str) {
        return JTFTools.decodeFont(str, null);
    }

    public static Font decodeFont(String str, Font oldFont) {
        String fontName = str;
        int fontStyle = 0;
        int fontSize = 12;
        int hyphen = str.indexOf(45);
        if (hyphen >= 0) {
            fontName = str.substring(0, hyphen);
            if ((hyphen = (str = str.substring(hyphen + 1)).indexOf(45)) >= 0) {
                String token = str.substring(0, hyphen).toLowerCase();
                if (token.equals("*") && oldFont != null) {
                    fontStyle = oldFont.getStyle();
                } else if (token.equals("plain")) {
                    fontStyle = 0;
                } else if (token.equals("bold")) {
                    fontStyle = 1;
                } else if (token.equals("italic")) {
                    fontStyle = 2;
                } else if (token.equals("bolditalic")) {
                    fontStyle = 3;
                } else {
                    throw new ErrorException("Illegal font style");
                }
                str = str.substring(hyphen + 1);
            }
            if (str.equals("*") && oldFont != null) {
                fontSize = oldFont.getSize();
            } else {
                try {
                    fontSize = Integer.valueOf(str);
                }
                catch (NumberFormatException ex) {
                    throw new ErrorException("Illegal font size");
                }
            }
        }
        if (fontName.equals("*")) {
            fontName = oldFont == null ? "Default" : oldFont.getName();
        }
        return new Font(fontName, fontStyle, fontSize);
    }

    public static Color decodeColor(String name) {
        if (name.equalsIgnoreCase("desktop")) {
            return SystemColor.desktop;
        }
        if (name.equalsIgnoreCase("activeCaption")) {
            return SystemColor.activeCaption;
        }
        if (name.equalsIgnoreCase("activeCaptionText")) {
            return SystemColor.activeCaptionText;
        }
        if (name.equalsIgnoreCase("activeCaptionBorder")) {
            return SystemColor.activeCaptionBorder;
        }
        if (name.equalsIgnoreCase("inactiveCaption")) {
            return SystemColor.inactiveCaption;
        }
        if (name.equalsIgnoreCase("inactiveCaptionText")) {
            return SystemColor.inactiveCaptionText;
        }
        if (name.equalsIgnoreCase("inactiveCaptionBorder")) {
            return SystemColor.inactiveCaptionBorder;
        }
        if (name.equalsIgnoreCase("window")) {
            return SystemColor.window;
        }
        if (name.equalsIgnoreCase("windowBorder")) {
            return SystemColor.windowBorder;
        }
        if (name.equalsIgnoreCase("windowText")) {
            return SystemColor.windowText;
        }
        if (name.equalsIgnoreCase("menu")) {
            return SystemColor.menu;
        }
        if (name.equalsIgnoreCase("menuText")) {
            return SystemColor.menuText;
        }
        if (name.equalsIgnoreCase("text")) {
            return SystemColor.text;
        }
        if (name.equalsIgnoreCase("textText")) {
            return SystemColor.textText;
        }
        if (name.equalsIgnoreCase("textHighlight")) {
            return SystemColor.textHighlight;
        }
        if (name.equalsIgnoreCase("textHighlightText")) {
            return SystemColor.textHighlightText;
        }
        if (name.equalsIgnoreCase("textInactiveText")) {
            return SystemColor.textInactiveText;
        }
        if (name.equalsIgnoreCase("control")) {
            return SystemColor.control;
        }
        if (name.equalsIgnoreCase("controlText")) {
            return SystemColor.controlText;
        }
        if (name.equalsIgnoreCase("controlHighlight")) {
            return SystemColor.controlHighlight;
        }
        if (name.equalsIgnoreCase("controlLtHighlight")) {
            return SystemColor.controlLtHighlight;
        }
        if (name.equalsIgnoreCase("controlShadow")) {
            return SystemColor.controlShadow;
        }
        if (name.equalsIgnoreCase("controlDkShadow")) {
            return SystemColor.controlDkShadow;
        }
        if (name.equalsIgnoreCase("scrollbar")) {
            return SystemColor.scrollbar;
        }
        if (name.equalsIgnoreCase("info")) {
            return SystemColor.info;
        }
        if (name.equalsIgnoreCase("infoText")) {
            return SystemColor.infoText;
        }
        if (name.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (name.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (name.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (name.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (name.equalsIgnoreCase("DARK_GRAY")) {
            return Color.darkGray;
        }
        if (name.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (name.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (name.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (name.equalsIgnoreCase("LIGHT_GRAY")) {
            return Color.lightGray;
        }
        if (name.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (name.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (name.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (name.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (name.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (name.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        try {
            return Color.decode(name);
        }
        catch (NumberFormatException ex) {
            throw new ErrorException("Illegal color value");
        }
    }

    public static void registerApplet(Applet applet) {
        JTFTools.registerApplet(applet, Thread.currentThread());
        mostRecentApplet = applet;
    }

    public static void registerApplet(Applet applet, Thread thread) {
        appletTable.put(thread, applet);
    }

    public static Applet getApplet() {
        Applet applet = (Applet)appletTable.get(Thread.currentThread());
        if (applet == null) {
            applet = mostRecentApplet;
        }
        return applet;
    }

    public static void pause(double milliseconds) {
        try {
            int millis = (int)milliseconds;
            int nanos = (int)Math.round((milliseconds - (double)millis) * 1000000.0);
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

