package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2007  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/

 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
;

public class Website implements Printable, Commandline
{
    private StoryController controller;
    private m2a program;  
    private String question="";
    private Receiver receiver;
    private boolean audio;

    public Website(m2a p, boolean audio)
    {
        this.program = p; 
        this.audio = audio;
    }
    
    public void setStory(StoryController s)
    {
        controller = s;
    }
    
    public void print(String t)
    {
        if (t.endsWith("-")) {
            this.question += " "+t.replaceAll("-$","");
        } else {
            this.question += "<br>"+t;
        }
        this.program.output = this.question;
    }
    
    public void input(Receiver r)
    {
        
        if (this.audio) toolbox.speak(this.question.replaceAll("<br>",""));
        this.question="";
        this.receiver = r;
       
    }
    
    public void answer(String a)
    {
         
        if (a.equals("#exit"))
        {
            this.controller.stopStory();
        }
        
        if (a.equals("#save")) a="";
        if (a.equals("#mem")) a="";
        
        this.receiver.receive(a,true);
    }
    
    
}
