module AR
  module Game

    class Guard < Npc
      def initialize id=nil
        super 
        self.noun = "guard"
        self.ownership = "his"
        self.root_dialog_node = IntroNode.new self
        self.add_story_implement GuardStory.new
      end

      #just to keep it easy on the fingers
      class BN < AR::Game::NpcDialogBehavior::Node
      end
      class BSI < AR::Game::StoryBehavior::StoryImplement
      end
      class Story < AR::Game::StoryBehavior::Story
      end
      class IntroNode < BN
        def initialize npc
          super

          


          give_the_sword = BN.new npc
          give_the_sword.player_speech_event = AR::Events::CharacterTalked.new character: player, speech: "Okay, here you go... (Give him your sword)"

          give_the_sword.npc_speech_or_other_events = []
          give_the_sword.npc_speech_or_other_events.push(AR::Events::ItemGivenEvent.new giver: player, receiver: npc, item: npc.world.find("sword"))

          give_the_sword.npc_speech_or_other_events.push(AR::Events::CharacterTalked.new character: npc, speech: "Thanks.  You can go inside now.")
          give_the_sword.npc_speech_or_other_events.push(AR::Events::BlockerRemoved.new blocker: npc.world.find("guard_block"), gateway: npc.world.find("inn_door_leading_in"))

          limbs.push give_the_sword

          #give_the_sword.player_speech_event = AR::Events::CharacterTalked.new character: player, speech: "I can assure you I won't cause any harm, and I also won't give you my sword."
        end

        def player_speech_event
          AR::Events::CharacterTalked.new character: player, speech: "Hello Officer"
        end
        def npc_speech_or_other_events 
          AR::Events::CharacterTalked.new  character: npc, speech: "Hold it right there please. I can see your sword.  Hand it over if you want in."
        end
      end

      class GuardStory < BSI
        def initialize stories=[]
          super
          s = Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            player = e.engine.world.player
            ret = ""
            if e.inspector == e.engine.world.player
              ret = "You analyze the gaurd, who wears a brigandine and wields a spear.  He looks back at you."
            end
            ret
          end
          add_story s
        end
      end
    end

    

  end
end
