require "./lib/apocrodentia"
require "test/unit"
require_relative "../classes.rb"


class TestGateway < BaseBehaviorTestCase 
  include TestTypes

  def setup
    super
    @gate = Gate.new 
    @inhabitable1 = GameScene.new
    @inhabitable2 = GameScene.new
    @blocker = GatewayBlockingObject.new
    @gate.destination= @inhabitable2

    @traveller = Traveller.new
    @traveller.parent = @inhabitable1


    @test_data = {destination_id:"dosntmatter"}

  end

  def test_gateway_gives_off_object_enterered_event_on_enterer_travelled
    evt = AR::Events::ARObjectTravelledEvent.new traveller: @traveller, gateway: @gate
    results = evt.resolve!
    result = results.select{|e| e.class == AR::Events::ARObjectEnteredInhabitableEvent}.first
    assert_not_nil result
    assert_equal result.enterer, @traveller
    assert_equal result.inhabitable, @inhabitable2
  end

  def test_gateway_gives_off_object_failed_entering_on_failure
    @gate.add_blocker  @blocker, "on the gate"
    evt = AR::Events::ARObjectTravelledEvent.new traveller: @traveller, gateway: @gate
    results = evt.resolve!
    results = results.select{|e| e.class == AR::Events::ARObjectEntryBlockedEvent}

    assert_not_nil results.first
    assert_equal @blocker, results.first.blocker
  end



end
