#this is only used for the new game began event
#it initializes gauges, since this only should happen for a new game
module AR::Game::GaugeManagement 
  
  #add attr_accessor properties here... 
  #if you don't need them serialized on save
  attr_accessor :gauge_info_to_initialize
  attr_accessor :after_init_gauge_routines
   

  #...initialize them here
  def self.init ar_object 
    ar_object.gauge_info_to_initialize = []
    ar_object.after_init_gauge_routines = []
  end

  def self.extended ar_object
    self.init ar_object
    
    ar_object.resolutions.push initialize_gauges_on_gauges_initialized
  end 

  def self.initialize_gauges_on_gauges_initialized
    AR::Events::Resolution.new when: AR::Events::GaugesInitialized, as: "gauge_manager" do |e|

      gm = e.gauge_manager
      gm.gauge_info_to_initialize.map do |gi|
        g = AR::Game::Gauge.new(gi[:id])
        g.name = gi[:name]
      end

      gm.after_init_gauge_routines.map{|gr| gr.call gm }
      nil
    end
  end


  def gauge_id_from_name n
    "#{self.id}_#{n}"
  end

  def gauge name
    self.world.find gauge_id_from_name(name)
  end

  def register_gauge name
    gauge_info_to_initialize.push name: name, id: gauge_id_from_name(name)
  end 

  def after_gauges_init &routine
    after_init_gauge_routines.push routine
  end


  #add more methods here

end
