module AR
  module Game

    class OldMan < Npc 
      def initialize id=nil
        super 
        self.noun = "old man"
        self.ownership = "his"
        #add_behavior AR::Game::SomeBehavior
        self.root_dialog_node_class = IntroNode
        self.add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end
      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
      end


      #just to keep it easy on the fingers
      class DNode < AR::Game::NpcDialogBehavior::Node
      end


      class SecondRootNode < DNode

        def player_speech_event
        end

        def npc_speech_or_other_events
          AR::Events::NarrationEvent.new narration: "Hello again young one.  I see you've found your way here without too much harm.  Forgive me for not simply escorting you here from that spot in the forest.  It was necessary for you to gain some grit and become stronger for what lies ahead.  If I had mal-intent, I would coddle you and leave you unprepared.  Now! having said that, you must have other curiosities.  Now that we are in the protection of my home, I feel comfortable enough to answer your questions.  Go ahead."
        end

        def initialize npc
          super
          loop_back = AR::Events::DialogMenuPresented.new dialog_node: self
          what_lies_ahead = DNode.new npc
          what_lies_ahead.player_speech_event = AR::Events::CharacterTalked.new character: self.player, speech: "What lies ahead?"
          what_lies_ahead.npc_speech_or_other_events = [(AR::Events::CharacterTalked.new character: npc, speech: "Well, I assume you don't want to stay in this forest valley forever do you?  Whether you decide to take your revenge on your betrayers, or leave it behind you, first things first: You must get out of this forest valley.  This will not be easy with all the gigantic insects, and poisonous plant life.  Indeed, this forest will literally suck the life out of you if let it!"), loop_back]

          who_are_you = DNode.new npc
          who_are_you.player_speech_event = AR::Events::CharacterTalked.new character: self.player, speech: "Who are you?"
          who_are_you.npc_speech_or_other_events = [(AR::Events::CharacterTalked.new character: npc, speech: "Just an hermit in search of some peace and quiet.  I like to study, and experiment with nature. I try as much as possible to remain neutral in most matters."), loop_back]

          where_are_we = DNode.new npc
          where_are_we.player_speech_event = AR::Events::CharacterTalked.new character: self.player, speech: "Where are we?"
          where_are_we.npc_speech_or_other_events = [(AR::Events::CharacterTalked.new character: npc, speech: "We are in a forested valley on an Isle called Migna.  As you may have seen on your way here, there are two mountains to our north and south, which create this valley."), loop_back]
          

          why_help= DNode.new npc
          why_help.player_speech_event = AR::Events::CharacterTalked.new character: self.player, speech: "Why are you helping me?"
          why_help.npc_speech_or_other_events = [(AR::Events::CharacterTalked.new character: npc, speech: "Still don't trust me Hmm?  Well, I warrant any reasonable person in your scenario would have a serving of pessimism.  The results of my helping or not helping are very simple.  I help you, you live;  I do not, then I should have to come across your remains and and a shot of guilt at some point.  Since I am not a diabolical old man, I have opted to help you."), loop_back]

          no_more_q= DNode.new npc
          no_more_q.player_speech_event = AR::Events::CharacterTalked.new character: self.player, speech: "I have no more questions.  Just tell me what I need to do to get out of this forest."

          enmq1 = npc_speaks("Very well.  The entrance to this forest valley lies to our East.  However, leaving will not be as simple as continually traveling East where you can.  When I first came here, I enchanted the entrance to reduce frequency of disturbance.  To get out, you will need to travel in a certain pattern of directions.  Naturally, over the centuries I've forgotten the pattern to leave, since I never leave...\"\n\nHe continues, \"I can tell you seem very disappointed.  All is not lost though, as I was wise enough to inscribe the pattern on a parchment.  Unfortunately, I believe this scroll fell out of my bag when I was collecting mushrooms in a nearby cave recently.  If you expect to navigate the cave properly, you will need to have this on you: (He hands you a torch)")
          evts_no_more_q = [enmq1, (AR::Events::ItemGivenEvent.new item: npc.world.find("torch"), giver: npc, receiver: player), npc_speaks("Go to the cave, and find the scroll. It should be in the deepest part.  When you do, you will need to bring the scroll back to me so I can translate the writing.  It is scribed in my own code."), npc_speaks("Now, before you go, I have some important things to tell you.\" \n\n\nThe old man continues: \"First, I would urge you to rest.  You can use my bed here.  When you do, your mind will be able to absorb all the experience you've gained, which may make you noticeably stronger.  Come back and use it any time.")]


          item_classes = player.inventory_items.map(&:class)
          materials = [AR::Game::BeetleChitin, AR::Game::BeetleMeat, AR::Game::RedMushroom, AR::Game::GreenMushroom]
          #if the player has any materials
          unless (item_classes & materials).empty?
            evts_no_more_q.push(AR::Events::CharacterTalked.new character: npc, speech: "Also I notice you have collected some useful materials.  Talk to me again, and give them to me.  I will then be able to better equip you for the dangers ahead.")
          else
             evts_no_more_q.push(AR::Events::CharacterTalked.new character: npc, speech: "Also, you have not collected anything useful from your surroundings.  You probably should do some foraging for mushrooms, beetle meat, and beetle chitin so I can craft some useful things for you. I recommend you do this before venturing into the cave.")
          end

          evts_no_more_q.push AR::Events::RanProc.new proc: (Proc.new {|evt| npc.root_dialog_node_class = ThirdRootNode; nil})
          no_more_q.npc_speech_or_other_events =  evts_no_more_q


          self.limbs = [what_lies_ahead, who_are_you, where_are_we, why_help, no_more_q]

        end 
      end

      class ThirdRootNode < DNode

        def player_speech_event
        end

        def npc_speech_or_other_events
          npc_speaks("Hello again, young one. Have you found the scroll with my code on it yet? Or are you here to have me craft something for you?")
        end

        def initialize npc
          super
          player_stuff_types = player.inventory_items.map(&:class)

          if player_stuff_types.include?(AR::Game::BeetleChitin)
            chitins = player.inventory_items.select do |it|
              it.class == AR::Game::BeetleChitin
            end
            give_chitin = AR::Events::ItemGivenEvent.new(item: chitins.last, giver: player, receiver: npc)
            craft_chitin = DNode.new npc

            craft_chitin.player_speech_event = player_speaks "I found this, can you make anything with it?  (You show him the beetle chitin)"
            craft_chitin.npc_speech_or_other_events = [npc_speaks("Hmm looks like you have managed to find some useful equipment-making material.  I can create a sword, a dagger, a shield, or a chest plate for you.  What should I create for you?")]
            sword = DNode.new npc
            sword.player_speech_event = player_speaks "Create me a sword, so I can deal most deadly blows."
            sword.npc_speech_or_other_events = [(npc_speaks("Okay then.  Give me just a moment...  Here you are!  Just be careful not to fall on it yourself.")), give_chitin, AR::Events::ItemGivenEvent.new(item: ChitinSword.new, giver: npc, receiver: player)]

            dagger = DNode.new npc
            dagger.player_speech_event = player_speaks "Create me a dagger, so I can deal the most cunning blows."
            dagger.npc_speech_or_other_events = [(npc_speaks("Ahh, an aspiring rogue are we? Okay then.  Give me just a moment...  Here you are!")), give_chitin,(AR::Events::ItemGivenEvent.new item: ChitinDagger.new, giver: npc, receiver: player)]


            shield = DNode.new npc
            shield.player_speech_event = player_speaks "Create me a shield, so I can block incoming blows."
            shield.npc_speech_or_other_events = [(npc_speaks("Alright.  Seems you favor a good defense.  Here you are!")), give_chitin, (AR::Events::ItemGivenEvent.new item: ChitinShield.new, giver: npc, receiver: player)]

            chest = DNode.new npc
            chest.player_speech_event = player_speaks "Create me a chestplate, so I can resist damage without extra effort."
            chest.npc_speech_or_other_events = [(npc_speaks("Okay.  You should know, when equipped, this will increase your damage resistance, but will make it more difficult to avoid attacks.  Here you go!")), give_chitin, (AR::Events::ItemGivenEvent.new item: ChitinChest.new, giver: npc, receiver: player)]


            forget_it = DNode.new npc
            forget_it.player_speech_event = player_speaks "Forget it.  I don't want you to make any of those things right now."
            forget_it.npc_speech_or_other_events = [npc_speaks("Okay then... suit yourself as they say."), loop_to(self)]
            craft_chitin.limbs = [sword, dagger, shield, chest, forget_it]

            limbs.push craft_chitin 
          end

          if player_stuff_types.include?(AR::Game::RedMushroom)
            red_mushies = player.inventory_items.select do |it|
              it.class == AR::Game::RedMushroom
            end
            give_red_shroom = AR::Events::ItemGivenEvent.new(item: red_mushies.last, giver: player, receiver: npc)
            craft_potion = DNode.new npc

            craft_potion.player_speech_event = player_speaks "I found this, can you make anything with it?  (You show him the red mushroom)"
            craft_potion.npc_speech_or_other_events = [npc_speaks("Hmm looks like you have managed to find a nicely sized red mushroom.  I can use that to create a healing potion.   Just give me a moment here... Drink to your health young one!  Just remember you will waste it if you are already healthy."), give_red_shroom, AR::Events::ItemGivenEvent.new(item: MushroomPotion.new, giver: npc, receiver: player)]

            limbs.push craft_potion
          end



          if player_stuff_types.include?(AR::Game::GreenMushroom)
            grn_mushies = player.inventory_items.select do |it|
              it.class == AR::Game::GreenMushroom
            end

            give_grn_shroom = AR::Events::ItemGivenEvent.new(item: grn_mushies.last, giver: player, receiver: npc)
            craft_antidote = DNode.new npc

            craft_antidote.player_speech_event = player_speaks "I found this, can you make anything with it?  (You show him the green mushroom)"
            craft_antidote.npc_speech_or_other_events = [npc_speaks("Hmm looks like you have managed to find a nicely sized green mushroom.  I can use that to create an antidote.  Just give me a moment here... Here you go! Now remember to only drink this when you've become poisoned.  Otherwise you will have wasted it."), give_grn_shroom, AR::Events::ItemGivenEvent.new(item: Antidote.new, giver: npc, receiver: player)]
            limbs.push craft_antidote
          end



          if player_stuff_types.include? AR::Game::Scroll
             
          else
            no_i_havent = DNode.new npc
            no_i_havent.player_speech_event = player_speaks("No, I still haven't found the scroll")
            no_i_havent.npc_speech_or_other_events = npc_speaks("Well, what are you waiting for then? You look perfectly capable to me.")
            limbs.push no_i_havent
          end
        end

      end


      class IntroNode < DNode

        def player_speech_event
          nil
        end

        def npc_speech_or_other_events 
          results = []
          results.push(AR::Events::NarrationEvent.new  new_paragraph: true, narration: "From the corner of your eye, a shift of movement near a tree catches your attention.  A figure, wearing a full cloak appears.  The cloak is studded with glossy, black plates, which help to camoflage the wearer.  From the hood, an ashen beard flows down to the waste.  Above that, the tip of a gnarly nose peeks into the light.  His cheeks and eyes are hidden beneath shadow. He begins to speak in a tired and wise voice...")
          results.push(AR::Events::CharacterTalked.new  character: npc, speech: "Hello young one.  It has been a long era since your kind has trodden this forest floor; now adversity has brought that to an abrupt end. Look how you've damaged the poor old trees!")
          results.push(AR::Events::NarrationEvent.new  new_paragraph: true, narration: "The old man moves a bit behind his cloak, and reveals an ornately carved cane.  With it, he gestures to the canopy of branches right above you. As you glance up, you can see a hole in the canopy, and now you notice several broken branches near the half-eaten corpse of the giant bat.")
          results.push(AR::Events::CharacterTalked.new  character: npc, speech: "Now, explain yourself quickly.  Where were you headed before your mount fainted and succumbed to treachery?")
          results.push(AR::Events::NarrationEvent.new  new_paragraph: true, narration: "Taking a moment to think, you realize you can't remember anything about where you were going, or who you are. ")
          results
        end

        def initialize npc
          super

          express_amnesia = DNode.new npc
          express_amnesia.player_speech_event = AR::Events::CharacterTalked.new character: player, speech: "I can't seem to remember anything at all."
          eamn = []
          eamn.push(AR::Events::NarrationEvent.new new_paragraph: true, narration: "He pauses and strokes his beard in one hand, and with the other he reaches out and points toward your head with his rod.  You can sense your thoughts shuffle like a deck of cards.  He stops, and slowly lowers his magical weapon, seemingly surprised. \n\"Hmmphh!\", he grumbles, \"It seems as though you are telling the truth, despite what your unsavory clothing speaks of you...\"")
=begin
=end


          eamn.push(AR::Events::NarrationEvent.new new_paragraph: true, narration: "You take a moment to look down at yourself.  You are wearing robe and mantle, black as midnight.  Covering the chest of the mantle is a detailed embroidery of a skull whose right eye is made to look still fleshy, gazing at you.  \n\nThe Old Man speaks, \"You must have rather serious amnesia from your descent...  I am certain this meeting of ours would have gone very differently if you had remembered your identity and purpose.\" \n\nHe continues, \"You were riding this creature through the night when it swooned into the trees.  A cunning animal like this would not just collapse before trying to safely land, and it wouldn't take off if it were aware of any physical blight.  Obviously, this is the work of malignent sorcery, due to take effect when you were at deadly heights. It seems the spell wasn't robust enough to account for the trees' ability to break your fall, however.\"")



          e_join = AR::Events::NarrationEvent.new new_paragraph: true, narration: "\"Wherever you decide to set your bearings, consider staying at my home before you set out. You will be very unlikely to survive outdoors for long.  The creatures here have grown very dangerous these past weeks.\""

          express_amnesia.npc_speech_or_other_events = eamn 

          eamn_l1 = DNode.new npc
          eamn_l1.player_speech_event = AR::Events::CharacterTalked.new character: player, speech: "What can you tell me about these robes?"
          eamn_l1_e1 = AR::Events::CharacterTalked.new character: npc, speech: "Not a terrible lot of detail, but enough for now.  I am certain that garmants such as those would belong to a cult captain.  A powerful necromancer or the like. To learn more you will need to trace them to the group that bears this insignia (He motions toward the skull on your chest).  And if I were you, I would take the fortune of your situation and let it be as you are:  Untainted by the decisions of your past.  Many a king would give up his treasury to be where you are."
          eamn_l1.npc_speech_or_other_events = [eamn_l1_e1, e_join]

          eamn_l2 = DNode.new npc
          eamn_l2.player_speech_event = AR::Events::CharacterTalked.new character: player, speech: "How do I find out who did this to me?"
          eamn_l2_e1 = AR::Events::CharacterTalked.new character: npc, speech: "You should wonder what this knowledge is worth to you.  Your clothing suggests you were in a coven of necromancers and hags.  In your current state, having forgotten all your power, those of your past would surely overtake you.  Worse than that, you would most likely end up in a most unnatural servitude of undeath."
          eamn_l2.npc_speech_or_other_events = [eamn_l2_e1, e_join]


          tell_player_ill_give_supplies = AR::Events::NarrationEvent.new narration: "Before I go, I have some things that will help you, seeing as though you are helpless.  Here are some supplies..."
          give_player_jerky = AR::Events::ItemAddedToInventory.new item: BeetleJerky.new, inventory_owner: player
          give_player_potion1 = AR::Events::ItemAddedToInventory.new item: MushroomPotion.new, inventory_owner: player
          give_player_potion2 = AR::Events::ItemAddedToInventory.new item: MushroomPotion.new, inventory_owner: player
          give_player_potion3 = AR::Events::ItemAddedToInventory.new item: MushroomPotion.new, inventory_owner: player
          tell_player_to_collect = AR::Events::NarrationEvent.new new_paragraph: true, narration: "The Old Man folds his arms and stands straight in a cacoon-like position.  He begins to talk as though saying farewell, \"One more thing.  You should collect the valuable materials from that beetle there, and anything else you find curious in the forest.\" He points at the recently slain giant beetle, and goes on, \"If you bring them to me, I may be able to help better equip you for survival.\"  The Old Man then zips into the air in a plume of smoke."
          zip_back_home = AR::Events::ARObjectEnteredInhabitableEvent.new enterer: npc, placement: "by the fire", inhabitable: npc.world.find("old_man_house"), dont_narrate: true
          lose_sight = AR::Events::DiscoveryLostEvent.new perceiver: player, undiscovered: npc

          next_dlog =  AR::Events::RanProc.new proc: (Proc.new {|evt| npc.root_dialog_node_class = SecondRootNode; nil})
          closing = [tell_player_ill_give_supplies, give_player_jerky, give_player_potion1, give_player_potion3, tell_player_to_collect, zip_back_home, lose_sight, next_dlog]

          pessimistic = DNode.new npc
          pessimistic.player_speech_event = (AR::Events::CharacterTalked.new character: player, speech: "You seem rather inviting for a stranger.  How do I know I can trust you?")

          pessimistic.npc_speech_or_other_events = [(AR::Events::CharacterTalked.new character: npc, speech: "Think about an answer to your question for a moment.  I revealed myself willingly, and leave you without harm willingly.  If I wished you ill fate, you would already have had it, and without any perception of me.\n\nWhen you realize that you need rest and guidance, come to my home.  It's 3 stretches north, and 2 stretches east from here, at the foot of the warm mountain.")] + closing

          accepting = DNode.new npc
          accepting.player_speech_event = (AR::Events::CharacterTalked.new character: player, speech: "That sounds very releiving.  Can you tell me exactly where to find your home?")
          accepting.npc_speech_or_other_events = [(AR::Events::CharacterTalked.new character: npc, speech: "My home can be found 3 stretches north, and 2 stretches to the east, at the foot of the warm mountain.")] + closing

          over_accepting = DNode.new npc
          over_accepting.player_speech_event = (AR::Events::CharacterTalked.new character: player, speech: "I should really just follow you.  I have no idea where I am.")
          over_accepting.npc_speech_or_other_events = [(AR::Events::CharacterTalked.new character: npc, speech: "Nonsense! To get out of this valley, you will need to become familiar with it.  Additionally, you have some things to do and discover between here and there.  Find my place is 3 stretches north, and 2 stretches east from here, at the foot of the warm mountain.")] + closing
          closing_node_limbs = [pessimistic, accepting, over_accepting]

          eamn_l1.limbs = closing_node_limbs
          eamn_l2.limbs = closing_node_limbs

          express_amnesia.limbs = [eamn_l1, eamn_l2]
          limbs.push express_amnesia
        end
      end




    end



  end
end

