module AR
  module Game

    class Forest03EntranceEast < PhysicalObject 
      def initialize id=nil
        super 
        self.noun = "cave entrance"
        add_behavior Gateway
        add_story_implement StoryImplement.new
        #add_behavior AR::Game::SomeBehavior
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement

        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "Toward the east, a part of the path branches off and ascends the foot of the mountain.  It goes between some boulders and delves into a pitch black cave."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The entrance to the cave is supported by 4 huge boulders.  Best not go in without some kind of light source."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::ARObjectTravelledEvent, as: "gateway" do |e|
            if e.traveller == e.engine.world.player
              ret = "You nervously make your way up the trail, to the mouth of the mountain cave.  As it swallows you, the darkness is almost dizzying, yet you press on anyhow."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end#initialize

      end#StoryImplement



    end#Gateway class



  end#Game
end#AR
