class AR::Events::Resolution < AR::Events::Subscription
  attr_accessor :as_who
  def initialize args={}
    super
    self.as_who = args[:as_who] || args[:as]
  end
  def is_for? event_class, as_who
    as_who = as_who.to_s rescue nil
    return false unless super event_class
    self.as_who == as_who
  end  
end

class AR::Events::OneTimeResolution < AR::Events::Resolution
end




#this is for ai
class AR::Events::ResolutionDesireChanger < AR::Events::Resolution 
  attr_accessor :desire
  def initialize params
    super
    self.desire = params[:desire]
  end 

  def call *args
    super *args, desire
  end
end

