/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.TextPrinter;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.text.Text;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NumericTextMenu {
    private String title;
    private final List<UserAction> commands;
    private final TextPrinter txt;
    private final boolean persistent;

    public NumericTextMenu(String title, Collection<? extends UserAction> commands, TextPrinter textPrinter, boolean persistent) {
        this.title = title;
        this.commands = new ArrayList<UserAction>(commands);
        this.txt = textPrinter;
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void render() {
        if (this.title != null) {
            this.txt.println(this.title);
        }
        for (int i = 0; i < this.commands.size(); ++i) {
            this.txt.println(i + 1 + ". " + this.commands.get(i).getDescription());
        }
        this.txt.println("Enter 1-" + this.commands.size() + " or any other command." + Text.getLineSeparator());
    }

    public boolean parseInput(String input, TextAppController controller) {
        int idx;
        try {
            idx = Integer.parseInt(input);
        }
        catch (Exception ex) {
            return false;
        }
        if (idx < 1 || idx > this.commands.size()) {
            return this.handleUserSelectsOutOfRangeIndex(idx);
        }
        UserAction chosenCommand = this.commands.get(idx - 1);
        controller.executeInSimulation(simulation -> {
            if (chosenCommand.isValid(simulation.getCurrentFrame())) {
                chosenCommand.execute(controller);
            } else {
                this.txt.println("It is no longer possible " + chosenCommand.getDescription() + ".");
            }
        });
        return true;
    }

    public boolean handleUserSelectsOutOfRangeIndex(int idx) {
        this.txt.println(idx + " isn't a menu option.");
        return true;
    }
}

