/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommandWithTool;
import com.fabriziopolo.textcraft.commands.AbstractUserAction;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.TakeCommand;
import com.fabriziopolo.textcraft.nlg.AdjectivePhrase;
import com.fabriziopolo.textcraft.nlg.GroupedCollectionNounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.PureAdjectivePhrase;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class AbstractCraftCommand
extends AbstractCommandWithTool {
    private static final List<String> FROM_SYNONYMS = Arrays.asList("from", "with");
    private final CraftingDelegate delegate;

    protected AbstractCraftCommand(CraftingDelegate delegate) {
        this.delegate = delegate;
    }

    public CraftingDelegate getDelegate() {
        return this.delegate;
    }

    protected abstract Set<Noun> getAccessibleNouns(Command.Context var1);

    @Override
    public ActionsAndHints parseWithTool(String[] words, Command.Context context, Noun tool) {
        ActionsAndHints failureHints;
        TextMatcher.ResultWithData<List<Noun>> matchedResourcesResult;
        if (words.length == 0 || !words[0].toLowerCase().equals(this.getCraftVerb()) || this.delegate.getPrototype() == null) {
            return null;
        }
        int idx = 1;
        String adjective = null;
        TextMatcher.Result adjectiveResult = this.matchAnAdjective(idx, words, context);
        if (adjectiveResult.isMatch) {
            adjective = words[idx];
            idx += adjectiveResult.numWordsMatched;
        }
        TextMatcher.Result objectResult = this.matchTheObject(idx, words, context);
        if (!objectResult.isMatch) {
            return null;
        }
        if ((idx += objectResult.numWordsMatched) >= words.length) {
            return this.failToMatchResourcesWithHint();
        }
        if (FROM_SYNONYMS.contains(words[idx].toLowerCase())) {
            ++idx;
        }
        if (!(matchedResourcesResult = this.matchResourceList(idx, words, context, failureHints = new ActionsAndHints())).isMatch()) {
            return this.failToMatchResourcesWithHint(failureHints);
        }
        List resourcesToBeUsed = (List)matchedResourcesResult.data;
        return this.getActionsAndHintsFromParse(resourcesToBeUsed, adjective, tool, context);
    }

    private ActionsAndHints getActionsAndHintsFromParse(List<Noun> resources, String adjective, Noun tool, Command.Context context) {
        if (!this.validateResources(resources)) {
            return this.failToMatchResourcesWithHint();
        }
        ArrayList<ParseResult> results = new ArrayList<ParseResult>();
        results.add(new ParseResult(context, adjective, this.delegate.getPrototype(), resources, this.delegate, tool));
        return new ActionsAndHints(results);
    }

    private ActionsAndHints failToMatchResourcesWithHint() {
        return ActionsAndHints.hint(this.delegate.getHint());
    }

    private ActionsAndHints failToMatchResourcesWithHint(ActionsAndHints failureHints) {
        return failureHints.addHint(this.delegate.getHint());
    }

    @Override
    public String getHelpString() {
        return "The 'craft' command lets you make new items from items in your inventory, and lets you build new structures in your environment.  Type 'craft' followed by the name of the thing you want to try to make.  Crafting usually requires resources.  For example 'craft sandwich from bread, meat and cheese' or 'craft shelter from tree wood reeds'.  Many items can be crafted in multiple ways.  Just because you can use a particular resource doesn't necessarily mean you have to.  Sometimes there are others that will also work.\n\nCrafing some objects requires that you use a tool.  Wield the tool first ('wield lighter'), or specify it: 'craft fire from wood and gasoline with lighter'.  Crafting lets you make all sorts of things.  You'll have to experiment to see what you can create.\n\nTo customize your creations you can provide an adjective.  Instead of 'craft sandwich...' you could 'craft delicious sandwich...'.  Other examples include 'craft humble shelter...', 'craft fetching hat', and 'craft welcome mat'.";
    }

    @Override
    public abstract String getNameString();

    @Override
    public abstract String getPurposeString();

    public String getCraftVerb() {
        return this.getNameString();
    }

    private TextMatcher.Result matchAnAdjective(int idx, String[] words, Command.Context context) {
        if (idx >= words.length) {
            return TextMatcher.Result.createFailed();
        }
        TextMatcher.Result foundObject = this.matchTheObject(idx, words, context);
        if (foundObject.isMatch) {
            return TextMatcher.Result.createFailed();
        }
        return TextMatcher.Result.createMatch(idx, 1);
    }

    private TextMatcher.Result matchTheObject(int idx, String[] words, Command.Context context) {
        if (this.delegate.getPrototype() == null) {
            return TextMatcher.Result.createFailed();
        }
        return this.delegate.getPrototype().getDefaultPerception(context.simulation.getCurrentFrame()).matches(words, idx, context.simulation.getCurrentFrame());
    }

    private TextMatcher.ResultWithData<List<Noun>> matchResourceList(int startIdx, String[] words, Command.Context context, ActionsAndHints accumulatedHints) {
        int idx = startIdx;
        ArrayList matchedResources = new ArrayList();
        Set<Noun> accessibleNouns = this.getAccessibleNouns(context);
        while (idx < words.length) {
            TextMatcher.ResultWithData<Noun> resourceMatch = this.matchOneResource(idx, words, context, accessibleNouns);
            if (!resourceMatch.isMatch()) {
                accumulatedHints.addHint(this.getFailedResourceMatchMessage(idx, words, context));
                return TextMatcher.ResultWithData.createFailed();
            }
            matchedResources.add(resourceMatch.data);
            accessibleNouns.remove(resourceMatch.data);
            if ((idx += resourceMatch.getNumWordsMatched()) >= words.length) {
                return TextMatcher.ResultWithData.createMatch(startIdx, idx - startIdx, matchedResources);
            }
            if (words[idx].equals(",") || words[idx].equals("and")) {
                ++idx;
            }
            if ((idx > words.length || !words[idx].equals(",")) && !words[idx].equals("and")) continue;
            ++idx;
        }
        return TextMatcher.ResultWithData.createMatch(startIdx, idx - startIdx, matchedResources);
    }

    private String getFailedResourceMatchMessage(int idx, String[] words, Command.Context context) {
        TextMatcher.ResultWithData<Noun> nearbyMatch = this.matchOneResource(idx, words, context, AbstractCraftCommand.getAccessibleNearbyNouns(context));
        if (nearbyMatch.isMatch()) {
            String aNearbyNoun = NounPhraseWithArticle.a(((Noun)nearbyMatch.data).getContextFreeDescription()).toString();
            return "In order to use " + aNearbyNoun + " to craft " + NounPhraseWithArticle.a(this.delegate.getPrototype().getContextFreeDescription()) + " you need to put it in your inventory.";
        }
        return "Starting with \"" + words[idx] + "...\" I don't know what resources you're referring to.";
    }

    private TextMatcher.ResultWithData<Noun> matchOneResource(int idx, String[] words, Command.Context context, Set<Noun> accessibleNouns) {
        if (idx >= words.length) {
            return TextMatcher.ResultWithData.createFailed();
        }
        Frame frame = context.simulation.getCurrentFrame();
        for (Noun noun : accessibleNouns) {
            TextMatcher.Result result = noun.matches(words, idx, context.player, frame);
            if (!result.isMatch) continue;
            return TextMatcher.ResultWithData.createMatch(result, noun);
        }
        return TextMatcher.ResultWithData.createFailed();
    }

    private boolean validateResources(List<Noun> resources) {
        return true;
    }

    protected static Set<Noun> getAccessibleInventoryNouns(Command.Context context) {
        InventoryState inventoryState = InventoryState.get(context.simulation.getCurrentFrame());
        List<Noun> items = inventoryState.get(context.player).getItems();
        HashSet<Noun> itemSet = new HashSet<Noun>();
        itemSet.addAll(items);
        return itemSet;
    }

    protected static Set<Noun> getAccessibleNearbyNouns(Command.Context context) {
        List<Noun> items = TakeCommand.getAccessibleNouns(context.player, context.simulation.getCurrentFrame());
        InventoryState inventoryState = InventoryState.get(context.simulation.getCurrentFrame());
        List<Noun> inventoryItems = inventoryState.get(context.player).getItems();
        HashSet<Noun> itemSet = new HashSet<Noun>();
        itemSet.addAll(inventoryItems);
        itemSet.addAll(items);
        return itemSet;
    }

    public static interface CraftingDelegate
    extends Serializable {
        public void execute(ParseResult var1);

        public Noun validateAndCraftNewNoun(ParseResult var1);

        public Noun craftNewNoun(ParseResult var1);

        public Noun getPrototype();

        public String getHint();
    }

    public static final class ParseResult
    extends AbstractUserAction {
        public final AdjectivePhrase adjective;
        public final Noun objectPrototype;
        public final List<Noun> resources;
        public final CraftingDelegate craftingDelegate;
        public final Noun tool;

        public ParseResult(Command.Context context, String adjective, Noun objectPrototype, List<Noun> resources, CraftingDelegate craftingDelegate, Noun tool) {
            super(context);
            this.adjective = adjective != null ? new PureAdjectivePhrase(adjective) : null;
            this.objectPrototype = objectPrototype;
            this.resources = resources;
            this.craftingDelegate = craftingDelegate;
            this.tool = tool;
        }

        @Override
        public String getDescription() {
            Player player = this.context.player;
            Frame frame = this.context.simulation.getCurrentFrame();
            GroupedCollectionNounPhrase groupedResources = GroupedCollectionNounPhrase.create(this.resources.stream().map(noun -> player.getPerceptionOf((Noun)noun, frame)).collect(Collectors.toList()));
            String craftText = "to craft " + player.getPerceptionOf(this.objectPrototype, frame) + " from " + groupedResources;
            return craftText;
        }

        @Override
        public void execute(TextAppController controller) {
            this.craftingDelegate.execute(this);
        }

        @Override
        public boolean isValid(Frame frame) {
            return false;
        }
    }
}

