/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommandWithTool;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.TakeCommand;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class AttackCommand
extends AbstractCommandWithTool {
    private static final List<String> ATTACK_SYNONYMS = Arrays.asList("attack", "a");

    @Override
    public String getHelpString() {
        return "Type 'attack' followed by the thing you'd like to attack, for instance 'attack bambi'.  To use a weapon, either wield it in advance ('wield crossbow') or reference it directly ('attack bambi with crossbow').";
    }

    @Override
    public String getNameString() {
        return "attack";
    }

    @Override
    public String getPurposeString() {
        return "Lay waste to one of god's beautiful creations.";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    @Override
    ActionsAndHints parseWithTool(String[] words, Command.Context context, Noun tool) {
        Frame frame = context.simulation.getCurrentFrame();
        if (words.length < 1) {
            return null;
        }
        String firstWord = words[0].toLowerCase();
        if (!ATTACK_SYNONYMS.contains(firstWord)) {
            return null;
        }
        List<TextMatcher.ResultWithData<Noun>> results = TakeCommand.matchOneAccessibleNoun(words, 1, context.player, frame);
        if (results.isEmpty()) {
            return this.failWithBadObjectHint();
        }
        return new ActionsAndHints(results.stream().map(tmResult -> new Result(context, (Noun)tmResult.data, tool)).collect(Collectors.toList()));
    }

    private ActionsAndHints failWithBadObjectHint() {
        return ActionsAndHints.hint("What are you trying to attack?");
    }

    class Result
    implements UserAction {
        private final Command.Context context;
        private final Noun thingToAttack;
        private final Noun weapon;

        private Result(Command.Context context, Noun thingToAttack, Noun weapon) {
            this.context = context;
            this.thingToAttack = thingToAttack;
            this.weapon = weapon;
        }

        @Override
        public String getDescription() {
            return "to attack " + NounPhraseWithArticle.the(this.context.player.getPerceptionOf(this.thingToAttack, this.context.simulation.getCurrentFrame()));
        }

        @Override
        public void execute(TextAppController controller) {
            Frame frame = this.context.simulation.getCurrentFrame();
            IndependentClause attackDescription = this.weapon == null ? Nlg.literalClause("you attack it") : Nlg.literalClause("you attack it with " + NounPhraseWithArticle.a(this.weapon.getDefaultPerception(frame)));
            HealthState.requestChange(this.thingToAttack, -1000.0, attackDescription, this.context.simulation);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

