/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textcraft.commands.AbstractCraftCommand;
import com.fabriziopolo.textcraft.commands.DefaultCraftingDelegateImpl;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.capability.Capability;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import java.util.List;

public abstract class BuildCraftingDelegate
extends DefaultCraftingDelegateImpl {
    private static final String BUILD_CRAFTING_VERB = "craft";

    protected BuildCraftingDelegate(Noun prototype, List<Capability> resourceRequirements, Capability toolRequirement) {
        super(prototype, resourceRequirements, toolRequirement, BUILD_CRAFTING_VERB);
    }

    protected BuildCraftingDelegate(Noun prototype, List<Capability> resourceRequirements) {
        super(prototype, resourceRequirements, BUILD_CRAFTING_VERB);
    }

    @Override
    public void execute(AbstractCraftCommand.ParseResult result) {
        Simulation simulation = result.context.simulation;
        Player player = result.context.player;
        Noun builtNoun = this.validateAndCraftNewNoun(result);
        if (builtNoun != null) {
            for (Noun resource : result.resources) {
                InventoryState.requestRemoveItem(player, resource, simulation);
            }
        }
    }

    @Override
    public String getHint() {
        return null;
    }
}

