/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.useable.UseHandler;
import com.fabriziopolo.textcraft.states.useable.UseableState;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UseCommand
extends AbstractCommand {
    private static final List<String> USE_SYNONYMS = Arrays.asList("use");

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length < 1) {
            return null;
        }
        String firstWord = words[0].toLowerCase();
        if (!USE_SYNONYMS.contains(firstWord)) {
            return null;
        }
        if (words.length == 1) {
            return this.failWithHint();
        }
        Frame frame = context.simulation.getCurrentFrame();
        List<Noun> nounsWeMightUse = this.getNounsWeMightUse(context.player, frame);
        List<TextMatcher.ResultWithData<Noun>> results = UseCommand.matchOne(words, 1, nounsWeMightUse, context.player, frame);
        if (results.isEmpty()) {
            return this.failWithBadObjectHint();
        }
        ArrayList actions = new ArrayList();
        results.forEach(tmResult -> {
            List<UserAction> uses;
            UseHandler handler = UseableState.getHandler((Noun)tmResult.data, frame);
            if (handler != null && (uses = handler.getUses((Noun)tmResult.data, context)) != null) {
                actions.addAll(uses);
            }
        });
        if (actions.isEmpty()) {
            return this.failWithUnusableObject();
        }
        return new ActionsAndHints(actions);
    }

    @Override
    public String getHelpString() {
        return "Type 'use' followed by the name of the object you'd like to use to invoke a specific capability of that object.  The use command is only for cases where a more specific verb does not apply.  Hint: The cell phone is the only thing you can use.";
    }

    @Override
    public String getNameString() {
        return "use";
    }

    @Override
    public String getPurposeString() {
        return "Use an object.";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private List<Noun> getNounsWeMightUse(Perceiver player, Frame frame) {
        return player.getPerceivableNouns(frame);
    }

    private ActionsAndHints failWithHint() {
        return ActionsAndHints.hint(this.getHelpString());
    }

    private ActionsAndHints failWithBadObjectHint() {
        return ActionsAndHints.hint("I don't recognize the item you're trying to use.");
    }

    private ActionsAndHints failWithUnusableObject() {
        return ActionsAndHints.hint("You can't use that.");
    }
}

