/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.Inventory;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.inventory.WieldRequest;
import java.util.List;
import java.util.stream.Collectors;

public class WieldCommand
implements Command {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0 || !words[0].toLowerCase().equals("wield")) {
            return null;
        }
        if (words.length == 1) {
            return this.getHint();
        }
        Frame frame = context.simulation.getCurrentFrame();
        Inventory inventory = InventoryState.get(frame).get(context.player);
        if (inventory == null) {
            return this.failWithBadObjectHint();
        }
        List<Noun> nounsWeMightWield = inventory.getItems();
        List results = AbstractCommand.matchOne(words, 1, nounsWeMightWield, context.player, frame).stream().filter(result -> result.getStartIndex() + result.getNumWordsMatched() == words.length).collect(Collectors.toList());
        if (results.isEmpty()) {
            return this.failWithBadObjectHint();
        }
        return new ActionsAndHints(results.stream().map(tmResult -> new Result((Noun)tmResult.data, context)).collect(Collectors.toList()));
    }

    @Override
    public String getHelpString() {
        return "To wield a weapon or tool, type 'wield' followed by the name of the tool.  You will need to wield tools in order to use them implicitly.  You can always use a tool explicitly by adding 'with <tool>' to the end of a command. The wield command allows you to use a tool in other commands (like 'attack' or 'take') without having to specify it. For instance, 'wield axe', followed by 'take tree' cuts down a tree with the axe. This has the same effect as 'take tree with axe'.";
    }

    @Override
    public String getNameString() {
        return "wield";
    }

    @Override
    public String getPurposeString() {
        return "Ready a tool for implicit use.";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private ActionsAndHints getHint() {
        return ActionsAndHints.hint(this.getHelpString());
    }

    private ActionsAndHints failWithBadObjectHint() {
        return ActionsAndHints.hint("I don't recognize the item you're trying to wield.");
    }

    public static final class Result
    implements UserAction {
        private final Command.Context context;
        private final Noun nounToWield;

        public Result(Noun nounToWield, Command.Context context) {
            this.nounToWield = nounToWield;
            this.context = context;
        }

        @Override
        public String getDescription() {
            NounPhrase perceptionOfWieldedNoun = this.context.player.getPerceptionOf(this.nounToWield, this.context.simulation.getCurrentFrame());
            return "to wield " + NounPhraseWithArticle.the(perceptionOfWieldedNoun);
        }

        @Override
        public void execute(TextAppController controller) {
            WieldRequest.request(this.context.player, this.nounToWield, this.context.simulation);
        }

        @Override
        public boolean isValid(Frame frame) {
            return InventoryState.isInInventory(this.context.player, this.nounToWield, frame);
        }
    }
}

