/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.events.position;

import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.nlg.GroupedCollectionNounPhrase;
import com.fabriziopolo.textcraft.nlg.IndependentWithAdverbialClause;
import com.fabriziopolo.textcraft.nlg.MultipleSentences;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithAdjective;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Pronouns;
import com.fabriziopolo.textcraft.nlg.PureAdverbialClause;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.SimpleDocument;
import com.fabriziopolo.textcraft.nlg.SingleClauseSentence;
import com.fabriziopolo.textcraft.nlg.ThereExistsClause;
import com.fabriziopolo.textcraft.nlg.Verbs;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.constants.Directions;
import com.fabriziopolo.textcraft.states.description.DescriptionState;
import com.fabriziopolo.textcraft.states.position.PathSegment;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.scenery.SceneryState;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.plexus.util.StringUtils;

public class PlayerExaminesSurroundingsEvent
implements Event {
    public final Noun player;
    public final Noun direction;

    public PlayerExaminesSurroundingsEvent(Noun player, Noun direction) {
        this.player = player;
        this.direction = direction;
    }

    public static void post(Command.Context context) {
        PlayerExaminesSurroundingsEvent.post(null, context);
    }

    public static void post(Noun direction, Command.Context context) {
        context.simulation.postEvent(new PlayerExaminesSurroundingsEvent(context.player, direction));
    }

    public static void post(Noun player, Simulation simulation) {
        PlayerExaminesSurroundingsEvent.post(player, null, simulation);
    }

    public static void post(Noun player, Noun direction, Simulation simulation) {
        simulation.postEvent(new PlayerExaminesSurroundingsEvent(player, direction));
    }

    @Override
    public Sentences asPerceivedBy(Perceiver perceiver, Frame frame, PerceptionChannel unusedChannel) {
        PositionState positionState = PositionState.get(frame);
        Noun containingRoom = positionState.getContainingRoom(this.player);
        Noun surroundingParent = StructureState.getSurroundingParent(this.player, frame);
        if (surroundingParent != null) {
            return this.asPerceivedByWithinSurroundingParent(perceiver, surroundingParent, frame);
        }
        SimpleDocument.Builder doc = SimpleDocument.builder();
        MultipleSentences.Builder roomDescriptionBuilder = MultipleSentences.builder();
        roomDescriptionBuilder.add(perceiver.getVerbosePerceptionOf(containingRoom, frame));
        this.appendDescriptionOfScenery(perceiver, frame, containingRoom, roomDescriptionBuilder);
        roomDescriptionBuilder.add(DescriptionState.getDescriptionOfWeather(perceiver, frame));
        this.appendRelativePositionDescriptionToDoc(perceiver, frame, roomDescriptionBuilder);
        doc.appendSentences(roomDescriptionBuilder.build());
        this.appendDescriptionOfObjects(perceiver, containingRoom, frame, doc);
        doc.appendSentences(Nlg.literalSentences("\n"));
        this.appendDescriptionOfExits(perceiver, frame, positionState, containingRoom, doc);
        return doc.build();
    }

    private Sentences asPerceivedByWithinSurroundingParent(Perceiver perceiver, Noun surroundingNoun, Frame frame) {
        PositionState positionState = PositionState.get(frame);
        SimpleDocument.Builder doc = SimpleDocument.builder();
        MultipleSentences.Builder surroundingDescriptionBuilder = MultipleSentences.builder();
        surroundingDescriptionBuilder.add(perceiver.getVerbosePerceptionOf(surroundingNoun, frame));
        this.appendRelativePositionDescriptionToDoc(perceiver, frame, surroundingDescriptionBuilder);
        doc.appendSentences(surroundingDescriptionBuilder.build());
        this.appendDescriptionOfObjects(perceiver, surroundingNoun, frame, doc);
        Noun oustideNoun = StructureState.getSurroundParentOrRoot(surroundingNoun, frame);
        if (oustideNoun != null) {
            doc.appendSentences(Nlg.literalSentences("\n"));
            this.appendDescriptionOfExits(perceiver, frame, positionState, surroundingNoun, doc);
        }
        return doc.build();
    }

    private void appendDescriptionOfScenery(Perceiver perceiver, Frame frame, Noun containingRoom, MultipleSentences.Builder roomDescriptionBuilder) {
        if (this.direction != null) {
            roomDescriptionBuilder.add(SceneryState.getSceneryDescription(perceiver, this.direction, frame));
        }
    }

    private void appendDescriptionOfExits(Perceiver perceiver, Frame frame, PositionState positionState, Noun containingRoom, SimpleDocument.Builder doc) {
        DescriptionState descriptionState = DescriptionState.get(frame);
        Map<SpacialRelationship, PathSegment> directionSegmentMap = positionState.getExits(containingRoom);
        this.appendExitDescriptionsToDoc(directionSegmentMap, doc, frame, perceiver);
    }

    private void appendDescriptionOfObjects(Perceiver perceiver, Noun roomOrSurroundingNoun, Frame frame, SimpleDocument.Builder doc) {
        Set<Noun> nounsInRoom = this.getObjectsToReveal(perceiver, roomOrSurroundingNoun, frame);
        List nounPhrases = nounsInRoom.stream().filter(noun -> noun != this.player).map(noun -> perceiver.getPerceptionOf((Noun)noun, frame)).filter(nounPhrase -> nounPhrase != null).collect(Collectors.toList());
        GroupedCollectionNounPhrase objectsNounPhrase = GroupedCollectionNounPhrase.create(nounPhrases);
        if (objectsNounPhrase != null) {
            ThereExistsClause thereExistsClause = new ThereExistsClause(objectsNounPhrase);
            IndependentWithAdverbialClause fullSentenceClause = IndependentWithAdverbialClause.createInverted(thereExistsClause, new PureAdverbialClause("here"));
            SingleClauseSentence thereExistsSentences = new SingleClauseSentence(fullSentenceClause);
            doc.appendSentencesOnNewLine(thereExistsSentences);
        }
    }

    private void appendExitDescriptionsToDoc(Map<SpacialRelationship, PathSegment> directionSegmentMap, SimpleDocument.Builder doc, Frame frame, Perceiver perceiver) {
        if (directionSegmentMap == null) {
            return;
        }
        Directions directions = Directions.get(frame);
        Set<SpacialRelationship> remainingExits = directionSegmentMap.keySet();
        List<Noun> allDirections = directions.getAll();
        for (Noun direction : allDirections) {
            SpacialRelationship srDirection = SpacialRelationship.of(direction);
            if (!remainingExits.contains(srDirection)) continue;
            this.appendExitDescriptionForDirection(srDirection, directionSegmentMap, doc, frame, perceiver, directions);
            remainingExits.remove(srDirection);
        }
        remainingExits.forEach(spacialRelationship -> this.appendExitDescriptionForDirection((SpacialRelationship)spacialRelationship, directionSegmentMap, doc, frame, perceiver, directions));
    }

    private void appendExitDescriptionForDirection(SpacialRelationship spacialRelationship, Map<SpacialRelationship, PathSegment> directionSegmentMap, SimpleDocument.Builder doc, Frame frame, Perceiver perceiver, Directions directions) {
        this.appendExitDescriptionToDoc(spacialRelationship, directionSegmentMap.get(spacialRelationship), doc, frame, perceiver);
    }

    private void appendExitDescriptionToDoc(SpacialRelationship spacialRelationship, PathSegment pathSegment, SimpleDocument.Builder doc, Frame frame, Perceiver perceiver) {
        NounPhrase exitDescription = DescriptionState.get(frame).getPathSegmentAsPerceivedBy(perceiver, pathSegment, frame);
        if (exitDescription != null) {
            String directionString = spacialRelationship.isDirection() ? perceiver.getPerceptionOf(spacialRelationship.getDirection(), frame).toString() : spacialRelationship.getPreposition().toString();
            doc.appendSentencesOnNewLine(Nlg.literalSentences(directionString + StringUtils.repeat(" ", 5 - directionString.length()) + " - " + NounPhraseWithArticle.a(exitDescription) + "."));
        }
    }

    private void appendRelativePositionDescriptionToDoc(Perceiver perceiver, Frame frame, MultipleSentences.Builder roomDescriptionBuilder) {
        PositionState positionState = PositionState.get(frame);
        Noun spot = positionState.getParent(perceiver);
        StructureState structureState = StructureState.get(frame);
        if (structureState.isIntegral(spot)) {
            return;
        }
        if (positionState.getParent(spot) == null) {
            return;
        }
        Preposition preposition = positionState.getPreposition(perceiver);
        if (preposition == null) {
            return;
        }
        NounPhrase perceptionOfSpot = perceiver.getPerceptionOf(spot, frame);
        if (perceptionOfSpot == null) {
            return;
        }
        NounPhraseWithAdjective atASpot = new NounPhraseWithAdjective(Nlg.pureAdjective(preposition.toString()), NounPhraseWithArticle.a(perceptionOfSpot));
        Sentences sentences = Nlg.simpleSentence(Pronouns.You, Verbs.toBe, atASpot);
        roomDescriptionBuilder.add(sentences);
    }

    private Set<Noun> getObjectsToReveal(Perceiver perceiver, Noun roomOrSurroundingNoun, Frame frame) {
        return PlayerExaminesSurroundingsEvent.getVisibleDescendentsOf(roomOrSurroundingNoun, frame);
    }

    private static Set<Noun> getVisibleDescendentsOf(Noun noun, Frame frame) {
        HashSet<Noun> descendents = new HashSet<Noun>();
        PlayerExaminesSurroundingsEvent.accumulateVisibleDescendentsOf(noun, frame, descendents);
        return descendents;
    }

    private static void accumulateVisibleDescendentsOf(Noun noun, Frame frame, Set<Noun> descendents) {
        Set<Noun> childrenOfNoun = PositionState.get(frame).getChildren(noun);
        if (childrenOfNoun == null) {
            return;
        }
        StructureState structure = StructureState.get(frame);
        DescriptionState descriptionState = DescriptionState.get(frame);
        for (Noun child : childrenOfNoun) {
            if (!structure.isIntegral(child)) {
                descendents.add(child);
            }
            if (!descriptionState.shouldDescribeChildrenInOverview(child)) continue;
            PlayerExaminesSurroundingsEvent.accumulateVisibleDescendentsOf(child, frame, descendents);
        }
    }
}

