/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.events.status;

import com.fabriziopolo.textcraft.nlg.MultipleSentences;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.characterbio.energy.EnergyState;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.characterbio.hunger.HungerState;
import com.fabriziopolo.textcraft.states.characterbio.hydration.HydrationState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureState;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.text.BarNumberRenderer;
import com.fabriziopolo.textcraft.text.TextTableBuilder;
import java.text.DecimalFormat;

public class PlayerExaminesStatusEvent
implements Event {
    private final Noun player;

    public PlayerExaminesStatusEvent(Noun player) {
        this.player = player;
    }

    @Override
    public Sentences asPerceivedBy(Perceiver perceiver, Frame frame, PerceptionChannel channel) {
        MultipleSentences.Builder builder = MultipleSentences.builder();
        if (perceiver != this.player) {
            return null;
        }
        Double energy = EnergyState.get(frame).getValue(this.player);
        Double maxEnergy = EnergyState.get(frame).getMaxEnergy(this.player, frame);
        Double health = HealthState.get(frame).getValue(this.player);
        Double hunger = HungerState.get(frame).getValue(this.player);
        Double thirst = HydrationState.get(frame).getValue(this.player);
        Double temperature = TemperatureState.getTemperatureAt(this.player, frame).getFlexibleValue();
        TextTableBuilder table = new TextTableBuilder();
        this.addColumnsToBioStatTable(table);
        if (energy != null) {
            this.addRowToBioStatTable("Energy", EnergyState.getEnergyDescription(energy), this.formatValueForDisplay(energy, maxEnergy), table);
        }
        if (health != null) {
            this.addRowToBioStatTable("Health", HealthState.getHealthDescription(health), this.formatValueForDisplay(health, 1.0), table);
        }
        if (hunger != null) {
            this.addRowToBioStatTable("Food", HungerState.getHungerDescription(hunger), this.formatValueForDisplay(hunger, 1.0), table);
        }
        if (thirst != null) {
            this.addRowToBioStatTable("Water", HydrationState.getHydrationDescription(thirst), this.formatValueForDisplay(thirst, 1.0), table);
        }
        this.addRowToBioStatTable("Temp", "", TemperatureState.getTemperatureDescription(temperature) + " - " + this.mapTemperatureForDisplay(temperature), table);
        builder.add(Nlg.literalSentences(table.build()));
        builder.add(TimeState.get(frame).getTimeOfDayDescriptionSentences());
        double x = this.convertHeatToScore(temperature);
        double feeling = Math.min(energy, Math.min(health, Math.min(hunger, Math.min(thirst, this.convertHeatToScore(temperature)))));
        Sentences feelingSentences = feeling < 0.1 ? Nlg.literalSentences("You feel like death.") : (feeling < 0.3 ? Nlg.literalSentences("You feel horrible.") : (feeling < 0.4 ? Nlg.literalSentences("You feel awful.") : (feeling < 0.5 ? Nlg.literalSentences("You feel unwell.") : (feeling < 0.7 ? Nlg.literalSentences("You feel ok.") : (feeling < 0.8 ? Nlg.literalSentences("You feel good.") : (feeling < 0.9 ? Nlg.literalSentences("You feel great.") : Nlg.literalSentences("You feel fantastic.")))))));
        builder.add(feelingSentences);
        return builder.build();
    }

    private void addColumnsToBioStatTable(TextTableBuilder table) {
        table.addColumnFormatter(TextTableBuilder.RIGHT_JUSTIFIED);
        table.addColumnFormatter(TextTableBuilder.LEFT_JUSTIFIED);
    }

    private void addRowToBioStatTable(String category, String description, String value, TextTableBuilder table) {
        table.addRow();
        table.addCell(category + " - ");
        table.addCell(value);
    }

    private String formatValueForDisplay(double value, double maxValue) {
        return new BarNumberRenderer().render(value, maxValue);
    }

    private String mapTemperatureForDisplay(double temp) {
        double estimatedTemp;
        double zeroTemp = 75.0;
        if (temp < 0.0) {
            double exp = 1.0;
            double absTemp = -temp;
            estimatedTemp = -Math.pow(absTemp, exp) * (50.0 / Math.pow(5.0, exp)) + zeroTemp;
        } else {
            double exp = 1.5;
            estimatedTemp = Math.pow(temp, exp) * (45.0 / Math.pow(5.0, exp)) + zeroTemp;
        }
        return "Feels like " + new DecimalFormat("0;-0").format(estimatedTemp) + "\u00b0" + "F";
    }

    private double convertHeatToScore(double heat) {
        return 1.0 - Math.abs(heat) * 0.2;
    }
}

