/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.SingleClauseSentence;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class MultipleSentences
implements Sentences {
    private final List<Sentences> sentencesList;

    private MultipleSentences(Builder builder) {
        this(builder.sentencesList);
    }

    public MultipleSentences(Sentences ... sentences) {
        this(Arrays.asList(sentences));
    }

    public MultipleSentences(Collection<Sentences> sentencesList) {
        this.sentencesList = sentencesList.stream().filter(sentence -> sentence != null).collect(Collectors.toList());
    }

    public String toString() {
        if (this.sentencesList.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.sentencesList.size() - 1; ++i) {
            Sentences sentence = this.sentencesList.get(i);
            String sentenceStr = sentence.toString();
            builder.append(sentenceStr);
            if (sentenceStr.length() <= 0 || sentenceStr.charAt(sentenceStr.length() - 1) != '.') continue;
            builder.append("  ");
        }
        builder.append(this.sentencesList.get(this.sentencesList.size() - 1).toString());
        return builder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<Sentences> sentencesList = new ArrayList<Sentences>();

        public Builder add(Sentences sentences) {
            if (sentences != null) {
                this.sentencesList.add(sentences);
            }
            return this;
        }

        public Builder add(IndependentClause clause) {
            if (clause != null) {
                this.sentencesList.add(SingleClauseSentence.create(clause));
            }
            return this;
        }

        public MultipleSentences build() {
            return new MultipleSentences(this);
        }
    }
}

