/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.objects;

import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.description.DescriptionState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.room.RoomState;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.worldbuilder.WorldBuilder;

public class RoomFactory
extends WorldBuilder {
    public RoomFactory(Simulation simulation) {
        super(simulation);
    }

    private Noun createSimple(String nounPhraseAutoDescription, String verboseDescription, String nounPhraseAutoDescriptionDark, String verboseDescriptionDark) {
        return this.createSimple(nounPhraseAutoDescription, verboseDescription, nounPhraseAutoDescriptionDark, verboseDescriptionDark, nounPhraseAutoDescriptionDark, verboseDescriptionDark);
    }

    private Noun createSimple(String nounPhraseAutoDescription, String verboseDescription, String nounPhraseAutoDescriptionDark, String verboseDescriptionDark, String nounPhraseAutoDescriptionBlind, String verboseDescriptionBlind) {
        SimpleNoun room = SimpleNoun.autoBuilder().setDescription(verboseDescription, nounPhraseAutoDescription, "rooms", new String[0]).setDarkDescription(verboseDescriptionDark, nounPhraseAutoDescriptionDark, "rooms", new String[0]).setBlindDescription(verboseDescriptionBlind, nounPhraseAutoDescriptionBlind, "rooms", new String[0]).build();
        return room;
    }

    public Noun roomWithFloor(String autoNounPhrase, String verboseDescription, String autoNounPhraseDark, String verboseDescriptionDark, Noun floor) {
        Noun roomNoun = this.createSimple(autoNounPhrase, verboseDescription, autoNounPhraseDark, verboseDescriptionDark);
        this.addFloorToRoom(roomNoun, floor);
        return roomNoun;
    }

    public Noun roomWithFloor(Noun roomNoun, Noun floor) {
        this.addFloorToRoom(roomNoun, floor);
        return roomNoun;
    }

    public void addFloorToRoom(Noun roomNoun, Noun floorNoun) {
        if (floorNoun == null) {
            return;
        }
        PositionState.requestPut(floorNoun, Prepositions.in, Prepositions.at, roomNoun, this.simulation);
        StructureState.requestMakeIntegral(floorNoun, this.simulation);
        DescriptionState.requestDescribeChildrenInOverview(floorNoun, this.simulation);
        RoomState.requestFloorUpdate(roomNoun, floorNoun, this.simulation);
        this.makeEntrance(floorNoun, Prepositions.on);
    }
}

