/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.simulation;

import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.FrameBuilder;
import com.fabriziopolo.textcraft.simulation.NextFrameBuilder;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import com.fabriziopolo.textcraft.simulation.UpdateParameters;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;

public class SinglePlayerSimulation
implements Simulation,
Serializable {
    public final Player player;
    public final UpdateParameters updateParameters;
    public final Random random;
    private Frame currentFrame;
    private FrameBuilder frameBuilder = new FrameBuilder();
    private NextFrameBuilder nextFrameBuilder = new NextFrameBuilder();

    public SinglePlayerSimulation(Frame initialFrame, Player player, UpdateParameters parameters, Random random) {
        this.currentFrame = Objects.requireNonNull(initialFrame);
        this.player = Objects.requireNonNull(player);
        this.updateParameters = Objects.requireNonNull(parameters);
        this.random = Objects.requireNonNull(random);
    }

    @Override
    public synchronized boolean update() {
        this.frameBuilder.addAll(this.nextFrameBuilder);
        this.nextFrameBuilder = new NextFrameBuilder();
        this.currentFrame = this.frameBuilder.build(this);
        this.frameBuilder = new FrameBuilder();
        return false;
    }

    @Override
    public synchronized Frame getCurrentFrame() {
        return this.currentFrame;
    }

    @Override
    public synchronized List<StateChangeRequest> getStateChangeRequests(Class stateClass) {
        List<StateChangeRequest> objects = this.frameBuilder.stateChangeRequests.get(stateClass);
        if (objects == null) {
            return new ArrayList<StateChangeRequest>();
        }
        return objects;
    }

    @Override
    public synchronized UpdateParameters getUpdateParameters() {
        return this.updateParameters;
    }

    @Override
    public synchronized void requestStateChange(Class stateClass, StateChangeRequest changeRequest) {
        this.nextFrameBuilder.requestStateChange(stateClass, changeRequest);
    }

    @Override
    public synchronized void postEvent(Event event) {
        this.frameBuilder.postEvent(event);
    }

    @Override
    public Random getRandom() {
        return this.random;
    }
}

