/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.ValueProvider;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;

public abstract class ValueProviderState<V, A>
extends ValueState<ValueProvider<V, A>> {
    private final V defaultValue;

    protected ValueProviderState() {
        this(null);
    }

    protected ValueProviderState(V defaultValue) {
        this.defaultValue = defaultValue;
    }

    public V get(Noun noun, A args, Frame frame) {
        ValueProvider provider = (ValueProvider)this.get(noun);
        if (provider == null) {
            return this.defaultValue;
        }
        return (V)provider.get(noun, args, frame);
    }

    @Override
    protected final ValueProvider<V, A> combineValues(Noun noun, ValueProvider<V, A> t1, ValueProvider<V, A> t2, Simulation simulation) {
        return t2;
    }

    @Override
    protected void setUpdatedState(Simulation simulation, ValueState<ValueProvider<V, A>> newStateBuilder) {
        super.setUpdatedState(simulation, newStateBuilder);
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(this.getStateKey());
        builder.addLine("valueProvider", this.get(noun));
        try {
            builder.addLine("value", this.get(noun) == null ? null : ((ValueProvider)this.get(noun)).get(noun, null, frame));
        }
        catch (Exception ex) {
            builder.addLine("value", "<FAILED TO GET VALUE>");
        }
        return builder.toString();
    }

    @Override
    public void requestChange(Simulation simulation, Noun noun, V value) {
        ChangeRequest request = new ChangeRequest(noun, value);
        simulation.requestStateChange(this.getStateKey(), request);
    }

    protected static final class ChangeRequest<R, A>
    extends ValueState.ChangeRequest<ValueProvider<R, A>> {
        public ChangeRequest(Noun noun, ValueProvider<R, A> provider) {
            super(noun, provider);
        }

        public ChangeRequest(Noun noun, R value) {
            super(noun, new PureValueProvider(value));
        }
    }

    private static final class PureValueProvider<R, A>
    implements ValueProvider<R, A> {
        private final R value;

        private PureValueProvider(R value) {
            this.value = value;
        }

        @Override
        public R get(Noun noun, A args, Frame frame) {
            return this.value;
        }

        public String toString() {
            return "Pure(" + this.value + ")";
        }
    }
}

