/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.coordinate;

import java.io.Serializable;

public class Coordinates
implements Serializable {
    public final double x;
    public final double y;

    public Coordinates(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Coordinates) {
            Coordinates coord = (Coordinates)obj;
            return this.x == coord.x && this.y == coord.y;
        }
        return false;
    }

    public String toString() {
        return "Coordinates(" + this.x + ", " + this.y + ")";
    }

    public static double distanceBetwween(Coordinates a, Coordinates b) {
        if (a == null) {
            return Double.MAX_VALUE;
        }
        return a.distanceTo(b);
    }

    public double distanceTo(Coordinates other) {
        if (other == null) {
            return Double.MAX_VALUE;
        }
        return Math.abs(other.x - this.x) + Math.abs(other.y - this.y);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

