/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.inventory;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.inventory.InventoryStateChangeRequest;

public class UnwieldRequest
implements InventoryStateChangeRequest {
    private final Perceiver who;

    public UnwieldRequest(Perceiver who) {
        this.who = who;
    }

    @Override
    public void apply(InventoryState.Builder builder, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        Noun wieldedItem = InventoryState.get(frame).getWieldedItem(this.who);
        if (wieldedItem != null) {
            builder.unWield(this.who);
            NounPhrase perceptionOfItem = wieldedItem.getDefaultPerception(frame);
            PlayerNotificationEvent.post((Noun)this.who, simulation, "You put away your " + perceptionOfItem + ".");
        } else {
            PlayerNotificationEvent.post((Noun)this.who, simulation, "You aren't wielding anything.");
        }
    }

    public static void request(Perceiver who, Simulation simulation) {
        simulation.requestStateChange(InventoryState.class, new UnwieldRequest(who));
    }
}

