/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.notification;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import com.fabriziopolo.textcraft.states.notification.Notification;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;
import com.fabriziopolo.textcraft.states.notification.NotificationStateBuilder;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import com.fabriziopolo.textcraft.utils.Lockable;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NotificationState
extends Lockable
implements State {
    protected final Map<Noun, Map<NotificationKey, TimedNotification>> notifications = new HashMap<Noun, Map<NotificationKey, TimedNotification>>();

    private NotificationState getUpdatedNotificationState(Simulation simulation) {
        NotificationStateBuilder builder = NotificationState.builder();
        Instant now = Instant.now();
        NotificationStateBuilder aux = NotificationState.builder();
        List<Notification> newNotifications = NotificationState.getPostedNotifications(simulation);
        newNotifications.forEach(notification -> aux.putUnnotified((Notification)notification));
        NotificationState auxState = aux.build();
        this.notifications.entrySet().forEach(nounMapKv -> ((Map)nounMapKv.getValue()).entrySet().forEach(keyNotificationKv -> {
            Noun player = (Noun)nounMapKv.getKey();
            NotificationKey key = (NotificationKey)keyNotificationKv.getKey();
            TimedNotification timedNotification = (TimedNotification)keyNotificationKv.getValue();
            if (timedNotification.isExpired(now)) {
                return;
            }
            if (auxState.containsKey(player, key)) {
                return;
            }
            if (timedNotification.isTimeToNotify(now)) {
                NotificationState.notifyPlayer(timedNotification.notification, simulation);
                builder.putNotified(timedNotification.notification, timedNotification);
            } else {
                builder.putTimedNotification(timedNotification);
            }
        }));
        newNotifications.forEach(notification -> {
            TimedNotification maybeExistingTn = this.get(notification.player, notification.key);
            if (maybeExistingTn == null) {
                NotificationState.notifyPlayer(notification, simulation);
                builder.putNotified((Notification)notification);
                return;
            }
            if (maybeExistingTn.getMessage().equals(notification.message)) {
                if (maybeExistingTn.isTimeToNotify(now)) {
                    NotificationState.notifyPlayer(notification, simulation);
                    builder.putNotified((Notification)notification);
                } else {
                    builder.putUpdated((Notification)notification, maybeExistingTn);
                }
            } else {
                if (notification.notifyOnMessageChange) {
                    NotificationState.notifyPlayer(notification, simulation);
                }
                builder.putNotified((Notification)notification);
            }
        });
        return builder.build();
    }

    private static void notifyPlayer(Notification notification, Simulation simulation) {
        PlayerNotificationEvent.post(notification.style, notification.player, simulation, notification.message);
    }

    private boolean containsKey(Noun player, NotificationKey key) {
        if (!this.notifications.containsKey(player)) {
            return false;
        }
        return this.notifications.get(player).containsKey(key);
    }

    private TimedNotification get(Noun player, NotificationKey key) {
        if (!this.notifications.containsKey(player)) {
            return null;
        }
        return this.notifications.get(player).get(key);
    }

    public static NotificationState get(Frame frame) {
        return (NotificationState)frame.states.get(NotificationState.class);
    }

    @Override
    public State updateState(Simulation simulation) {
        return this.getUpdatedNotificationState(simulation);
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(NotificationState.class);
        builder.addLine("notifications", this.notifications.get(noun));
        return builder.toString();
    }

    private static List<Notification> getPostedNotifications(Simulation simulation) {
        List<StateChangeRequest> stateChangeRequests = simulation.getStateChangeRequests(NotificationState.class);
        if (stateChangeRequests == null) {
            return new ArrayList<Notification>();
        }
        return stateChangeRequests.stream().map(obj -> (Notification)obj).collect(Collectors.toList());
    }

    public static void post(Simulation simulation, Notification notification) {
        simulation.requestStateChange(NotificationState.class, notification);
    }

    public static void post(String message, Noun player, NotificationKey key, Simulation simulation) {
        NotificationState.post(simulation, new Notification(message, player, key));
    }

    public static NotificationStateBuilder builder() {
        return new NotificationStateBuilder();
    }

    private static List<Notification> dedupNotifcationList(List<Notification> notifications) {
        if (notifications == null || notifications.isEmpty()) {
            return notifications;
        }
        Noun player = notifications.get((int)0).player;
        HashMap dedupMap = new HashMap();
        notifications.forEach(notification -> {
            assert (player == notification.player);
            if (dedupMap.containsKey(notification.key)) {
                System.out.println("DUPLICATE NOTIFICATION KEY: " + notification.key);
            }
            dedupMap.put(notification.key, notification);
        });
        return dedupMap.values().stream().collect(Collectors.toList());
    }

    protected static final class TimedNotification
    implements Serializable {
        protected final Instant creationTime;
        protected final Notification notification;
        protected final Instant lastNotificationTime;

        protected String getMessage() {
            return this.notification.message;
        }

        private TimedNotification(Instant creationTime, Notification notification, Instant lastNotificationTime) {
            this.creationTime = creationTime;
            this.notification = notification;
            this.lastNotificationTime = lastNotificationTime;
        }

        protected static TimedNotification createUnnotified(Notification notification) {
            return new TimedNotification(Instant.now(), notification, Instant.MIN);
        }

        protected static TimedNotification createUpdated(Notification notification, TimedNotification tn) {
            return new TimedNotification(Instant.now(), notification, tn.lastNotificationTime);
        }

        protected static TimedNotification createNotified(Notification notification) {
            Instant now = Instant.now();
            return new TimedNotification(now, notification, now);
        }

        protected static TimedNotification createNotified(Notification notification, TimedNotification tn) {
            Instant now = Instant.now();
            return new TimedNotification(tn.creationTime, notification, now);
        }

        protected boolean isExpired(Instant now) {
            return Duration.between(this.creationTime, now).getSeconds() > this.notification.duration;
        }

        protected boolean isTimeToNotify(Instant now) {
            if (!this.notification.notifyPeriodically) {
                return false;
            }
            return Duration.between(this.lastNotificationTime, now).getSeconds() >= this.notification.interval;
        }

        protected TimedNotification asNotifiedAt(Instant lastNotificationTime) {
            return new TimedNotification(this.creationTime, this.notification, lastNotificationTime);
        }

        protected TimedNotification asCreatedAt(Instant createdAt) {
            return new TimedNotification(createdAt, this.notification, this.lastNotificationTime);
        }
    }
}

