/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.position.PositionState;
import java.util.Set;

public class AbstractTreeAlgorithm {
    protected boolean onRoot(Noun root, Frame frame) {
        return true;
    }

    protected boolean onParent(Noun parent, Set<Noun> children, Frame frame) {
        return true;
    }

    protected boolean onComplete(Noun root, Frame frame) {
        return true;
    }

    protected boolean onChild(Noun child, Noun parent, Frame frame) {
        return true;
    }

    public final void traverseDepthFirst(Noun root, Frame frame) {
        if (!this.onRoot(root, frame)) {
            return;
        }
        this.internalTraverseDepthFirst(root, frame);
        this.onComplete(root, frame);
    }

    private void internalTraverseDepthFirst(Noun parent, Frame frame) {
        PositionState positions = PositionState.get(frame);
        Set<Noun> children = positions.getChildren(parent);
        if (!this.onParent(parent, children, frame)) {
            return;
        }
        if (children != null) {
            for (Noun child : children) {
                if (!this.onChild(child, parent, frame)) {
                    return;
                }
                this.internalTraverseDepthFirst(child, frame);
            }
        }
    }
}

