/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position.updates;

import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.droppable.DropHandler;
import com.fabriziopolo.textcraft.states.droppable.DroppableState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.PositionUpdateRequest;

public class DropObjectPositionUpdateRequest
implements PositionUpdateRequest {
    public static final DropHandler DEFAULT_DROP_HANDLER = new DropHandler(){};
    public final Noun player;
    public final Noun object;

    private DropObjectPositionUpdateRequest(Noun player, Noun object) {
        this.player = player;
        this.object = object;
    }

    @Override
    public void apply(PositionStateBuilder partialState, Simulation simulation) {
        this.getDropHandler(simulation.getCurrentFrame()).onDrop(this.player, this.object, simulation, partialState);
    }

    private DropHandler getDropHandler(Frame frame) {
        DropHandler dropHandler = DroppableState.get(frame).get(this.object);
        if (dropHandler != null) {
            return dropHandler;
        }
        return DEFAULT_DROP_HANDLER;
    }

    public static void post(Noun player, Noun objectToDrop, Simulation simulation) {
        simulation.requestStateChange(PositionState.class, new DropObjectPositionUpdateRequest(player, objectToDrop));
    }

    public static void post(Noun objectToDrop, Command.Context context) {
        DropObjectPositionUpdateRequest.post(context.player, objectToDrop, context.simulation);
    }
}

