/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.singleplayer;

import com.fabriziopolo.textcraft.events.end.EndGameEvent;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import java.util.List;

public final class EndGameState
implements State {
    private boolean ended = false;

    @Override
    public State updateState(Simulation simulation) {
        List<StateChangeRequest> reqs = simulation.getStateChangeRequests(EndGameState.class);
        if (!reqs.isEmpty()) {
            this.ended = true;
            StringBuilder messageBuilder = new StringBuilder();
            Event.Style style = Event.Style.DEFAULT;
            for (StateChangeRequest req : reqs) {
                EndGameRequest request;
                String msg;
                if (!(req instanceof EndGameRequest) || (msg = (request = (EndGameRequest)req).getMessage()) == null) continue;
                messageBuilder.append(msg);
                style = Event.Style.combine(style, request.getStyle());
            }
            String message = messageBuilder.toString();
            if (!message.isEmpty()) {
                simulation.postEvent(new EndGameEvent(message, style));
            }
        }
        return this;
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        return null;
    }

    public static void requestEndGame(Simulation simulation) {
        simulation.requestStateChange(EndGameState.class, new EndGameRequest());
    }

    public static void requestEndGame(Simulation simulation, String message) {
        simulation.requestStateChange(EndGameState.class, new EndGameRequest(message, Event.Style.PROMINENT));
    }

    public static void requestEndGamePage(Simulation simulation, String message) {
        simulation.requestStateChange(EndGameState.class, new EndGameRequest(message, Event.Style.PROMINENT_PAGE));
    }

    public static boolean isGameEnded(Frame frame) {
        return EndGameState.get((Frame)frame).ended;
    }

    private static EndGameState get(Frame frame) {
        return (EndGameState)frame.states.get(EndGameState.class);
    }

    private static final class EndGameRequest
    implements StateChangeRequest {
        private final String message;
        private final Event.Style style;

        private EndGameRequest() {
            this(null, null);
        }

        private EndGameRequest(String message, Event.Style style) {
            this.message = message;
            this.style = style;
        }

        private String getMessage() {
            return this.message;
        }

        public Event.Style getStyle() {
            return this.style;
        }
    }
}

