/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.alphaisland.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.text.TextTableBuilder;

public class CreditsCommand
implements Command {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length != 1) {
            return null;
        }
        if (!words[0].toLowerCase().equals("credits")) {
            return null;
        }
        ActionsAndHints result = new ActionsAndHints();
        result.addAction(new DisplayCreditsAction(context));
        return result;
    }

    @Override
    public String getHelpString() {
        return "Type 'credits' to display the credits for Alpha Island.";
    }

    @Override
    public String getNameString() {
        return "credits";
    }

    @Override
    public String getPurposeString() {
        return "Display the credits.";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    public static String getCredits() {
        TextTableBuilder builder = new TextTableBuilder().addColumnFormatter(TextTableBuilder.LEFT_JUSTIFIED).addColumnFormatter(TextTableBuilder.RIGHT_JUSTIFIED).addColumnFormatter(TextTableBuilder.LEFT_JUSTIFIED).addColumnFormatter(TextTableBuilder.LEFT_JUSTIFIED);
        CreditsCommand.addCredit(builder, "TextCraft engine", "Fabrizio Polo");
        CreditsCommand.addCredit(builder, "Alpha Island game", "Fabrizio Polo");
        CreditsCommand.addCredit(builder, "play testing", "Skylar Castator");
        CreditsCommand.addCredit(builder, "play testing", "Travis Spaid");
        CreditsCommand.addCredit(builder, "play testing", "Angelo Polo");
        CreditsCommand.addCredit(builder, "play testing", "Michael Twilla (last and also least)");
        CreditsCommand.addCredit(builder, "islands, survival, and games", "Skylar Castator");
        CreditsCommand.addCredit(builder, "inspiration", "Quentin Michelet");
        CreditsCommand.addCredit(builder, "morale", "Carly Williamson");
        CreditsCommand.addCredit(builder, "ASCII art", "Joan G Stark");
        return builder.build().toString();
    }

    private static void addCredit(TextTableBuilder builder, String title, String name) {
        builder.addRow().addCell("    ").addCell(title).addCell(" -- ").addCell(name);
    }

    private static final class DisplayCreditsAction
    implements UserAction {
        private final Command.Context context;

        private DisplayCreditsAction(Command.Context context) {
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to display the credits for TextCraft: Alpha Island";
        }

        @Override
        public void execute(TextAppController controller) {
            PlayerNotificationEvent.postAlwaysPerceivable(this.context.player, CreditsCommand.getCredits(), Event.Style.PROMINENT_PAGE, this.context.simulation);
        }
    }
}

