/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.capabilities;

import com.fabriziopolo.textcraft.states.capability.CapabilityImpl;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.timecraft.capabilities.DryCapability;

public final class ResourceCapabilities {
    public static final VerticalStructure MINOR_VERTICAL_STRUCTURE = new VerticalStructure(0.0);
    public static final BeamStructure MINOR_BEAM_STRUCTURE = new BeamStructure(0.0);
    public static final BeamStructure BEAM_STRUCTURE = new BeamStructure(1.0);
    public static final RoofStructure MINOR_ROOF_STRUCTURE = new RoofStructure(0.0);
    public static final BladeMaterial BLADE_MATERIAL = new BladeMaterial(1.0);
    public static final BladeMaterial MINOR_BLADE_MATERIAL = new BladeMaterial(0.0);
    public static final Blade BLADE = new Blade(1.0);
    public static final HandleMaterial HANDLE_MATERIAL = new HandleMaterial(0.0);
    public static final BindingMaterial COSMETIC_BINDING_MATEIRAL = new BindingMaterial(0.0);
    public static final BindingMaterial BINDING_MATEIRAL = new BindingMaterial(1.0);
    public static final RigidWeavableMaterial WEAVABLE_MATERIAL = new RigidWeavableMaterial();
    public static final Burnable BURNABLE_MATERIAL = new Burnable(0.0);
    public static final Tinder TINDER_MATERIAL = new Tinder(10.0);
    public static final Burnable SMALL_BURNABLE_MATERIAL = new Burnable(180.0);
    public static final Burnable LARGE_BURNABLE_MATERIAL = new Burnable(600.0);
    public static final Fabric MINOR_FABRIC_MATERIAL = new Fabric(0.0);
    public static final Fabric FABRIC_MATERIAL = new Fabric(1.0);
    public static final BraCupMaterial BRA_CUP_MATERIAL = new BraCupMaterial();
    public static final Fabric LIGHT_WOVEN_FABRIC_MATERIAL = ResourceCapabilities.createInsulatedFabricMaterial(FlexibleHeatUnit.create(0.0, 1.0, -0.5));
    public static final Fabric SMALL_GAME_FUR_MATERIAL = ResourceCapabilities.createInsulatedFabricMaterial(FlexibleHeatUnit.create(1.0, 1.0, -0.0));
    public static final Flerovium FLEROVIUM = new Flerovium();
    public static final RadioactiveFlerovium RADIOACTIVE_FLEROVIUM = new RadioactiveFlerovium();

    private ResourceCapabilities() {
    }

    public static final Fabric createInsulatedFabricMaterial(FlexibleHeatUnit insulationUnit) {
        return new Fabric(1.0, insulationUnit);
    }

    public static class RadioactiveFlerovium
    extends CapabilityImpl {
        public RadioactiveFlerovium() {
            super(0.0, "radiocative flerovium");
        }
    }

    public static class Flerovium
    extends CapabilityImpl {
        public Flerovium() {
            super(0.0, "flerovium");
        }
    }

    public static class BraCupMaterial
    extends CapabilityImpl {
        public BraCupMaterial() {
            super(0.0, "bra cup material");
        }
    }

    public static class Fabric
    extends CapabilityImpl {
        private final FlexibleHeatUnit insulationUnit;

        public Fabric(double rank) {
            super(rank, "fabric");
            this.insulationUnit = FlexibleHeatUnit.createNeutral();
        }

        public Fabric(double rank, FlexibleHeatUnit insulationUnit) {
            super(rank, "fabric");
            this.insulationUnit = insulationUnit;
        }

        public FlexibleHeatUnit getInsulationUnit() {
            return this.insulationUnit;
        }
    }

    public static class Burnable
    extends DryCapability {
        public Burnable(double fuelAmount) {
            super(fuelAmount, "burnable");
        }

        public double getFuelAmount() {
            return this.getRank();
        }
    }

    public static class Tinder
    extends Burnable {
        public Tinder(double fuelAmount) {
            super(fuelAmount);
        }

        @Override
        public String getNounDescription() {
            return "dry tinder";
        }
    }

    public static class RigidWeavableMaterial
    extends CapabilityImpl {
        public RigidWeavableMaterial() {
            super("rigid weavable material");
        }
    }

    public static class BindingMaterial
    extends CapabilityImpl {
        public BindingMaterial(double rank) {
            super(rank, "binding material");
        }
    }

    public static class HandleMaterial
    extends CapabilityImpl {
        public HandleMaterial(double rank) {
            super(rank, "handle material");
        }
    }

    public static class Blade
    extends CapabilityImpl {
        public Blade(double rank) {
            super(rank, "blade");
        }
    }

    public static class BladeMaterial
    extends CapabilityImpl {
        public BladeMaterial(double rank) {
            super(rank, "blade material");
        }
    }

    public static class RoofStructure
    extends CapabilityImpl {
        public RoofStructure(double rank) {
            super(rank, "roofing material");
        }
    }

    public static class BeamStructure
    extends CapabilityImpl {
        public BeamStructure(double rank) {
            super(rank, "supporting structure");
        }
    }

    public static class VerticalStructure
    extends CapabilityImpl {
        public VerticalStructure(double rank) {
            super(rank, "vertical support");
        }
    }
}

