/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.commands;

import com.fabriziopolo.textcraft.commands.AbstractCraftCommand;
import com.fabriziopolo.textcraft.commands.CraftCommand;
import com.fabriziopolo.textcraft.commands.InventoryItemCraftingDelegate;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.capability.Capability;
import com.fabriziopolo.timecraft.capabilities.ResourceCapabilities;
import com.fabriziopolo.timecraft.capabilities.ToolCapabilities;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.Serializable;
import java.util.List;

public final class Crafts
implements Serializable {
    private final Dsl dsl;
    private final Noun KNIFE_PROTOTYPE;
    private static final List<Capability> knifeResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.BLADE_MATERIAL, ResourceCapabilities.HANDLE_MATERIAL});
    private final Noun AXE_PROTOTYPE;
    private static final List<Capability> axeResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.BLADE, ResourceCapabilities.HANDLE_MATERIAL, ResourceCapabilities.BINDING_MATEIRAL});
    private final Noun BLADE_PROTOTYPE;
    private static final List<Capability> bladeResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.MINOR_BLADE_MATERIAL});
    private final Noun FISH_TRAP_PROTOTYPE;
    private static final List<Capability> fishTrapResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.WEAVABLE_MATERIAL});
    private final Noun BRA_PROTOTYPE;
    private static final List<Capability> braResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.BRA_CUP_MATERIAL});
    private final Noun BELT_PROTOTYPE;
    private static final List<Capability> beltResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.COSMETIC_BINDING_MATEIRAL});
    private final Noun MAT_PROTOTYPE;
    private static final List<Capability> matResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.WEAVABLE_MATERIAL.or(ResourceCapabilities.MINOR_FABRIC_MATERIAL)});
    private final Noun WOVEN_MATERIAL_PROTOTYPE;
    private static final List<Capability> wovenMaterialResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.WEAVABLE_MATERIAL});
    private final Noun HAT_PROTOTYPE;
    private static final List<Capability> hatResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.MINOR_FABRIC_MATERIAL});
    private final Noun COAT_PROTOTYPE;
    private static final List<Capability> coatResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.FABRIC_MATERIAL});
    private final Noun PANTS_PROTOTYPE;
    private static final List<Capability> pantsResourceRequirements = Arrays.asList(new Capability[]{ResourceCapabilities.FABRIC_MATERIAL});

    public Crafts(Simulation simulation) {
        this.dsl = new Dsl(simulation);
        this.KNIFE_PROTOTYPE = this.dsl.tools().knife();
        this.AXE_PROTOTYPE = this.dsl.tools().prototypeAxe();
        this.BLADE_PROTOTYPE = this.dsl.tools().prototypeBlade();
        this.FISH_TRAP_PROTOTYPE = this.dsl.tools().prototypeFishTrap();
        this.BRA_PROTOTYPE = this.dsl.clothes().bra();
        this.BELT_PROTOTYPE = this.dsl.clothes().belt();
        this.MAT_PROTOTYPE = this.dsl.clothes().mat();
        this.HAT_PROTOTYPE = this.dsl.clothes().hat();
        this.COAT_PROTOTYPE = this.dsl.clothes().prototypeCoat();
        this.PANTS_PROTOTYPE = this.dsl.clothes().prototypePants();
        this.WOVEN_MATERIAL_PROTOTYPE = this.dsl.clothes().prototypeWovenMaterial();
    }

    public CraftCommand knife() {
        return new CraftCommand(new CraftKnifeDelegate());
    }

    public CraftCommand axe() {
        return new CraftCommand(new CraftAxeDelegate());
    }

    public CraftCommand blade() {
        return new CraftCommand(new CraftBladeDelegate());
    }

    public CraftCommand fishTrap() {
        return new CraftCommand(new CraftFishTrapDelegate());
    }

    public CraftCommand bra() {
        return new CraftCommand(new CraftBraDelegate());
    }

    public CraftCommand belt() {
        return new CraftCommand(new CraftBeltDelegate());
    }

    public CraftCommand mat() {
        return new CraftCommand(new CraftMatDelegate());
    }

    public CraftCommand wovenMaterial() {
        return new CraftCommand(new CraftWovenMaterialDelegate());
    }

    public CraftCommand hat() {
        return new CraftCommand(new CraftHatDelegate());
    }

    public CraftCommand coat() {
        return new CraftCommand(new CraftCoatDelegate());
    }

    public CraftCommand pants() {
        return new CraftCommand(new CraftPantsDelegate());
    }

    private final class CraftPantsDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftPantsDelegate() {
            super(Crafts.this.PANTS_PROTOTYPE, pantsResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return new Dsl(result.context.simulation).clothes().pants(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft a " + Crafts.this.PANTS_PROTOTYPE.getContextFreeDescription() + " you will need a material like fabric, fur, or leather.";
        }
    }

    private final class CraftCoatDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftCoatDelegate() {
            super(Crafts.this.COAT_PROTOTYPE, coatResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return new Dsl(result.context.simulation).clothes().coat(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft a " + Crafts.this.COAT_PROTOTYPE.getContextFreeDescription() + " you will need a material like fabric, fur, or leather.";
        }
    }

    private final class CraftHatDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftHatDelegate() {
            super(Crafts.this.HAT_PROTOTYPE, hatResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return new Dsl(result.context.simulation).clothes().hat(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft a " + Crafts.this.HAT_PROTOTYPE.getContextFreeDescription() + " you will need a suitable material.";
        }
    }

    private final class CraftWovenMaterialDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftWovenMaterialDelegate() {
            super(Crafts.this.WOVEN_MATERIAL_PROTOTYPE, wovenMaterialResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return new Dsl(result.context.simulation).clothes().wovenMaterial(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft a " + Crafts.this.WOVEN_MATERIAL_PROTOTYPE.getContextFreeDescription() + " you will need something you can weave.";
        }
    }

    private final class CraftMatDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftMatDelegate() {
            super(Crafts.this.MAT_PROTOTYPE, matResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return new Dsl(result.context.simulation).clothes().mat(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft a " + Crafts.this.MAT_PROTOTYPE.getContextFreeDescription() + " you will need something you can weave.";
        }
    }

    private final class CraftBeltDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftBeltDelegate() {
            super(Crafts.this.BELT_PROTOTYPE, beltResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return new Dsl(result.context.simulation).clothes().belt(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft a " + Crafts.this.BELT_PROTOTYPE.getContextFreeDescription() + " you will need a suitable cord material.";
        }
    }

    private final class CraftBraDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftBraDelegate() {
            super(Crafts.this.BRA_PROTOTYPE, braResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return new Dsl(result.context.simulation).clothes().bra(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft a " + Crafts.this.BRA_PROTOTYPE.getContextFreeDescription() + " you will need a suitable cup material.";
        }
    }

    private final class CraftFishTrapDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftFishTrapDelegate() {
            super(Crafts.this.FISH_TRAP_PROTOTYPE, fishTrapResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return Crafts.this.dsl.tools().fishTrap(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft " + NounPhraseWithArticle.a(Crafts.this.FISH_TRAP_PROTOTYPE.getContextFreeDescription()) + " you will need something you can weave.";
        }
    }

    private final class CraftBladeDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftBladeDelegate() {
            super(Crafts.this.BLADE_PROTOTYPE, (List<Capability>)bladeResourceRequirements, ToolCapabilities.HAMMER);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return Crafts.this.dsl.tools().blade(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft " + NounPhraseWithArticle.a(Crafts.this.BLADE_PROTOTYPE.getContextFreeDescription()) + " you will need a suitable material and you will need to use a tool.  " + "For instance, 'craft damascus blade from hot iron with hammer'.";
        }
    }

    private final class CraftAxeDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftAxeDelegate() {
            super(Crafts.this.AXE_PROTOTYPE, axeResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return Crafts.this.dsl.tools().axe(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft " + NounPhraseWithArticle.a(Crafts.this.AXE_PROTOTYPE.getContextFreeDescription()) + " you will need a blade, something for the handle, and something " + "to bind the two together.  You will have to craft the blade separately.";
        }
    }

    private final class CraftKnifeDelegate
    extends InventoryItemCraftingDelegate {
        protected CraftKnifeDelegate() {
            super(Crafts.this.KNIFE_PROTOTYPE, knifeResourceRequirements);
        }

        @Override
        public Noun craftNewNoun(AbstractCraftCommand.ParseResult result) {
            return Crafts.this.dsl.tools().knife(result.adjective, result.resources);
        }

        @Override
        public String getHint() {
            return "If you want to craft a " + Crafts.this.KNIFE_PROTOTYPE.getContextFreeDescription() + " you will need something for the blade and something for the handle.";
        }
    }
}

