/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.game;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.Game;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.menu.SmartMenuLauncher;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.UpdateParameters;
import com.fabriziopolo.textcraft.states.capability.ResourceState;
import com.fabriziopolo.textcraft.states.capability.ToolState;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeState;
import com.fabriziopolo.textcraft.states.characterbio.energy.EnergyState;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.characterbio.hunger.HungerState;
import com.fabriziopolo.textcraft.states.characterbio.hydration.HydrationState;
import com.fabriziopolo.textcraft.states.characterbio.oxygen.OxygenState;
import com.fabriziopolo.textcraft.states.constants.Directions;
import com.fabriziopolo.textcraft.states.coordinate.CoordinateState;
import com.fabriziopolo.textcraft.states.description.DescriptionState;
import com.fabriziopolo.textcraft.states.description.ProminenceState;
import com.fabriziopolo.textcraft.states.droppable.DroppableState;
import com.fabriziopolo.textcraft.states.edibility.EdibilityState;
import com.fabriziopolo.textcraft.states.encumbrance.EncumbranceState;
import com.fabriziopolo.textcraft.states.goability.GoableState;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.light.LightState;
import com.fabriziopolo.textcraft.states.notification.NotificationState;
import com.fabriziopolo.textcraft.states.perception.PerceptionFilterState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.putreceiver.PutReceiverState;
import com.fabriziopolo.textcraft.states.room.RoomState;
import com.fabriziopolo.textcraft.states.scenery.SceneryState;
import com.fabriziopolo.textcraft.states.shade.ShadeState;
import com.fabriziopolo.textcraft.states.singleplayer.EndGameState;
import com.fabriziopolo.textcraft.states.singleplayer.PauseGameState;
import com.fabriziopolo.textcraft.states.singleplayer.RequestSaveGameState;
import com.fabriziopolo.textcraft.states.singleplayer.WaitState;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.states.takeable.TakeableState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureEffectState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureFilterState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureState;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.updatable.Updateable;
import com.fabriziopolo.textcraft.states.updatable.UpdateableState;
import com.fabriziopolo.textcraft.states.useable.UseableState;
import com.fabriziopolo.textcraft.states.water.SubmersionEffect;
import com.fabriziopolo.textcraft.states.water.SubmersionEffectState;
import com.fabriziopolo.textcraft.states.water.WaterState;
import com.fabriziopolo.textcraft.states.wearabililty.WearabilityState;
import com.fabriziopolo.textcraft.states.weather.WeatherState;
import com.fabriziopolo.textcraft.states.weather.rain.BlocksRainState;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffectState;
import com.fabriziopolo.textcraft.text.InputParser;
import com.fabriziopolo.timecraft.world.weather.AlphaIslandWeatherProvider;
import com.fabriziopolo.timecraft.world.weather.NeutralWeatherProvider;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.function.Supplier;

public abstract class TimeCraftGameBase
extends Game {
    private static final double DEFAULT_DT = 1.0;
    private static final double DEFAULT_TIMESCALE = 96.0;
    public static final UpdateParameters DEFAULT_UPDATE_PARAMETERS = new UpdateParameters(1.0, 96.0);

    public TimeCraftGameBase(String textCraftName, String episodeName, String version) {
        super(textCraftName, episodeName, version);
    }

    protected abstract String getTitleArt();

    public abstract Supplier<SinglePlayerGameState> getInitialGameStateCreator();

    @Override
    public void start(TextAppController controller) {
        controller.getTxt().println(this.getTitleArt());
        SmartMenuLauncher.launch(controller, this.getInitialGameStateCreator());
    }

    @Override
    public SinglePlayerGameState createInitialGameState() {
        return new SinglePlayerGameState(new InputParser(), this.createEmptySimulation());
    }

    protected Frame createEmptyFrame() {
        HashMap<Object, State> states = new HashMap<Object, State>();
        states.put(TimeState.class, new TimeState(Instant.parse("2016-09-13T06:00:00.00Z"), 0.0));
        states.put(PositionState.class, PositionState.builder().build());
        states.put(InventoryState.class, InventoryState.builder().build());
        states.put(RoomState.class, RoomState.builder().build());
        states.put(HungerState.class, HungerState.builder().build());
        states.put(HydrationState.class, HydrationState.builder().build());
        states.put(HealthState.class, HealthState.builder().build());
        states.put(EnergyState.class, EnergyState.builder().build());
        states.put(AwakeState.class, AwakeState.builder().build());
        states.put(SunState.class, SunState.builder().build());
        states.put(EdibilityState.class, EdibilityState.builder().build());
        states.put(LightState.class, LightState.builder().build());
        states.put(StructureState.class, StructureState.builder().build());
        states.put(DescriptionState.class, DescriptionState.builder().build());
        states.put(NotificationState.class, NotificationState.builder().build());
        states.put(WaterState.class, WaterState.builder().build());
        states.put(TakeableState.class, TakeableState.builder().build());
        states.put(ToolState.class, ToolState.builder().build());
        states.put(ResourceState.class, ResourceState.builder().build());
        states.put(GoableState.class, GoableState.builder().build());
        states.put(WeatherState.class, new WeatherState(new NeutralWeatherProvider()));
        states.put(RainEffectState.class, RainEffectState.builder().build());
        states.put(ShadeState.class, ShadeState.builder().build());
        states.put(SubmersionEffect.class, new SubmersionEffectState());
        states.put(OxygenState.class, new OxygenState());
        states.put(BlocksRainState.class, new BlocksRainState());
        states.put(WearabilityState.class, new WearabilityState());
        states.put(CoordinateState.class, new CoordinateState());
        states.put(PutReceiverState.class, new PutReceiverState());
        states.put(UpdateableState.class, new UpdateableState());
        states.put(PerceptionFilterState.class, new PerceptionFilterState());
        states.put(TemperatureState.class, new TemperatureState());
        states.put(TemperatureEffectState.class, new TemperatureEffectState());
        states.put(ProminenceState.class, new ProminenceState());
        states.put(WaitState.class, new WaitState());
        states.put(SceneryState.class, new SceneryState());
        states.put(UseableState.class, new UseableState());
        states.put(TemperatureFilterState.class, new TemperatureFilterState());
        states.put(EncumbranceState.class, new EncumbranceState());
        states.put(DroppableState.class, new DroppableState());
        states.put(PauseGameState.class, new PauseGameState());
        states.put(EndGameState.class, new EndGameState());
        states.put(Directions.class, new Directions());
        ArrayList events = new ArrayList();
        HashMap prevStates = new HashMap();
        return Frame.builder().setStates(states).setUpdateParamters(DEFAULT_UPDATE_PARAMETERS).build();
    }

    private SinglePlayerSimulation createEmptySimulation() {
        return new SinglePlayerSimulation(this.createEmptyFrame(), new Player(), DEFAULT_UPDATE_PARAMETERS, new Random(0L));
    }

    protected Frame createSeedFrame() {
        HashMap<Object, State> states = new HashMap<Object, State>();
        states.put(TimeState.class, new TimeState(Instant.parse("2016-09-13T06:00:00.00Z"), 0.0));
        states.put(PositionState.class, PositionState.builder().build());
        states.put(InventoryState.class, InventoryState.builder().build());
        states.put(RoomState.class, RoomState.builder().build());
        states.put(HungerState.class, HungerState.builder().build());
        states.put(HydrationState.class, HydrationState.builder().build());
        states.put(HealthState.class, HealthState.builder().build());
        states.put(EnergyState.class, EnergyState.builder().build());
        states.put(AwakeState.class, AwakeState.builder().build());
        states.put(SunState.class, SunState.builder().build());
        states.put(EdibilityState.class, EdibilityState.builder().build());
        states.put(LightState.class, LightState.builder().build());
        states.put(StructureState.class, StructureState.builder().build());
        states.put(DescriptionState.class, DescriptionState.builder().build());
        states.put(NotificationState.class, NotificationState.builder().build());
        states.put(WaterState.class, WaterState.builder().build());
        states.put(TakeableState.class, TakeableState.builder().build());
        states.put(ToolState.class, ToolState.builder().build());
        states.put(ResourceState.class, ResourceState.builder().build());
        states.put(GoableState.class, GoableState.builder().build());
        states.put(WeatherState.class, new WeatherState(new AlphaIslandWeatherProvider()));
        states.put(RainEffectState.class, RainEffectState.builder().build());
        states.put(ShadeState.class, ShadeState.builder().build());
        states.put(SubmersionEffect.class, new SubmersionEffectState());
        states.put(OxygenState.class, new OxygenState());
        states.put(BlocksRainState.class, new BlocksRainState());
        states.put(WearabilityState.class, new WearabilityState());
        states.put(CoordinateState.class, new CoordinateState());
        states.put(PutReceiverState.class, new PutReceiverState());
        states.put(UpdateableState.class, new UpdateableState());
        states.put(PerceptionFilterState.class, new PerceptionFilterState());
        states.put(TemperatureState.class, new TemperatureState());
        states.put(TemperatureEffectState.class, new TemperatureEffectState());
        states.put(ProminenceState.class, new ProminenceState());
        states.put(SceneryState.class, new SceneryState());
        states.put(UseableState.class, new UseableState());
        states.put(TemperatureFilterState.class, new TemperatureFilterState());
        states.put(EncumbranceState.class, new EncumbranceState());
        states.put(DroppableState.class, new DroppableState());
        states.put(RequestSaveGameState.class, new RequestSaveGameState());
        states.put(WaitState.class, new WaitState());
        states.put(PauseGameState.class, new PauseGameState());
        states.put(EndGameState.class, new EndGameState());
        states.put(Directions.class, new Directions());
        return Frame.builder().setStates(states).setUpdateParamters(DEFAULT_UPDATE_PARAMETERS).build();
    }

    protected static void installAutoSaver(Simulation simulation) {
        UpdateableState.requestCreateUpdateable(simulation, new Updateable(){

            @Override
            public void update(Noun noun, Simulation simulation) {
                Frame frame = simulation.getCurrentFrame();
                TimeState nextTimeState = TimeState.get(frame);
                if (nextTimeState == null) {
                    return;
                }
                ZonedDateTime nextFrameGameTime = nextTimeState.getGameTime();
                ZonedDateTime frameGameTime = nextFrameGameTime.minusNanos((long)(1.0E9 * simulation.getUpdateParameters().getGameTimeDtSeconds()));
                int autoSaveHour = 5;
                if (frameGameTime.getHour() < autoSaveHour && nextFrameGameTime.getHour() == autoSaveHour) {
                    RequestSaveGameState.requestSave(simulation);
                }
            }
        });
    }
}

