/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.map.timelapse;

import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.worldbuilder.WorldBuilder;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.map.rendering.MapPopulator;
import com.fabriziopolo.timecraft.world.map.rendering.RectanglesMapPopulator;
import com.fabriziopolo.timecraft.world.map.rendering.Util;
import com.fabriziopolo.timecraft.world.map.timelapse.HighMountainRectangleMapPopulator;
import com.fabriziopolo.timecraft.world.map.timelapse.JungleRectangleMapPopulator;
import com.fabriziopolo.timecraft.world.map.timelapse.MountainRectangleMapPopulator;
import com.fabriziopolo.timecraft.world.map.timelapse.OceanRectangleMapPopulator;
import com.fabriziopolo.timecraft.world.map.timelapse.PlainsRectangleMapPopulator;

public class TimeLapseMapPopulator
extends WorldBuilder
implements MapPopulator {
    private static final double dPlainsLeft = 0.1;
    private static final double dJungleLeft = 0.4;
    private static final double dDeepJungleLeft = 0.55;
    private static final double dMountainLeft = 0.7;
    private static final double dHighMountainsLeft = 0.8;
    private final int plainsLeft;
    private final int jungleLeft;
    private final int deepJungleLeft;
    private final int mountainsLeft;
    private final int highMountainsLeft;
    private final Dsl dsl;
    private final Player player;
    private final int xLength;
    private final int yLength;
    private final int xStart;
    private final int yStart;
    private final RectanglesMapPopulator rectanglesMapPopulator;

    public TimeLapseMapPopulator(Simulation simulation, Player player, int xLength, int yLength) {
        super(simulation);
        this.dsl = new Dsl(simulation);
        this.player = player;
        this.xLength = xLength;
        this.yLength = yLength;
        this.plainsLeft = (int)((double)xLength * 0.1);
        this.jungleLeft = (int)((double)xLength * 0.4);
        this.deepJungleLeft = (int)((double)xLength * 0.55);
        this.mountainsLeft = (int)((double)xLength * 0.7);
        this.highMountainsLeft = (int)((double)xLength * 0.8);
        this.xStart = this.mountainsLeft;
        this.yStart = this.mountainsLeft;
        this.rectanglesMapPopulator = new RectanglesMapPopulator();
        this.rectanglesMapPopulator.add(this.plainsLeft, 0, this.jungleLeft - this.plainsLeft, yLength, new PlainsRectangleMapPopulator(this.dsl, yLength, this.jungleLeft - this.plainsLeft));
        this.rectanglesMapPopulator.add(this.jungleLeft, 0, this.deepJungleLeft - this.jungleLeft, yLength, new JungleRectangleMapPopulator(this.dsl, yLength, this.deepJungleLeft - this.jungleLeft));
        this.rectanglesMapPopulator.add(this.deepJungleLeft, 0, this.mountainsLeft - this.deepJungleLeft, yLength, new JungleRectangleMapPopulator(this.dsl, yLength, this.mountainsLeft - this.deepJungleLeft));
        this.rectanglesMapPopulator.add(this.mountainsLeft, 0, this.highMountainsLeft - this.mountainsLeft, yLength, new MountainRectangleMapPopulator(this.dsl, yLength, this.highMountainsLeft - this.mountainsLeft));
        this.rectanglesMapPopulator.add(this.highMountainsLeft, 0, xLength - this.highMountainsLeft, yLength, new HighMountainRectangleMapPopulator(this.dsl, yLength, xLength - this.highMountainsLeft));
        this.rectanglesMapPopulator.add(0, 0, xLength, yLength, new OceanRectangleMapPopulator(this.dsl, xLength, yLength));
    }

    @Override
    public Noun createNewRoomAt(int x, int y) {
        return this.rectanglesMapPopulator.createNewRoomAt(x, y);
    }

    @Override
    public void putObjectsInRoom(Noun room, int x, int y) {
        this.rectanglesMapPopulator.putObjectsInRoom(room, x, y);
    }

    @Override
    public void createExitsAndEntrancesAt(int x, int y, Noun[][] map) {
        Util.createOpenExitsAndEntrances(this.dsl, x, y, 0, -1, map);
        Util.createOpenExitsAndEntrances(this.dsl, x, y, 0, 1, map);
        Util.createOpenExitsAndEntrances(this.dsl, x, y, 1, 0, map);
        Util.createOpenExitsAndEntrances(this.dsl, x, y, -1, 0, map);
    }

    @Override
    public void addScenery(Noun room, int x, int y) {
        this.rectanglesMapPopulator.addScenery(room, x, y);
    }

    @Override
    public void finish() {
        this.rectanglesMapPopulator.finish();
    }

    public int getxStart() {
        return this.xStart;
    }

    public int getyStart() {
        return this.yStart;
    }
}

