/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Operations;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import java.awt.Font;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GuiOperations {
    private static final String METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String WINDOW = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String GTK = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";

    private GuiOperations() {
    }

    public static void UpdateLookAndFeel(String option, LaFrame owner) {
        String laf = new String();
        laf = option.equals("System") ? UIManager.getSystemLookAndFeelClassName() : (option.equals("Metal") ? METAL : (option.equals("Motif") ? MOTIF : (option.equals("Window") ? WINDOW : (option.equals("GTK") ? GTK : UIManager.getCrossPlatformLookAndFeelClassName()))));
        try {
            UIManager.setLookAndFeel(laf);
            SwingUtilities.updateComponentTreeUI(owner);
        }
        catch (Exception e) {
            System.err.println("** ERR: This platform does not support: " + laf);
        }
    }

    public static void UpdateFont(Font font, Font guiFont, LaFrame owner) {
        LaFrame.setDefaultLookAndFeelDecorated(true);
        UIManager.put("MenuBar.font", guiFont);
        UIManager.put("MenuItem.font", guiFont);
        UIManager.put("Menu.font", guiFont);
        UIManager.put("Menu.acceleratorFont", guiFont);
        UIManager.put("PopupMenu.font", guiFont);
        UIManager.put("MenuItem.acceleratorFont", guiFont);
        UIManager.put("OptionPane.messageFont", guiFont);
        UIManager.put("OptionPane.font", guiFont);
        UIManager.put("OptionPane.buttonFont", guiFont);
        UIManager.put("TextPane.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("FormattedTextField.font", font);
        UIManager.put("PasswordField.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("EditorPane.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("ComboBox.font", font);
        UIManager.put("CheckBoxMenuItem.acceleratorFont", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("RadioButtonMenuItem.acceleratorFont", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("Tree.font", font);
        UIManager.put("Panel.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("ScrollPane.font", font);
        UIManager.put("Viewport.font", font);
        UIManager.put("TableHeader.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("List.font", font);
        UIManager.put("ToolBar.font", guiFont);
        UIManager.put("ToggleButton.font", guiFont);
        UIManager.put("Button.font", guiFont);
        UIManager.put("InternalFrame.titleFont", guiFont);
        UIManager.put("ToolTip.font", guiFont);
        UIManager.put("TitledBorder.font", guiFont);
        SwingUtilities.updateComponentTreeUI(owner);
    }
}

