/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Api;

import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.TXDocument;
import gov.nih.nlm.nls.lexCheck.Gram.CheckGrammer;
import gov.nih.nlm.nls.lexCheck.Lib.CatEntry;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.Convert;
import gov.nih.nlm.nls.lexCheck.Lib.ErrMsg;
import gov.nih.nlm.nls.lexCheck.Lib.InflVar;
import gov.nih.nlm.nls.lexCheck.Lib.InflVarsAndAgreements;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ToJavaObjApi {
    private static int lexRecNum_ = 0;

    @Deprecated
    public static Vector<LexRecord> ToJavaObjs(String xmlFileName) throws Exception {
        return ToJavaObjApi.ToJavaObjsFromXmlFile(xmlFileName);
    }

    public static Vector<LexRecord> ToJavaObjsFromXmlFile(String xmlFileName) throws Exception {
        FileInputStream is = new FileInputStream(xmlFileName);
        Parser parser = new Parser(xmlFileName);
        TXDocument doc = parser.readStream((InputStream)is);
        if (parser.getNumberOfErrors() > 0) {
            return null;
        }
        Vector<LexRecord> lexRecords = ToJavaObjApi.GetLexRecords((Node)doc);
        return lexRecords;
    }

    public static Vector<LexRecord> ToJavaObjsFromTextFile(String inFile) throws Exception {
        CheckSt st = new CheckSt();
        CheckSt catSt = new CheckSt(40);
        LineObject lineObject = new LineObject();
        int recordNum = 0;
        Vector<LexRecord> lexRecords = new Vector<LexRecord>();
        try {
            BufferedReader inReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
            while (lineObject != null) {
                if (lineObject.IsGoToNext()) {
                    lineObject.SetLine(inReader.readLine());
                    lineObject.IncreaseLineNum();
                }
                if (lineObject.GetLine() == null) break;
                recordNum = ToJavaObjApi.CheckLine(st, catSt, lineObject, lexRecords, recordNum);
            }
            inReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lexRecords;
    }

    public static Vector<LexRecord> ToJavaObjsFromText(String text) throws Exception {
        CheckSt st = new CheckSt();
        CheckSt catSt = new CheckSt(40);
        LineObject lineObject = new LineObject();
        String unixText = Convert.ToUnixLineSeparator(text);
        StringTokenizer buf = new StringTokenizer(unixText, "\n");
        Vector<LexRecord> lexRecords = new Vector<LexRecord>();
        while (lineObject != null) {
            if (lineObject.IsGoToNext()) {
                if (!buf.hasMoreTokens()) break;
                lineObject.SetLine(buf.nextToken());
                lineObject.IncreaseLineNum();
            }
            ToJavaObjApi.CheckLine(st, catSt, lineObject, lexRecords);
        }
        return lexRecords;
    }

    public static LexRecord ToJavaObjFromText(String text) throws Exception {
        ErrMsg.ResetErrMsg();
        CheckSt st = new CheckSt();
        CheckSt catSt = new CheckSt(40);
        LineObject lineObject = new LineObject();
        String unixText = Convert.ToUnixLineSeparator(text);
        StringTokenizer buf = new StringTokenizer(unixText, "\n");
        LexRecord lexRecord = new LexRecord();
        while (lineObject != null) {
            if (lineObject.IsGoToNext()) {
                if (!buf.hasMoreTokens()) break;
                lineObject.SetLine(buf.nextToken());
                lineObject.IncreaseLineNum();
            }
            lexRecord = ToJavaObjApi.CheckLine(st, catSt, lineObject);
        }
        return lexRecord;
    }

    public static boolean CheckRecordText(String text) throws Exception {
        ErrMsg.ResetErrMsg();
        CheckSt st = new CheckSt();
        CheckSt catSt = new CheckSt(40);
        LineObject lineObject = new LineObject();
        String unixText = Convert.ToUnixLineSeparator(text);
        StringTokenizer buf = new StringTokenizer(unixText, "\n");
        while (lineObject != null) {
            if (lineObject.IsGoToNext()) {
                if (!buf.hasMoreTokens()) break;
                lineObject.SetLine(buf.nextToken());
                lineObject.IncreaseLineNum();
            }
            if (ToJavaObjApi.CheckLine2(st, catSt, lineObject)) continue;
            return false;
        }
        return true;
    }

    public static int CheckRecordsFromTextFile(String inFile) throws Exception {
        lexRecNum_ = 0;
        CheckSt st = new CheckSt();
        CheckSt catSt = new CheckSt(40);
        LineObject lineObject = new LineObject();
        BufferedReader inReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
        while (lineObject != null) {
            if (lineObject.IsGoToNext()) {
                String line = inReader.readLine();
                if (line == null) break;
                lineObject.SetLine(line);
                lineObject.IncreaseLineNum();
            }
            if (ToJavaObjApi.CheckLine2(st, catSt, lineObject)) continue;
            return -1;
        }
        inReader.close();
        return lexRecNum_;
    }

    public static String GetErrMsg() {
        return ErrMsg.GetErrMsg();
    }

    public static void main(String[] argv) {
        String bat = "{base=bat\nentry=E0012112\n\tcat=noun\n\tvariants=reg\nsignature=vanni\n}";
        String molt = "{base=molt\nspelling_variant=moult\nentry=E0040723\n\tcat=noun\n\tvariants=reg\n\tacronym_of=test123\n\tabbreviation_of=test456\n\tacronym_of=test789\nsignature=vanni\n}\n{base=molt\nspelling_variant=moult\nentry=E0040724\n\tcat=verb\n\tvariants=reg\n\tintran\n\ttran=np\n\tnominalization=molting|noun|E0412675\nsignature=vanni\n}";
        if (argv.length == 0) {
            try {
                Vector<LexRecord> lexRecords = ToJavaObjApi.ToJavaObjsFromText(molt);
                for (int i = 0; i < lexRecords.size(); ++i) {
                    LexRecord lexRecord = lexRecords.elementAt(i);
                    System.out.println(lexRecord.GetText());
                    System.out.println("---------------------------------");
                }
                LexRecord lexRecord = ToJavaObjApi.ToJavaObjFromText(molt);
                System.out.println(lexRecord.GetText());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (argv.length == 1) {
            try {
                Vector<LexRecord> lexRecords = ToJavaObjApi.ToJavaObjs(argv[0]);
                if (lexRecords.size() <= 0) {
                    System.exit(1);
                }
                for (int i = 0; i < lexRecords.size(); ++i) {
                    LexRecord lexRecord = lexRecords.elementAt(i);
                    System.out.println(lexRecord.GetText());
                    System.out.println(lexRecord.GetXml());
                    System.out.println("---------------------------------");
                    InflVarsAndAgreements infls = new InflVarsAndAgreements(lexRecord);
                    Vector<InflVar> inflVars = infls.GetInflValues();
                    for (int j = 0; j < inflVars.size(); ++j) {
                        InflVar inflVar = inflVars.elementAt(j);
                        System.out.println("unInfl: " + inflVar.GetUnInfl() + "; infl: " + inflVar.GetInflection() + "; var: " + inflVar.GetVar());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("*** Usage: java ToJavaObjApi <filename>");
            System.exit(1);
        }
    }

    private static Vector<LexRecord> GetLexRecords(Node node) throws Exception {
        Vector<LexRecord> lexRecords = new Vector<LexRecord>();
        LexRecord lexRecord = null;
        CatEntry catEntry = null;
        for (Node records = node.getFirstChild(); records != null; records = records.getNextSibling()) {
            for (Node record = records.getFirstChild(); record != null; record = record.getNextSibling()) {
                if (record.getNodeType() != 1) continue;
                if (record.getNodeName().equals("lexRecord")) {
                    lexRecord = new LexRecord();
                    ToJavaObjApi.GetLexRecord(record, lexRecord, catEntry);
                }
                lexRecords.addElement(lexRecord);
            }
        }
        return lexRecords;
    }

    private static void GetLexRecord(Node node, LexRecord lexRecord, CatEntry catEntry) throws Exception {
        if (node.getNodeType() == 1) {
            if (node.getNodeName().equals("base")) {
                lexRecord.SetBase(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("eui")) {
                lexRecord.SetEui(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("cat")) {
                lexRecord.SetCat(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("spellingVars")) {
                lexRecord.SetSpellingVar(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("acronyms")) {
                lexRecord.GetAcronyms().addElement(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("abbreviations")) {
                lexRecord.GetAbbreviations().addElement(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("annotations")) {
                lexRecord.GetAnnotations().addElement(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("signature")) {
                lexRecord.SetSignature(ToJavaObjApi.getValue(node));
            } else if (node.getNodeName().equals("verbEntry")) {
                catEntry = ToJavaObjApi.getVerbValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("auxEntry")) {
                catEntry = ToJavaObjApi.getAuxValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("modalEntry")) {
                catEntry = ToJavaObjApi.getModalValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("nounEntry")) {
                catEntry = ToJavaObjApi.getNounValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("pronEntry")) {
                catEntry = ToJavaObjApi.getPronValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("adjEntry")) {
                catEntry = ToJavaObjApi.getAdjValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("advEntry")) {
                catEntry = ToJavaObjApi.getAdvValues(node);
                lexRecord.SetCatEntry(catEntry);
            } else if (node.getNodeName().equals("detEntry")) {
                catEntry = ToJavaObjApi.getDetValues(node);
                lexRecord.SetCatEntry(catEntry);
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            ToJavaObjApi.GetLexRecord(child, lexRecord, catEntry);
        }
    }

    private static CatEntry getVerbValues(Node node) {
        CatEntry catEntry = new CatEntry("verb");
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element)) continue;
            if (ch.getNodeName().equals("variants")) {
                catEntry.GetVerbEntry().GetVariants().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("intran")) {
                catEntry.GetVerbEntry().GetIntran().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("tran")) {
                catEntry.GetVerbEntry().GetTran().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("ditran")) {
                catEntry.GetVerbEntry().GetDitran().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("link")) {
                catEntry.GetVerbEntry().GetLink().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("cplxtran")) {
                catEntry.GetVerbEntry().GetCplxtran().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (!ch.getNodeName().equals("nominalization")) continue;
            catEntry.GetVerbEntry().GetNominalization().addElement(ToJavaObjApi.getValue(ch));
        }
        return catEntry;
    }

    private static CatEntry getAuxValues(Node node) {
        CatEntry catEntry = new CatEntry("aux");
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element) || !ch.getNodeName().equals("variant")) continue;
            catEntry.GetAuxEntry().GetVariant().addElement(ToJavaObjApi.getValue(ch));
        }
        return catEntry;
    }

    private static CatEntry getModalValues(Node node) {
        CatEntry catEntry = new CatEntry("modal");
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element) || !ch.getNodeName().equals("variant")) continue;
            catEntry.GetModalEntry().GetVariant().addElement(ToJavaObjApi.getValue(ch));
        }
        return catEntry;
    }

    private static CatEntry getNounValues(Node node) {
        CatEntry catEntry = new CatEntry("noun");
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element)) continue;
            if (ch.getNodeName().equals("variants")) {
                catEntry.GetNounEntry().GetVariants().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("compl")) {
                catEntry.GetNounEntry().GetCompl().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("nominalization")) {
                catEntry.GetNounEntry().GetNominalization().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("tradeName")) {
                catEntry.GetNounEntry().GetTradeName().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("trademark")) {
                catEntry.GetNounEntry().SetTradeMark(true);
                continue;
            }
            if (!ch.getNodeName().equals("proper")) continue;
            catEntry.GetNounEntry().SetProper(true);
        }
        return catEntry;
    }

    private static CatEntry getPronValues(Node node) {
        CatEntry catEntry = new CatEntry("pron");
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element)) continue;
            if (ch.getNodeName().equals("variants")) {
                catEntry.GetPronEntry().GetVariants().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("type")) {
                catEntry.GetPronEntry().GetType().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("gender")) {
                catEntry.GetPronEntry().SetGender(ToJavaObjApi.getAttribute(ch, "type"));
                continue;
            }
            if (!ch.getNodeName().equals("interrogative")) continue;
            catEntry.GetPronEntry().SetInterrogative(true);
        }
        return catEntry;
    }

    private static CatEntry getDetValues(Node node) {
        CatEntry catEntry = new CatEntry("det");
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element)) continue;
            if (ch.getNodeName().equals("variants")) {
                catEntry.GetDetEntry().SetVariants(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("interrogative")) {
                catEntry.GetDetEntry().SetInterrogative(true);
                continue;
            }
            if (!ch.getNodeName().equals("demonstrative")) continue;
            catEntry.GetDetEntry().SetDemonstrative(true);
        }
        return catEntry;
    }

    private static CatEntry getAdvValues(Node node) {
        CatEntry catEntry = new CatEntry("adv");
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element)) continue;
            if (ch.getNodeName().equals("variants")) {
                catEntry.GetAdvEntry().GetVariants().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("modification")) {
                catEntry.GetAdvEntry().GetModification().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("negative")) {
                catEntry.GetAdvEntry().SetNegative(ToJavaObjApi.getAttribute(ch, "type"));
                continue;
            }
            if (!ch.getNodeName().equals("interrogative")) continue;
            catEntry.GetAdvEntry().SetInterrogative(true);
        }
        return catEntry;
    }

    private static CatEntry getAdjValues(Node node) {
        CatEntry catEntry = new CatEntry("adj");
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (!(ch instanceof Element)) continue;
            if (ch.getNodeName().equals("variants")) {
                catEntry.GetAdjEntry().GetVariants().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("position")) {
                catEntry.GetAdjEntry().GetPosition().addElement(ToJavaObjApi.getAttribute(ch, "type"));
                continue;
            }
            if (ch.getNodeName().equals("compl")) {
                catEntry.GetAdjEntry().GetCompl().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (ch.getNodeName().equals("nominalization")) {
                catEntry.GetAdjEntry().GetNominalization().addElement(ToJavaObjApi.getValue(ch));
                continue;
            }
            if (!ch.getNodeName().equals("stative")) continue;
            catEntry.GetAdjEntry().SetStative(true);
        }
        return catEntry;
    }

    private static String getValue(Node node) {
        String value = null;
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (ch instanceof Element || ch instanceof EntityReference) {
                ToJavaObjApi.getValue(ch);
                continue;
            }
            if (!(ch instanceof Text)) continue;
            value = ch.getNodeValue();
        }
        return value;
    }

    private static String getAttribute(Node node, String name) {
        Node item;
        String attribute = new String();
        NamedNodeMap nnm = node.getAttributes();
        if (nnm.getLength() == 1 && (item = nnm.item(0)).getNodeName().equals(name)) {
            attribute = item.getNodeValue();
        }
        return attribute;
    }

    private static Vector getAttributes(Node node) {
        Vector<String> positions = new Vector<String>();
        NamedNodeMap nnm = node.getAttributes();
        for (int i = 0; i < nnm.getLength(); ++i) {
            Node item = nnm.item(i);
            if (!item.getNodeName().equals("type")) continue;
            positions.addElement(item.getNodeValue());
        }
        return positions;
    }

    private static void CheckLine(CheckSt st, CheckSt catSt, LineObject lineObject, Vector<LexRecord> lexRecords) {
        boolean flag = false;
        boolean printFlag = true;
        flag = CheckGrammer.Check(lineObject, printFlag, st, catSt, false);
        if (st.GetCurState() == 10 && flag) {
            lexRecords.add(CheckGrammer.GetLexRecord());
        }
    }

    private static LexRecord CheckLine(CheckSt st, CheckSt catSt, LineObject lineObject) {
        boolean flag = false;
        boolean printFlag = true;
        flag = CheckGrammer.Check(lineObject, printFlag, st, catSt, false);
        LexRecord lexRecord = new LexRecord();
        if (st.GetCurState() == 10 && flag) {
            lexRecord = CheckGrammer.GetLexRecord();
        }
        return lexRecord;
    }

    private static boolean CheckLine2(CheckSt st, CheckSt catSt, LineObject lineObject) {
        boolean flag = false;
        boolean printFlag = true;
        flag = CheckGrammer.Check(lineObject, printFlag, st, catSt, false);
        if (!flag) {
            return flag;
        }
        if (st.GetCurState() == 10 && flag) {
            ++lexRecNum_;
        }
        return flag;
    }

    private static int CheckLine(CheckSt st, CheckSt catSt, LineObject lineObject, Vector<LexRecord> lexRecords, int recordNum) {
        boolean flag = false;
        boolean printFlag = true;
        flag = CheckGrammer.Check(lineObject, printFlag, st, catSt, false);
        if (st.GetCurState() == 10 && flag) {
            lexRecords.add(CheckGrammer.GetLexRecord());
            ++recordNum;
        }
        return recordNum;
    }
}

