/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Cat.Adj;

import gov.nih.nlm.nls.lexCheck.Compl.CheckAsComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckFinComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckInfComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckPphr;
import gov.nih.nlm.nls.lexCheck.Compl.CheckWhinfComp;
import gov.nih.nlm.nls.lexCheck.Lib.CheckFormat;
import java.util.HashSet;

public class CheckFormatAdjCompl
implements CheckFormat {
    private static final int LEGAL_FILLER_NUM = 8;
    private static HashSet<String> filler_ = new HashSet(8);

    @Override
    public boolean IsLegalFormat(String filler) {
        boolean flag = false;
        if (filler_.contains(filler)) {
            flag = true;
        } else if (filler.startsWith("ascomp:")) {
            flag = CheckAsComp.IsLegal(filler);
        } else if (filler.startsWith("fincomp(")) {
            flag = CheckFinComp.IsLegal(filler);
        } else if (filler.startsWith("infcomp:")) {
            flag = CheckInfComp.IsLegal(filler);
        } else if (filler.startsWith("pphr(")) {
            flag = CheckPphr.IsLegal(filler);
        } else if (!filler.startsWith("binfcomp:")) {
            flag = filler.startsWith("whinfcomp:") ? CheckWhinfComp.IsLegal(filler) : false;
        }
        return flag;
    }

    static {
        filler_.add("advbl");
        filler_.add("ascomp:");
        filler_.add("fincomp(");
        filler_.add("infcomp:");
        filler_.add("pphr");
        filler_.add("binfcomp:");
        filler_.add("whfincomp");
        filler_.add("whinfcomp:");
    }
}

